/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class ParamUtil {
    private static final Logger LOGGER = LogUtils.logger(ParamUtil.class);
    private static String defaultContextPath = "nacos";
    private static String defaultNodesPath = "serverlist";
    private static String appKey;
    private static String appName;
    private static String defaultServerPort;
    private static String clientVersion;
    private static int connectTimeout;
    private static double perTaskConfigSize;

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        ParamUtil.appKey = appKey;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        ParamUtil.appName = appName;
    }

    public static String getDefaultContextPath() {
        return defaultContextPath;
    }

    public static void setDefaultContextPath(String defaultContextPath) {
        ParamUtil.defaultContextPath = defaultContextPath;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        ParamUtil.clientVersion = clientVersion;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static double getPerTaskConfigSize() {
        return perTaskConfigSize;
    }

    public static void setPerTaskConfigSize(double perTaskConfigSize) {
        ParamUtil.perTaskConfigSize = perTaskConfigSize;
    }

    public static String getDefaultServerPort() {
        return defaultServerPort;
    }

    public static String getDefaultNodesPath() {
        return defaultNodesPath;
    }

    public static void setDefaultNodesPath(String defaultNodesPath) {
        ParamUtil.defaultNodesPath = defaultNodesPath;
    }

    static {
        clientVersion = "unknown";
        perTaskConfigSize = 3000.0;
        appKey = System.getProperty("nacos.client.appKey", "");
        appName = AppNameUtils.getAppName();
        String defaultServerPortTmp = "8848";
        defaultServerPort = System.getProperty("nacos.server.port", defaultServerPortTmp);
        LOGGER.info("[settings] [req-serv] nacos-server port:{}", (Object)defaultServerPort);
        String tmp = "1000";
        try {
            tmp = System.getProperty("NACOS.CONNECT.TIMEOUT", "1000");
            connectTimeout = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        LOGGER.info("[settings] [http-client] connect timeout:{}", (Object)connectTimeout);
        try {
            InputStream in = HttpSimpleClient.class.getClassLoader().getResourceAsStream("application.properties");
            Properties props = new Properties();
            props.load(in);
            String val = null;
            val = props.getProperty("version");
            if (val != null) {
                clientVersion = val;
            }
            LOGGER.info("NACOS_CLIENT_VERSION: {}", (Object)clientVersion);
        }
        catch (Exception e) {
            LOGGER.error("[500] read application.properties", (Throwable)e);
        }
        try {
            perTaskConfigSize = Double.valueOf(System.getProperty("PER_TASK_CONFIG_SIZE", "3000"));
            LOGGER.info("PER_TASK_CONFIG_SIZE: {}", (Object)perTaskConfigSize);
        }
        catch (Throwable t) {
            LOGGER.error("[PER_TASK_CONFIG_SIZE] PER_TASK_CONFIG_SIZE invalid", t);
        }
    }
}

