/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerlistChangeEvent;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.EnvUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServerListManager
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ServerListManager.class);
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    private final NacosRestTemplate nacosRestTemplate = ConfigHttpClientManager.getInstance().getNacosRestTemplate();
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.ServerListManager");
            t.setDaemon(true);
            return t;
        }
    });
    private final String name;
    private String namespace = "";
    private String tenant = "";
    public static final String DEFAULT_NAME = "default";
    public static final String CUSTOM_NAME = "custom";
    public static final String FIXED_NAME = "fixed";
    private final int initServerlistRetryTimes = 5;
    static final int TIMEOUT = 5000;
    final boolean isFixed;
    boolean isStarted = false;
    private String endpoint;
    private int endpointPort = 8080;
    private String contentPath = ParamUtil.getDefaultContextPath();
    private String serverListName = ParamUtil.getDefaultNodesPath();
    volatile List<String> serverUrls = new ArrayList<String>();
    private volatile String currentServerAddr;
    private Iterator<String> iterator;
    public String serverPort = ParamUtil.getDefaultServerPort();
    public String addressServerUrl;
    private String serverAddrsStr;

    public ServerListManager() {
        this.isFixed = false;
        this.isStarted = false;
        this.name = DEFAULT_NAME;
    }

    public ServerListManager(List<String> fixed) {
        this(fixed, null);
    }

    public ServerListManager(List<String> fixed, String namespace) {
        this.isFixed = true;
        this.isStarted = true;
        ArrayList<String> serverAddrs = new ArrayList<String>();
        for (String serverAddr : fixed) {
            String[] serverAddrArr = IPUtil.splitIPPortStr((String)serverAddr);
            if (serverAddrArr.length == 1) {
                serverAddrs.add(serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                continue;
            }
            serverAddrs.add(serverAddr);
        }
        this.serverUrls = new ArrayList<String>(serverAddrs);
        if (StringUtils.isBlank((String)namespace)) {
            this.name = "fixed-" + this.getFixedNameSuffix(serverAddrs.toArray(new String[serverAddrs.size()]));
        } else {
            this.namespace = namespace;
            this.name = "fixed-" + this.getFixedNameSuffix(serverAddrs.toArray(new String[serverAddrs.size()])) + "-" + namespace;
        }
    }

    public ServerListManager(String host, int port) {
        this.isFixed = false;
        this.isStarted = false;
        this.name = "custom-" + host + "-" + port;
        this.addressServerUrl = String.format("http://%s:%d%s/%s", host, port, ContextPathUtil.normalizeContextPath(this.contentPath), this.serverListName);
    }

    public ServerListManager(String endpoint) throws NacosException {
        this(endpoint, null);
    }

    public ServerListManager(String endpoint, String namespace) throws NacosException {
        this.isFixed = false;
        this.isStarted = false;
        Properties properties = new Properties();
        properties.setProperty("endpoint", endpoint);
        endpoint = this.initEndpoint(properties);
        if (StringUtils.isBlank((String)endpoint)) {
            throw new NacosException(-400, "endpoint is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            this.name = endpoint;
            this.addressServerUrl = String.format("http://%s:%d%s/%s", endpoint, this.endpointPort, ContextPathUtil.normalizeContextPath(this.contentPath), this.serverListName);
        } else {
            if (StringUtils.isBlank((String)endpoint)) {
                throw new NacosException(-400, "endpoint is blank");
            }
            this.name = endpoint + "-" + namespace;
            this.namespace = namespace;
            this.tenant = namespace;
            this.addressServerUrl = String.format("http://%s:%d%s/%s?namespace=%s", endpoint, this.endpointPort, ContextPathUtil.normalizeContextPath(this.contentPath), this.serverListName, namespace);
        }
    }

    public ServerListManager(Properties properties) throws NacosException {
        this.isStarted = false;
        this.serverAddrsStr = properties.getProperty("serverAddr");
        String namespace = properties.getProperty("namespace");
        this.initParam(properties);
        if (StringUtils.isNotEmpty((String)this.serverAddrsStr)) {
            String[] serverAddrsArr;
            this.isFixed = true;
            ArrayList<String> serverAddrs = new ArrayList<String>();
            for (String serverAddr : serverAddrsArr = this.serverAddrsStr.split(",")) {
                if (serverAddr.startsWith(HTTPS) || serverAddr.startsWith(HTTP)) {
                    serverAddrs.add(serverAddr);
                    continue;
                }
                String[] serverAddrArr = IPUtil.splitIPPortStr((String)serverAddr);
                if (serverAddrArr.length == 1) {
                    serverAddrs.add(HTTP + serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                    continue;
                }
                serverAddrs.add(HTTP + serverAddr);
            }
            this.serverUrls = serverAddrs;
            if (StringUtils.isBlank((String)namespace)) {
                this.name = "fixed-" + this.getFixedNameSuffix(this.serverUrls.toArray(new String[this.serverUrls.size()]));
            } else {
                this.namespace = namespace;
                this.tenant = namespace;
                this.name = "fixed-" + this.getFixedNameSuffix(this.serverUrls.toArray(new String[this.serverUrls.size()])) + "-" + namespace;
            }
        } else {
            if (StringUtils.isBlank((String)this.endpoint)) {
                throw new NacosException(-400, "endpoint is blank");
            }
            this.isFixed = false;
            if (StringUtils.isBlank((String)namespace)) {
                this.name = this.endpoint;
                this.addressServerUrl = String.format("http://%s:%d%s/%s", this.endpoint, this.endpointPort, ContextPathUtil.normalizeContextPath(this.contentPath), this.serverListName);
            } else {
                this.namespace = namespace;
                this.tenant = namespace;
                this.name = this.endpoint + "-" + namespace;
                this.addressServerUrl = String.format("http://%s:%d%s/%s?namespace=%s", this.endpoint, this.endpointPort, ContextPathUtil.normalizeContextPath(this.contentPath), this.serverListName, namespace);
            }
        }
    }

    private void initParam(Properties properties) {
        String serverListNameTmp;
        this.endpoint = this.initEndpoint(properties);
        String contentPathTmp = properties.getProperty("contextPath");
        if (!StringUtils.isBlank((String)contentPathTmp)) {
            this.contentPath = contentPathTmp;
        }
        if (!StringUtils.isBlank((String)(serverListNameTmp = properties.getProperty("clusterName")))) {
            this.serverListName = serverListNameTmp;
        }
    }

    private String initEndpoint(final Properties properties) {
        String endpointPortTmp = TemplateUtils.stringEmptyAndThenExecute(System.getenv("ALIBABA_ALIWARE_ENDPOINT_PORT"), new Callable<String>(){

            @Override
            public String call() {
                return properties.getProperty("endpointPort");
            }
        });
        if (StringUtils.isNotBlank((String)endpointPortTmp)) {
            this.endpointPort = Integer.parseInt(endpointPortTmp);
        }
        String endpointTmp = properties.getProperty("endpoint");
        String isUseEndpointRuleParsing = properties.getProperty("isUseEndpointParsingRule", System.getProperty("nacos.use.endpoint.parsing.rule", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseEndpointRuleParsing)) {
            String endpointUrl = ParamUtil.parsingEndpointRule(endpointTmp);
            if (StringUtils.isNotBlank((String)endpointUrl)) {
                this.serverAddrsStr = "";
            }
            return endpointUrl;
        }
        return StringUtils.isNotBlank((String)endpointTmp) ? endpointTmp : "";
    }

    public synchronized void start() throws NacosException {
        if (this.isStarted || this.isFixed) {
            return;
        }
        GetServerListTask getServersTask = new GetServerListTask(this.addressServerUrl);
        for (int i = 0; i < 5 && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            if (!this.serverUrls.isEmpty()) break;
            try {
                this.wait((long)(i + 1) * 100L);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("get serverlist fail,url: {}", (Object)this.addressServerUrl);
            }
        }
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[init-serverlist] fail to get NACOS-server serverlist! env: {}, url: {}", (Object)this.name, (Object)this.addressServerUrl);
            throw new NacosException(500, "fail to get NACOS-server serverlist! env:" + this.name + ", not connnect url:" + this.addressServerUrl);
        }
        this.executorService.scheduleWithFixedDelay(getServersTask, 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    public List<String> getServerUrls() {
        return this.serverUrls;
    }

    Iterator<String> iterator() {
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[{}] [iterator-serverlist] No server address defined!", (Object)this.name);
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LOGGER);
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private void updateIfChanged(List<String> newList) {
        if (null == newList || newList.isEmpty()) {
            LOGGER.warn("[update-serverlist] current serverlist from address server is empty!!!");
            return;
        }
        ArrayList<String> newServerAddrList = new ArrayList<String>();
        for (String server : newList) {
            if (server.startsWith(HTTP) || server.startsWith(HTTPS)) {
                newServerAddrList.add(server);
                continue;
            }
            newServerAddrList.add(HTTP + server);
        }
        if (newServerAddrList.equals(this.serverUrls)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newServerAddrList);
        this.refreshCurrentServerAddr();
        NotifyCenter.publishEvent((Event)new ServerlistChangeEvent());
        LOGGER.info("[{}] [update-serverlist] serverlist updated to {}", (Object)this.name, this.serverUrls);
    }

    private List<String> getApacheServerList(String url, String name) {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(url, Header.EMPTY, Query.EMPTY, String.class);
            if (httpResult.ok()) {
                if (DEFAULT_NAME.equals(name)) {
                    EnvUtil.setSelfEnv(httpResult.getHeader().getOriginalResponseHeader());
                }
                List lines = IoUtils.readLines((Reader)new StringReader((String)httpResult.getData()));
                ArrayList<String> result = new ArrayList<String>(lines.size());
                for (String serverAddr : lines) {
                    if (!StringUtils.isNotBlank((String)serverAddr)) continue;
                    String[] ipPort = IPUtil.splitIPPortStr((String)serverAddr.trim());
                    String ip = ipPort[0].trim();
                    if (ipPort.length == 1) {
                        result.add(ip + ":" + ParamUtil.getDefaultServerPort());
                        continue;
                    }
                    result.add(serverAddr);
                }
                return result;
            }
            LOGGER.error("[check-serverlist] error. addressServerUrl: {}, code: {}", (Object)this.addressServerUrl, (Object)httpResult.getCode());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[check-serverlist] exception. url: " + url, (Throwable)e);
            return null;
        }
    }

    String getUrlString() {
        return this.serverUrls.toString();
    }

    String getFixedNameSuffix(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            serverIp = serverIp.replaceAll("http(s)?://", "");
            sb.append(serverIp.replaceAll(":", "_"));
            split = "-";
        }
        return sb.toString();
    }

    public String toString() {
        return "ServerManager-" + this.name + "-" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.serverUrls.contains(ip);
    }

    public synchronized void refreshCurrentServerAddr() {
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    public String getCurrentServerAddr() {
        if (StringUtils.isBlank((String)this.currentServerAddr)) {
            this.refreshCurrentServerAddr();
        }
        return this.currentServerAddr;
    }

    public void updateCurrentServerAddr(String currentServerAddr) {
        this.currentServerAddr = currentServerAddr;
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    public String getNextServerAddr() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
        try {
            return this.iterator.next();
        }
        catch (Exception exception) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTenant() {
        return this.tenant;
    }

    private static class ServerAddressIterator
    implements Iterator<String> {
        final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
        final Iterator<RandomizedServerAddress> iter;

        public ServerAddressIterator(List<String> source) {
            for (String address : source) {
                this.sorted.add(new RandomizedServerAddress(address));
            }
            Collections.sort(this.sorted);
            this.iter = this.sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next().serverIp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static class RandomizedServerAddress
        implements Comparable<RandomizedServerAddress> {
            static Random random = new Random();
            String serverIp;
            int priority = 0;
            int seed;

            public RandomizedServerAddress(String ip) {
                try {
                    this.serverIp = ip;
                    this.seed = random.nextInt(Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int compareTo(RandomizedServerAddress other) {
                if (this.priority != other.priority) {
                    return other.priority - this.priority;
                }
                return other.seed - this.seed;
            }
        }
    }

    class GetServerListTask
    implements Runnable {
        final String url;

        GetServerListTask(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.this.getApacheServerList(this.url, ServerListManager.this.name));
            }
            catch (Exception e) {
                LOGGER.error("[" + ServerListManager.this.name + "][update-serverlist] failed to update serverlist from address server!", (Throwable)e);
            }
        }
    }
}

