/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.config.remote.request.ClientConfigMetricRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigBatchListenRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigChangeNotifyRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigReSyncRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ClientConfigMetricResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigChangeBatchListenResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigChangeNotifyResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigReSyncResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.http.MetricsHttpAgent;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.CacheData;
import com.alibaba.nacos.client.config.impl.ConfigTransportClient;
import com.alibaba.nacos.client.config.impl.Limiter;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.ServerlistChangeEvent;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.ParamUtils;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ClientWorker
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ClientWorker.class);
    private final AtomicReference<Map<String, CacheData>> cacheMap = new AtomicReference(new HashMap());
    private final ConfigFilterChainManager configFilterChainManager;
    private boolean isHealthServer = true;
    private String uuid = UUID.randomUUID().toString();
    private long timeout;
    private ConfigTransportClient agent;
    private int taskPenaltyTime;
    private boolean enableRemoteSyncConfig = false;

    public void addListeners(String dataId, String group, List<? extends Listener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (Listener listener : listeners) {
            cache.addListener(listener);
        }
        if (!cache.isSync()) {
            this.agent.notifyListenConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenantListeners(String dataId, String group, List<? extends Listener> listeners) throws NacosException {
        CacheData cache;
        group = this.null2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cacheData = cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        synchronized (cacheData) {
            for (Listener listener : listeners) {
                cache.addListener(listener);
            }
            if (!cache.isSync()) {
                this.agent.notifyListenConfig();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenantListenersWithContent(String dataId, String group, String content, List<? extends Listener> listeners) throws NacosException {
        CacheData cache;
        group = this.null2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cacheData = cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        synchronized (cacheData) {
            cache.setContent(content);
            for (Listener listener : listeners) {
                cache.addListener(listener);
            }
            if (!cache.isSync()) {
                this.agent.notifyListenConfig();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String dataId, String group, Listener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null != cache) {
            CacheData cacheData = cache;
            synchronized (cacheData) {
                cache.removeListener(listener);
                if (cache.getListeners().isEmpty()) {
                    cache.setSync(false);
                    this.agent.removeCache(dataId, group);
                }
            }
        }
    }

    public void removeTenantListener(String dataId, String group, Listener listener) {
        String tenant;
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group), tenant = this.agent.getTenant());
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                cache.setSync(false);
                this.agent.removeCache(dataId, group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKey(dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [unsubscribe] {}", (Object)this.agent.getName(), (Object)groupKey);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [unsubscribe] {}", (Object)this.agent.getName(), (Object)groupKey);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
    }

    public boolean removeConfig(String dataId, String group, String tenant, String tag) throws NacosException {
        return this.agent.removeConfig(dataId, group, tenant, tag);
    }

    public boolean publishConfig(String dataId, String group, String tenant, String appName, String tag, String betaIps, String content) throws NacosException {
        return this.agent.publishConfig(dataId, group, tenant, appName, tag, betaIps, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKey(dataId, group);
        cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                int taskId = this.cacheMap.get().size() / (int)ParamUtil.getPerTaskConfigSize();
                cache.setTaskId(taskId);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [subscribe] {}", (Object)this.agent.getName(), (Object)key);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) throws NacosException {
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group, tenant);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group, tenant);
                int taskId = this.cacheMap.get().size() / (int)ParamUtil.getPerTaskConfigSize();
                cache.setTaskId(taskId);
                if (this.enableRemoteSyncConfig) {
                    String[] ct = this.getServerConfig(dataId, group, tenant, 3000L, false);
                    cache.setContent(ct[0]);
                }
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [subscribe] {}", (Object)this.agent.getName(), (Object)key);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
        return cache;
    }

    public CacheData getCache(String dataId, String group) {
        return this.getCache(dataId, group, TenantUtil.getUserTenantForAcm());
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKeyTenant(dataId, group, tenant));
    }

    public String[] getServerConfig(String dataId, String group, String tenant, long readTimeout, boolean notify) throws NacosException {
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        return this.agent.queryConfig(dataId, group, tenant, readTimeout, notify);
    }

    private void checkLocalConfig(String agentName, CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        String tenant = cacheData.tenant;
        File path = LocalConfigInfoProcessor.getFailoverFile(agentName, dataId, group, tenant);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(agentName, dataId, group, tenant);
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            LOGGER.warn("[{}] [failover-change] failover file created. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{agentName, dataId, group, tenant, md5, ContentUtils.truncateContent(content)});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            LOGGER.warn("[{}] [failover-change] failover file deleted. dataId={}, group={}, tenant={}", new Object[]{agentName, dataId, group, tenant});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(agentName, dataId, group, tenant);
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            LOGGER.warn("[{}] [failover-change] failover file changed. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{agentName, dataId, group, tenant, md5, ContentUtils.truncateContent(content)});
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    public ClientWorker(ConfigFilterChainManager configFilterChainManager, Properties properties) throws NacosException {
        this.configFilterChainManager = configFilterChainManager;
        this.init(properties);
        ServerListManager serverListManager = new ServerListManager(properties);
        serverListManager.start();
        this.agent = ParamUtils.useHttpSwitch() ? new ConfigHttpTransportClient(properties, serverListManager) : new ConfigRpcTransportClient(properties, serverListManager);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.Worker_" + ClientWorker.this.agent.getName());
                t.setDaemon(true);
                return t;
            }
        });
        this.agent.setExecutor(executorService);
        this.agent.start();
    }

    private void refreshContentAndCheck(String groupKey, boolean notify) {
        if (this.cacheMap.get() != null && this.cacheMap.get().containsKey(groupKey)) {
            CacheData cache = this.cacheMap.get().get(groupKey);
            this.refreshContentAndCheck(cache, notify);
        }
    }

    private void refreshContentAndCheck(CacheData cacheData, boolean notify) {
        try {
            String[] ct = this.getServerConfig(cacheData.dataId, cacheData.group, cacheData.tenant, 3000L, notify);
            cacheData.setContent(ct[0]);
            if (null != ct[1]) {
                cacheData.setType(ct[1]);
            }
            if (notify) {
                LOGGER.info("[{}] [data-received] dataId={}, group={}, tenant={}, md5={}, content={}, type={}", new Object[]{this.agent.getName(), cacheData.dataId, cacheData.group, cacheData.tenant, cacheData.getMd5(), ContentUtils.truncateContent(ct[0]), ct[1]});
            }
            cacheData.checkListenerMd5();
        }
        catch (Exception e) {
            LOGGER.error("refresh content and check md5 fail ,dataid={},group={},tenant={} ", new Object[]{cacheData.dataId, cacheData.group, cacheData.tenant, e});
        }
    }

    private void init(Properties properties) {
        this.timeout = Math.max(ConvertUtils.toInt((String)properties.getProperty("configLongPollTimeout"), (int)30000), 10000);
        this.taskPenaltyTime = ConvertUtils.toInt((String)properties.getProperty("configRetryTime"), (int)2000);
        this.enableRemoteSyncConfig = Boolean.parseBoolean(properties.getProperty("enableRemoteSyncConfig"));
    }

    private Map<String, Object> getMetrics(List<ClientConfigMetricRequest.MetricsKey> metricsKeys) {
        HashMap<String, Object> metric = new HashMap<String, Object>(16);
        metric.put("listenKeys", String.valueOf(this.cacheMap.get().size()));
        metric.put("clientVersion", VersionUtils.getFullClientVersion());
        Map<ClientConfigMetricRequest.MetricsKey, Object> metricValues = this.getMetricsValue(metricsKeys);
        metric.put("metricValues", metricValues);
        HashMap<String, Object> metrics = new HashMap<String, Object>(1);
        metrics.put(this.uuid, JacksonUtils.toJson(metric));
        return metrics;
    }

    private Map<ClientConfigMetricRequest.MetricsKey, Object> getMetricsValue(List<ClientConfigMetricRequest.MetricsKey> metricsKeys) {
        if (metricsKeys == null) {
            return null;
        }
        HashMap<ClientConfigMetricRequest.MetricsKey, Object> values = new HashMap<ClientConfigMetricRequest.MetricsKey, Object>(16);
        for (ClientConfigMetricRequest.MetricsKey metricsKey : metricsKeys) {
            if ("cacheData".equals(metricsKey.getType())) {
                values.putIfAbsent(metricsKey, this.cacheMap.get().get(metricsKey.getKey()));
            }
            if (!"snapshotData".equals(metricsKey.getType())) continue;
            String[] configStr = GroupKey.parseKey(metricsKey.getKey());
            String snapshot = LocalConfigInfoProcessor.getSnapshot(this.agent.getName(), configStr[0], configStr[1], configStr[2]);
            values.putIfAbsent(metricsKey, snapshot);
        }
        return values;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.agent.executor, (Logger)LOGGER);
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public boolean isHealthServer() {
        return this.isHealthServer;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.isHealthServer = isHealthServer;
    }

    List<String> checkUpdateDataIds(HttpAgent httpAgent, ConfigTransportClient configTransportClient, List<CacheData> cacheDatas, List<String> inInitializingCacheList) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDatas) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            if (StringUtils.isBlank((String)cacheData.tenant)) {
                sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            } else {
                sb.append(cacheData.getMd5()).append(Constants.WORD_SEPARATOR);
                sb.append(cacheData.getTenant()).append(Constants.LINE_SEPARATOR);
            }
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateConfigStr(httpAgent, configTransportClient, sb.toString(), isInitializingCacheList);
    }

    List<String> checkUpdateConfigStr(HttpAgent httpAgent, ConfigTransportClient configTransportClient, String probeUpdateString, boolean isInitializingCacheList) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("Listening-Configs", probeUpdateString);
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Long-Pulling-Timeout", "" + this.timeout);
        if (isInitializingCacheList) {
            headers.put("Long-Pulling-Timeout-No-Hangup", "true");
        }
        if (StringUtils.isBlank((String)probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            Map<String, String> signHeaders;
            Map<String, String> commonHeader;
            Map<String, String> spasHeaders;
            Map<String, String> securityHeaders = configTransportClient.getSecurityHeaders();
            if (securityHeaders != null) {
                params.putAll(securityHeaders);
            }
            if ((spasHeaders = configTransportClient.getSpasHeaders()) != null) {
                headers.putAll(spasHeaders);
            }
            if ((commonHeader = configTransportClient.getCommonHeader()) != null) {
                headers.putAll(commonHeader);
            }
            if ((signHeaders = SpasAdapter.getSignHeaders(params, configTransportClient.secretKey)) != null) {
                headers.putAll(signHeaders);
            }
            long readTimeoutMs = this.timeout + (long)Math.round(this.timeout >> 1);
            HttpRestResult<String> result = httpAgent.httpPost("/v1/cs/configs/listener", headers, params, httpAgent.getEncode(), readTimeoutMs);
            if (result.ok()) {
                this.setHealthServer(true);
                return this.parseUpdateDataIdResponse(httpAgent, (String)result.getData());
            }
            this.setHealthServer(false);
            LOGGER.error("[{}] [check-update] get changed dataId error, code: {}", (Object)httpAgent.getName(), (Object)result.getCode());
        }
        catch (Exception e) {
            this.setHealthServer(false);
            LOGGER.error("[" + httpAgent.getName() + "] [check-update] get changed dataId exception", (Throwable)e);
            throw e;
        }
        return Collections.emptyList();
    }

    private List<String> parseUpdateDataIdResponse(HttpAgent httpAgent, String response) {
        if (StringUtils.isBlank((String)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error("[" + httpAgent.getName() + "] [polling-resp] decode modifiedDataIdsString error", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isBlank((String)dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 2) {
                updateList.add(GroupKey.getKey(dataId, group));
                LOGGER.info("[{}] [polling-resp] config changed. dataId={}, group={}", new Object[]{httpAgent.getName(), dataId, group});
                continue;
            }
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant(dataId, group, tenant));
                LOGGER.info("[{}] [polling-resp] config changed. dataId={}, group={}, tenant={}", new Object[]{httpAgent.getName(), dataId, group, tenant});
                continue;
            }
            LOGGER.error("[{}] [polling-resp] invalid dataIdAndGroup error {}", (Object)httpAgent.getName(), (Object)dataIdAndGroup);
        }
        return updateList;
    }

    public String getAgentName() {
        return this.agent.getName();
    }

    class LongPollingRunnable
    implements Runnable {
        private final int taskId;
        private HttpAgent httpAgent;
        private ConfigTransportClient configTransportClient;

        public LongPollingRunnable(HttpAgent httpAgent, int taskId, ConfigTransportClient configTransportClient) {
            this.taskId = taskId;
            this.httpAgent = httpAgent;
            this.configTransportClient = configTransportClient;
        }

        @Override
        public void run() {
            ArrayList<CacheData> cacheDatas = new ArrayList<CacheData>();
            ArrayList<String> inInitializingCacheList = new ArrayList<String>();
            try {
                for (CacheData cacheData : ((Map)ClientWorker.this.cacheMap.get()).values()) {
                    if (cacheData.getTaskId() != this.taskId) continue;
                    cacheDatas.add(cacheData);
                    try {
                        ClientWorker.this.checkLocalConfig(this.httpAgent.getName(), cacheData);
                        if (!cacheData.isUseLocalConfigInfo()) continue;
                        cacheData.checkListenerMd5();
                    }
                    catch (Exception e) {
                        LOGGER.error("get local config info error", (Throwable)e);
                    }
                }
                List<String> changedGroupKeys = ClientWorker.this.checkUpdateDataIds(this.httpAgent, this.configTransportClient, cacheDatas, inInitializingCacheList);
                if (!CollectionUtils.isEmpty(changedGroupKeys)) {
                    LOGGER.info("get changedGroupKeys:" + changedGroupKeys);
                }
                for (String groupKey : changedGroupKeys) {
                    String[] key = GroupKey.parseKey(groupKey);
                    String dataId = key[0];
                    String group = key[1];
                    String tenant = null;
                    if (key.length == 3) {
                        tenant = key[2];
                    }
                    try {
                        CacheData cache = (CacheData)((Map)ClientWorker.this.cacheMap.get()).get(GroupKey.getKeyTenant(dataId, group, tenant));
                        String[] ct = ClientWorker.this.getServerConfig(dataId, group, tenant, 3000L, !cache.isInitializing());
                        cache.setContent(ct[0]);
                        if (null != ct[1]) {
                            cache.setType(ct[1]);
                        }
                        LOGGER.info("[{}] [data-received] dataId={}, group={}, tenant={}, md5={}, content={}, type={}", new Object[]{this.httpAgent.getName(), dataId, group, tenant, cache.getMd5(), ContentUtils.truncateContent(ct[0]), ct[1]});
                    }
                    catch (NacosException ioe) {
                        String message = String.format("[%s] [get-update] get changed config exception. dataId=%s, group=%s, tenant=%s", this.httpAgent.getName(), dataId, group, tenant);
                        LOGGER.error(message, (Throwable)ioe);
                    }
                }
                for (CacheData cacheData : cacheDatas) {
                    if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant))) continue;
                    cacheData.checkListenerMd5();
                    cacheData.setInitializing(false);
                }
                inInitializingCacheList.clear();
                this.configTransportClient.executor.execute(this);
            }
            catch (Throwable e) {
                LOGGER.error("longPolling error : ", e);
                this.configTransportClient.executor.schedule(this, (long)ClientWorker.this.taskPenaltyTime, TimeUnit.MILLISECONDS);
            }
        }
    }

    public class ConfigHttpTransportClient
    extends ConfigTransportClient {
        private static final long POST_TIMEOUT = 3000L;
        HttpAgent agent;
        private double currentLongingTaskCount;

        public ConfigHttpTransportClient(Properties properties, ServerListManager serverListManager) throws NacosException {
            super(properties, serverListManager);
            this.currentLongingTaskCount = 0.0;
            this.agent = new MetricsHttpAgent(new ServerHttpAgent(properties));
        }

        @Override
        public void startInternal() {
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigHttpTransportClient.this.executeConfigListen();
                    }
                    catch (Throwable e) {
                        LOGGER.error("[" + ConfigHttpTransportClient.this.agent.getName() + "] [sub-check] rotate check error", e);
                    }
                }
            }, 1L, 10L, TimeUnit.MILLISECONDS);
        }

        @Override
        public String getName() {
            return this.agent.getName();
        }

        @Override
        public void notifyListenConfig() {
        }

        @Override
        public void executeConfigListen() {
            int listenerSize = ((Map)ClientWorker.this.cacheMap.get()).size();
            int longingTaskCount = (int)Math.ceil((double)listenerSize / ParamUtil.getPerTaskConfigSize());
            if ((double)longingTaskCount > this.currentLongingTaskCount) {
                for (int i = (int)this.currentLongingTaskCount; i < longingTaskCount; ++i) {
                    this.executor.execute(new LongPollingRunnable(this.agent, i, this));
                }
                this.currentLongingTaskCount = longingTaskCount;
            }
        }

        @Override
        public void removeCache(String dataId, String group) {
            ClientWorker.this.removeCache(dataId, group);
        }

        @Override
        public String[] queryConfig(String dataId, String group, String tenant, long readTimeout, boolean notify) throws NacosException {
            String[] ct = new String[2];
            if (StringUtils.isBlank((String)group)) {
                group = "DEFAULT_GROUP";
            }
            HttpRestResult<String> result = null;
            try {
                HashMap<String, String> params = new HashMap<String, String>(3);
                if (StringUtils.isBlank((String)tenant)) {
                    params.put("dataId", dataId);
                    params.put("group", group);
                } else {
                    params.put("dataId", dataId);
                    params.put("group", group);
                    params.put("tenant", tenant);
                }
                HashMap<String, String> headers = new HashMap<String, String>(16);
                headers.put("notify", String.valueOf(notify));
                result = this.httpGet("/v1/cs/configs", headers, params, this.agent.getEncode(), readTimeout);
            }
            catch (Exception ex) {
                String message = String.format("[%s] [sub-server] get server config exception, dataId=%s, group=%s, tenant=%s", this.agent.getName(), dataId, group, tenant);
                LOGGER.error(message, (Throwable)ex);
                throw new NacosException(500, (Throwable)ex);
            }
            switch (result.getCode()) {
                case 200: {
                    LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, (String)result.getData());
                    ct[0] = (String)result.getData();
                    ct[1] = result.getHeader().getValue("Config-Type") != null ? result.getHeader().getValue("Config-Type") : ConfigType.TEXT.getType();
                    return ct;
                }
                case 404: {
                    LocalConfigInfoProcessor.saveSnapshot(this.agent.getName(), dataId, group, tenant, null);
                    return ct;
                }
                case 409: {
                    LOGGER.error("[{}] [sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
                    throw new NacosException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
                }
                case 403: {
                    LOGGER.error("[{}] [sub-server-error] no right, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
                    throw new NacosException(result.getCode(), result.getMessage());
                }
            }
            LOGGER.error("[{}] [sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode()});
            throw new NacosException(result.getCode(), "http error, code=" + result.getCode() + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
        }

        private void assembleHttpParams(Map<String, String> params, Map<String, String> headers) throws Exception {
            Map<String, String> signHeaders;
            Map<String, String> commonHeader;
            Map<String, String> spasHeaders;
            Map<String, String> securityHeaders = super.getSecurityHeaders();
            if (securityHeaders != null) {
                params.putAll(securityHeaders);
                if (StringUtils.isNotBlank((String)this.tenant) && !params.containsKey("tenant")) {
                    params.put("tenant", this.tenant);
                }
            }
            if ((spasHeaders = super.getSpasHeaders()) != null) {
                headers.putAll(spasHeaders);
            }
            if ((commonHeader = super.getCommonHeader()) != null) {
                headers.putAll(commonHeader);
            }
            if ((signHeaders = SpasAdapter.getSignHeaders(params, this.secretKey)) != null) {
                headers.putAll(signHeaders);
            }
        }

        @Override
        public boolean publishConfig(String dataId, String group, String tenant, String appName, String tag, String betaIps, String content) throws NacosException {
            group = ClientWorker.this.null2defaultGroup(group);
            ParamUtils.checkParam(dataId, group, content);
            ConfigRequest cr = new ConfigRequest();
            cr.setDataId(dataId);
            cr.setTenant(tenant);
            cr.setGroup(group);
            cr.setContent(content);
            ClientWorker.this.configFilterChainManager.doFilter(cr, null);
            content = cr.getContent();
            String url = "/v1/cs/configs";
            HashMap<String, String> params = new HashMap<String, String>(6);
            params.put("dataId", dataId);
            params.put("group", group);
            params.put("content", content);
            if (StringUtils.isNotEmpty((String)tenant)) {
                params.put("tenant", tenant);
            }
            if (StringUtils.isNotEmpty((String)appName)) {
                params.put("appName", appName);
            }
            if (StringUtils.isNotEmpty((String)tag)) {
                params.put("tag", tag);
            }
            HashMap<String, String> headers = new HashMap<String, String>(1);
            if (StringUtils.isNotEmpty((String)betaIps)) {
                headers.put("betaIps", betaIps);
            }
            HttpRestResult<String> result = null;
            try {
                result = this.httpPost(url, headers, params, this.encode, 3000L);
            }
            catch (Exception ex) {
                LOGGER.warn("[{}] [publish-single] exception, dataId={}, group={}, msg={}", new Object[]{this.agent.getName(), dataId, group, ex.toString()});
                return false;
            }
            if (result.ok()) {
                LOGGER.info("[{}] [publish-single] ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
                return true;
            }
            if (403 == result.getCode()) {
                LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
                throw new NacosException(result.getCode(), result.getMessage());
            }
            LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
            return false;
        }

        private HttpRestResult<String> httpPost(String path, Map<String, String> headers, Map<String, String> paramValues, String encoding, long readTimeoutMs) throws Exception {
            if (headers == null) {
                headers = new HashMap<String, String>(16);
            }
            this.assembleHttpParams(paramValues, headers);
            return this.agent.httpPost(path, headers, paramValues, encoding, readTimeoutMs);
        }

        private HttpRestResult<String> httpGet(String path, Map<String, String> headers, Map<String, String> paramValues, String encoding, long readTimeoutMs) throws Exception {
            if (headers == null) {
                headers = new HashMap<String, String>(16);
            }
            this.assembleHttpParams(paramValues, headers);
            return this.agent.httpGet(path, headers, paramValues, encoding, readTimeoutMs);
        }

        private HttpRestResult<String> httpDelete(String path, Map<String, String> headers, Map<String, String> paramValues, String encoding, long readTimeoutMs) throws Exception {
            if (headers == null) {
                headers = new HashMap<String, String>(16);
            }
            this.assembleHttpParams(paramValues, headers);
            return this.agent.httpDelete(path, headers, paramValues, encoding, readTimeoutMs);
        }

        @Override
        public boolean removeConfig(String dataId, String group, String tenat, String tag) throws NacosException {
            group = ClientWorker.this.null2defaultGroup(group);
            ParamUtils.checkKeyParam(dataId, group);
            String url = "/v1/cs/configs";
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("dataId", dataId);
            params.put("group", group);
            if (StringUtils.isNotEmpty((String)this.tenant)) {
                params.put("tenant", this.tenant);
            }
            if (StringUtils.isNotEmpty((String)tag)) {
                params.put("tag", tag);
            }
            HttpRestResult<String> result = null;
            try {
                result = this.httpDelete(url, null, params, this.encode, 3000L);
            }
            catch (Exception ex) {
                LOGGER.warn("[remove] error, " + dataId + ", " + group + ", " + this.tenant + ", msg: " + ex.toString());
                return false;
            }
            if (result.ok()) {
                LOGGER.info("[{}] [remove] ok, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, this.tenant});
                return true;
            }
            if (403 == result.getCode()) {
                LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, this.tenant, result.getCode(), result.getMessage()});
                throw new NacosException(result.getCode(), result.getMessage());
            }
            LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, this.tenant, result.getCode(), result.getMessage()});
            return false;
        }
    }

    public class ConfigRpcTransportClient
    extends ConfigTransportClient {
        private final BlockingQueue<Object> listenExecutebell;
        private Object bellItem;
        private Map<String, RpcClient> rpcClientMap;

        public ConfigRpcTransportClient(Properties properties, ServerListManager serverListManager) {
            super(properties, serverListManager);
            this.listenExecutebell = new ArrayBlockingQueue<Object>(1);
            this.bellItem = new Object();
            this.rpcClientMap = new HashMap<String, RpcClient>();
        }

        private ConnectionType getConnectionType() {
            ConnectionType connectionTypeInner;
            ConnectionType connectionType = ConnectionType.GRPC;
            String connectionTypeString = ParamUtils.configRemoteConnectionType();
            if (StringUtils.isNotBlank((String)connectionTypeString) && (connectionTypeInner = ConnectionType.valueOf((String)connectionTypeString)) != null) {
                connectionType = connectionTypeInner;
            }
            return connectionType;
        }

        private Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>(2, 1.0f);
            labels.put("source", "sdk");
            labels.put("module", "config");
            labels.put("AppName", AppNameUtils.getAppName());
            return labels;
        }

        private void initRpcClientHandler(final RpcClient rpcClientInner) {
            rpcClientInner.registerServerRequestHandler((request, requestMeta) -> {
                if (request instanceof ConfigChangeNotifyRequest || request instanceof ConfigReSyncRequest) {
                    ConfigReSyncRequest configReSyncRequest = (ConfigReSyncRequest)request;
                    LOGGER.info("[{}] [server-push] config {}. dataId={}, group={}", new Object[]{rpcClientInner.getName(), request instanceof ConfigChangeNotifyRequest ? "changed" : "re sync", configReSyncRequest.getDataId(), configReSyncRequest.getGroup()});
                    String groupKey = GroupKey.getKeyTenant(configReSyncRequest.getDataId(), configReSyncRequest.getGroup(), configReSyncRequest.getTenant());
                    CacheData cacheData = (CacheData)((Map)ClientWorker.this.cacheMap.get()).get(groupKey);
                    if (cacheData != null) {
                        cacheData.setSync(false);
                        this.notifyListenConfig();
                    }
                    return request instanceof ConfigChangeNotifyRequest ? new ConfigChangeNotifyResponse() : new ConfigReSyncResponse();
                }
                return null;
            });
            rpcClientInner.registerServerRequestHandler((request, requestMeta) -> {
                if (request instanceof ClientConfigMetricRequest) {
                    ClientConfigMetricResponse response = new ClientConfigMetricResponse();
                    response.setMetrics(ClientWorker.this.getMetrics(((ClientConfigMetricRequest)request).getMetricsKeys()));
                    return response;
                }
                return null;
            });
            rpcClientInner.registerConnectionListener(new ConnectionEventListener(){

                public void onConnected() {
                    LOGGER.info("[{}] Connected,notify listen context...", (Object)rpcClientInner.getName());
                    ConfigRpcTransportClient.this.notifyListenConfig();
                }

                public void onDisConnect() {
                    String taskId = (String)rpcClientInner.getLabels().get("taskId");
                    LOGGER.info("[{}] DisConnected,clear listen context...", (Object)rpcClientInner.getName());
                    Collection values = ((Map)ClientWorker.this.cacheMap.get()).values();
                    for (CacheData cacheData : values) {
                        if (StringUtils.isNotBlank((String)taskId)) {
                            if (!Integer.valueOf(taskId).equals(cacheData.getTaskId())) continue;
                            cacheData.setSync(false);
                            continue;
                        }
                        cacheData.setSync(false);
                    }
                }
            });
            rpcClientInner.init(new ServerListFactory(){

                public String genNextServer() {
                    return ConfigRpcTransportClient.this.serverListManager.getNextServerAddr();
                }

                public String getCurrentServer() {
                    return ConfigRpcTransportClient.this.serverListManager.getCurrentServerAddr();
                }

                public List<String> getServerList() {
                    return ((ConfigRpcTransportClient)ConfigRpcTransportClient.this).serverListManager.serverUrls;
                }
            });
        }

        @Override
        public void startInternal() throws NacosException {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                ConfigRpcTransportClient.this.listenExecutebell.poll(5L, TimeUnit.SECONDS);
                                ConfigRpcTransportClient.this.executeConfigListen();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("[ rpc listen execute ] [rpc listen] exception", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }, 0L, TimeUnit.MILLISECONDS);
            NotifyCenter.registerSubscriber((Subscriber)new Subscriber(){

                public void onEvent(Event event) {
                    for (RpcClient rpcClient : ConfigRpcTransportClient.this.rpcClientMap.values()) {
                        RpcClient.ServerInfo currentServer = rpcClient.getCurrentServer();
                        if (currentServer == null) continue;
                        List<String> serverUrls = ConfigRpcTransportClient.this.serverListManager.getServerUrls();
                        String currentServerIp = currentServer.getServerIp();
                        int currentServerPort = currentServer.getServerPort() - rpcClient.rpcPortOffset();
                        String currentAddress = currentServerIp + ":" + currentServerPort;
                        for (String server : serverUrls) {
                            if (!server.equals(currentAddress)) continue;
                            rpcClient.switchServerAsync();
                            return;
                        }
                    }
                }

                public Class<? extends Event> subscribeType() {
                    return ServerlistChangeEvent.class;
                }
            });
        }

        @Override
        public String getName() {
            return "config_rpc_client";
        }

        @Override
        public void notifyListenConfig() {
            this.listenExecutebell.offer(this.bellItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void executeConfigListen() {
            RpcClient rpcClient;
            ConfigBatchListenRequest configChangeListenRequest;
            String taskId;
            HashMap<String, LinkedList<CacheData>> listenCachesMap = new HashMap<String, LinkedList<CacheData>>(16);
            HashMap<String, LinkedList<CacheData>> removeListenCachesMap = new HashMap<String, LinkedList<CacheData>>(16);
            for (CacheData cacheData : ((Map)ClientWorker.this.cacheMap.get()).values()) {
                List<CacheData> cacheDatas;
                if (cacheData.isSync()) continue;
                if (!CollectionUtils.isEmpty(cacheData.getListeners())) {
                    if (cacheData.isUseLocalConfigInfo()) continue;
                    cacheDatas = (LinkedList<CacheData>)listenCachesMap.get(String.valueOf(cacheData.getTaskId()));
                    if (cacheDatas == null) {
                        cacheDatas = new LinkedList<CacheData>();
                        listenCachesMap.put(String.valueOf(cacheData.getTaskId()), (LinkedList<CacheData>)cacheDatas);
                    }
                    cacheDatas.add(cacheData);
                    continue;
                }
                if (!CollectionUtils.isEmpty(cacheData.getListeners()) || cacheData.isUseLocalConfigInfo()) continue;
                cacheDatas = (List)removeListenCachesMap.get(String.valueOf(cacheData.getTaskId()));
                if (cacheDatas == null) {
                    cacheDatas = new LinkedList();
                    removeListenCachesMap.put(String.valueOf(cacheData.getTaskId()), (LinkedList<CacheData>)cacheDatas);
                }
                cacheDatas.add(cacheData);
            }
            if (!listenCachesMap.isEmpty()) {
                for (Map.Entry entry : listenCachesMap.entrySet()) {
                    taskId = (String)entry.getKey();
                    List listenCaches = (List)entry.getValue();
                    configChangeListenRequest = this.buildConfigRequest(listenCaches);
                    configChangeListenRequest.setListen(true);
                    try {
                        rpcClient = this.ensureRpcClient(taskId);
                        ConfigChangeBatchListenResponse configChangeBatchListenResponse = (ConfigChangeBatchListenResponse)this.requestProxy(rpcClient, (Request)configChangeListenRequest);
                        if (configChangeBatchListenResponse == null || !configChangeBatchListenResponse.isSuccess()) continue;
                        HashSet<String> changeKeys = new HashSet<String>();
                        if (!CollectionUtils.isEmpty(configChangeBatchListenResponse.getChangedConfigs())) {
                            for (ConfigChangeBatchListenResponse.ConfigContext changeConfig : configChangeBatchListenResponse.getChangedConfigs()) {
                                String changeKey = GroupKey.getKeyTenant(changeConfig.getDataId(), changeConfig.getGroup(), changeConfig.getTenant());
                                changeKeys.add(changeKey);
                                boolean isInitializing = ((CacheData)((Map)ClientWorker.this.cacheMap.get()).get(changeKey)).isInitializing();
                                ClientWorker.this.refreshContentAndCheck(changeKey, !isInitializing);
                            }
                        }
                        for (CacheData cacheData : listenCaches) {
                            if (!changeKeys.contains(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.getTenant()))) {
                                if (cacheData.checkListenersMd5Consistent()) {
                                    cacheData.setSync(true);
                                } else {
                                    cacheData.checkListenerMd5();
                                }
                            }
                            cacheData.setInitializing(false);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof NacosException && ((NacosException)((Object)e)).getErrCode() == -401) {
                            LOGGER.warn("async listen config change fail ,client is not connected.");
                        } else {
                            LOGGER.error("async listen config change error ", (Throwable)e);
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException configChangeBatchListenResponse) {}
                    }
                }
            }
            if (!removeListenCachesMap.isEmpty()) {
                for (Map.Entry entry : removeListenCachesMap.entrySet()) {
                    taskId = (String)entry.getKey();
                    List removeListenCaches = (List)entry.getValue();
                    configChangeListenRequest = this.buildConfigRequest(removeListenCaches);
                    configChangeListenRequest.setListen(false);
                    try {
                        rpcClient = this.ensureRpcClient(taskId);
                        boolean removeSuccess = this.unListenConfigChange(rpcClient, configChangeListenRequest);
                        if (removeSuccess) {
                            Iterator iterator = removeListenCaches.iterator();
                            while (iterator.hasNext()) {
                                CacheData cacheData;
                                CacheData cacheData2 = cacheData = (CacheData)iterator.next();
                                synchronized (cacheData2) {
                                    if (cacheData.getListeners().isEmpty()) {
                                        ClientWorker.this.removeCache(cacheData.dataId, cacheData.group, cacheData.tenant);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("async remove listen config change error ", (Throwable)e);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private synchronized RpcClient ensureRpcClient(String taskId) throws NacosException {
            Map<String, String> labels = this.getLabels();
            HashMap<String, String> newlabels = new HashMap<String, String>(labels);
            newlabels.put("taskId", taskId);
            RpcClient rpcClient = RpcClientFactory.createClient((String)("config-" + taskId + "-" + ClientWorker.this.uuid), (ConnectionType)this.getConnectionType(), newlabels);
            if (rpcClient.isWaitInitiated()) {
                this.initRpcClientHandler(rpcClient);
                rpcClient.start();
            }
            return rpcClient;
        }

        private ConfigBatchListenRequest buildConfigRequest(List<CacheData> caches) {
            ConfigBatchListenRequest configChangeListenRequest = new ConfigBatchListenRequest();
            for (CacheData cacheData : caches) {
                configChangeListenRequest.addConfigListenContext(cacheData.group, cacheData.dataId, cacheData.tenant, cacheData.getMd5());
            }
            return configChangeListenRequest;
        }

        @Override
        public void removeCache(String dataId, String group) {
            this.notifyListenConfig();
        }

        private boolean unListenConfigChange(RpcClient rpcClient, ConfigBatchListenRequest configChangeListenRequest) throws NacosException {
            ConfigChangeBatchListenResponse response = (ConfigChangeBatchListenResponse)this.requestProxy(rpcClient, (Request)configChangeListenRequest);
            return response.isSuccess();
        }

        @Override
        public String[] queryConfig(String dataId, String group, String tenant, long readTimeouts, boolean notify) throws NacosException {
            ConfigQueryRequest request = ConfigQueryRequest.build((String)dataId, (String)group, (String)tenant);
            request.putHeader("notify", String.valueOf(notify));
            ConfigQueryResponse response = (ConfigQueryResponse)this.requestProxy(this.getOneRunningClient(), (Request)request, readTimeouts);
            String[] ct = new String[2];
            if (response.isSuccess()) {
                LocalConfigInfoProcessor.saveSnapshot(this.getName(), dataId, group, tenant, response.getContent());
                ct[0] = response.getContent();
                ct[1] = StringUtils.isNotBlank((String)response.getContentType()) ? response.getContentType() : ConfigType.TEXT.getType();
                return ct;
            }
            if (response.getErrorCode() == 300) {
                LocalConfigInfoProcessor.saveSnapshot(this.getName(), dataId, group, tenant, null);
                return ct;
            }
            if (response.getErrorCode() == 400) {
                LOGGER.error("[{}] [sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{this.getName(), dataId, group, tenant});
                throw new NacosException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            LOGGER.error("[{}] [sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{this.getName(), dataId, group, tenant, response});
            throw new NacosException(response.getErrorCode(), "http error, code=" + response.getErrorCode() + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
        }

        private Response requestProxy(RpcClient rpcClientInner, Request request) throws NacosException {
            return this.requestProxy(rpcClientInner, request, 3000L);
        }

        private Response requestProxy(RpcClient rpcClientInner, Request request, long timeoutMills) throws NacosException {
            try {
                request.putAllHeader(super.getSecurityHeaders());
                request.putAllHeader(super.getSpasHeaders());
            }
            catch (Exception e) {
                throw new NacosException(-400, (Throwable)e);
            }
            JsonObject asJsonObjectTemp = new Gson().toJsonTree((Object)request).getAsJsonObject();
            asJsonObjectTemp.remove("headers");
            asJsonObjectTemp.remove("requestId");
            boolean limit = Limiter.isLimit(request.getClass() + asJsonObjectTemp.toString());
            if (limit) {
                throw new NacosException(-503, "More than client-side current limit threshold");
            }
            return rpcClientInner.request(request, timeoutMills);
        }

        RpcClient getOneRunningClient() throws NacosException {
            return this.ensureRpcClient("0");
        }

        @Override
        public boolean publishConfig(String dataId, String group, String tenant, String appName, String tag, String betaIps, String content) throws NacosException {
            try {
                ConfigPublishRequest request = new ConfigPublishRequest(dataId, group, tenant, content);
                request.putAdditonalParam("tag", tag);
                request.putAdditonalParam("appName", appName);
                request.putAdditonalParam("betaIps", betaIps);
                ConfigPublishResponse response = (ConfigPublishResponse)this.requestProxy(this.getOneRunningClient(), (Request)request);
                return response.isSuccess();
            }
            catch (Exception e) {
                LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.getName(), dataId, group, tenant, "unkonw", e.getMessage()});
                return false;
            }
        }

        @Override
        public boolean removeConfig(String dataId, String group, String tenant, String tag) throws NacosException {
            ConfigRemoveRequest request = new ConfigRemoveRequest(dataId, group, tenant, tag);
            ConfigRemoveResponse response = (ConfigRemoveResponse)this.requestProxy(this.getOneRunningClient(), (Request)request);
            return response.isSuccess();
        }
    }
}

