/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.core.ServerListManager;
import com.alibaba.nacos.client.naming.core.ServiceInfoUpdateService;
import com.alibaba.nacos.client.naming.event.InstancesChangeNotifier;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.Properties;
import java.util.Set;

public class NamingClientProxyDelegate
implements NamingClientProxy {
    private final ServerListManager serverListManager;
    private final ServiceInfoUpdateService serviceInfoUpdateService;
    private final ServiceInfoHolder serviceInfoHolder;
    private final NamingHttpClientProxy httpClientProxy;
    private final NamingGrpcClientProxy grpcClientProxy;

    public NamingClientProxyDelegate(String namespace, ServiceInfoHolder serviceInfoHolder, Properties properties, InstancesChangeNotifier changeNotifier) throws NacosException {
        this.serviceInfoUpdateService = new ServiceInfoUpdateService(properties, serviceInfoHolder, this, changeNotifier);
        this.serverListManager = new ServerListManager(properties);
        this.serviceInfoHolder = serviceInfoHolder;
        this.httpClientProxy = new NamingHttpClientProxy(namespace, this.serverListManager, properties, serviceInfoHolder);
        this.grpcClientProxy = new NamingGrpcClientProxy(namespace, this.serverListManager, properties, serviceInfoHolder);
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy().registerService(serviceName, groupName, instance);
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy().deregisterService(serviceName, groupName, instance);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, int udpPort, boolean healthyOnly) throws NacosException {
        return this.getExecuteClientProxy().queryInstancesOfService(serviceName, groupName, clusters, udpPort, healthyOnly);
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return null;
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return false;
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        return this.getExecuteClientProxy().getServiceList(pageNo, pageSize, groupName, selector);
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        String serviceNameWithGroup = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        String serviceKey = ServiceInfo.getKey((String)serviceNameWithGroup, (String)clusters);
        ServiceInfo result = this.serviceInfoHolder.getServiceInfoMap().get(serviceKey);
        if (null == result) {
            result = this.getExecuteClientProxy().subscribe(serviceName, groupName, clusters);
        }
        this.serviceInfoUpdateService.scheduleUpdateIfAbsent(serviceName, groupName, clusters);
        this.serviceInfoHolder.processServiceInfo(result);
        return result;
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        this.serviceInfoUpdateService.stopUpdateIfContain(serviceName, groupName, clusters);
        this.getExecuteClientProxy().unsubscribe(serviceName, groupName, clusters);
    }

    @Override
    public void updateBeatInfo(Set<Instance> modifiedInstances) {
        this.httpClientProxy.updateBeatInfo(modifiedInstances);
    }

    @Override
    public boolean serverHealthy() {
        return this.grpcClientProxy.serverHealthy() || this.httpClientProxy.serverHealthy();
    }

    private NamingClientProxy getExecuteClientProxy() {
        return this.grpcClientProxy;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.serviceInfoUpdateService.shutdown();
        this.serverListManager.shutdown();
        this.httpClientProxy.shutdown();
        this.grpcClientProxy.shutdown();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

