/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.utils;

import com.alibaba.nacos.common.utils.IoUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentDiskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentDiskUtil.class);
    static final int RETRY_COUNT = 10;
    static final int SLEEP_BASETIME = 10;
    private static final String READ_ONLY = "r";
    private static final String READ_WRITE = "rw";

    public static String getFileContent(String path, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.getFileContent(file, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file, String charsetName) throws IOException {
        RandomAccessFile fis = null;
        FileLock rlock = null;
        try {
            fis = new RandomAccessFile(file, READ_ONLY);
            FileChannel fcin = fis.getChannel();
            int i = 0;
            do {
                try {
                    rlock = fcin.tryLock(0L, Long.MAX_VALUE, true);
                }
                catch (Exception e) {
                    if (++i > 10) {
                        LOGGER.error("read {} fail;retryed time:{}", (Object)file.getName(), (Object)i);
                        throw new IOException("read " + file.getAbsolutePath() + " conflict");
                    }
                    ConcurrentDiskUtil.sleep(10 * i);
                    LOGGER.warn("read {} conflict;retry time:{}", (Object)file.getName(), (Object)i);
                }
            } while (null == rlock);
            int fileSize = (int)fcin.size();
            ByteBuffer byteBuffer = ByteBuffer.allocate(fileSize);
            fcin.read(byteBuffer);
            byteBuffer.flip();
            String string = ConcurrentDiskUtil.byteBufferToString(byteBuffer, charsetName);
            return string;
        }
        finally {
            if (rlock != null) {
                rlock.release();
                rlock = null;
            }
            if (fis != null) {
                IoUtils.closeQuietly(fis);
                fis = null;
            }
        }
    }

    public static Boolean writeFileContent(String path, String content, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.writeFileContent(file, content, charsetName);
    }

    public static Boolean writeFileContent(File file, String content, String charsetName) throws IOException {
        boolean isCreateOk;
        if (!file.exists() && !(isCreateOk = file.createNewFile())) {
            return false;
        }
        FileChannel channel = null;
        FileLock lock = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, READ_WRITE);
            channel = raf.getChannel();
            int i = 0;
            do {
                try {
                    lock = channel.tryLock();
                }
                catch (Exception e) {
                    if (++i > 10) {
                        LOGGER.error("write {} fail;retryed time:{}", (Object)file.getName(), (Object)i);
                        throw new IOException("write " + file.getAbsolutePath() + " conflict");
                    }
                    ConcurrentDiskUtil.sleep(10 * i);
                    LOGGER.warn("write {} conflict;retry time:{}", (Object)file.getName(), (Object)i);
                }
            } while (null == lock);
            ByteBuffer sendBuffer = ByteBuffer.wrap(content.getBytes(charsetName));
            while (sendBuffer.hasRemaining()) {
                channel.write(sendBuffer);
            }
            channel.truncate(content.length());
        }
        catch (FileNotFoundException e) {
            throw new IOException("file not exist");
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                    lock = null;
                }
                catch (IOException e) {
                    LOGGER.warn("close wrong", (Throwable)e);
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                    channel = null;
                }
                catch (IOException e) {
                    LOGGER.warn("close wrong", (Throwable)e);
                }
            }
            if (raf != null) {
                try {
                    raf.close();
                    raf = null;
                }
                catch (IOException e) {
                    LOGGER.warn("close wrong", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static String byteBufferToString(ByteBuffer buffer, String charsetName) throws IOException {
        Charset charset = null;
        CharsetDecoder decoder = null;
        CharBuffer charBuffer = null;
        charset = Charset.forName(charsetName);
        decoder = charset.newDecoder();
        charBuffer = decoder.decode(buffer.asReadOnlyBuffer());
        return charBuffer.toString();
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.warn("sleep wrong", (Throwable)e);
        }
    }
}

