/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc.redo.data;

public abstract class RedoData<T> {
    private final String serviceName;
    private final String groupName;
    private volatile boolean registered;
    private volatile boolean unregistering;
    private T data;

    protected RedoData(String serviceName, String groupName) {
        this.serviceName = serviceName;
        this.groupName = groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isUnregistering() {
        return this.unregistering;
    }

    public void setUnregistering(boolean unregistering) {
        this.unregistering = unregistering;
    }

    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
    }

    public RedoType getRedoType() {
        if (this.isRegistered() && !this.isUnregistering()) {
            return RedoType.NONE;
        }
        if (this.isRegistered() && this.isUnregistering()) {
            return RedoType.UNREGISTER;
        }
        if (!this.isRegistered() && !this.isUnregistering()) {
            return RedoType.REGISTER;
        }
        return RedoType.REMOVE;
    }

    public boolean isNeedRedo() {
        return !RedoType.NONE.equals((Object)this.getRedoType());
    }

    public static enum RedoType {
        REGISTER,
        UNREGISTER,
        NONE,
        REMOVE;

    }
}

