/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.concurrent.TimeUnit;

public class HttpClientConfig {
    private final int conTimeOutMillis;
    private final int readTimeOutMillis;
    private final long connTimeToLive;
    private final TimeUnit connTimeToLiveTimeUnit;
    private final int connectionRequestTimeout;
    private final int maxRedirects;
    private final int maxConnTotal;
    private final int maxConnPerRoute;
    private final boolean contentCompressionEnabled;
    private final int ioThreadCount;
    private final String userAgent;

    public HttpClientConfig(int conTimeOutMillis, int readTimeOutMillis, long connTimeToLive, TimeUnit timeUnit, int connectionRequestTimeout, int maxRedirects, int maxConnTotal, int maxConnPerRoute, boolean contentCompressionEnabled, int ioThreadCount, String userAgent) {
        this.conTimeOutMillis = conTimeOutMillis;
        this.readTimeOutMillis = readTimeOutMillis;
        this.connTimeToLive = connTimeToLive;
        this.connTimeToLiveTimeUnit = timeUnit;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.maxRedirects = maxRedirects;
        this.maxConnTotal = maxConnTotal;
        this.maxConnPerRoute = maxConnPerRoute;
        this.contentCompressionEnabled = contentCompressionEnabled;
        this.ioThreadCount = ioThreadCount;
        this.userAgent = userAgent;
    }

    public int getConTimeOutMillis() {
        return this.conTimeOutMillis;
    }

    public int getReadTimeOutMillis() {
        return this.readTimeOutMillis;
    }

    public long getConnTimeToLive() {
        return this.connTimeToLive;
    }

    public TimeUnit getConnTimeToLiveTimeUnit() {
        return this.connTimeToLiveTimeUnit;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public int getMaxConnTotal() {
        return this.maxConnTotal;
    }

    public int getMaxConnPerRoute() {
        return this.maxConnPerRoute;
    }

    public boolean getContentCompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public static final class HttpClientConfigBuilder {
        private int conTimeOutMillis = -1;
        private int readTimeOutMillis = -1;
        private long connTimeToLive = -1L;
        private TimeUnit connTimeToLiveTimeUnit = TimeUnit.MILLISECONDS;
        private int connectionRequestTimeout = -1;
        private int maxRedirects = 50;
        private int maxConnTotal = 0;
        private int maxConnPerRoute = 0;
        private boolean contentCompressionEnabled = true;
        private int ioThreadCount = ThreadUtils.getSuitableThreadCount(1);
        private String userAgent;

        public HttpClientConfigBuilder setConTimeOutMillis(int conTimeOutMillis) {
            this.conTimeOutMillis = conTimeOutMillis;
            return this;
        }

        public HttpClientConfigBuilder setReadTimeOutMillis(int readTimeOutMillis) {
            this.readTimeOutMillis = readTimeOutMillis;
            return this;
        }

        public HttpClientConfigBuilder setConnectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
            this.connTimeToLive = connTimeToLive;
            this.connTimeToLiveTimeUnit = connTimeToLiveTimeUnit;
            return this;
        }

        public HttpClientConfigBuilder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public HttpClientConfigBuilder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public HttpClientConfigBuilder setMaxConnTotal(int maxConnTotal) {
            this.maxConnTotal = maxConnTotal;
            return this;
        }

        public HttpClientConfigBuilder setMaxConnPerRoute(int maxConnPerRoute) {
            this.maxConnPerRoute = maxConnPerRoute;
            return this;
        }

        public HttpClientConfigBuilder setContentCompressionEnabled(boolean contentCompressionEnabled) {
            this.contentCompressionEnabled = contentCompressionEnabled;
            return this;
        }

        public HttpClientConfigBuilder setIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public HttpClientConfigBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.conTimeOutMillis, this.readTimeOutMillis, this.connTimeToLive, this.connTimeToLiveTimeUnit, this.connectionRequestTimeout, this.maxRedirects, this.maxConnTotal, this.maxConnPerRoute, this.contentCompressionEnabled, this.ioThreadCount, this.userAgent);
        }
    }
}

