/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.opencensus.trace.internal;

import com.alibaba.nacos.shaded.io.opencensus.internal.Utils;
import com.alibaba.nacos.shaded.io.opencensus.trace.BaseMessageEvent;
import com.alibaba.nacos.shaded.io.opencensus.trace.MessageEvent;
import com.alibaba.nacos.shaded.io.opencensus.trace.NetworkEvent;

public final class BaseMessageEventUtils {
    public static MessageEvent asMessageEvent(BaseMessageEvent event) {
        Utils.checkNotNull(event, "event");
        if (event instanceof MessageEvent) {
            return (MessageEvent)event;
        }
        NetworkEvent networkEvent = (NetworkEvent)event;
        MessageEvent.Type type = networkEvent.getType() == NetworkEvent.Type.RECV ? MessageEvent.Type.RECEIVED : MessageEvent.Type.SENT;
        return MessageEvent.builder(type, networkEvent.getMessageId()).setUncompressedMessageSize(networkEvent.getUncompressedMessageSize()).setCompressedMessageSize(networkEvent.getCompressedMessageSize()).build();
    }

    public static NetworkEvent asNetworkEvent(BaseMessageEvent event) {
        Utils.checkNotNull(event, "event");
        if (event instanceof NetworkEvent) {
            return (NetworkEvent)event;
        }
        MessageEvent messageEvent = (MessageEvent)event;
        NetworkEvent.Type type = messageEvent.getType() == MessageEvent.Type.RECEIVED ? NetworkEvent.Type.RECV : NetworkEvent.Type.SENT;
        return NetworkEvent.builder(type, messageEvent.getMessageId()).setUncompressedMessageSize(messageEvent.getUncompressedMessageSize()).setCompressedMessageSize(messageEvent.getCompressedMessageSize()).build();
    }

    private BaseMessageEventUtils() {
    }
}

