/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.model.v2;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 6258345442767540526L;
    private final Integer code;
    private final String message;
    private final T data;

    public Result(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Result() {
        this(null);
    }

    public Result(T data) {
        this(ErrorCode.SUCCESS.getCode(), ErrorCode.SUCCESS.getMsg(), data);
    }

    public Result(Integer code, String message) {
        this(code, message, null);
    }

    public static <T> Result<T> success() {
        return new Result<T>();
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(data);
    }

    public static Result<String> failure(String message) {
        return Result.failure(ErrorCode.SERVER_ERROR, message);
    }

    public static <T> Result<T> failure(ErrorCode errorCode) {
        return new Result<T>(errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> Result<T> failure(ErrorCode errorCode, T data) {
        return new Result<T>(errorCode.getCode(), errorCode.getMsg(), data);
    }

    public String toString() {
        return "Result{errorCode=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }
}

