package com.alibaba.nacos.shaded.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The bottom type in the LessThan type system. Programmers should rarely write this type.
 *
 * @checker_framework.manual #index-inequalities Index Chceker Inequalities
 * @checker_framework.manual #bottom-type the bottom type
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
@SubtypeOf({LessThan.class})
public @interface LessThanBottom {}
