/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityStatus;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.remote.request.AbstractNamingRequest;
import com.alibaba.nacos.api.naming.remote.request.BatchInstanceRequest;
import com.alibaba.nacos.api.naming.remote.request.InstanceRequest;
import com.alibaba.nacos.api.naming.remote.request.PersistentInstanceRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceListRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceQueryRequest;
import com.alibaba.nacos.api.naming.remote.request.SubscribeServiceRequest;
import com.alibaba.nacos.api.naming.remote.response.BatchInstanceResponse;
import com.alibaba.nacos.api.naming.remote.response.QueryServiceResponse;
import com.alibaba.nacos.api.naming.remote.response.ServiceListResponse;
import com.alibaba.nacos.api.naming.remote.response.SubscribeServiceResponse;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.event.ServerListChangedEvent;
import com.alibaba.nacos.client.naming.remote.AbstractNamingClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.NamingPushRequestHandler;
import com.alibaba.nacos.client.naming.remote.gprc.redo.NamingGrpcRedoService;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.BatchInstanceRedoData;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.InstanceRedoData;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NamingGrpcClientProxy
extends AbstractNamingClientProxy {
    private final String namespaceId;
    private final String uuid;
    private final Long requestTimeout;
    private final RpcClient rpcClient;
    private final NamingGrpcRedoService redoService;

    public NamingGrpcClientProxy(String namespaceId, SecurityProxy securityProxy, ServerListFactory serverListFactory, NacosClientProperties properties, ServiceInfoHolder serviceInfoHolder) throws NacosException {
        super(securityProxy);
        this.namespaceId = namespaceId;
        this.uuid = UUID.randomUUID().toString();
        this.requestTimeout = Long.parseLong(properties.getProperty("namingRequestTimeout", "-1"));
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("source", "sdk");
        labels.put("module", "naming");
        labels.put("AppName", AppNameUtils.getAppName());
        this.rpcClient = RpcClientFactory.createClient(this.uuid, ConnectionType.GRPC, labels, RpcClientTlsConfig.properties(properties.asProperties()));
        this.redoService = new NamingGrpcRedoService(this, properties);
        LogUtils.NAMING_LOGGER.info("Create naming rpc client for uuid->{}", (Object)this.uuid);
        this.start(serverListFactory, serviceInfoHolder);
    }

    private void start(ServerListFactory serverListFactory, ServiceInfoHolder serviceInfoHolder) throws NacosException {
        this.rpcClient.serverListFactory(serverListFactory);
        this.rpcClient.registerConnectionListener(this.redoService);
        this.rpcClient.registerServerRequestHandler(new NamingPushRequestHandler(serviceInfoHolder));
        this.rpcClient.start();
        NotifyCenter.registerSubscriber(this);
    }

    @Override
    public void onEvent(ServerListChangedEvent event) {
        this.rpcClient.onServerListChange();
    }

    @Override
    public Class<? extends Event> subscribeType() {
        return ServerListChangedEvent.class;
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[REGISTER-SERVICE] {} registering service {} with instance {}", new Object[]{this.namespaceId, serviceName, instance});
        if (instance.isEphemeral()) {
            this.registerServiceForEphemeral(serviceName, groupName, instance);
        } else {
            this.doRegisterServiceForPersistent(serviceName, groupName, instance);
        }
    }

    private void registerServiceForEphemeral(String serviceName, String groupName, Instance instance) throws NacosException {
        this.redoService.cacheInstanceForRedo(serviceName, groupName, instance);
        this.doRegisterService(serviceName, groupName, instance);
    }

    @Override
    public void batchRegisterService(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        this.redoService.cacheInstanceForRedo(serviceName, groupName, instances);
        this.doBatchRegisterService(serviceName, groupName, instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDeregisterService(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.redoService.getRegisteredInstances();
        synchronized (concurrentMap) {
            List<Instance> retainInstance = this.getRetainInstance(serviceName, groupName, instances);
            this.batchRegisterService(serviceName, groupName, retainInstance);
        }
    }

    private List<Instance> getRetainInstance(String serviceName, String groupName, List<Instance> deRegisterInstances) throws NacosException {
        if (CollectionUtils.isEmpty(deRegisterInstances)) {
            throw new NacosException(400, String.format("[Batch deRegistration] need deRegister instance is empty, instances: %s,", deRegisterInstances));
        }
        String combinedServiceName = NamingUtils.getGroupedName(serviceName, groupName);
        InstanceRedoData instanceRedoData = this.redoService.getRegisteredInstancesByKey(combinedServiceName);
        if (!(instanceRedoData instanceof BatchInstanceRedoData)) {
            throw new NacosException(400, String.format("[Batch deRegistration] batch deRegister is not BatchInstanceRedoData type , instances: %s,", deRegisterInstances));
        }
        BatchInstanceRedoData batchInstanceRedoData = (BatchInstanceRedoData)instanceRedoData;
        List<Instance> allRedoInstances = batchInstanceRedoData.getInstances();
        if (CollectionUtils.isEmpty(allRedoInstances)) {
            throw new NacosException(400, String.format("[Batch deRegistration] not found all registerInstance , serviceName\uff1a%s , groupName: %s", serviceName, groupName));
        }
        Map deRegisterInstanceMap = deRegisterInstances.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        ArrayList<Instance> retainInstances = new ArrayList<Instance>();
        for (Instance redoInstance : allRedoInstances) {
            boolean needRetained = true;
            Iterator it = deRegisterInstanceMap.entrySet().iterator();
            while (it.hasNext()) {
                Instance deRegisterInstance = (Instance)it.next().getKey();
                if (!this.compareIpAndPort(deRegisterInstance, redoInstance)) continue;
                needRetained = false;
                it.remove();
                break;
            }
            if (!needRetained) continue;
            retainInstances.add(redoInstance);
        }
        return retainInstances;
    }

    private boolean compareIpAndPort(Instance deRegisterInstance, Instance redoInstance) {
        return deRegisterInstance.getIp().equals(redoInstance.getIp()) && deRegisterInstance.getPort() == redoInstance.getPort();
    }

    public void doBatchRegisterService(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        BatchInstanceRequest request = new BatchInstanceRequest(this.namespaceId, serviceName, groupName, "batchRegisterInstance", instances);
        this.requestToServer(request, BatchInstanceResponse.class);
        this.redoService.instanceRegistered(serviceName, groupName);
    }

    public void doRegisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        InstanceRequest request = new InstanceRequest(this.namespaceId, serviceName, groupName, "registerInstance", instance);
        this.requestToServer(request, Response.class);
        this.redoService.instanceRegistered(serviceName, groupName);
    }

    public void doRegisterServiceForPersistent(String serviceName, String groupName, Instance instance) throws NacosException {
        PersistentInstanceRequest request = new PersistentInstanceRequest(this.namespaceId, serviceName, groupName, "registerInstance", instance);
        this.requestToServer(request, Response.class);
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DEREGISTER-SERVICE] {} deregistering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        if (instance.isEphemeral()) {
            this.deregisterServiceForEphemeral(serviceName, groupName, instance);
        } else {
            this.doDeregisterServiceForPersistent(serviceName, groupName, instance);
        }
    }

    private void deregisterServiceForEphemeral(String serviceName, String groupName, Instance instance) throws NacosException {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        InstanceRedoData instanceRedoData = this.redoService.getRegisteredInstancesByKey(key);
        if (instanceRedoData instanceof BatchInstanceRedoData) {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            if (null != instance) {
                instances.add(instance);
            }
            this.batchDeregisterService(serviceName, groupName, instances);
        } else {
            this.redoService.instanceDeregister(serviceName, groupName);
            this.doDeregisterService(serviceName, groupName, instance);
        }
    }

    public void doDeregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        InstanceRequest request = new InstanceRequest(this.namespaceId, serviceName, groupName, "deregisterInstance", instance);
        this.requestToServer(request, Response.class);
        this.redoService.instanceDeregistered(serviceName, groupName);
    }

    public void doDeregisterServiceForPersistent(String serviceName, String groupName, Instance instance) throws NacosException {
        PersistentInstanceRequest request = new PersistentInstanceRequest(this.namespaceId, serviceName, groupName, "deregisterInstance", instance);
        this.requestToServer(request, Response.class);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, boolean healthyOnly) throws NacosException {
        ServiceQueryRequest request = new ServiceQueryRequest(this.namespaceId, serviceName, groupName);
        request.setCluster(clusters);
        request.setHealthyOnly(healthyOnly);
        QueryServiceResponse response = this.requestToServer(request, QueryServiceResponse.class);
        return response.getServiceInfo();
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return null;
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return false;
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        ServiceListRequest request = new ServiceListRequest(this.namespaceId, groupName, pageNo, pageSize);
        if (selector != null && SelectorType.valueOf(selector.getType()) == SelectorType.label) {
            request.setSelector(JacksonUtils.toJson(selector));
        }
        ServiceListResponse response = this.requestToServer(request, ServiceListResponse.class);
        ListView<String> result = new ListView<String>();
        result.setCount(response.getCount());
        result.setData(response.getServiceNames());
        return result;
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
            LogUtils.NAMING_LOGGER.debug("[GRPC-SUBSCRIBE] service:{}, group:{}, cluster:{} ", new Object[]{serviceName, groupName, clusters});
        }
        this.redoService.cacheSubscriberForRedo(serviceName, groupName, clusters);
        return this.doSubscribe(serviceName, groupName, clusters);
    }

    public ServiceInfo doSubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        SubscribeServiceRequest request = new SubscribeServiceRequest(this.namespaceId, groupName, serviceName, clusters, true);
        SubscribeServiceResponse response = this.requestToServer(request, SubscribeServiceResponse.class);
        this.redoService.subscriberRegistered(serviceName, groupName, clusters);
        return response.getServiceInfo();
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
            LogUtils.NAMING_LOGGER.debug("[GRPC-UNSUBSCRIBE] service:{}, group:{}, cluster:{} ", new Object[]{serviceName, groupName, clusters});
        }
        this.redoService.subscriberDeregister(serviceName, groupName, clusters);
        this.doUnsubscribe(serviceName, groupName, clusters);
    }

    @Override
    public boolean isSubscribed(String serviceName, String groupName, String clusters) throws NacosException {
        return this.redoService.isSubscriberRegistered(serviceName, groupName, clusters);
    }

    public void doUnsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        SubscribeServiceRequest request = new SubscribeServiceRequest(this.namespaceId, groupName, serviceName, clusters, false);
        this.requestToServer(request, SubscribeServiceResponse.class);
        this.redoService.removeSubscriberForRedo(serviceName, groupName, clusters);
    }

    @Override
    public boolean serverHealthy() {
        return this.rpcClient.isRunning();
    }

    public boolean isAbilitySupportedByServer(AbilityKey abilityKey) {
        return this.rpcClient.getConnectionAbility(abilityKey) == AbilityStatus.SUPPORTED;
    }

    private <T extends Response> T requestToServer(AbstractNamingRequest request, Class<T> responseClass) throws NacosException {
        Response response = null;
        try {
            request.putAllHeader(this.getSecurityHeaders(request.getNamespace(), request.getGroupName(), request.getServiceName()));
            Response response2 = response = this.requestTimeout < 0L ? this.rpcClient.request(request) : this.rpcClient.request(request, this.requestTimeout);
            if (ResponseCode.SUCCESS.getCode() != response.getResultCode()) {
                throw new NacosException(response.getErrorCode(), response.getMessage());
            }
            if (responseClass.isAssignableFrom(response.getClass())) {
                return (T)response;
            }
            LogUtils.NAMING_LOGGER.error("Server return unexpected response '{}', expected response should be '{}'", (Object)response.getClass().getName(), (Object)responseClass.getName());
            throw new NacosException(500, "Server return invalid response");
        }
        catch (NacosException e) {
            this.recordRequestFailedMetrics(request, e, response);
            throw e;
        }
        catch (Exception e) {
            this.recordRequestFailedMetrics(request, e, response);
            throw new NacosException(500, "Request nacos server failed: ", e);
        }
    }

    private void recordRequestFailedMetrics(AbstractNamingRequest request, Exception exception, Response response) {
        if (Objects.isNull(response)) {
            MetricsMonitor.getNamingRequestFailedMonitor(request.getClass().getSimpleName(), "none", "none", exception.getClass().getSimpleName()).inc();
        } else {
            MetricsMonitor.getNamingRequestFailedMonitor(request.getClass().getSimpleName(), String.valueOf(response.getResultCode()), String.valueOf(response.getErrorCode()), "none").inc();
        }
    }

    @Override
    public void shutdown() throws NacosException {
        LogUtils.NAMING_LOGGER.info("Shutdown naming grpc client proxy for  uuid->{}", (Object)this.uuid);
        this.redoService.shutdown();
        this.shutDownAndRemove(this.uuid);
        NotifyCenter.deregisterSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownAndRemove(String uuid) {
        Set<Map.Entry<String, RpcClient>> set = RpcClientFactory.getAllClientEntries();
        synchronized (set) {
            try {
                RpcClientFactory.destroyClient(uuid);
                LogUtils.NAMING_LOGGER.info("shutdown and remove naming rpc client  for uuid ->{}", (Object)uuid);
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.warn("Fail to shutdown naming rpc client  for uuid ->{}", (Object)uuid);
            }
        }
    }

    public boolean isEnable() {
        return this.rpcClient.isRunning();
    }
}

