/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.ConfigChangeEvent;
import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.impl.ChangeNotifyBlockEvent;
import com.alibaba.nacos.client.config.impl.ConfigChangeHandler;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.nacos.client.config.listener.impl.AbstractConfigChangeListener;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.NumberUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class CacheData {
    private static final Logger LOGGER = LogUtils.logger(CacheData.class);
    private static final long DEFAULT_NOTIF_WARN_TIMEOUTS = 60000L;
    private static long notifyWarnTimeout = 60000L;
    static ScheduledThreadPoolExecutor scheduledExecutor;
    static boolean initSnapshot;
    public final String envName;
    private final ConfigFilterChainManager configFilterChainManager;
    public final String dataId;
    public final String group;
    public final String tenant;
    private final CopyOnWriteArrayList<ManagerListenerWrap> listeners;
    private volatile String md5;
    private volatile boolean isUseLocalConfig = false;
    private volatile long localConfigLastModified;
    private volatile String content;
    private volatile String encryptedDataKey;
    private final AtomicLong lastModifiedTs = new AtomicLong(0L);
    private final AtomicBoolean receiveNotifyChanged = new AtomicBoolean(false);
    private int taskId;
    private volatile boolean isInitializing = true;
    private final AtomicBoolean isConsistentWithServer = new AtomicBoolean();
    private volatile boolean isDiscard = false;
    private String type;

    static long initNotifyWarnTimeout() {
        String notifyTimeouts = System.getProperty("nacos.listener.notify.warn.timeout");
        if (StringUtils.isNotBlank((String)notifyTimeouts) && NumberUtils.isDigits((String)notifyTimeouts)) {
            notifyWarnTimeout = Long.valueOf(notifyTimeouts);
            LOGGER.info("config listener notify warn timeout millis is set to {}", (Object)notifyWarnTimeout);
        } else {
            LOGGER.info("config listener notify warn timeout millis use default {} millis ", (Object)60000L);
            notifyWarnTimeout = 60000L;
        }
        return notifyWarnTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ScheduledThreadPoolExecutor getNotifyBlockMonitor() {
        if (scheduledExecutor != null) return scheduledExecutor;
        Class<CacheData> clazz = CacheData.class;
        synchronized (CacheData.class) {
            if (scheduledExecutor != null) return scheduledExecutor;
            scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.notify.block.monitor"), new ThreadPoolExecutor.DiscardPolicy());
            scheduledExecutor.setRemoveOnCancelPolicy(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return scheduledExecutor;
        }
    }

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.md5 = CacheData.getMd5String(this.content);
    }

    public AtomicBoolean getReceiveNotifyChanged() {
        return this.receiveNotifyChanged;
    }

    public AtomicLong getLastModifiedTs() {
        return this.lastModifiedTs;
    }

    public void setLastModifiedTs(long lastModifiedTs) {
        this.lastModifiedTs.set(lastModifiedTs);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addListener(Listener listener) throws NacosException {
        ManagerListenerWrap wrap;
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        if (listener instanceof AbstractConfigChangeListener) {
            ConfigResponse cr = new ConfigResponse();
            cr.setDataId(this.dataId);
            cr.setGroup(this.group);
            cr.setContent(this.content);
            cr.setEncryptedDataKey(this.encryptedDataKey);
            this.configFilterChainManager.doFilter(null, cr);
            String contentTmp = cr.getContent();
            wrap = new ManagerListenerWrap(listener, this.md5, contentTmp);
        } else {
            wrap = new ManagerListenerWrap(listener, this.md5);
        }
        if (this.listeners.addIfAbsent(wrap)) {
            LOGGER.info("[{}] [add-listener] ok, tenant={}, dataId={}, group={}, cnt={}", new Object[]{this.envName, this.tenant, this.dataId, this.group, this.listeners.size()});
        }
    }

    public void removeListener(Listener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.remove(wrap)) {
            LOGGER.info("[{}] [remove-listener] ok, dataId={}, group={},tenant={}, cnt={}", new Object[]{this.envName, this.dataId, this.group, this.tenant, this.listeners.size()});
        }
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (ManagerListenerWrap wrap : this.listeners) {
            result.add(wrap.listener);
        }
        return result;
    }

    public long getLocalConfigInfoVersion() {
        return this.localConfigLastModified;
    }

    public void setLocalConfigInfoVersion(long localConfigLastModified) {
        this.localConfigLastModified = localConfigLastModified;
    }

    public boolean isUseLocalConfigInfo() {
        return this.isUseLocalConfig;
    }

    public void setUseLocalConfigInfo(boolean useLocalConfigInfo) {
        this.isUseLocalConfig = useLocalConfigInfo;
        if (!useLocalConfigInfo) {
            this.localConfigLastModified = -1L;
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CacheData other = (CacheData)obj;
        return this.dataId.equals(other.dataId) && this.group.equals(other.group);
    }

    public String toString() {
        return "CacheData [" + this.dataId + ", " + this.group + "]";
    }

    void checkListenerMd5() {
        for (ManagerListenerWrap wrap : this.listeners) {
            if (this.md5.equals(wrap.lastCallMd5)) continue;
            this.safeNotifyListener(this.dataId, this.group, this.content, this.type, this.md5, this.encryptedDataKey, wrap);
        }
    }

    public boolean checkListenersMd5Consistent() {
        for (ManagerListenerWrap wrap : this.listeners) {
            if (this.md5.equals(wrap.lastCallMd5)) continue;
            return false;
        }
        return true;
    }

    private static String getTrace(StackTraceElement[] stackTrace, int traceDeep) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        int deep = 0;
        for (StackTraceElement element : stackTrace) {
            stringBuilder.append("\tat " + element + "\n");
            if (traceDeep <= 0 || ++deep <= traceDeep) continue;
            stringBuilder.append("\tat ... \n");
            break;
        }
        return stringBuilder.toString();
    }

    private void safeNotifyListener(final String dataId, final String group, final String content, final String type, final String md5, final String encryptedDataKey, final ManagerListenerWrap listenerWrap) {
        final Listener listener = listenerWrap.listener;
        if (listenerWrap.inNotifying) {
            LOGGER.warn("[{}] [notify-currentSkip] dataId={}, group={},tenant={}, md5={}, listener={}, listener is not finish yet,will try next time.", new Object[]{this.envName, dataId, group, this.tenant, md5, listener});
            return;
        }
        NotifyTask job = new NotifyTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                ClassLoader myClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader appClassLoader = listener.getClass().getClassLoader();
                ScheduledFuture<?> timeSchedule = null;
                try {
                    if (listener instanceof AbstractSharedListener) {
                        AbstractSharedListener adapter = (AbstractSharedListener)listener;
                        adapter.fillContext(dataId, group);
                        LOGGER.info("[{}] [notify-context] dataId={}, group={},tenant={}, md5={}", new Object[]{CacheData.this.envName, dataId, group, CacheData.this.tenant, md5});
                    }
                    Thread.currentThread().setContextClassLoader(appClassLoader);
                    ConfigResponse cr = new ConfigResponse();
                    cr.setDataId(dataId);
                    cr.setGroup(group);
                    cr.setContent(content);
                    cr.setEncryptedDataKey(encryptedDataKey);
                    CacheData.this.configFilterChainManager.doFilter(null, cr);
                    String contentTmp = cr.getContent();
                    timeSchedule = CacheData.getNotifyBlockMonitor().schedule(new LongNotifyHandler(listener.getClass().getSimpleName(), dataId, group, CacheData.this.tenant, md5, notifyWarnTimeout, Thread.currentThread()), notifyWarnTimeout, TimeUnit.MILLISECONDS);
                    listenerWrap.inNotifying = true;
                    listener.receiveConfigInfo(contentTmp);
                    if (listener instanceof AbstractConfigChangeListener) {
                        Map<String, ConfigChangeItem> data = ConfigChangeHandler.getInstance().parseChangeData(listenerWrap.lastContent, contentTmp, type);
                        ConfigChangeEvent event = new ConfigChangeEvent(data);
                        ((AbstractConfigChangeListener)listener).receiveConfigChange(event);
                        listenerWrap.lastContent = contentTmp;
                    }
                    listenerWrap.lastCallMd5 = md5;
                    LOGGER.info("[{}] [notify-ok] dataId={}, group={},tenant={}, md5={}, listener={} ,job run cost={} millis.", new Object[]{CacheData.this.envName, dataId, group, CacheData.this.tenant, md5, listener, System.currentTimeMillis() - start});
                }
                catch (NacosException ex) {
                    LOGGER.error("[{}] [notify-error] dataId={}, group={},tenant={},md5={}, listener={} errCode={} errMsg={},stackTrace :{}", new Object[]{CacheData.this.envName, dataId, group, CacheData.this.tenant, md5, listener, ex.getErrCode(), ex.getErrMsg(), CacheData.getTrace(ex.getStackTrace(), 3)});
                }
                catch (Throwable t) {
                    LOGGER.error("[{}] [notify-error] dataId={}, group={},tenant={}, md5={}, listener={} tx={}", new Object[]{CacheData.this.envName, dataId, group, CacheData.this.tenant, md5, listener, CacheData.getTrace(t.getStackTrace(), 3)});
                }
                finally {
                    listenerWrap.inNotifying = false;
                    Thread.currentThread().setContextClassLoader(myClassLoader);
                    if (timeSchedule != null) {
                        timeSchedule.cancel(true);
                    }
                }
            }
        };
        try {
            if (null != listener.getExecutor()) {
                LOGGER.info("[{}] [notify-listener] task submitted to user executor, dataId={}, group={},tenant={}, md5={}, listener={} ", new Object[]{this.envName, dataId, group, this.tenant, md5, listener});
                job.async = true;
                listener.getExecutor().execute(job);
            } else {
                LOGGER.info("[{}] [notify-listener] task execute in nacos thread, dataId={}, group={},tenant={}, md5={}, listener={} ", new Object[]{this.envName, dataId, group, this.tenant, md5, listener});
                job.run();
            }
        }
        catch (Throwable t) {
            LOGGER.error("[{}] [notify-listener-error] dataId={}, group={},tenant={}, md5={}, listener={} throwable={}", new Object[]{this.envName, dataId, group, this.tenant, md5, listener, t.getCause()});
        }
    }

    public static String getMd5String(String config) {
        return null == config ? "" : MD5Utils.md5Hex((String)config, (String)"UTF-8");
    }

    private String loadCacheContentFromDiskLocal(String name, String dataId, String group, String tenant) {
        String content = LocalConfigInfoProcessor.getFailover(name, dataId, group, tenant);
        content = null != content ? content : LocalConfigInfoProcessor.getSnapshot(name, dataId, group, tenant);
        return content;
    }

    public boolean isConsistentWithServer() {
        return this.isConsistentWithServer.get();
    }

    public void setConsistentWithServer(boolean consistentWithServer) {
        this.isConsistentWithServer.set(consistentWithServer);
    }

    public boolean isDiscard() {
        return this.isDiscard;
    }

    public void setDiscard(boolean discard) {
        this.isDiscard = discard;
    }

    public CacheData(ConfigFilterChainManager configFilterChainManager, String envName, String dataId, String group) {
        this(configFilterChainManager, envName, dataId, group, TenantUtil.getUserTenantForAcm());
    }

    public CacheData(ConfigFilterChainManager configFilterChainManager, String envName, String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.configFilterChainManager = configFilterChainManager;
        this.envName = envName;
        this.dataId = dataId;
        this.group = group;
        this.tenant = tenant;
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        if (initSnapshot) {
            this.content = this.loadCacheContentFromDiskLocal(envName, dataId, group, tenant);
            this.encryptedDataKey = this.loadEncryptedDataKeyFromDiskLocal(envName, dataId, group, tenant);
            this.md5 = CacheData.getMd5String(this.content);
        }
    }

    public String getEncryptedDataKey() {
        return this.encryptedDataKey;
    }

    public void setEncryptedDataKey(String encryptedDataKey) {
        this.encryptedDataKey = encryptedDataKey;
    }

    private String loadEncryptedDataKeyFromDiskLocal(String envName, String dataId, String group, String tenant) {
        String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(envName, dataId, group, tenant);
        if (encryptedDataKey != null) {
            return encryptedDataKey;
        }
        return LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(envName, dataId, group, tenant);
    }

    static {
        CacheData.initNotifyWarnTimeout();
        initSnapshot = NacosClientProperties.PROTOTYPE.getBoolean("nacos.cache.data.init.snapshot", true);
        LOGGER.info("nacos.cache.data.init.snapshot = {} ", (Object)initSnapshot);
    }

    private static class ManagerListenerWrap {
        boolean inNotifying = false;
        final Listener listener;
        String lastCallMd5 = "";
        String lastContent = null;

        ManagerListenerWrap(Listener listener) {
            this.listener = listener;
        }

        ManagerListenerWrap(Listener listener, String md5) {
            this.listener = listener;
            this.lastCallMd5 = md5;
        }

        ManagerListenerWrap(Listener listener, String md5, String lastContent) {
            this(listener, md5);
            this.lastContent = lastContent;
        }

        public boolean equals(Object obj) {
            if (null == obj || obj.getClass() != this.getClass()) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ManagerListenerWrap other = (ManagerListenerWrap)obj;
            return this.listener.equals(other.listener);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    abstract class NotifyTask
    implements Runnable {
        boolean async = false;

        NotifyTask() {
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }
    }

    class LongNotifyHandler
    implements Runnable {
        String listenerClass;
        long startTime = System.currentTimeMillis();
        long timeoutMills;
        String dataId;
        String group;
        String tenant;
        String md5;
        Thread thread;

        public LongNotifyHandler(String listenerClass, String dataId, String group, String tenant, String md5, long timeoutMills, Thread thread) {
            this.listenerClass = listenerClass;
            this.dataId = dataId;
            this.group = group;
            this.tenant = tenant;
            this.md5 = md5;
            this.timeoutMills = timeoutMills;
            this.thread = thread;
        }

        @Override
        public void run() {
            String blockTrace = CacheData.getTrace(this.thread.getStackTrace(), 5);
            LOGGER.warn("[{}] [notify-block-monitor] dataId={}, group={},tenant={}, md5={}, receiveConfigInfo execute over {} mills\uff0cthread trace block : {}", new Object[]{CacheData.this.envName, this.dataId, this.group, this.tenant, this.md5, this.timeoutMills, blockTrace});
            NotifyCenter.publishEvent((Event)new ChangeNotifyBlockEvent(this.listenerClass, this.dataId, this.group, this.tenant, this.startTime, System.currentTimeMillis(), blockTrace));
        }
    }
}

