/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.remote;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityStatus;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.ai.remote.request.AbstractMcpRequest;
import com.alibaba.nacos.api.ai.remote.request.McpServerEndpointRequest;
import com.alibaba.nacos.api.ai.remote.request.QueryMcpServerRequest;
import com.alibaba.nacos.api.ai.remote.request.ReleaseMcpServerRequest;
import com.alibaba.nacos.api.ai.remote.response.McpServerEndpointResponse;
import com.alibaba.nacos.api.ai.remote.response.QueryMcpServerResponse;
import com.alibaba.nacos.api.ai.remote.response.ReleaseMcpServerResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.ai.cache.NacosMcpServerCacheHolder;
import com.alibaba.nacos.client.ai.remote.redo.AiGrpcRedoService;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.core.NamingServerListManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientConfigFactory;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiGrpcClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiGrpcClient.class);
    private final String namespaceId;
    private final String uuid;
    private final Long requestTimeout;
    private final RpcClient rpcClient;
    private final AbstractServerListManager serverListManager;
    private final AiGrpcRedoService redoService;
    private SecurityProxy securityProxy;
    private NacosMcpServerCacheHolder mcpServerCacheHolder;

    public AiGrpcClient(String namespaceId, NacosClientProperties properties) {
        this.namespaceId = namespaceId;
        this.uuid = UUID.randomUUID().toString();
        this.requestTimeout = Long.parseLong(properties.getProperty("nacosAiRequestTimeout", "-1"));
        this.rpcClient = this.buildRpcClient(properties);
        this.serverListManager = new NamingServerListManager(properties, namespaceId);
        this.redoService = new AiGrpcRedoService(properties, this);
    }

    private RpcClient buildRpcClient(NacosClientProperties properties) {
        HashMap<String, String> labels = new HashMap<String, String>(3);
        labels.put("source", "sdk");
        labels.put("module", "ai");
        labels.put("AppName", AppNameUtils.getAppName());
        GrpcClientConfig grpcClientConfig = RpcClientConfigFactory.getInstance().createGrpcClientConfig(properties.asProperties(), labels);
        return RpcClientFactory.createClient(this.uuid, ConnectionType.GRPC, grpcClientConfig);
    }

    public void start(NacosMcpServerCacheHolder mcpServerCacheHolder) throws NacosException {
        this.mcpServerCacheHolder = mcpServerCacheHolder;
        this.serverListManager.start();
        this.rpcClient.registerConnectionListener(this.redoService);
        this.rpcClient.serverListFactory((ServerListFactory)this.serverListManager);
        this.rpcClient.start();
        this.securityProxy = new SecurityProxy(this.serverListManager, NamingHttpClientManager.getInstance().getNacosRestTemplate());
    }

    public McpServerDetailInfo queryMcpServer(String mcpName, String version) throws NacosException {
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        QueryMcpServerRequest request = new QueryMcpServerRequest();
        request.setNamespaceId(this.namespaceId);
        request.setMcpName(mcpName);
        request.setVersion(version);
        QueryMcpServerResponse response = this.requestToServer(request, QueryMcpServerResponse.class);
        return response.getMcpServerDetailInfo();
    }

    public String releaseMcpServer(McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        LOGGER.info("[{}] RELEASE Mcp server {}, version {}", new Object[]{this.uuid, serverSpecification.getName(), serverSpecification.getVersionDetail().getVersion()});
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        ReleaseMcpServerRequest request = new ReleaseMcpServerRequest();
        request.setNamespaceId(this.namespaceId);
        request.setMcpName(serverSpecification.getName());
        request.setServerSpecification(serverSpecification);
        request.setToolSpecification(toolSpecification);
        request.setEndpointSpecification(endpointSpecification);
        ReleaseMcpServerResponse response = this.requestToServer(request, ReleaseMcpServerResponse.class);
        return response.getMcpId();
    }

    public void registerMcpServerEndpoint(String mcpName, String address, int port, String version) throws NacosException {
        LOGGER.info("[{}] REGISTER Mcp server endpoint {}:{}, version {} into mcp server {}", new Object[]{this.uuid, address, port, version, mcpName});
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        this.redoService.cachedMcpServerEndpointForRedo(mcpName, address, port, version);
        this.doRegisterMcpServerEndpoint(mcpName, address, port, version);
    }

    public void doRegisterMcpServerEndpoint(String mcpName, String address, int port, String version) throws NacosException {
        McpServerEndpointRequest request = new McpServerEndpointRequest();
        request.setNamespaceId(this.namespaceId);
        request.setMcpName(mcpName);
        request.setAddress(address);
        request.setPort(port);
        request.setVersion(version);
        request.setType("registerEndpoint");
        this.requestToServer(request, McpServerEndpointResponse.class);
        this.redoService.mcpServerEndpointRegistered(mcpName);
    }

    public void deregisterMcpServerEndpoint(String mcpName, String address, int port) throws NacosException {
        LOGGER.info("[{}] DE-REGISTER Mcp server endpoint {}:{} from mcp server {}", new Object[]{this.uuid, address, port, mcpName});
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        this.redoService.mcpServerEndpointDeregister(mcpName);
        this.doDeregisterMcpServerEndpoint(mcpName, address, port);
    }

    public void doDeregisterMcpServerEndpoint(String mcpName, String address, int port) throws NacosException {
        McpServerEndpointRequest request = new McpServerEndpointRequest();
        request.setNamespaceId(this.namespaceId);
        request.setMcpName(mcpName);
        request.setAddress(address);
        request.setPort(port);
        request.setType("deregisterEndpoint");
        this.requestToServer(request, McpServerEndpointResponse.class);
        this.redoService.mcpServerEndpointDeregistered(mcpName);
    }

    public McpServerDetailInfo subscribeMcpServer(String mcpName, String version) throws NacosException {
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        McpServerDetailInfo cachedServer = this.mcpServerCacheHolder.getMcpServer(mcpName, version);
        if (null == cachedServer) {
            cachedServer = this.queryMcpServer(mcpName, version);
            this.mcpServerCacheHolder.processMcpServerDetailInfo(cachedServer);
            this.mcpServerCacheHolder.addMcpServerUpdateTask(mcpName, version);
        }
        return cachedServer;
    }

    public void unsubscribeMcpServer(String mcpName, String version) throws NacosException {
        if (!this.isAbilitySupportedByServer(AbilityKey.SERVER_MCP_REGISTRY)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support mcp registry feature.");
        }
        this.mcpServerCacheHolder.removeMcpServerUpdateTask(mcpName, version);
    }

    public boolean isEnable() {
        return this.rpcClient.isRunning();
    }

    public boolean isAbilitySupportedByServer(AbilityKey abilityKey) {
        return this.rpcClient.getConnectionAbility(abilityKey) == AbilityStatus.SUPPORTED;
    }

    private <T extends Response> T requestToServer(Request request, Class<T> responseClass) throws NacosException {
        Response response = null;
        try {
            if (!(request instanceof AbstractMcpRequest)) {
                throw new NacosException(400, String.format("Unknown AI request type: %s", request.getClass().getSimpleName()));
            }
            request.putAllHeader(this.getSecurityHeaders(((AbstractMcpRequest)request).getNamespaceId(), ((AbstractMcpRequest)request).getMcpName()));
            Response response2 = response = this.requestTimeout < 0L ? this.rpcClient.request(request) : this.rpcClient.request(request, this.requestTimeout);
            if (ResponseCode.SUCCESS.getCode() != response.getResultCode()) {
                if (403 == response.getErrorCode()) {
                    this.securityProxy.reLogin();
                }
                throw new NacosException(response.getErrorCode(), response.getMessage());
            }
            if (responseClass.isAssignableFrom(response.getClass())) {
                return (T)response;
            }
            throw new NacosException(500, String.format("Server return invalid response: %s", response.getClass().getSimpleName()));
        }
        catch (NacosException e) {
            LOGGER.warn("AI request {} execute failed, {}", (Object)request.getClass().getSimpleName(), (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("AI request {} execute failed. ", (Object)request.getClass().getSimpleName(), (Object)e);
            throw new NacosException(500, "Request nacos server failed: ", e);
        }
    }

    private Map<String, String> getSecurityHeaders(String namespace, String mcpName) {
        RequestResource resource = this.buildRequestResource(namespace, mcpName);
        return this.securityProxy.getIdentityContext(resource);
    }

    private RequestResource buildRequestResource(String namespaceId, String mcpName) {
        RequestResource.Builder builder = RequestResource.aiBuilder();
        builder.setNamespace(namespaceId);
        builder.setGroup("DEFAULT_GROUP");
        builder.setResource(null == mcpName ? "" : mcpName);
        return builder.build();
    }

    @Override
    public void shutdown() throws NacosException {
        this.rpcClient.shutdown();
        this.serverListManager.shutdown();
        if (null != this.securityProxy) {
            this.securityProxy.shutdown();
        }
    }
}

