/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.remote.redo;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.ai.remote.AiGrpcClient;
import com.alibaba.nacos.client.ai.remote.redo.AiGrpcRedoService;
import com.alibaba.nacos.client.ai.remote.redo.McpServerEndpoint;
import com.alibaba.nacos.client.ai.remote.redo.McpServerEndpointRedoData;
import com.alibaba.nacos.client.redo.data.RedoData;
import com.alibaba.nacos.client.redo.service.AbstractRedoTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiRedoScheduledTask
extends AbstractRedoTask<AiGrpcRedoService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiRedoScheduledTask.class);
    private final AiGrpcClient aiGrpcClient;

    public AiRedoScheduledTask(AiGrpcRedoService redoService, AiGrpcClient aiGrpcClient) {
        super(LOGGER, redoService);
        this.aiGrpcClient = aiGrpcClient;
    }

    @Override
    protected void redoData() throws NacosException {
        try {
            this.redoForMcpSeverEndpoint();
        }
        catch (Exception e) {
            LOGGER.warn("Redo task run with unexpected exception: ", (Throwable)e);
        }
    }

    private void redoForMcpSeverEndpoint() {
        for (RedoData<McpServerEndpoint> each : ((AiGrpcRedoService)this.getRedoService()).findMcpServerEndpointRedoData()) {
            McpServerEndpointRedoData redoData = (McpServerEndpointRedoData)each;
            try {
                this.redoForEndpoint(redoData);
            }
            catch (NacosException e) {
                LOGGER.error("Redo mcp server endpoint operation {} for {}} failed. ", new Object[]{each.getRedoType(), redoData.getMcpName(), e});
            }
        }
    }

    private void redoForEndpoint(McpServerEndpointRedoData redoData) throws NacosException {
        RedoData.RedoType redoType = redoData.getRedoType();
        String mcpName = redoData.getMcpName();
        LOGGER.info("Redo mcp server endpoint operation {} for {}.", (Object)redoType, (Object)mcpName);
        McpServerEndpoint endpoint = (McpServerEndpoint)redoData.get();
        switch (redoType) {
            case REGISTER: {
                if (!this.aiGrpcClient.isEnable()) {
                    return;
                }
                this.aiGrpcClient.doRegisterMcpServerEndpoint(mcpName, endpoint.getAddress(), endpoint.getPort(), endpoint.getVersion());
                break;
            }
            case UNREGISTER: {
                if (!this.aiGrpcClient.isEnable()) {
                    return;
                }
                this.aiGrpcClient.doDeregisterMcpServerEndpoint(mcpName, endpoint.getAddress(), endpoint.getPort());
                break;
            }
            case REMOVE: {
                ((AiGrpcRedoService)this.getRedoService()).removeMcpServerEndpointForRedo(mcpName);
                break;
            }
        }
    }
}

