/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClusterClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcSdkClient;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.remote.client");
    private static final Map<String, RpcClient> CLIENT_MAP = new ConcurrentHashMap<String, RpcClient>();

    public static Set<Map.Entry<String, RpcClient>> getAllClientEntries() {
        return CLIENT_MAP.entrySet();
    }

    public static void destroyClient(String clientName) throws NacosException {
        RpcClient rpcClient = CLIENT_MAP.remove(clientName);
        if (rpcClient != null) {
            rpcClient.shutdown();
        }
    }

    public static RpcClient getClient(String clientName) {
        return CLIENT_MAP.get(clientName);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        return RpcClientFactory.createClient(clientName, connectionType, null, null, labels);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        return RpcClientFactory.createClient(clientName, connectionType, null, null, labels, tlsConfig);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Map<String, String> labels, Properties properties, RpcClientTlsConfig tlsConfig) {
        return RpcClientFactory.createClient(clientName, connectionType, null, null, labels, tlsConfig);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels) {
        return RpcClientFactory.createClient(clientName, connectionType, threadPoolCoreSize, threadPoolMaxSize, labels, null);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        if (!ConnectionType.GRPC.equals((Object)connectionType)) {
            throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
        }
        return CLIENT_MAP.computeIfAbsent(clientName, clientNameInner -> {
            LOGGER.info("[RpcClientFactory] create a new rpc client of " + clientName);
            return new GrpcSdkClient((String)clientNameInner, threadPoolCoreSize, threadPoolMaxSize, labels, tlsConfig);
        });
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, GrpcClientConfig grpcClientConfig) {
        if (!ConnectionType.GRPC.equals((Object)connectionType)) {
            throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
        }
        return CLIENT_MAP.computeIfAbsent(clientName, clientNameInner -> {
            LOGGER.info("[RpcClientFactory] create a new rpc client of " + clientName);
            grpcClientConfig.setName((String)clientNameInner);
            return new GrpcSdkClient(grpcClientConfig);
        });
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        return RpcClientFactory.createClusterClient(clientName, connectionType, null, null, labels);
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        return RpcClientFactory.createClusterClient(clientName, connectionType, null, null, labels, tlsConfig);
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels) {
        return RpcClientFactory.createClusterClient(clientName, connectionType, threadPoolCoreSize, threadPoolMaxSize, labels, null);
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        if (!ConnectionType.GRPC.equals((Object)connectionType)) {
            throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
        }
        return CLIENT_MAP.computeIfAbsent(clientName, clientNameInner -> new GrpcClusterClient((String)clientNameInner, threadPoolCoreSize, threadPoolMaxSize, labels, tlsConfig));
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, GrpcClientConfig grpcClientConfig) {
        if (!ConnectionType.GRPC.equals((Object)connectionType)) {
            throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
        }
        return CLIENT_MAP.computeIfAbsent(clientName, clientNameInner -> {
            LOGGER.info("[RpcClientFactory] create a new cluster rpc client of " + clientName);
            grpcClientConfig.setName((String)clientNameInner);
            return new GrpcClusterClient(grpcClientConfig);
        });
    }
}

