/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FuzzyGroupKeyPattern {
    public static String generatePattern(String resourcePattern, String groupPattern, String fixNamespace) {
        if (StringUtils.isBlank(resourcePattern)) {
            throw new IllegalArgumentException("Param 'resourcePattern' is illegal, resourcePattern is blank");
        }
        if (StringUtils.isBlank(groupPattern)) {
            throw new IllegalArgumentException("Param 'groupPattern' is illegal, group is blank");
        }
        if (StringUtils.isBlank(fixNamespace)) {
            fixNamespace = "public";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fixNamespace);
        sb.append(">>");
        sb.append(groupPattern);
        sb.append(">>");
        sb.append(resourcePattern);
        return sb.toString().intern();
    }

    public static Set<String> filterMatchedPatterns(Collection<String> groupKeyPatterns, String resourceName, String group, String namespace) {
        if (CollectionUtils.isEmpty(groupKeyPatterns)) {
            return new HashSet<String>(1);
        }
        HashSet<String> matchedPatternList = new HashSet<String>();
        for (String keyPattern : groupKeyPatterns) {
            if (!FuzzyGroupKeyPattern.matchPattern(keyPattern, resourceName, group, namespace)) continue;
            matchedPatternList.add(keyPattern);
        }
        return matchedPatternList;
    }

    public static boolean matchPattern(String groupKeyPattern, String resourceName, String group, String namespace) {
        String[] splitPatterns;
        if (StringUtils.isBlank(namespace)) {
            namespace = "public";
        }
        return (splitPatterns = groupKeyPattern.split(">>"))[0].equals(namespace) && FuzzyGroupKeyPattern.itemMatched(splitPatterns[1], group) && FuzzyGroupKeyPattern.itemMatched(splitPatterns[2], resourceName);
    }

    public static String getNamespaceFromPattern(String groupKeyPattern) {
        return groupKeyPattern.split(">>")[0];
    }

    private static boolean itemMatched(String pattern, String resource) {
        if (!pattern.contains("*")) {
            return pattern.equals(resource);
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String pureString = pattern.replace("*", "");
            return resource.contains(pureString);
        }
        if (pattern.startsWith("*")) {
            String pureString = pattern.replace("*", "");
            return resource.endsWith(pureString);
        }
        if (pattern.endsWith("*")) {
            String pureString = pattern.replace("*", "");
            return resource.startsWith(pureString);
        }
        return false;
    }

    public static List<GroupKeyState> diffGroupKeys(Set<String> basedGroupKeys, Set<String> followedGroupKeys) {
        HashSet<String> addGroupKeys = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(basedGroupKeys)) {
            addGroupKeys.addAll(basedGroupKeys);
        }
        if (CollectionUtils.isNotEmpty(followedGroupKeys)) {
            addGroupKeys.removeAll(followedGroupKeys);
        }
        HashSet<String> removeGroupKeys = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(followedGroupKeys)) {
            removeGroupKeys.addAll(followedGroupKeys);
        }
        if (CollectionUtils.isNotEmpty(basedGroupKeys)) {
            removeGroupKeys.removeAll(basedGroupKeys);
        }
        return Stream.concat(addGroupKeys.stream().map(groupKey -> new GroupKeyState((String)groupKey, true)), removeGroupKeys.stream().map(groupKey -> new GroupKeyState((String)groupKey, false))).collect(Collectors.toList());
    }

    public static class GroupKeyState {
        String groupKey;
        boolean exist;

        public GroupKeyState(String groupKey, boolean exist) {
            this.groupKey = groupKey;
            this.exist = exist;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public boolean isExist() {
            return this.exist;
        }

        public void setExist(boolean exist) {
            this.exist = exist;
        }
    }
}

