/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logger.adapter.logback12;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import com.alibaba.nacos.common.logging.NacosLoggingProperties;
import com.alibaba.nacos.logger.adapter.logback12.NacosClientPropertyAction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class NacosLogbackConfiguratorAdapterV1
extends JoranConfigurator {
    private NacosLoggingProperties loggingProperties;

    public void setLoggingProperties(NacosLoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }

    public void registerSafeConfiguration(List<SaxEvent> eventList) {
    }

    public void addInstanceRules(RuleStore rs) {
        super.addInstanceRules(rs);
        rs.addRule(new ElementSelector("configuration/nacosClientProperty"), (Action)new NacosClientPropertyAction(this.loggingProperties));
    }

    public void configure(URL url) throws Exception {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            if (this.hasNewDoConfigureApi()) {
                this.doConfigure(in, url.toExternalForm());
            } else {
                this.doConfigure(in);
            }
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    String errMsg = "Could not close input stream";
                    this.addError(errMsg, ioe);
                    throw new JoranException(errMsg, (Throwable)ioe);
                }
            }
        }
    }

    private boolean hasNewDoConfigureApi() {
        try {
            ((Object)((Object)this)).getClass().getMethod("doConfigure", InputStream.class, String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

