/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.ai;

import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.ai.model.mcp.registry.ServerVersionDetail;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import java.util.Map;
import java.util.Objects;

public interface McpMaintainerService {
    default public Page<McpServerBasicInfo> listMcpServer() throws NacosException {
        return this.listMcpServer(1, 100);
    }

    default public Page<McpServerBasicInfo> listMcpServer(int pageNo, int pageSize) throws NacosException {
        return this.listMcpServer("", pageNo, pageSize);
    }

    default public Page<McpServerBasicInfo> listMcpServer(String mcpName, int pageNo, int pageSize) throws NacosException {
        return this.listMcpServer("", mcpName, pageNo, pageSize);
    }

    public Page<McpServerBasicInfo> listMcpServer(String var1, String var2, int var3, int var4) throws NacosException;

    default public Page<McpServerBasicInfo> searchMcpServer(String mcpName) throws NacosException {
        return this.searchMcpServer(mcpName, 1, 100);
    }

    default public Page<McpServerBasicInfo> searchMcpServer(String mcpName, int pageNo, int pageSize) throws NacosException {
        return this.searchMcpServer("public", mcpName, pageNo, pageSize);
    }

    public Page<McpServerBasicInfo> searchMcpServer(String var1, String var2, int var3, int var4) throws NacosException;

    default public McpServerDetailInfo getMcpServerDetail(String mcpName) throws NacosException {
        return this.getMcpServerDetail(mcpName, null);
    }

    default public McpServerDetailInfo getMcpServerDetail(String mcpName, String version) throws NacosException {
        return this.getMcpServerDetail("public", mcpName, version);
    }

    public McpServerDetailInfo getMcpServerDetail(String var1, String var2, String var3) throws NacosException;

    default public boolean createLocalMcpServer(String mcpName, String version) throws NacosException {
        return this.createLocalMcpServer(mcpName, version, null);
    }

    default public boolean createLocalMcpServer(String mcpName, String version, String description) throws NacosException {
        return this.createLocalMcpServer(mcpName, version, description, null);
    }

    default public boolean createLocalMcpServer(String mcpName, String version, String description, McpToolSpecification toolSpec) throws NacosException {
        return this.createLocalMcpServer(mcpName, version, description, null, toolSpec);
    }

    default public boolean createLocalMcpServer(String mcpName, String version, String description, Map<String, Object> localServerConfig, McpToolSpecification toolSpec) throws NacosException {
        McpServerBasicInfo serverSpec = new McpServerBasicInfo();
        serverSpec.setName(mcpName);
        serverSpec.setProtocol("stdio");
        ServerVersionDetail versionDetail = new ServerVersionDetail();
        versionDetail.setVersion(version);
        serverSpec.setVersionDetail(versionDetail);
        serverSpec.setDescription(description);
        serverSpec.setLocalServerConfig(localServerConfig);
        return this.createLocalMcpServer(mcpName, serverSpec, toolSpec);
    }

    default public boolean createLocalMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec) throws NacosException {
        if (Objects.isNull(serverSpec)) {
            throw new NacosException(400, "Mcp server specification cannot be null.");
        }
        if (!"stdio".equalsIgnoreCase(serverSpec.getProtocol())) {
            throw new NacosException(400, String.format("Mcp server type must be `local`, input is `%s`", serverSpec.getProtocol()));
        }
        return this.createMcpServer(mcpName, serverSpec, toolSpec, null);
    }

    default public boolean createRemoteMcpServer(String mcpName, String version, String protocol, McpEndpointSpec endpointSpec) throws NacosException {
        return this.createRemoteMcpServer(mcpName, version, protocol, null, endpointSpec);
    }

    default public boolean createRemoteMcpServer(String mcpName, String version, String protocol, McpServerRemoteServiceConfig remoteServiceConfig, McpEndpointSpec endpointSpec) throws NacosException {
        return this.createRemoteMcpServer(mcpName, version, null, protocol, remoteServiceConfig, endpointSpec);
    }

    default public boolean createRemoteMcpServer(String mcpName, String version, String description, String protocol, McpServerRemoteServiceConfig remoteServiceConfig, McpEndpointSpec endpointSpec) throws NacosException {
        return this.createRemoteMcpServer(mcpName, version, description, protocol, remoteServiceConfig, endpointSpec, null);
    }

    default public boolean createRemoteMcpServer(String mcpName, String version, String description, String protocol, McpServerRemoteServiceConfig remoteServiceConfig, McpEndpointSpec endpointSpec, McpToolSpecification toolSpec) throws NacosException {
        McpServerBasicInfo serverSpec = new McpServerBasicInfo();
        serverSpec.setName(mcpName);
        serverSpec.setProtocol(protocol);
        ServerVersionDetail detail = new ServerVersionDetail();
        detail.setVersion(version);
        serverSpec.setVersionDetail(detail);
        serverSpec.setDescription(description);
        serverSpec.setRemoteServerConfig(remoteServiceConfig);
        return this.createRemoteMcpServer(mcpName, serverSpec, toolSpec, endpointSpec);
    }

    default public boolean createRemoteMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpEndpointSpec endpointSpec) throws NacosException {
        return this.createRemoteMcpServer(mcpName, serverSpec, null, endpointSpec);
    }

    default public boolean createRemoteMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        if (Objects.isNull(serverSpec)) {
            throw new NacosException(400, "Mcp server specification cannot be null.");
        }
        if ("stdio".equalsIgnoreCase(serverSpec.getProtocol())) {
            throw new NacosException(400, "Mcp server type cannot be `local` or empty.");
        }
        if (Objects.isNull(endpointSpec)) {
            throw new NacosException(400, "Mcp server endpoint specification cannot be null.");
        }
        return this.createMcpServer(mcpName, serverSpec, toolSpec, endpointSpec);
    }

    default public boolean createMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        return this.createMcpServer("public", mcpName, serverSpec, toolSpec, endpointSpec);
    }

    public boolean createMcpServer(String var1, String var2, McpServerBasicInfo var3, McpToolSpecification var4, McpEndpointSpec var5) throws NacosException;

    default public boolean updateMcpServer(String mcpName, boolean isLatest, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        return this.updateMcpServer("public", mcpName, isLatest, serverSpec, toolSpec, endpointSpec);
    }

    public boolean updateMcpServer(String var1, String var2, boolean var3, McpServerBasicInfo var4, McpToolSpecification var5, McpEndpointSpec var6) throws NacosException;

    default public boolean updateMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        return this.updateMcpServer(mcpName, true, serverSpec, toolSpec, endpointSpec);
    }

    default public boolean deleteMcpServer(String mcpName) throws NacosException {
        return this.deleteMcpServer("public", mcpName);
    }

    public boolean deleteMcpServer(String var1, String var2) throws NacosException;
}

