/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.address.DefaultServerListManager;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.remote.HttpClientManager;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.client.ClientAuthService;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHttpProxy
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientHttpProxy.class);
    private final NacosRestTemplate nacosRestTemplate = HttpClientManager.getInstance().getNacosRestTemplate();
    private final boolean enableHttps = Boolean.getBoolean("tls.enable");
    private final long refreshIntervalMills = ParamUtil.getRefreshIntervalMills();
    private final int maxRetry = ParamUtil.getMaxRetryTimes();
    private DefaultServerListManager serverListManager;
    private ClientAuthPluginManager clientAuthPluginManager;
    private ScheduledExecutorService executor;

    public ClientHttpProxy(Properties properties) throws NacosException {
        this.initServerListManager(properties);
        this.initClientAuthService();
        this.initScheduledExecutor(properties);
    }

    public void initServerListManager(Properties properties) throws NacosException {
        this.serverListManager = new DefaultServerListManager(NacosClientProperties.PROTOTYPE.derive(properties));
        this.serverListManager.start();
    }

    private void initClientAuthService() {
        this.clientAuthPluginManager = new ClientAuthPluginManager();
        this.clientAuthPluginManager.init(this.serverListManager.getServerList(), this.nacosRestTemplate);
    }

    private void initScheduledExecutor(Properties properties) {
        this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.maintainer.client.http.proxy"));
        this.executor.scheduleWithFixedDelay(() -> this.login(properties), 0L, this.refreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    public void login(Properties properties) {
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            clientAuthService.login(properties);
        }
    }

    public HttpRestResult<String> executeSyncHttpRequest(HttpRequest request) throws NacosException {
        long endTime = System.currentTimeMillis() + (long)ParamUtil.getReadTimeout();
        String currentServerAddr = this.serverListManager.getCurrentServer();
        int retryCount = this.maxRetry;
        int resultCode = 0;
        NacosException requestException = null;
        while (System.currentTimeMillis() <= endTime && retryCount >= 0) {
            try {
                HttpRestResult<String> result = this.executeSync(request, currentServerAddr);
                if (result.isNoRight()) {
                    this.reLogin();
                }
                if (result.ok()) {
                    return result;
                }
                throw new NacosException(result.getCode(), result.getMessage());
            }
            catch (NacosException nacosException) {
                requestException = nacosException;
                resultCode = nacosException.getErrCode();
            }
            catch (Exception ex) {
                LOGGER.error("[NACOS Exception] Server address: {}, Error: {}", (Object)currentServerAddr, (Object)ex.getMessage());
                resultCode = 500;
            }
            if (this.isFail(resultCode)) {
                currentServerAddr = this.serverListManager.genNextServer();
            }
            --retryCount;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (null != requestException) {
            throw new NacosException(requestException.getErrCode(), "No available server after " + this.maxRetry + " retries, last tried server: " + currentServerAddr + ", last errMsg: " + requestException.getErrMsg());
        }
        throw new NacosException(502, "No available server after " + this.maxRetry + " retries, last tried server: " + currentServerAddr);
    }

    private HttpRestResult<String> executeSync(HttpRequest request, String serverAddr) throws Exception {
        long readTimeoutMs = ParamUtil.getReadTimeout();
        long connectTimeoutMs = ParamUtil.getConnectTimeout();
        Map<String, String> paramValues = request.getParamValues();
        Map<String, String> headers = request.getHeaders();
        HttpClientConfig httpConfig = HttpClientConfig.builder().setReadTimeOutMillis(Long.valueOf(readTimeoutMs).intValue()).setConTimeOutMillis(Long.valueOf(connectTimeoutMs).intValue()).build();
        Header httpHeaders = Header.newInstance();
        this.addAuthHeader(httpHeaders);
        if (headers != null) {
            httpHeaders.addAll(headers);
        }
        Query query = Query.newInstance().initParams(paramValues);
        String url = this.buildUrl(serverAddr, request.getPath());
        switch (request.getHttpMethod()) {
            case "GET": {
                return this.nacosRestTemplate.get(url, httpConfig, httpHeaders, query, String.class);
            }
            case "POST": {
                if (StringUtils.isNotBlank((String)request.getBody())) {
                    return this.nacosRestTemplate.postJson(url, httpHeaders, query, request.getBody(), String.class);
                }
                return this.nacosRestTemplate.postForm(url, httpConfig, httpHeaders, paramValues, String.class);
            }
            case "PUT": {
                return this.nacosRestTemplate.putForm(url, httpConfig, httpHeaders, paramValues, String.class);
            }
            case "DELETE": {
                return this.nacosRestTemplate.delete(url, httpConfig, httpHeaders, query, String.class);
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + request.getHttpMethod());
    }

    private void addAuthHeader(Header header) {
        this.clientAuthPluginManager.getAuthServiceSpiImplSet().forEach(clientAuthService -> {
            LoginIdentityContext loginIdentityContext = clientAuthService.getLoginIdentityContext(new RequestResource());
            for (String key : loginIdentityContext.getAllKey()) {
                header.addParam(key, loginIdentityContext.getParameter(key));
            }
        });
    }

    private String buildUrl(String serverAddr, String relativePath) {
        if (!serverAddr.startsWith("http://") && !serverAddr.startsWith("https://")) {
            serverAddr = this.getPrefix() + serverAddr;
        }
        String contextPath = this.serverListManager.getContextPath();
        return serverAddr + ContextPathUtil.normalizeContextPath((String)contextPath) + relativePath;
    }

    public String getPrefix() {
        return this.enableHttps ? "https://" : "http://";
    }

    private boolean isFail(int resultCode) {
        return resultCode == 500 || resultCode == 502 || resultCode == 503 || resultCode == 504;
    }

    public void reLogin() {
        for (ClientAuthService clientAuthService : this.clientAuthPluginManager.getAuthServiceSpiImplSet()) {
            try {
                LoginIdentityContext loginIdentityContext = clientAuthService.getLoginIdentityContext(new RequestResource());
                if (loginIdentityContext == null) continue;
                loginIdentityContext.setParameter("reLoginFlag", "true");
            }
            catch (Exception e) {
                LOGGER.error("[ClientHttpProxy] set reLoginFlag failed.", (Throwable)e);
            }
        }
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        HttpClientManager.getInstance().shutdown();
        this.serverListManager.shutdown();
        if (null != this.clientAuthPluginManager) {
            this.clientAuthPluginManager.shutdown();
        }
        if (null != this.executor) {
            this.executor.shutdown();
        }
        LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

