/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol;

import com.alibaba.fastjson.JSON;
import com.alibaba.nls.client.protocol.Constant;
import com.alibaba.nls.client.protocol.SdkInfo;
import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.util.IdGen;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechReqProtocol {
    static Logger logger = LoggerFactory.getLogger(SpeechReqProtocol.class);
    protected String accessToken;
    protected Connection conn;
    protected String currentTaskId;
    protected State state = State.STATE_INIT;
    public Map<String, String> header = new HashMap<String, String>();
    public Map<String, Object> payload;
    public Map<String, Object> context = new HashMap<String, Object>();

    public SpeechReqProtocol() {
        this.header.put("message_id", IdGen.genId());
        SdkInfo sdk = new SdkInfo();
        sdk.version = Constant.sdkVersion;
        this.context.put("sdk", sdk);
    }

    public String getAppKey() {
        return this.header.get("appkey");
    }

    public void setAppKey(String appKey) {
        this.header.put("appkey", appKey);
    }

    public String getTaskId() {
        return this.header.get("task_id");
    }

    protected void setTaskId(String requestId) {
        this.header.put("task_id", requestId);
    }

    public void putContext(String key, Object obj) {
        this.context.put(key, obj);
    }

    public void addCustomedParam(String key, Object value) {
        this.payload.put(key, value);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String serialize() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("header", this.header);
        if (this.payload != null) {
            result.put("payload", this.payload);
            result.put("context", this.context);
        }
        return JSON.toJSONString(result);
    }

    public String serializeWithContext() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("header", this.header);
        if (this.context != null) {
            result.put("context", this.context);
        }
        if (this.payload != null) {
            result.put("payload", this.payload);
        }
        return JSON.toJSONString(result);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public State getState() {
        return this.state;
    }

    public void start() throws Exception {
        String taskId;
        this.state.checkStart();
        HashMap<String, Long> network = new HashMap<String, Long>();
        network.put("connect_cost", this.conn.getConnectingLatency());
        network.put("upgrade_cost", this.conn.getWsHandshakeLatency());
        this.putContext("network", network);
        this.currentTaskId = taskId = IdGen.genId();
        this.setTaskId(this.currentTaskId);
        this.conn.sendText(this.serialize());
        this.state = State.STATE_REQUEST_SENT;
    }

    public static enum State {
        STATE_FAIL(-1){

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        }
        ,
        STATE_INIT(0){

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        }
        ,
        STATE_CONNECTED(10){

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        }
        ,
        STATE_REQUEST_SENT(20){

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        }
        ,
        STATE_REQUEST_CONFIRMED(30){

            @Override
            public void checkSend() {
            }

            @Override
            public void checkStart() {
            }

            @Override
            public void checkStop() {
            }
        }
        ,
        STATE_STOP_SENT(40){

            @Override
            public void checkSend() {
                throw new RuntimeException("only STATE_REQUEST_CONFIRMED can send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        }
        ,
        STATE_COMPLETE(50){

            @Override
            public void checkSend() {
                logger.warn("task is completed before sending binary");
            }

            @Override
            public void checkStart() {
            }

            @Override
            public void checkStop() {
                logger.warn("task is completed before sending stop command");
            }
        }
        ,
        STATE_CLOSED(60){

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }
        };

        int value;

        public abstract void checkSend();

        public abstract void checkStart();

        public abstract void checkStop();

        private State(int value) {
            this.value = value;
        }
    }
}

