/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.util;

import com.alibaba.nls.client.util.NativeLibUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpuCodec {
    public static final int RAW_BUF_SIZE = 640;
    public static final int OPU_BUF_SIZE = 512;
    static Logger logger = LoggerFactory.getLogger(OpuCodec.class);

    public native long createOpuEncoder(int var1);

    public native int encode(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public native void destroyOpuEncoder(long var1);

    public void encode(int sampleRate, InputStream ins, OutputStream outs) throws Exception {
        long encoder = this.createOpuEncoder(sampleRate);
        try {
            byte[] buffer = new byte[640];
            byte[] bytes = new byte[512];
            while (ins.available() >= 640) {
                ins.read(buffer, 0, 640);
                int encodeSize = this.encode(encoder, buffer, 640, bytes, 512);
                outs.write(bytes, 0, encodeSize);
            }
            int remainSize = ins.read(buffer, 0, 640);
            if (remainSize > 0) {
                Arrays.fill(buffer, remainSize - 1, 640, (byte)0);
                int encodeSize = this.encode(encoder, buffer, 640, bytes, 512);
                outs.write(bytes, 0, encodeSize);
            }
            ins.close();
            outs.close();
        }
        catch (Exception e) {
            logger.error("encode error", (Throwable)e);
            throw e;
        }
        finally {
            this.destroyOpuEncoder(encoder);
        }
    }

    public void encode(int sampleRate, InputStream ins, EncodeListener listener) throws Exception {
        long encoder = this.createOpuEncoder(sampleRate);
        try {
            byte[] buffer = new byte[640];
            byte[] bytes = new byte[512];
            while (ins.available() >= 640) {
                ins.read(buffer, 0, 640);
                int encodeSize = this.encode(encoder, buffer, 640, bytes, 512);
                listener.onEncodedData(Arrays.copyOfRange(bytes, 0, encodeSize));
            }
            int remainSize = ins.read(buffer, 0, 640);
            if (remainSize > 0) {
                Arrays.fill(buffer, remainSize - 1, 640, (byte)0);
                int encodeSize = this.encode(encoder, buffer, 640, bytes, 512);
                listener.onEncodedData(Arrays.copyOfRange(bytes, 0, encodeSize));
            }
            ins.close();
        }
        catch (Exception e) {
            logger.error("encode error", (Throwable)e);
            throw e;
        }
        finally {
            this.destroyOpuEncoder(encoder);
        }
    }

    static {
        try {
            NativeLibUtil.loadFromJar("nlsJniOpu");
        }
        catch (Throwable e1) {
            logger.warn("error to load nlsJniOpu :{}", (Object)e1.getMessage());
        }
    }

    public static interface EncodeListener {
        public void onEncodedData(byte[] var1);
    }
}

