/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.tts;

import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.OutputFormatEnum;
import com.alibaba.nls.client.protocol.SampleRateEnum;
import com.alibaba.nls.client.protocol.SpeechReqProtocol;
import com.alibaba.nls.client.protocol.tts.FlowingSpeechSynthesizerListener;
import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.util.IdGen;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowingSpeechSynthesizer
extends SpeechReqProtocol {
    static Logger logger = LoggerFactory.getLogger(FlowingSpeechSynthesizer.class);
    protected FlowingSpeechSynthesizerListener StreamTTSListener;
    private CountDownLatch completeLatch;
    private CountDownLatch readyLatch;
    protected long lastSendTime = -1L;
    protected String currentSessionId;
    protected long minSendIntervalMS = 100L;
    private static final String DEFAULT_FORMAT = "pcm";
    private static final Integer DEFAULT_SAMPLE_RATE = 16000;
    private static final Integer DEFAULT_VOICE_VOLUME = 50;

    public FlowingSpeechSynthesizer(NlsClient client, FlowingSpeechSynthesizerListener listener) throws Exception {
        this.conn = client.connect((ConnectionListener)listener);
        this.afterConnection(listener);
    }

    public FlowingSpeechSynthesizer(NlsClient client, String token, FlowingSpeechSynthesizerListener listener) throws Exception {
        Connection conn;
        this.conn = conn = client.connect(token, (ConnectionListener)listener);
        this.afterConnection(listener);
    }

    public FlowingSpeechSynthesizerListener getStreamTTSListener() {
        return this.StreamTTSListener;
    }

    public String getCurrentSessionId() {
        return this.currentSessionId;
    }

    protected void afterConnection(FlowingSpeechSynthesizerListener listener) {
        this.payload = new HashMap();
        this.header.put("namespace", "FlowingSpeechSynthesizer");
        this.header.put("name", "StartSynthesis");
        this.payload.put("format", DEFAULT_FORMAT);
        this.payload.put("sample_rate", DEFAULT_SAMPLE_RATE);
        this.payload.put("volume", DEFAULT_VOICE_VOLUME);
        listener.setFlowingSpeechSynthesizer(this);
        this.StreamTTSListener = listener;
        this.state = SpeechReqProtocol.State.STATE_CONNECTED;
    }

    public void setVoice(String voice) {
        this.payload.put("voice", voice);
    }

    public void setFormat(OutputFormatEnum format) {
        this.payload.put("format", format.getName());
    }

    public void setSampleRate(SampleRateEnum sampleRate) {
        this.payload.put("sample_rate", sampleRate.value);
    }

    public void setSampleRate(int sampleRate) {
        this.payload.put("sample_rate", sampleRate);
    }

    public void setVolume(int volume) {
        this.payload.put("volume", volume);
    }

    public void setSpeechRate(int speechRate) {
        this.payload.put("speech_rate", speechRate);
    }

    public void setPitchRate(int pitchRate) {
        this.payload.put("pitch_rate", pitchRate);
    }

    public void setMinSendIntervalMS(long sendInterval) {
        this.minSendIntervalMS = sendInterval;
    }

    public void send(String text) {
        long msNeedToSleep = this.minSendIntervalMS - (System.currentTimeMillis() - this.lastSendTime);
        if (this.lastSendTime != -1L && msNeedToSleep > 0L) {
            logger.info("too short send interval, sleep {} million second", (Object)msNeedToSleep);
            try {
                Thread.sleep(msNeedToSleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.state.checkSend();
        try {
            SpeechReqProtocol req = new SpeechReqProtocol();
            req.header.put("task_id", this.currentTaskId);
            req.header.put("namespace", "FlowingSpeechSynthesizer");
            req.header.put("name", "RunSynthesis");
            req.setAppKey(this.getAppKey());
            req.payload = new HashMap();
            req.payload.put("text", text);
            this.conn.sendText(req.serialize());
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("fail to send text, current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    void markSynthesisReady() {
        this.state = SpeechReqProtocol.State.STATE_REQUEST_CONFIRMED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
    }

    void markSynthesisComplete() {
        this.state = SpeechReqProtocol.State.STATE_COMPLETE;
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markFail() {
        this.state = SpeechReqProtocol.State.STATE_FAIL;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markClosed() {
        this.state = SpeechReqProtocol.State.STATE_CLOSED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    public void start() throws Exception {
        this.start(10000L);
    }

    public void start(long milliSeconds) throws Exception {
        String sessionId = IdGen.genId();
        logger.info("start, gen session id: {}", (Object)sessionId);
        this.currentSessionId = sessionId;
        this.header.put("session_id", this.currentSessionId);
        super.start();
        this.completeLatch = new CountDownLatch(1);
        this.readyLatch = new CountDownLatch(1);
        boolean result = this.readyLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for start confirmation.task_id:%s,state:%s", milliSeconds, this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void stop() throws Exception {
        this.state.checkStop();
        SpeechReqProtocol req = new SpeechReqProtocol();
        req.header.put("task_id", this.currentTaskId);
        req.header.put("namespace", "FlowingSpeechSynthesizer");
        req.header.put("name", "StopSynthesis");
        req.setAppKey(this.getAppKey());
        this.conn.sendText(req.serialize());
        this.state = SpeechReqProtocol.State.STATE_STOP_SENT;
        this.completeLatch.await();
        if (this.state == SpeechReqProtocol.State.STATE_FAIL) {
            String msg = String.format("STATE_FAIL in stop. task_id:%s,state:%s", this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void close() {
        this.conn.close();
    }
}

