/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageDecoder;

public class MessageSelector {
    private String type;
    private String expression;
    private Map<String, String> properties = new HashMap<String, String>(4);

    private MessageSelector(String type, String expression) {
        this.type = type;
        this.expression = expression;
    }

    public static MessageSelector bySql(String sql) {
        return new MessageSelector("SQL92", sql);
    }

    public static MessageSelector byTag(String tag) {
        return new MessageSelector("TAG", tag);
    }

    public String getExpressionType() {
        return this.type;
    }

    public String getExpression() {
        return this.expression;
    }

    public void putProperty(String key, String value) {
        if (key == null || value == null || key.trim() == "" || value.trim() == "") {
            throw new IllegalArgumentException("Key and Value can not be null or empty string!");
        }
        this.properties.put(key, value);
    }

    public void putAllProperties(Map<String, String> puts) {
        if (puts == null || puts.isEmpty()) {
            return;
        }
        this.properties.putAll(puts);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPropertiesStr() {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        return MessageDecoder.messageProperties2String(this.properties);
    }
}

