/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.dbsync;

import com.alibaba.otter.canal.parse.driver.mysql.packets.server.FieldPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DruidDdlParser;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DatabaseTableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.MemoryTableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TableMetaCache {
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_TYPE = "COLUMN_TYPE";
    public static final String IS_NULLABLE = "IS_NULLABLE";
    public static final String COLUMN_KEY = "COLUMN_KEY";
    public static final String COLUMN_DEFAULT = "COLUMN_DEFAULT";
    public static final String EXTRA = "EXTRA";
    private MysqlConnection connection;
    private boolean isOnRDS = false;
    private boolean isOnTSDB = false;
    private TableMetaTSDB tableMetaTSDB;
    private LoadingCache<String, TableMeta> tableMetaDB;

    public TableMetaCache(MysqlConnection con, TableMetaTSDB tableMetaTSDB) {
        this.connection = con;
        this.tableMetaTSDB = tableMetaTSDB;
        if (tableMetaTSDB == null) {
            this.tableMetaDB = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TableMeta>(){

                public TableMeta load(String name) throws Exception {
                    try {
                        return TableMetaCache.this.getTableMetaByDB(name);
                    }
                    catch (Throwable e) {
                        try {
                            TableMetaCache.this.connection.reconnect();
                            return TableMetaCache.this.getTableMetaByDB(name);
                        }
                        catch (IOException e1) {
                            throw new CanalParseException("fetch failed by table meta:" + name, e1);
                        }
                    }
                }
            });
        } else {
            this.isOnTSDB = true;
        }
        try {
            ResultSetPacket packet = this.connection.query("show global variables  like 'rds\\_%'");
            if (packet.getFieldValues().size() > 0) {
                this.isOnRDS = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized TableMeta getTableMetaByDB(String fullname) throws IOException {
        try {
            ResultSetPacket packet = this.connection.query("show create table " + fullname);
            String[] names = StringUtils.split((String)fullname, (String)"`.`");
            String schema = names[0];
            String table = names[1].substring(0, names[1].length());
            return new TableMeta(schema, table, TableMetaCache.parseTableMeta(schema, table, packet));
        }
        catch (Throwable e) {
            ResultSetPacket packet = this.connection.query("desc " + fullname);
            String[] names = StringUtils.split((String)fullname, (String)"`.`");
            String schema = names[0];
            String table = names[1].substring(0, names[1].length());
            return new TableMeta(schema, table, TableMetaCache.parseTableMetaByDesc(packet));
        }
    }

    public static List<TableMeta.FieldMeta> parseTableMeta(String schema, String table, ResultSetPacket packet) {
        if (packet.getFieldValues().size() > 1) {
            String createDDL = (String)packet.getFieldValues().get(1);
            MemoryTableMeta memoryTableMeta = new MemoryTableMeta();
            memoryTableMeta.apply(DatabaseTableMeta.INIT_POSITION, schema, createDDL, null);
            TableMeta tableMeta = memoryTableMeta.find(schema, table);
            return tableMeta.getFields();
        }
        return new ArrayList<TableMeta.FieldMeta>();
    }

    public static List<TableMeta.FieldMeta> parseTableMetaByDesc(ResultSetPacket packet) {
        HashMap<String, Integer> nameMaps = new HashMap<String, Integer>(6, 1.0f);
        int index = 0;
        for (FieldPacket fieldPacket : packet.getFieldDescriptors()) {
            nameMaps.put(fieldPacket.getOriginalName(), index++);
        }
        int size = packet.getFieldDescriptors().size();
        int count = packet.getFieldValues().size() / packet.getFieldDescriptors().size();
        ArrayList<TableMeta.FieldMeta> result = new ArrayList<TableMeta.FieldMeta>();
        for (int i = 0; i < count; ++i) {
            TableMeta.FieldMeta meta = new TableMeta.FieldMeta();
            meta.setColumnName(((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_NAME) + i * size)).intern());
            meta.setColumnType((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_TYPE) + i * size));
            meta.setNullable(StringUtils.equalsIgnoreCase((String)((String)packet.getFieldValues().get((Integer)nameMaps.get(IS_NULLABLE) + i * size)), (String)"YES"));
            meta.setKey("PRI".equalsIgnoreCase((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_KEY) + i * size)));
            meta.setUnique("UNI".equalsIgnoreCase((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_KEY) + i * size)));
            meta.setDefaultValue(DruidDdlParser.unescapeQuotaName((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_DEFAULT) + i * size)));
            meta.setExtra((String)packet.getFieldValues().get((Integer)nameMaps.get(EXTRA) + i * size));
            result.add(meta);
        }
        return result;
    }

    public TableMeta getTableMeta(String schema, String table) {
        return this.getTableMeta(schema, table, true);
    }

    public TableMeta getTableMeta(String schema, String table, boolean useCache) {
        if (!useCache) {
            this.tableMetaDB.invalidate((Object)this.getFullName(schema, table));
        }
        return (TableMeta)this.tableMetaDB.getUnchecked((Object)this.getFullName(schema, table));
    }

    public TableMeta getTableMeta(String schema, String table, EntryPosition position) {
        return this.getTableMeta(schema, table, true, position);
    }

    public synchronized TableMeta getTableMeta(String schema, String table, boolean useCache, EntryPosition position) {
        TableMeta tableMeta = null;
        if (this.tableMetaTSDB != null) {
            tableMeta = this.tableMetaTSDB.find(schema, table);
            if (tableMeta == null) {
                String fullName = this.getFullName(schema, table);
                ResultSetPacket packet = null;
                String createDDL = null;
                try {
                    try {
                        packet = this.connection.query("show create table " + fullName);
                    }
                    catch (Exception e) {
                        this.connection.reconnect();
                        packet = this.connection.query("show create table " + fullName);
                    }
                    if (packet.getFieldValues().size() > 0) {
                        createDDL = (String)packet.getFieldValues().get(1);
                    }
                    this.tableMetaTSDB.apply(position, schema, createDDL, "first");
                    tableMeta = this.tableMetaTSDB.find(schema, table);
                }
                catch (IOException e) {
                    throw new CanalParseException("fetch failed by table meta:" + fullName, e);
                }
            }
            return tableMeta;
        }
        if (!useCache) {
            this.tableMetaDB.invalidate((Object)this.getFullName(schema, table));
        }
        return (TableMeta)this.tableMetaDB.getUnchecked((Object)this.getFullName(schema, table));
    }

    public void clearTableMeta(String schema, String table) {
        if (this.tableMetaTSDB == null) {
            this.tableMetaDB.invalidate((Object)this.getFullName(schema, table));
        }
    }

    public void clearTableMetaWithSchemaName(String schema) {
        if (this.tableMetaTSDB == null) {
            for (String name : this.tableMetaDB.asMap().keySet()) {
                if (!StringUtils.startsWithIgnoreCase((String)name, (String)(schema + "."))) continue;
                this.tableMetaDB.invalidate((Object)name);
            }
        }
    }

    public void clearTableMeta() {
        if (this.tableMetaTSDB == null) {
            this.tableMetaDB.invalidateAll();
        }
    }

    public boolean apply(EntryPosition position, String schema, String ddl, String extra) {
        if (this.tableMetaTSDB != null) {
            return this.tableMetaTSDB.apply(position, schema, ddl, extra);
        }
        return true;
    }

    private String getFullName(String schema, String table) {
        StringBuilder builder = new StringBuilder();
        return builder.append('`').append(schema).append('`').append('.').append('`').append(table).append('`').toString();
    }

    public boolean isOnTSDB() {
        return this.isOnTSDB;
    }

    public void setOnTSDB(boolean isOnTSDB) {
        this.isOnTSDB = isOnTSDB;
    }

    public boolean isOnRDS() {
        return this.isOnRDS;
    }

    public void setOnRDS(boolean isOnRDS) {
        this.isOnRDS = isOnRDS;
    }
}

