/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.oop;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractPojoRule;
import com.alibaba.p3c.pmd.lang.java.util.PojoUtils;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.jaxen.JaxenException;

public class PojoMustOverrideToStringRule
extends AbstractPojoRule {
    private static final String XPATH = "ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/MethodDeclaration[@Public='true' and MethodDeclarator[@Image='toString'] and MethodDeclarator[@Image='toString' and @ParameterCount='0']]";
    private static final String TOSTRING_XPATH = "//PrimaryExpression[PrimaryPrefix[Name[(ends-with(@Image, '.toString'))]][(../PrimarySuffix/Arguments/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix/Literal[@StringLiteral='true']) and ( count(../PrimarySuffix/Arguments/ArgumentList/Expression) = 1 )]][not(ancestor::Expression/ConditionalAndExpression//EqualityExpression[@Image='!=']//NullLiteral)][not(ancestor::Expression/ConditionalOrExpression//EqualityExpression[@Image='==']//NullLiteral)]";
    private static final String LOMBOK_XPATH = "../Annotation/MarkerAnnotation/Name[(@Image='Data' and //ImportDeclaration[@ImportedName='lombok.Data' or @ImportedName='lombok']) or (@Image='ToString' and //ImportDeclaration[@ImportedName='lombok.ToString' or @ImportedName='lombok']) or (@Image='lombok.Data') or (@Image='lombok.ToString')]";
    private static final String MESSAGE_KEY_PREFIX = "java.oop.PojoMustOverrideToStringRule.violation.msg";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!this.isPojo(node)) {
            return super.visit(node, data);
        }
        if (node.isAbstract() || this.withLombokAnnotation(node)) {
            return super.visit(node, data);
        }
        if (!node.hasDescendantMatchingXPath(XPATH)) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.oop.PojoMustOverrideToStringRule.violation.msg.notostring", node.getImage()));
        } else {
            this.checkForExtend(node, data);
        }
        return super.visit(node, data);
    }

    private void checkForExtend(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTExtendsList extendsList = (ASTExtendsList)node.getFirstChildOfType(ASTExtendsList.class);
        if (extendsList == null) {
            return;
        }
        String baseName = ((ASTClassOrInterfaceType)extendsList.getFirstChildOfType(ASTClassOrInterfaceType.class)).getImage();
        if (!PojoUtils.isPojo(baseName)) {
            return;
        }
        try {
            ASTMethodDeclaration toStringMethod = (ASTMethodDeclaration)node.findChildNodesWithXPath(XPATH).get(0);
            ASTBlock block = toStringMethod.getBlock();
            if (block.hasDescendantMatchingXPath(TOSTRING_XPATH)) {
                this.addViolationWithMessage(data, (Node)block, "java.oop.PojoMustOverrideToStringRule.violation.msg.usesuper");
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/MethodDeclaration[@Public='true' and MethodDeclarator[@Image='toString'] and MethodDeclarator[@Image='toString' and @ParameterCount='0']] failed: " + e.getLocalizedMessage(), e);
        }
    }

    private boolean withLombokAnnotation(ASTClassOrInterfaceDeclaration node) {
        return node.hasDescendantMatchingXPath(LOMBOK_XPATH);
    }
}

