/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.oop;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.jaxen.JaxenException;

public class BigDecimalAvoidDoubleConstructorRule
extends AbstractAliRule {
    private static final String XPATH = "Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression/Arguments[preceding-sibling::ClassOrInterfaceType[@Image = 'BigDecimal']]/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix";

    public Object visit(ASTVariableInitializer node, Object data) {
        try {
            List invocations = node.findChildNodesWithXPath(XPATH);
            if (invocations == null || invocations.isEmpty()) {
                return super.visit(node, data);
            }
            ASTPrimaryPrefix expression = (ASTPrimaryPrefix)invocations.get(0);
            if (this.isDoubleLiteral(expression) || this.isDoubleVariable(expression)) {
                this.addViolationWithMessage(data, (Node)node, "java.oop.BigDecimalAvoidDoubleConstructorRule.violation.msg", null);
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression/Arguments[preceding-sibling::ClassOrInterfaceType[@Image = 'BigDecimal']]/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix failed: " + e.getLocalizedMessage(), e);
        }
        return super.visit(node, data);
    }

    public void addViolation(Object data, Node node, String arg) {
        ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, node, data, "java.oop.BigDecimalAvoidDoubleConstructorRule.violation.msg");
    }

    private boolean isDoubleLiteral(ASTPrimaryPrefix node) {
        ASTLiteral literal = (ASTLiteral)node.getFirstChildOfType(ASTLiteral.class);
        return literal != null && literal.isDoubleLiteral();
    }

    private boolean isDoubleVariable(ASTPrimaryPrefix node) {
        ASTName name = (ASTName)node.getFirstChildOfType(ASTName.class);
        return name != null && Double.class == name.getType();
    }
}

