/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.other;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class AvoidDoubleOrFloatEqualCompareRule
extends AbstractAliRule {
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final int LIST_SIZE = 2;

    public Object visit(ASTEqualityExpression node, Object data) {
        List list = node.findDescendantsOfType(ASTPrimaryExpression.class);
        if (list.size() != 2) {
            return super.visit(node, data);
        }
        ASTPrimaryExpression left = (ASTPrimaryExpression)list.get(0);
        ASTPrimaryExpression right = (ASTPrimaryExpression)list.get(1);
        Class leftType = left.getType();
        Class rightType = right.getType();
        if (leftType == null || rightType == null) {
            return super.visit(node, data);
        }
        if (FLOAT.equals(leftType.getName()) && FLOAT.equals(rightType.getName())) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data);
        } else if (DOUBLE.equals(leftType.getName()) && DOUBLE.equals(rightType.getName())) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data);
        }
        return super.visit(node, data);
    }
}

