/*
 * Decompiled with CFR 0.152.
 */
package pemja.core;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import pemja.core.Interpreter;
import pemja.core.PythonInterpreterConfig;
import pemja.utils.CommonUtils;

public final class PythonInterpreter
implements Interpreter {
    private static final long serialVersionUID = 1L;
    private final MainInterpreter mainInterpreter = MainInterpreter.access$000();
    private long tState = 0L;

    public PythonInterpreter(PythonInterpreterConfig config) {
        this.initialize(config);
    }

    @Override
    public void set(String name, Object value) {
        this.checkPythonInterpreterRunning();
        if (value instanceof String) {
            this.set(this.tState, name, (String)value);
        } else if (value instanceof Boolean) {
            this.set(this.tState, name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.set(this.tState, name, ((Byte)value).byteValue());
        } else if (value instanceof Character) {
            this.set(this.tState, name, String.valueOf(((Character)value).charValue()));
        } else if (value instanceof Short) {
            this.set(this.tState, name, ((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.set(this.tState, name, (Integer)value);
        } else if (value instanceof Long) {
            this.set(this.tState, name, (Long)value);
        } else if (value instanceof Float) {
            this.set(this.tState, name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.set(this.tState, name, (Double)value);
        } else {
            this.set(this.tState, name, value);
        }
    }

    @Override
    public Object get(String name) {
        return this.get(name, Object.class);
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        this.checkPythonInterpreterRunning();
        return clazz.cast(this.get(this.tState, name, clazz));
    }

    @Override
    public Object invoke(String name, Object ... args) {
        this.checkPythonInterpreterRunning();
        int argNum = args.length;
        if (argNum == 0) {
            return this.invokeNoArgs(this.tState, name);
        }
        if (argNum == 1) {
            return this.invokeOneArg(name, args[0]);
        }
        return this.invoke(name, args, null);
    }

    @Override
    public Object invoke(String name, Map<String, Object> kwargs) {
        return this.invoke(name, null, kwargs);
    }

    @Override
    public Object invoke(String name, Object[] args, Map<String, Object> kwargs) {
        this.checkPythonInterpreterRunning();
        return this.invoke(this.tState, name, args, kwargs);
    }

    @Override
    public Object invokeMethod(String obj, String name, Object ... args) {
        this.checkPythonInterpreterRunning();
        int argNum = args.length;
        if (argNum == 0) {
            return this.invokeMethodNoArgs(this.tState, obj, name);
        }
        if (argNum == 1) {
            return this.invokeMethodOneArg(obj, name, args[0]);
        }
        return this.invokeMethod(this.tState, obj, name, args);
    }

    @Override
    public void exec(String str) {
        this.checkPythonInterpreterRunning();
        this.exec(this.tState, str);
    }

    @Override
    public void close() {
        if (this.tState > 0L) {
            try {
                this.finalize(this.tState);
            }
            finally {
                this.tState = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(PythonInterpreterConfig config) {
        this.mainInterpreter.initialize(config);
        this.tState = this.init(config.getExecType().ordinal());
        Class<PythonInterpreter> clazz = PythonInterpreter.class;
        synchronized (PythonInterpreter.class) {
            this.configSearchPaths(config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.exec("from pemja import logger");
            return;
        }
    }

    private void configSearchPaths(PythonInterpreterConfig config) {
        String[] paths = config.getPaths();
        if (paths != null) {
            this.exec("import sys");
            for (int i = paths.length - 1; i >= 0; --i) {
                this.exec(String.format("sys.path.insert(0, r'%s')", paths[i]));
            }
        }
        if (config.getPythonExec() == null) {
            String pythonModulePath = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "src", "main", "python");
            this.exec(String.format("sys.path.insert(0, r'%s')", pythonModulePath));
        }
    }

    private void checkPythonInterpreterRunning() {
        if (this.tState == 0L) {
            throw new RuntimeException("The python interpreter has not been started. You need to call the `open` method before.");
        }
    }

    private Object invokeOneArg(String name, Object arg) {
        if (arg instanceof String) {
            return this.invokeOneArgString(this.tState, name, (String)arg);
        }
        if (arg instanceof Boolean) {
            return this.invokeOneArgBoolean(this.tState, name, (Boolean)arg);
        }
        if (arg instanceof Integer) {
            return this.invokeOneArgInt(this.tState, name, (Integer)arg);
        }
        if (arg instanceof Float) {
            return this.invokeOneArgDouble(this.tState, name, ((Float)arg).floatValue());
        }
        if (arg instanceof Double) {
            return this.invokeOneArgDouble(this.tState, name, (Double)arg);
        }
        if (arg instanceof Long) {
            return this.invokeOneArgLong(this.tState, name, (Long)arg);
        }
        if (arg instanceof Character) {
            return this.invokeOneArgString(this.tState, name, String.valueOf(((Character)arg).charValue()));
        }
        if (arg instanceof Byte) {
            return this.invokeOneArgInt(this.tState, name, ((Byte)arg).byteValue());
        }
        if (arg instanceof Short) {
            return this.invokeOneArgInt(this.tState, name, ((Short)arg).shortValue());
        }
        return this.invokeOneArgObject(this.tState, name, arg);
    }

    private Object invokeMethodOneArg(String obj, String method, Object arg) {
        if (arg instanceof String) {
            return this.invokeMethodOneArgString(this.tState, obj, method, (String)arg);
        }
        if (arg instanceof Boolean) {
            return this.invokeMethodOneArgBoolean(this.tState, obj, method, (Boolean)arg);
        }
        if (arg instanceof Integer) {
            return this.invokeMethodOneArgInt(this.tState, obj, method, (Integer)arg);
        }
        if (arg instanceof Float) {
            return this.invokeMethodOneArgDouble(this.tState, obj, method, ((Float)arg).floatValue());
        }
        if (arg instanceof Double) {
            return this.invokeMethodOneArgDouble(this.tState, obj, method, (Double)arg);
        }
        if (arg instanceof Long) {
            return this.invokeMethodOneArgLong(this.tState, obj, method, (Long)arg);
        }
        if (arg instanceof Character) {
            return this.invokeMethodOneArgString(this.tState, obj, method, String.valueOf(((Character)arg).charValue()));
        }
        if (arg instanceof Byte) {
            return this.invokeMethodOneArgInt(this.tState, obj, method, ((Byte)arg).byteValue());
        }
        if (arg instanceof Short) {
            return this.invokeMethodOneArgInt(this.tState, obj, method, ((Short)arg).shortValue());
        }
        return this.invokeMethodOneArgObject(this.tState, obj, method, arg);
    }

    private native long init(int var1);

    private native void finalize(long var1);

    private native void set(long var1, String var3, boolean var4);

    private native void set(long var1, String var3, int var4);

    private native void set(long var1, String var3, long var4);

    private native void set(long var1, String var3, double var4);

    private native void set(long var1, String var3, String var4);

    private native void set(long var1, String var3, Object var4);

    private native Object get(long var1, String var3, Class<?> var4);

    private native Object invokeNoArgs(long var1, String var3);

    private native Object invokeOneArgBoolean(long var1, String var3, boolean var4);

    private native Object invokeOneArgInt(long var1, String var3, int var4);

    private native Object invokeOneArgLong(long var1, String var3, long var4);

    private native Object invokeOneArgDouble(long var1, String var3, double var4);

    private native Object invokeOneArgString(long var1, String var3, String var4);

    private native Object invokeOneArgObject(long var1, String var3, Object var4);

    private native Object invoke(long var1, String var3, Object[] var4, Map<String, Object> var5);

    private native Object invokeMethodNoArgs(long var1, String var3, String var4);

    private native Object invokeMethodOneArgBoolean(long var1, String var3, String var4, boolean var5);

    private native Object invokeMethodOneArgInt(long var1, String var3, String var4, int var5);

    private native Object invokeMethodOneArgLong(long var1, String var3, String var4, long var5);

    private native Object invokeMethodOneArgDouble(long var1, String var3, String var4, double var5);

    private native Object invokeMethodOneArgString(long var1, String var3, String var4, String var5);

    private native Object invokeMethodOneArgObject(long var1, String var3, String var4, Object var5);

    private native Object invokeMethod(long var1, String var3, String var4, Object[] var5);

    private native void exec(long var1, String var3);

    private static class MainInterpreter
    implements Serializable,
    AutoCloseable {
        private static final long serialVersionUID = 1L;
        private static final MainInterpreter instance = new MainInterpreter();
        private final CountDownLatch damonThreadStart = new CountDownLatch(1);
        private final CountDownLatch damonThreadFinish = new CountDownLatch(1);
        private boolean isStarted = false;
        private Thread thread;
        private Throwable error;

        private MainInterpreter() {
        }

        synchronized void initialize(final PythonInterpreterConfig config) {
            if (!this.isStarted) {
                block4: {
                    CommonUtils.INSTANCE.loadPython(config.getPythonExec());
                    this.thread = new Thread("PemJaMainInterpreter"){

                        @Override
                        public void run() {
                            try {
                                this.initialize(config.getPythonHome());
                                this.addToPath(CommonUtils.INSTANCE.getPemJaModulePath(config.getPythonExec()));
                                this.importModule("redirect_stream");
                            }
                            catch (Throwable t) {
                                error = t;
                            }
                            finally {
                                damonThreadStart.countDown();
                            }
                            try {
                                damonThreadFinish.await();
                            }
                            catch (InterruptedException e) {
                                throw new Error(e);
                            }
                        }
                    };
                    this.thread.setDaemon(true);
                    this.thread.start();
                    try {
                        this.damonThreadStart.await();
                    }
                    catch (InterruptedException e) {
                        if (this.error != null) break block4;
                        this.error = e;
                    }
                }
                if (this.error != null) {
                    throw new Error(this.error);
                }
                this.isStarted = true;
            }
        }

        @Override
        public void close() {
            if (this.thread != null) {
                this.damonThreadFinish.countDown();
            }
        }

        private native void initialize(String var1);

        private native void addToPath(String var1);

        private native void importModule(String var1);

        static /* synthetic */ MainInterpreter access$000() {
            return instance;
        }
    }
}

