/*
 * Decompiled with CFR 0.152.
 */
package pemja.core.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonLogWriter {
    public void log(String name, String severityName, String message, String trace) {
        Logger log = LoggerFactory.getLogger((String)name);
        Severity severity = Severity.valueOf(severityName);
        switch (severity) {
            case ERROR: 
            case CRITICAL: {
                if (trace == null) {
                    log.error(message);
                    break;
                }
                log.error("{} {}", (Object)message, (Object)trace);
                break;
            }
            case WARN: {
                if (trace == null) {
                    log.warn(message);
                    break;
                }
                log.warn("{} {}", (Object)message, (Object)trace);
                break;
            }
            case INFO: 
            case NOTICE: {
                log.info(message);
                break;
            }
            case DEBUG: {
                log.debug(message);
                break;
            }
            case UNSPECIFIED: 
            case TRACE: {
                log.trace(message);
                break;
            }
            default: {
                log.warn("Unknown message severity {}", (Object)severityName);
                log.info(message);
            }
        }
    }

    private static enum Severity {
        ERROR,
        CRITICAL,
        WARN,
        INFO,
        NOTICE,
        DEBUG,
        TRACE,
        UNSPECIFIED;

    }
}

