/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.GalaxyPrepare;

import com.alibaba.polardbx.common.datatype.UInt64;
import com.alibaba.polardbx.common.jdbc.TableName;
import com.alibaba.polardbx.common.type.MySQLStandardFieldType;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPParam;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPTable;
import com.alibaba.polardbx.rpc.client.XSession;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class GP57Util {
    private final int typeOffset;
    private final byte[] header;
    private final Object[] params;
    private static final BigInteger ZERO = new BigInteger("0");
    private static final BigInteger LONG_LIMIT = new BigInteger("18446744073709551616");

    public GP57Util(int paramCnt) {
        this.typeOffset = (paramCnt + 7) / 8 + 1;
        this.header = new byte[this.typeOffset + 2 * paramCnt];
        this.params = new Object[paramCnt];
    }

    public void reset() {
        Arrays.fill(this.header, (byte)0);
        Arrays.fill(this.params, null);
    }

    private static void writeLength(CodedOutputStream coded, int length) throws IOException {
        if (length < 251) {
            coded.write((byte)length);
        } else if (length < 65536) {
            coded.write((byte)-4);
            coded.write((byte)(length & 0xFF));
            coded.write((byte)(length >>> 8 & 0xFF));
        } else if (length < 0x1000000) {
            coded.write((byte)-3);
            coded.write((byte)(length & 0xFF));
            coded.write((byte)(length >>> 8 & 0xFF));
            coded.write((byte)(length >>> 16 & 0xFF));
        } else {
            coded.write((byte)-2);
            coded.writeInt64NoTag((long)length);
        }
    }

    public void setTiny(int idx, int i, boolean unsigned) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_TINY.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = (byte)(unsigned ? 128 : 0);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)i);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setShort(int idx, int i, boolean unsigned) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_SHORT.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = (byte)(unsigned ? 128 : 0);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(i & 0xFF));
            coded.write((byte)(i >>> 8 & 0xFF));
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setInt32(int idx, int i, boolean unsigned) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_LONG.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = (byte)(unsigned ? 128 : 0);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.writeFixed32NoTag(i);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setInt64(int idx, long l, boolean unsigned) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_LONGLONG.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = (byte)(unsigned ? 128 : 0);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.writeFixed64NoTag(l);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setFloat(int idx, float f) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_FLOAT.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.writeFloatNoTag(f);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setDouble(int idx, double d) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_DOUBLE.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.writeDoubleNoTag(d);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setDecimal(int idx, BigDecimal v) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_NEWDECIMAL.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            byte[] bytes = v.toString().getBytes(StandardCharsets.UTF_8);
            GP57Util.writeLength(coded, bytes.length);
            coded.write(bytes, 0, bytes.length);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setString(int idx, String s, String charset) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_STRING.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            byte[] bytes = s.getBytes(charset);
            GP57Util.writeLength(coded, bytes.length);
            coded.write(bytes, 0, bytes.length);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setString(int idx, String s, Charset charset) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_STRING.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            byte[] bytes = s.getBytes(charset);
            GP57Util.writeLength(coded, bytes.length);
            coded.write(bytes, 0, bytes.length);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setBoolean(int idx, boolean b) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_TINY.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(b ? 1 : 0));
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setNull(int idx) {
        try {
            int n = idx >>> 3;
            this.header[n] = (byte)(this.header[n] | 1 << (idx & 7));
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_NULL.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            this.params[idx] = null;
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void setBytes(int idx, byte[] data, int offset, int length) {
        try {
            this.header[this.typeOffset + 2 * idx] = (byte)(MySQLStandardFieldType.MYSQL_TYPE_STRING.getId() & 0xFF);
            this.header[this.typeOffset + 2 * idx + 1] = 0;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            GP57Util.writeLength(coded, length);
            coded.write(data, offset, length);
            coded.flush();
            this.params[idx] = stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void set(int idx, Object value, XSession session) {
        if (value instanceof String) {
            if (null == session) {
                this.setString(idx, (String)value, StandardCharsets.UTF_8);
            } else {
                this.setString(idx, (String)value, XSession.toJavaEncoding(session.getRequestEncodingMySQL()));
            }
        } else if (value instanceof Long) {
            this.setInt64(idx, (Long)value, false);
        } else if (value instanceof Integer) {
            this.setInt32(idx, (Integer)value, false);
        } else if (value instanceof Short) {
            this.setShort(idx, ((Short)value).shortValue(), false);
        } else if (value instanceof Byte) {
            this.setTiny(idx, ((Byte)value).byteValue(), false);
        } else if (null == value) {
            this.setNull(idx);
        } else if (value instanceof Float) {
            this.setFloat(idx, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(idx, (Double)value);
        } else if (value instanceof Boolean) {
            this.setBoolean(idx, (Boolean)value);
        } else if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(ZERO) >= 0 && ((BigInteger)value).compareTo(LONG_LIMIT) < 0) {
                this.setInt64(idx, ((BigInteger)value).longValue(), true);
            } else {
                this.setString(idx, value.toString(), StandardCharsets.UTF_8);
            }
        } else if (value instanceof BigDecimal) {
            this.setDecimal(idx, (BigDecimal)value);
        } else if (value instanceof Date) {
            this.setString(idx, value.toString(), StandardCharsets.UTF_8);
        } else if (value instanceof Time) {
            this.setString(idx, value.toString(), StandardCharsets.UTF_8);
        } else if (value instanceof Timestamp) {
            this.setString(idx, value.toString(), StandardCharsets.UTF_8);
        } else if (value instanceof java.util.Date) {
            this.setString(idx, null == session ? value.toString() : session.formatTime((java.util.Date)value), StandardCharsets.UTF_8);
        } else if (value instanceof byte[]) {
            byte[] val = (byte[])value;
            this.setBytes(idx, val, 0, val.length);
        } else if (value instanceof Blob) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                InputStream inputStream = ((Blob)value).getBinaryStream();
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = inputStream.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                byte[] val = outputStream.toByteArray();
                this.setBytes(idx, val, 0, val.length);
            }
            catch (Exception e) {
                throw GeneralUtil.nestedException((Throwable)e);
            }
        } else if (value instanceof TableName) {
            String substring;
            String tableName = ((TableName)value).getTableName();
            this.params[idx] = tableName.length() >= 2 && '`' == tableName.charAt(0) && '`' == tableName.charAt(tableName.length() - 1) ? ((substring = tableName.substring(1, tableName.length() - 1)).indexOf(96) != -1 ? substring.replaceAll("``", "`") : substring) : tableName;
        } else if (value instanceof UInt64) {
            this.setInt64(idx, ((UInt64)value).longValue(), true);
        } else {
            throw GeneralUtil.nestedException((String)("TODO: support more type. " + value.getClass().getName()));
        }
    }

    public GPParam genParam() {
        int tableCount = 0;
        for (Object o : this.params) {
            if (!(o instanceof String)) continue;
            ++tableCount;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            if (0 == tableCount) {
                this.header[this.typeOffset - 1] = 1;
                stream.write(this.header);
                for (Object o : this.params) {
                    assert (o instanceof byte[] || null == o);
                    if (o == null) continue;
                    stream.write((byte[])o);
                }
            } else {
                int newParamCnt = this.params.length - tableCount;
                if (newParamCnt > 0) {
                    int newTypeOffset = (newParamCnt + 7) / 8 + 1;
                    byte[] newHeader = new byte[newTypeOffset + 2 * newParamCnt];
                    int newIdx = 0;
                    for (int idx = 0; idx < this.params.length; ++idx) {
                        Object param = this.params[idx];
                        if (param instanceof String) continue;
                        assert (param instanceof byte[] || null == param);
                        if ((this.header[idx >>> 3] & 1 << (idx & 7)) != 0) {
                            int n = newIdx >>> 3;
                            newHeader[n] = (byte)(newHeader[n] | 1 << (newIdx & 7));
                        }
                        newHeader[newTypeOffset + 2 * newIdx] = this.header[this.typeOffset + 2 * idx];
                        newHeader[newTypeOffset + 2 * newIdx + 1] = this.header[this.typeOffset + 2 * idx + 1];
                        ++newIdx;
                    }
                    assert (newIdx == newParamCnt);
                    newHeader[newTypeOffset - 1] = 1;
                    stream.write(newHeader);
                    for (Object o : this.params) {
                        if (o instanceof String) continue;
                        assert (o instanceof byte[] || null == o);
                        if (o == null) continue;
                        stream.write((byte[])o);
                    }
                }
            }
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
        if (0 == tableCount) {
            return new GPParam(Collections.emptyList(), 0 == stream.size() ? ByteString.EMPTY : ByteString.copyFrom((byte[])stream.toByteArray()), this.params.length);
        }
        ArrayList<GPTable> tables = new ArrayList<GPTable>(tableCount);
        for (int idx = 0; idx < this.params.length; ++idx) {
            Object param = this.params[idx];
            if (!(param instanceof String)) continue;
            tables.add(new GPTable(idx + 1, (String)param));
        }
        assert (tables.size() == tableCount);
        return new GPParam(tables, 0 == stream.size() ? ByteString.EMPTY : ByteString.copyFrom((byte[])stream.toByteArray()), this.params.length - tableCount);
    }
}

