/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.GalaxyPrepare;

import com.alibaba.polardbx.common.jdbc.TableName;
import com.alibaba.polardbx.common.type.MySQLStandardFieldType;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.rpc.client.XSession;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class GPUtil {
    private static final BigInteger ZERO = new BigInteger("0");
    private static final BigInteger LONG_LIMIT = new BigInteger("18446744073709551616");

    public static byte[] genUtf8String(String s) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_STRING.getId() & 0xFF));
            coded.write((byte)0);
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            coded.writeInt64NoTag((long)bytes.length);
            coded.write(bytes, 0, bytes.length);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genSInt(long i) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_LONGLONG.getId() & 0xFF));
            coded.write((byte)0);
            coded.writeInt64NoTag(8L);
            coded.writeFixed64NoTag(i);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genUInt(long u) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_LONGLONG.getId() & 0xFF));
            coded.write((byte)2);
            coded.writeInt64NoTag(8L);
            coded.writeFixed64NoTag(u);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genFloat(float f) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_FLOAT.getId() & 0xFF));
            coded.write((byte)0);
            coded.writeInt64NoTag(4L);
            coded.writeFloatNoTag(f);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genDouble(double d) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_DOUBLE.getId() & 0xFF));
            coded.write((byte)0);
            coded.writeInt64NoTag(8L);
            coded.writeDoubleNoTag(d);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genBoolean(boolean b) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_TINY.getId() & 0xFF));
            coded.write((byte)0);
            coded.writeInt64NoTag(1L);
            coded.write((byte)(b ? 1 : 0));
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genNull() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_NULL.getId() & 0xFF));
            coded.write((byte)1);
            coded.writeInt64NoTag(0L);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static byte[] genBytes(byte[] data, int offset, int length) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            CodedOutputStream coded = CodedOutputStream.newInstance((OutputStream)stream);
            coded.write((byte)(MySQLStandardFieldType.MYSQL_TYPE_STRING.getId() & 0xFF));
            coded.write((byte)0);
            coded.writeInt64NoTag((long)length);
            coded.write(data, offset, length);
            coded.flush();
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public static Object gen(Object value, XSession session) {
        if (value instanceof String) {
            return GPUtil.genUtf8String((String)value);
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            return GPUtil.genSInt(((Number)value).longValue());
        }
        if (null == value) {
            return GPUtil.genNull();
        }
        if (value instanceof Float) {
            return GPUtil.genFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return GPUtil.genDouble((Double)value);
        }
        if (value instanceof Boolean) {
            return GPUtil.genBoolean((Boolean)value);
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(ZERO) >= 0 && ((BigInteger)value).compareTo(LONG_LIMIT) < 0) {
                return GPUtil.genUInt(((BigInteger)value).longValue());
            }
            return GPUtil.genUtf8String(value.toString());
        }
        if (value instanceof BigDecimal) {
            return GPUtil.genUtf8String(value.toString());
        }
        if (value instanceof Date) {
            return GPUtil.genUtf8String(value.toString());
        }
        if (value instanceof Time) {
            return GPUtil.genUtf8String(value.toString());
        }
        if (value instanceof Timestamp) {
            return GPUtil.genUtf8String(value.toString());
        }
        if (value instanceof java.util.Date) {
            return GPUtil.genUtf8String(null == session ? value.toString() : session.formatTime((java.util.Date)value));
        }
        if (value instanceof byte[]) {
            byte[] val = (byte[])value;
            return GPUtil.genBytes(val, 0, val.length);
        }
        if (value instanceof Blob) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                InputStream inputStream = ((Blob)value).getBinaryStream();
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = inputStream.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                byte[] val = outputStream.toByteArray();
                return GPUtil.genBytes(val, 0, val.length);
            }
            catch (Exception e) {
                throw GeneralUtil.nestedException((Throwable)e);
            }
        }
        if (value instanceof TableName) {
            String tableName = ((TableName)value).getTableName();
            if (tableName.length() >= 2 && '`' == tableName.charAt(0) && '`' == tableName.charAt(tableName.length() - 1)) {
                String substring = tableName.substring(1, tableName.length() - 1);
                if (substring.indexOf(96) != -1) {
                    return substring.replaceAll("``", "`");
                }
                return substring;
            }
            return tableName;
        }
        throw GeneralUtil.nestedException((String)("TODO: support more type. " + value.getClass().getName()));
    }
}

