/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc;

import com.alibaba.polardbx.common.datatype.Decimal;
import com.alibaba.polardbx.common.datatype.UInt64;
import com.alibaba.polardbx.common.jdbc.TableName;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.client.XSession;
import com.google.protobuf.ByteString;
import com.mysql.cj.x.protobuf.PolarxDatatypes;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class XUtil {
    private static final BigInteger ZERO = new BigInteger("0");
    private static final BigInteger LONG_LIMIT = new BigInteger("18446744073709551616");

    public static PolarxDatatypes.Scalar genUtf8RawStringScalar(String value, XSession session) {
        PolarxDatatypes.Scalar.String.Builder stringBuilder = PolarxDatatypes.Scalar.String.newBuilder();
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        if (session != null) {
            try {
                stringBuilder.setValue(ByteString.copyFrom((String)value, (String)XSession.toJavaEncoding(session.getRequestEncodingMySQL())));
            }
            catch (Exception e) {
                throw GeneralUtil.nestedException((Throwable)e);
            }
        } else {
            stringBuilder.setValue(ByteString.copyFromUtf8((String)value));
        }
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_RAW_STRING);
        scalarBuilder.setVString(stringBuilder);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genUtf8StringScalar(String value) {
        PolarxDatatypes.Scalar.String.Builder stringBuilder = PolarxDatatypes.Scalar.String.newBuilder();
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        stringBuilder.setCollation(45L);
        stringBuilder.setValue(ByteString.copyFromUtf8((String)value));
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_STRING);
        scalarBuilder.setVString(stringBuilder);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genStringScalar(String value, XSession session) {
        PolarxDatatypes.Scalar.String.Builder stringBuilder = PolarxDatatypes.Scalar.String.newBuilder();
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        if (session != null) {
            try {
                stringBuilder.setValue(ByteString.copyFrom((String)value, (String)XSession.toJavaEncoding(session.getRequestEncodingMySQL())));
            }
            catch (Exception e) {
                throw GeneralUtil.nestedException((Throwable)e);
            }
        } else {
            stringBuilder.setValue(ByteString.copyFromUtf8((String)value));
        }
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_STRING);
        scalarBuilder.setVString(stringBuilder);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genPlaceholderScalar(int position) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_PLACEHOLDER);
        scalarBuilder.setVPosition(position);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genSIntScalar(long value) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_SINT);
        scalarBuilder.setVSignedInt(value);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genUIntScalar(long value) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_UINT);
        scalarBuilder.setVUnsignedInt(value);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genFloatScalar(float value) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_FLOAT);
        scalarBuilder.setVFloat(value);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genDoubleScalar(double value) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_DOUBLE);
        scalarBuilder.setVDouble(value);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genBooleanScalar(boolean value) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_BOOL);
        scalarBuilder.setVBool(value);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genOctetsScalar(ByteBuffer buffer) {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        PolarxDatatypes.Scalar.Octets.Builder octetsBuilder = PolarxDatatypes.Scalar.Octets.newBuilder();
        octetsBuilder.setValue(ByteString.copyFrom((ByteBuffer)buffer));
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_OCTETS);
        scalarBuilder.setVOctets(octetsBuilder);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genNullScalar() {
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_NULL);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genIdentifierScalar(String identifier) {
        PolarxDatatypes.Scalar.String.Builder stringBuilder = PolarxDatatypes.Scalar.String.newBuilder();
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        stringBuilder.setCollation(45L);
        stringBuilder.setValue(ByteString.copyFromUtf8((String)identifier));
        if (XConfig.GALAXY_X_PROTOCOL) {
            scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_IDENTIFIER_GALAXY);
            scalarBuilder.setVIdentifierGalaxy(stringBuilder);
        } else {
            scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_IDENTIFIER);
            scalarBuilder.setVIdentifier(stringBuilder);
        }
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Scalar genIdentifierScalarStringCompatible(String identifier) {
        PolarxDatatypes.Scalar.String.Builder stringBuilder = PolarxDatatypes.Scalar.String.newBuilder();
        PolarxDatatypes.Scalar.Builder scalarBuilder = PolarxDatatypes.Scalar.newBuilder();
        stringBuilder.setCollation(45L);
        stringBuilder.setValue(ByteString.copyFromUtf8((String)identifier));
        scalarBuilder.setType(PolarxDatatypes.Scalar.Type.V_IDENTIFIER);
        scalarBuilder.setVString(stringBuilder);
        return scalarBuilder.build();
    }

    public static PolarxDatatypes.Array genScalarList(List values, XSession session) {
        PolarxDatatypes.Array.Builder builder = PolarxDatatypes.Array.newBuilder();
        for (Object value : values) {
            PolarxDatatypes.Scalar scalar = XUtil.genScalar(value, session);
            builder.addValue(XUtil.genAny(scalar));
        }
        return builder.build();
    }

    public static PolarxDatatypes.Scalar genScalar(Object value, XSession session) {
        if (value instanceof String) {
            return XUtil.genStringScalar((String)value, session);
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            return XUtil.genSIntScalar(((Number)value).longValue());
        }
        if (null == value) {
            return XUtil.genNullScalar();
        }
        if (value instanceof Float) {
            return XUtil.genFloatScalar(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return XUtil.genDoubleScalar((Double)value);
        }
        if (value instanceof Boolean) {
            return XUtil.genBooleanScalar((Boolean)value);
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).compareTo(ZERO) >= 0 && ((BigInteger)value).compareTo(LONG_LIMIT) < 0) {
                return XUtil.genUIntScalar(((BigInteger)value).longValue());
            }
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof BigDecimal) {
            if (session != null && session.supportRawString()) {
                return XUtil.genUtf8RawStringScalar(value.toString(), session);
            }
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof Decimal) {
            if (session != null && session.supportRawString()) {
                return XUtil.genUtf8RawStringScalar(value.toString(), session);
            }
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof Date) {
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof Time) {
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof Timestamp) {
            return XUtil.genUtf8StringScalar(value.toString());
        }
        if (value instanceof java.util.Date) {
            return XUtil.genUtf8StringScalar(null == session ? value.toString() : session.formatTime((java.util.Date)value));
        }
        if (value instanceof byte[]) {
            return XUtil.genOctetsScalar(ByteBuffer.wrap((byte[])value));
        }
        if (value instanceof Blob) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                InputStream inputStream = ((Blob)value).getBinaryStream();
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = inputStream.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                return XUtil.genOctetsScalar(ByteBuffer.wrap(outputStream.toByteArray()));
            }
            catch (Exception e) {
                throw GeneralUtil.nestedException((String)("XPreparedStatement setBlob error." + value.getClass().getName()));
            }
        }
        if (value instanceof TableName) {
            String tableName = ((TableName)value).getTableName();
            if (tableName.length() >= 2 && '`' == tableName.charAt(0) && '`' == tableName.charAt(tableName.length() - 1)) {
                return XUtil.genIdentifierScalar(tableName.substring(1, tableName.length() - 1));
            }
            return XUtil.genIdentifierScalar(tableName);
        }
        if (value instanceof UInt64) {
            return XUtil.genUIntScalar(((UInt64)value).longValue());
        }
        throw GeneralUtil.nestedException((String)("TODO: support more type. " + value.getClass().getName()));
    }

    public static PolarxDatatypes.Any genAny(PolarxDatatypes.Scalar scalar) {
        PolarxDatatypes.Any.Builder builder = PolarxDatatypes.Any.newBuilder();
        builder.setType(PolarxDatatypes.Any.Type.SCALAR);
        builder.setScalar(scalar);
        return builder.build();
    }

    public static PolarxDatatypes.Any genAny(PolarxDatatypes.Array array) {
        PolarxDatatypes.Any.Builder builder = PolarxDatatypes.Any.newBuilder();
        builder.setType(PolarxDatatypes.Any.Type.ARRAY);
        builder.setArray(array);
        return builder.build();
    }
}

