/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.client;

import com.alibaba.polardbx.common.eventlogger.EventLogger;
import com.alibaba.polardbx.common.eventlogger.EventType;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.properties.DynamicConfig;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.common.utils.Pair;
import com.alibaba.polardbx.common.utils.encrypt.SecurityUtil;
import com.alibaba.polardbx.common.utils.logger.MDC;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.net.NIOClient;
import com.alibaba.polardbx.rpc.net.NIOProcessor;
import com.alibaba.polardbx.rpc.net.NIOWorker;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.perf.SessionPerfItem;
import com.alibaba.polardbx.rpc.perf.TcpPerfCollection;
import com.alibaba.polardbx.rpc.perf.TcpPerfItem;
import com.alibaba.polardbx.rpc.pool.XClientPool;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import com.alibaba.polardbx.rpc.result.XResult;
import com.alibaba.polardbx.rpc.result.XResultUtil;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxConnection;
import com.mysql.cj.polarx.protobuf.PolarxNotice;
import com.mysql.cj.polarx.protobuf.PolarxSession;
import com.mysql.cj.x.protobuf.Polarx;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public class XClient
implements AutoCloseable {
    private static final String AUTH_OK_MARK = "Auth ok.";
    private final XClientPool pool;
    private final NIOWorker nioWorker;
    private final NIOClient nioClient;
    private final long connectTimeoutNanos;
    private final Map<Long, XSession> workingSessionMap = new ConcurrentHashMap<Long, XSession>();
    private final AtomicLong lastPacketNanos = new AtomicLong(0L);
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final long createNanos = System.nanoTime();
    private final long randomDelay = ThreadLocalRandom.current().nextLong(600000000000L);
    private final AtomicBoolean reusable = new AtomicBoolean(true);
    private final AtomicReference<Throwable> fatalError = new AtomicReference<Object>(null);
    private final AtomicReference<String> authMessage = new AtomicReference<Object>(null);
    private long authClientId = -1L;
    private volatile Map<String, Object> sessionVariablesL = null;
    private volatile Map<String, Object> globalVariablesL = null;
    private long lastVariablesNanos = 0L;
    private final TcpPerfCollection perfCollection = new TcpPerfCollection();
    private volatile ClientState state = ClientState.Initializing;
    private final AtomicInteger probeFailTimes = new AtomicInteger(0);
    private final AtomicBoolean probeEvent = new AtomicBoolean(false);
    private DnBaseVersion baseVersion = null;
    private String majorVersion = null;
    private String minorVersion = null;

    public XClient(NIOWorker nioWorker, XClientPool pool, BiFunction<XClient, XPacket, Boolean> filter, long connectTimeoutNanos) {
        this.pool = pool;
        this.nioWorker = nioWorker;
        this.nioClient = new NIOClient(msgs -> {
            boolean logEnabled = XLog.XProtocolLogger.isInfoEnabled();
            Map savedMdcContext = logEnabled ? MDC.getCopyOfContextMap() : null;
            try {
                long nowNanos = System.nanoTime();
                this.lastPacketNanos.set(nowNanos);
                XSession lastSession = null;
                ArrayList<XPacket> packets = null;
                block28: for (XPacket msg : msgs) {
                    if (filter != null && !((Boolean)filter.apply(this, msg)).booleanValue()) {
                        return;
                    }
                    long sessionId = msg.getSid();
                    if (0L == sessionId || XConfig.GALAXY_X_PROTOCOL && ClientState.Authing == this.state && 1L == sessionId) {
                        if (logEnabled) {
                            this.logPacket(msg, false, false);
                        }
                        block10 : switch (msg.getType()) {
                            case 2: {
                                AtomicBoolean atomicBoolean = this.probeEvent;
                                synchronized (atomicBoolean) {
                                    this.probeEvent.set(true);
                                    this.probeEvent.notify();
                                    break;
                                }
                            }
                            case 3: {
                                this.scramble(sessionId, ((PolarxSession.AuthenticateContinue)msg.getPacket()).getAuthData());
                                break;
                            }
                            case 4: {
                                PolarxSession.AuthenticateOk authenticateOk = (PolarxSession.AuthenticateOk)msg.getPacket();
                                String authData = authenticateOk.hasAuthData() ? authenticateOk.getAuthData().toStringUtf8() : "";
                                XLog.XLogLogger.info(this + " auth ok." + (authData.isEmpty() ? "" : " msg: " + authData));
                                AtomicReference<String> atomicReference = this.authMessage;
                                synchronized (atomicReference) {
                                    this.authMessage.set(AUTH_OK_MARK);
                                    this.authMessage.notify();
                                    break;
                                }
                            }
                            case 11: {
                                PolarxNotice.Frame frame = (PolarxNotice.Frame)msg.getPacket();
                                if (3 != frame.getType() || !frame.hasPayload() || frame.getPayload().size() <= 0) break;
                                try {
                                    PolarxNotice.SessionStateChanged sessionStateChanged = PolarxNotice.SessionStateChanged.parseFrom(frame.getPayload());
                                    if (!sessionStateChanged.getParam().equals((Object)PolarxNotice.SessionStateChanged.Parameter.CLIENT_ID_ASSIGNED) || !sessionStateChanged.hasValue()) continue block28;
                                    switch (sessionStateChanged.getValue().getType()) {
                                        case V_SINT: {
                                            this.authClientId = sessionStateChanged.getValue().getVSignedInt();
                                            break block10;
                                        }
                                        case V_UINT: {
                                            this.authClientId = sessionStateChanged.getValue().getVUnsignedInt();
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    XLog.XLogLogger.error((Throwable)e);
                                }
                                break;
                            }
                            case 1: {
                                Polarx.Error error = (Polarx.Error)msg.getPacket();
                                AtomicReference<String> atomicReference = this.authMessage;
                                synchronized (atomicReference) {
                                    this.authMessage.set(error.getMsg());
                                    this.authMessage.notify();
                                }
                                XLog.XLogLogger.error(this + " auth fatal. msg: " + error.getMsg());
                            }
                        }
                        continue;
                    }
                    if (null == lastSession || sessionId != lastSession.getSessionId()) {
                        if (lastSession != null) {
                            lastSession.setLastPacketNanos(nowNanos);
                            lastSession.pushPackets(packets);
                        }
                        if (null == (lastSession = this.workingSessionMap.get(sessionId))) continue;
                        packets = new ArrayList<XPacket>(16);
                        if (logEnabled) {
                            lastSession.applyThreadContext();
                            this.logPacket(msg, false, false);
                        }
                        packets.add(msg);
                        continue;
                    }
                    if (logEnabled) {
                        this.logPacket(msg, false, false);
                    }
                    packets.add(msg);
                }
                if (lastSession != null) {
                    lastSession.setLastPacketNanos(nowNanos);
                    lastSession.pushPackets(packets);
                }
            }
            catch (Throwable e) {
                XLog.XLogLogger.error(e);
                this.setFatalError(e);
            }
            finally {
                if (logEnabled) {
                    MDC.setContextMap((Map)savedMdcContext);
                }
            }
        }, this::setFatalError, this);
        this.connectTimeoutNanos = connectTimeoutNanos;
    }

    public XClientPool getPool() {
        return this.pool;
    }

    public int getWorkingSessionCount() {
        return this.workingSessionMap.size();
    }

    public Map<Long, XSession> getWorkingSessionMap() {
        return this.workingSessionMap;
    }

    public Throwable getFatalError() {
        return this.fatalError.get();
    }

    public void setFatalError(Throwable fatalError) {
        this.fatalError.set(fatalError);
        if (fatalError != null) {
            for (XSession session : this.workingSessionMap.values()) {
                session.pushFatal(new XPacket(-1L, 1, Polarx.Error.newBuilder().setSeverity(Polarx.Error.Severity.FATAL).setCode(-1).setSqlState(this + " fatal.").setMsg(fatalError.getMessage()).build()));
            }
        }
        this.close();
    }

    public TcpPerfCollection getPerfCollection() {
        return this.perfCollection;
    }

    public String getTcpTag() {
        String tag = this.nioClient.getTag();
        return null == tag ? "<unestablished>" : tag;
    }

    public TcpPerfItem getPerfItem() {
        TcpPerfItem item = new TcpPerfItem();
        item.setTcpTag(this.getTcpTag());
        item.setDnTag(this.pool.getDnTag());
        item.setSendMsgCount(this.perfCollection.getSendMsgCount().get());
        item.setSendFlushCount(this.perfCollection.getSendFlushCount().get());
        item.setSendSize(this.perfCollection.getSendSize().get());
        item.setRecvMsgCount(this.perfCollection.getRecvMsgCount().get());
        item.setRecvNetCount(this.perfCollection.getRecvNetCount().get());
        item.setRecvSize(this.perfCollection.getRecvSize().get());
        item.setSessionCreateCount(this.perfCollection.getSessionCreateCount().get());
        item.setSessionDropCount(this.perfCollection.getSessionDropCount().get());
        item.setSessionCreateSuccessCount(this.perfCollection.getSessionCreateSuccessCount().get());
        item.setSessionCreateFailCount(this.perfCollection.getSessionCreateFailCount().get());
        item.setSessionActiveCount(this.perfCollection.getSessionActiveCount().get());
        item.setSessionCount(this.workingSessionMap.size());
        long nowNanos = System.nanoTime();
        item.setClientState(this.state);
        long lastPkg = this.lastPacketNanos.get();
        item.setIdleNanosSinceLastPacket(0L == lastPkg ? 0L : nowNanos - lastPkg);
        item.setLiveNanos(nowNanos - this.createNanos);
        Throwable t = this.fatalError.get();
        item.setFatalError(null == t ? null : t.getMessage());
        item.setAuthId(this.authClientId);
        long lastVar = this.lastVariablesNanos;
        if (0L == lastVar || this.createNanos - lastVar > 0L) {
            lastVar = this.createNanos;
        }
        item.setNanosSinceLastVariablesFlush(nowNanos - lastVar);
        this.nioClient.fillTcpPhysicalInfo(item);
        return item;
    }

    public void gatherSessionPerf(List<SessionPerfItem> list) {
        XSession[] sessions;
        for (XSession session : sessions = this.workingSessionMap.values().toArray(new XSession[0])) {
            list.add(session.getPerfItem());
        }
    }

    @Override
    public void close() {
        this.nioClient.close();
    }

    private void scramble(long sessionId, ByteString challenge) throws Exception {
        String encoding = "UTF8";
        byte[] userBytes = this.pool.getUsername() == null ? new byte[]{} : this.pool.getUsername().getBytes("UTF8");
        byte[] passwordBytes = this.pool.getPassword() == null || this.pool.getPassword().length() == 0 ? new byte[]{} : this.pool.getPassword().getBytes("UTF8");
        byte[] databaseBytes = new byte[]{};
        byte[] hashedPassword = passwordBytes;
        if (this.pool.getPassword() != null && this.pool.getPassword().length() > 0) {
            hashedPassword = SecurityUtil.scramble411((byte[])passwordBytes, (byte[])challenge.toByteArray());
            hashedPassword = String.format("*%040x", new BigInteger(1, hashedPassword)).getBytes();
        }
        byte[] reply = new byte[databaseBytes.length + userBytes.length + hashedPassword.length + 2];
        System.arraycopy(databaseBytes, 0, reply, 0, databaseBytes.length);
        int pos = databaseBytes.length;
        reply[pos++] = 0;
        System.arraycopy(userBytes, 0, reply, pos, userBytes.length);
        pos += userBytes.length;
        reply[pos++] = 0;
        System.arraycopy(hashedPassword, 0, reply, pos, hashedPassword.length);
        PolarxSession.AuthenticateContinue.Builder builder = PolarxSession.AuthenticateContinue.newBuilder();
        builder.setAuthData(ByteString.copyFrom((byte[])reply));
        XPacket packet = new XPacket(sessionId, 5, builder.build());
        this.send(packet, true);
    }

    private void logPacket(XPacket packet, boolean send, boolean flush) {
        StringBuilder builder = new StringBuilder();
        builder.append('\n').append("{ ").append(this.toString()).append(" ").append(send ? "send" : "recv").append(flush ? " flush" : "").append('\n');
        builder.append("sid: ").append(packet.getSid()).append(" type: ").append(packet.getType()).append('\n').append(packet.getPacket());
        try {
            if (packet.getType() == 11) {
                PolarxNotice.Frame frame = (PolarxNotice.Frame)packet.getPacket();
                switch (frame.getType()) {
                    case 1: {
                        builder.append(PolarxNotice.Warning.parseFrom(frame.getPayload()));
                        break;
                    }
                    case 2: {
                        builder.append(PolarxNotice.SessionVariableChanged.parseFrom(frame.getPayload()));
                        break;
                    }
                    case 3: {
                        builder.append(PolarxNotice.SessionStateChanged.parseFrom(frame.getPayload()));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        builder.append('}');
        XLog.XProtocolLogger.info(builder.toString().replace('\n', ' '));
    }

    public boolean reuseSession(XSession session) {
        return this.pool.reuseSession(session);
    }

    public void dropSession(XSession session) {
        XSession freed = this.workingSessionMap.remove(session.getSessionId());
        if (freed != null) {
            this.perfCollection.getSessionDropCount().getAndIncrement();
            this.pool.getPerfCollection().getSessionDropCount().getAndIncrement();
            freed.close();
        }
    }

    public XSession newXSession(AtomicLong sessionIdGenerator, boolean autoCommit) {
        XSession session = new XSession(this, sessionIdGenerator.getAndIncrement() | (autoCommit && XConnectionManager.getInstance().isEnableAutoCommitOptimize() ? Long.MIN_VALUE : 0L), autoCommit && XConnectionManager.getInstance().isEnableAutoCommitOptimize() ? XSession.Status.AutoCommit : XSession.Status.Init);
        try {
            if (XLog.XProtocolLogger.isInfoEnabled()) {
                session.recordThreadContext();
            }
            XSession previous = this.workingSessionMap.put(session.getSessionId(), session);
            this.perfCollection.getSessionCreateCount().getAndIncrement();
            this.pool.getPerfCollection().getSessionCreateCount().getAndIncrement();
            assert (null == previous);
            XLog.XLogLogger.info("New session: " + session);
            return session;
        }
        catch (Throwable e) {
            XSession removed = this.workingSessionMap.remove(session.getSessionId());
            if (removed != null) {
                this.perfCollection.getSessionDropCount().getAndIncrement();
                this.pool.getPerfCollection().getSessionDropCount().getAndIncrement();
            }
            session.close();
            XLog.XLogLogger.error(e);
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " create XSession error: " + e.getMessage()});
        }
    }

    public XConnection newXConnection(AtomicLong sessionIdGenerator) {
        return this.newXConnection(sessionIdGenerator, false);
    }

    public XConnection newXConnection(AtomicLong sessionIdGenerator, boolean autoCommit) {
        XSession session = this.newXSession(sessionIdGenerator, autoCommit);
        try {
            return new XConnection(session);
        }
        catch (Throwable e) {
            XSession removed = this.workingSessionMap.remove(session.getSessionId());
            if (removed != null) {
                this.perfCollection.getSessionDropCount().getAndIncrement();
                this.pool.getPerfCollection().getSessionDropCount().getAndIncrement();
            }
            session.close();
            XLog.XLogLogger.error(e);
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " create XConnection error: " + e.getMessage()});
        }
    }

    public void send(XPacket packet, boolean flush) {
        if (XLog.XProtocolLogger.isInfoEnabled()) {
            this.logPacket(packet, true, flush);
        }
        try {
            this.nioClient.write(packet, flush);
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
    }

    public void flush() {
        this.nioClient.flush();
    }

    public void shrinkBuffer() {
        this.nioClient.shrinkBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitChannel() {
        boolean done = false;
        try {
            this.state = ClientState.Connecting;
            long startTime = System.currentTimeMillis();
            this.nioClient.connect(new InetSocketAddress(this.pool.getHost(), this.pool.getPort()), (int)(this.connectTimeoutNanos / 1000000L));
            this.state = ClientState.Registering;
            NIOProcessor processor = this.nioWorker.getProcessor();
            this.nioClient.setProcessor(processor);
            processor.postRegister(this.nioClient);
            long waitTime = System.currentTimeMillis();
            while (!this.nioClient.isValid()) {
                long now = System.currentTimeMillis();
                if (now > startTime + this.connectTimeoutNanos / 1000000L && now > waitTime + 1000L) {
                    XLog.XLogLogger.error(this + " connect wait valid timeout, " + this.connectTimeoutNanos + "ns.");
                    boolean bl = false;
                    return bl;
                }
                Thread.yield();
            }
            this.state = ClientState.Connected;
            done = true;
        }
        catch (Throwable e) {
            XLog.XLogLogger.error(e);
        }
        finally {
            this.connected.set(done);
        }
        return done;
    }

    private void authStart(long sessionId) {
        PolarxSession.AuthenticateStart.Builder builder = PolarxSession.AuthenticateStart.newBuilder();
        builder.setMechName("MYSQL41");
        XPacket packet = new XPacket(sessionId, 4, builder.build());
        this.send(packet, true);
    }

    public void refreshVariables(AtomicLong sessionIdGenerator, long timeoutNanos) throws Exception {
        Pair<Object, byte[]> val;
        String key;
        XResult result;
        if (this.sessionVariablesL != null && this.globalVariablesL != null && this.lastVariablesNanos != 0L && System.nanoTime() - this.lastVariablesNanos < XConnectionManager.getInstance().getSessionAgingNanos()) {
            return;
        }
        this.lastVariablesNanos = 0L == this.lastVariablesNanos ? System.nanoTime() - ThreadLocalRandom.current().nextLong(XConnectionManager.getInstance().getSessionAgingNanos()) : System.nanoTime();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        try (XConnection connection = this.newXConnection(sessionIdGenerator, XConnectionManager.getInstance().isEnableAutoCommitOptimize());){
            connection.setNetworkTimeoutNanos(timeoutNanos);
            connection.init(timeoutNanos);
            result = connection.execQuery("show variables");
            while (result.next() != null) {
                key = (String)XResultUtil.resultToObject(result.getMetaData().get(0), result.current().getRow().get(0), true, TimeZone.getDefault()).getKey();
                val = XResultUtil.resultToObject(result.getMetaData().get(1), result.current().getRow().get(1), true, TimeZone.getDefault());
                variables.put(key.toLowerCase(), val.getKey());
            }
        }
        this.sessionVariablesL = Collections.unmodifiableMap(variables);
        variables = new HashMap();
        connection = this.newXConnection(sessionIdGenerator, XConnectionManager.getInstance().isEnableAutoCommitOptimize());
        try {
            connection.setNetworkTimeoutNanos(timeoutNanos);
            connection.init(timeoutNanos);
            result = connection.execQuery("show global variables");
            while (result.next() != null) {
                key = (String)XResultUtil.resultToObject(result.getMetaData().get(0), result.current().getRow().get(0), true, TimeZone.getDefault()).getKey();
                val = XResultUtil.resultToObject(result.getMetaData().get(1), result.current().getRow().get(1), true, TimeZone.getDefault());
                variables.put(key.toLowerCase(), val.getKey());
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        this.globalVariablesL = Collections.unmodifiableMap(variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initClient(AtomicLong sessionIdGenerator, long timeoutNanos) throws Exception {
        Object val;
        if (XConnectionManager.getInstance().isEnableAuth()) {
            this.state = ClientState.Authing;
            this.authStart(0L);
            AtomicReference<String> atomicReference = this.authMessage;
            synchronized (atomicReference) {
                this.authMessage.wait(timeoutNanos / 1000000L);
            }
            String authResult = this.authMessage.get();
            if (null == authResult) {
                EventLogger.log((EventType)EventType.XRPC_AUTH_TIMEOUT, (String)("Auth timeout " + this));
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " auth timeout. " + timeoutNanos + "ns"});
            }
            if (!authResult.equals(AUTH_OK_MARK)) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{authResult});
            }
            this.state = ClientState.Authed;
        }
        this.state = ClientState.LoadVariables;
        this.refreshVariables(sessionIdGenerator, timeoutNanos);
        this.state = ClientState.Ready;
        boolean xrpc = this.globalVariablesL != null ? (val = this.globalVariablesL.get("new_rpc")) instanceof String && ((String)val).equalsIgnoreCase("ON") : false;
        String instId = XConnectionManager.getInstance().getInstId().get();
        EventLogger.log((EventType)EventType.XRPC_NEW_VALID_CLIENT, (String)("New authed " + this + " @@ " + String.join((CharSequence)",", this.pool.getInstInfo()) + " @@ " + (null == instId ? "unknown" : instId) + " @@ " + (xrpc ? "XRPC" : "XPROTO")));
        XLog.XLogLogger.info("New client: " + this);
    }

    public Map<String, Object> getGlobalVariablesL() {
        return this.globalVariablesL;
    }

    public Map<String, Object> getSessionVariablesL() {
        return this.sessionVariablesL;
    }

    public void decodeVersion() {
        String version = (String)this.globalVariablesL.get("version");
        String xdbMark = "X-Cluster";
        String polardb80Mark = "polardb-3az";
        try {
            int idx = version.indexOf("X-Cluster");
            int idx2 = version.indexOf("polardb-3az");
            if (idx != -1) {
                int midIdx = version.indexOf(45, idx + "X-Cluster".length() + 1);
                int lastIdx = midIdx != -1 ? version.indexOf(45, midIdx + 1) : -1;
                this.baseVersion = version.startsWith("5.7.") ? DnBaseVersion.DN_X_CLUSTER : DnBaseVersion.DN_RDS_80_X_CLUSTER;
                this.majorVersion = midIdx != -1 ? version.substring(idx + "X-Cluster".length() + 1, midIdx) : version.substring(idx + "X-Cluster".length() + 1);
                this.minorVersion = lastIdx != -1 ? version.substring(midIdx + 1, lastIdx) : version.substring(midIdx + 1);
            } else if (idx2 != -1) {
                int midIdx = version.indexOf(45, idx2 + "polardb-3az".length() + 1);
                int lastIdx = midIdx != -1 ? version.indexOf(45, midIdx + 1) : -1;
                this.baseVersion = DnBaseVersion.DN_POLAR_DB_80_3AZ;
                this.majorVersion = midIdx != -1 ? version.substring(idx2 + "polardb-3az".length() + 1, midIdx) : version.substring(idx2 + "polardb-3az".length() + 1);
                this.minorVersion = lastIdx != -1 ? version.substring(midIdx + 1, lastIdx) : version.substring(midIdx + 1);
            } else {
                this.baseVersion = DnBaseVersion.DN_UNKNOWN;
                this.minorVersion = "unknown";
                this.majorVersion = "unknown";
            }
            XLog.XLogLogger.info(this + " get " + this.baseVersion.name() + " version: " + this.majorVersion + " " + this.minorVersion);
        }
        catch (Throwable t) {
            this.baseVersion = DnBaseVersion.DN_UNKNOWN;
            this.minorVersion = "unknown";
            this.majorVersion = "unknown";
            XLog.XLogLogger.error(this + " get version error: " + version);
            XLog.XLogLogger.error(t);
        }
    }

    public DnBaseVersion getBaseVersion() {
        if (this.baseVersion != null) {
            return this.baseVersion;
        }
        this.decodeVersion();
        return this.baseVersion;
    }

    public String getMajorVersion() {
        if (this.majorVersion != null) {
            return this.majorVersion;
        }
        this.decodeVersion();
        return this.majorVersion;
    }

    public String getMinorVersion() {
        if (this.minorVersion != null) {
            return this.minorVersion;
        }
        this.decodeVersion();
        return this.minorVersion;
    }

    public boolean isOld() {
        return System.nanoTime() - this.createNanos - this.randomDelay > (long)DynamicConfig.getInstance().getXprotoTcpAging() * 1000000000L;
    }

    public void markNotReusable() {
        this.reusable.set(false);
    }

    public boolean reusable() {
        return this.reusable.get();
    }

    public boolean isActive() {
        return null == this.getFatalError() && this.connected.get() && this.sessionVariablesL != null && this.globalVariablesL != null;
    }

    public boolean isBad() {
        return this.getFatalError() != null;
    }

    public boolean needProb() {
        boolean b;
        boolean bl = b = this.connected.get() && this.sessionVariablesL != null && this.globalVariablesL != null && this.nioClient.idleTime() > 10000000000L;
        if (!b) {
            this.probeFailTimes.set(0);
        }
        return b;
    }

    private void capabilitiesGet(long sessionId) {
        PolarxConnection.CapabilitiesGet.Builder builder = PolarxConnection.CapabilitiesGet.newBuilder();
        XPacket packet = new XPacket(sessionId, 1, builder.build());
        this.send(packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean probe(AtomicLong sessionIdGenerator, long timeoutNanos) {
        if (XConfig.GALAXY_X_PROTOCOL) {
            try (XConnection connection = this.newXConnection(sessionIdGenerator, XConnectionManager.getInstance().isEnableAutoCommitOptimize());){
                connection.init(timeoutNanos);
                connection.setNetworkTimeoutNanos(timeoutNanos);
                connection.init(timeoutNanos);
                XResult result = connection.execQuery("/*X probe*/ select 1");
                long count = 0L;
                while (result.next() != null) {
                    Number res = (Number)XResultUtil.resultToObject(result.getMetaData().get(0), result.current().getRow().get(0), true, TimeZone.getDefault()).getKey();
                    count += res.longValue();
                }
                if (1L == count) {
                    this.probeFailTimes.set(0);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable t) {
                XLog.XLogLogger.error(t);
            }
        } else {
            try {
                this.probeEvent.set(false);
                this.capabilitiesGet(0L);
                AtomicBoolean t = this.probeEvent;
                synchronized (t) {
                    if (!this.probeEvent.get()) {
                        this.probeEvent.wait(timeoutNanos / 1000000L);
                    }
                }
                if (this.probeEvent.get()) {
                    this.probeFailTimes.set(0);
                    return true;
                }
            }
            catch (Throwable t) {
                XLog.XLogLogger.error(t);
            }
        }
        int failTimes = this.probeFailTimes.addAndGet(1);
        XLog.XLogLogger.warn(this + " probe fail times: " + failTimes + " idle: " + this.nioClient.idleTime() + "ns");
        return failTimes < 5;
    }

    public String toString() {
        return "XClient of " + this.nioClient + " to " + this.pool.getDnTag();
    }

    public static enum DnBaseVersion {
        DN_UNKNOWN,
        DN_X_CLUSTER,
        DN_POLAR_DB_80_3AZ,
        DN_RDS_80_X_CLUSTER;

    }

    public static enum ClientState {
        Unknown,
        Initializing,
        Connecting,
        Registering,
        Connected,
        Authing,
        Authed,
        LoadVariables,
        Ready;

    }
}

