/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.client;

import com.alibaba.polardbx.common.constants.ServerVariables;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.common.utils.TStringUtil;
import com.alibaba.polardbx.common.utils.logger.Logger;
import com.alibaba.polardbx.common.utils.logger.LoggerFactory;
import com.alibaba.polardbx.common.utils.logger.MDC;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPTable;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.XUtil;
import com.alibaba.polardbx.rpc.client.XClient;
import com.alibaba.polardbx.rpc.compatible.XDataSource;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.packet.XPacketBuilder;
import com.alibaba.polardbx.rpc.packet.XPacketQueue;
import com.alibaba.polardbx.rpc.perf.SessionPerfCollection;
import com.alibaba.polardbx.rpc.perf.SessionPerfItem;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import com.alibaba.polardbx.rpc.result.XResult;
import com.alibaba.polardbx.rpc.result.XResultUtil;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.mysql.cj.polarx.protobuf.PolarxExpect;
import com.mysql.cj.polarx.protobuf.PolarxPhysicalBackfill;
import com.mysql.cj.polarx.protobuf.PolarxSession;
import com.mysql.cj.polarx.protobuf.PolarxSql;
import com.mysql.cj.x.protobuf.Polarx;
import com.mysql.cj.x.protobuf.PolarxDatatypes;
import com.mysql.cj.x.protobuf.PolarxExecPlan;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class XSession
implements Comparable<XSession>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSession.class);
    public static final AtomicInteger GLOBAL_COUNTER = new AtomicInteger(0);
    public static final ByteString EXPLAIN_PRE = ByteString.copyFromUtf8((String)"explain ");
    private static final Exception CANCEL_EXCEPTION = new Exception("Query was canceled.");
    private static final Exception KILL_EXCEPTION = new Exception("Session was killed.");
    private final XClient client;
    private final long sessionId;
    private final long createNanos = System.nanoTime();
    private final long randomDelay = ThreadLocalRandom.current().nextLong(60000000000L);
    private volatile long lastPacketNanos = 0L;
    private final Object statusLock = new Object();
    private volatile Status status;
    private volatile Map mdcContext = null;
    private final XPacketQueue packetQueue = new XPacketQueue();
    private final AtomicReference<XResult> lastUserRequest = new AtomicReference<Object>(null);
    private final AtomicReference<XResult> lastRequest = new AtomicReference<Object>(null);
    private final AtomicReference<Throwable> lastException = new AtomicReference<Object>(null);
    private boolean lastIgnore = false;
    private String lastDB = null;
    private String lazyUseDB = null;
    private boolean lazyUseCtsTransaction = false;
    private boolean lazyMarkDistributed = false;
    private long lazySnapshotSeq = -1L;
    private long lazyCommitSeq = -1L;
    private boolean noCache = false;
    private boolean forceCache = false;
    private boolean chunkResult = false;
    private AtomicLong activeRequest = new AtomicLong(0L);
    private boolean returning = false;
    private List<String> historySql = new ArrayList<String>();
    private List<String> sessionSql = new ArrayList<String>();
    private String xaStatus = null;
    private boolean transactionStatus = false;
    private StackTraceElement[] stackTraceElements = null;
    private final SessionPerfCollection perfCollection = new SessionPerfCollection();
    private boolean autoCommit = true;
    private String characterSetClient = null;
    private String characterSetResults = null;
    private TimeZone timeZone = null;
    private SimpleDateFormat timeFormatter = null;
    private Integer isolation = null;
    private static final String[] protectedVariables = new String[]{"character_set_client", "character_set_connection", "character_set_results", "transaction_isolation", "tx_isolation", "autocommit"};
    private static final String[] encodingVariables = new String[]{"character_set_client", "character_set_connection", "character_set_results"};
    private static final String isolationVariable = "transaction_isolation";
    private Map<String, Object> sessionVariables = null;
    private Map<String, Object> globalVariables = null;
    private final Map<String, Object> sessionVariablesChanged = new HashMap<String, Object>();
    private String defaultEncodingMySQL = null;
    private boolean isStashed = false;
    private boolean stashUseCtsTransaction = false;
    private boolean stashMarkDistributed = false;
    private long stashSnapshotSeq = -1L;
    private long stashCommitSeq = -1L;
    private volatile long connectionId = -1L;
    private Boolean flagMessageTimestamp = null;
    private Boolean flagQueryCache = null;
    private Boolean flagQueryChunk = null;
    private Boolean flagSingleShardOptimization = null;
    private Boolean flagFeedback = null;
    private Boolean flagRawString = null;
    private Boolean flagXRPC = null;
    private Boolean flagMarkDistributed = null;

    public void recordStack() {
        this.stackTraceElements = Thread.currentThread().getStackTrace();
    }

    public XSession(XClient client, long sessionId, Status status) {
        this.client = client;
        this.sessionId = sessionId;
        this.status = status;
        if (Status.AutoCommit == status && 0L == sessionId >>> 63 || status != Status.AutoCommit && sessionId >>> 63 != 0L) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{this + " incorrect session id of " + status.name() + " session."});
        }
    }

    private void addActive() {
        long before = this.activeRequest.getAndIncrement();
        if (0L == before) {
            this.client.getPerfCollection().getSessionActiveCount().getAndIncrement();
            this.client.getPool().getPerfCollection().getSessionActiveCount().getAndIncrement();
        }
    }

    public void subActive() {
        long before;
        while ((before = this.activeRequest.get()) > 0L) {
            if (!this.activeRequest.compareAndSet(before, before - 1L)) continue;
            if (1L != before) break;
            this.client.getPerfCollection().getSessionActiveCount().getAndDecrement();
            this.client.getPool().getPerfCollection().getSessionActiveCount().getAndDecrement();
            break;
        }
    }

    private void freeAllActive() {
        long before;
        while ((before = this.activeRequest.get()) > 0L) {
            if (!this.activeRequest.compareAndSet(before, 0L)) continue;
            this.client.getPerfCollection().getSessionActiveCount().getAndDecrement();
            this.client.getPool().getPerfCollection().getSessionActiveCount().getAndDecrement();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Status nowStatus;
        this.freeAllActive();
        Object object = this.statusLock;
        synchronized (object) {
            nowStatus = this.status;
            if (Status.Closed == nowStatus) {
                XLog.XLogLogger.error(this + " close at error status.");
                return;
            }
            if (Status.AutoCommit == nowStatus) {
                return;
            }
        }
        if (nowStatus != Status.Init) {
            boolean needClose;
            Object object2 = this.statusLock;
            synchronized (object2) {
                boolean bl = needClose = this.status != Status.Closed;
                if (needClose) {
                    this.status = Status.Closed;
                }
            }
            if (needClose) {
                GLOBAL_COUNTER.getAndDecrement();
                if (!this.isXRPC()) {
                    XPacket packet = new XPacket(this.sessionId, 111, PolarxSession.KillSession.newBuilder().setType(PolarxSession.KillSession.KillType.CONNECTION).setXSessionId(this.sessionId).build());
                    this.client.send(packet, false);
                }
                PolarxSession.Close.Builder builder = PolarxSession.Close.newBuilder();
                XPacket packet = new XPacket(this.sessionId, 7, builder.build());
                this.client.send(packet, true);
                this.pushEOF();
            }
        }
    }

    public XClient getClient() {
        return this.client;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getLastPacketNanos() {
        return this.lastPacketNanos;
    }

    public void setLastPacketNanos(long lastPacketNanos) {
        this.lastPacketNanos = lastPacketNanos;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public void recordThreadContext() {
        this.mdcContext = MDC.getCopyOfContextMap();
    }

    public void clearThreadContext() {
        this.mdcContext = null;
    }

    public void applyThreadContext() {
        Map nowMdcContext = this.mdcContext;
        if (nowMdcContext != null) {
            MDC.setContextMap((Map)nowMdcContext);
        }
    }

    public XResult getLastUserRequest() {
        return this.lastUserRequest.get();
    }

    public XResult getLastRequest() {
        return this.lastRequest.get();
    }

    public Throwable getLastException() {
        return this.lastException.get();
    }

    public Throwable setLastException(Throwable lastException, boolean forceReplace) {
        if (lastException != null && forceReplace) {
            this.lastException.set(lastException);
        } else {
            this.lastException.compareAndSet(null, lastException);
        }
        return lastException;
    }

    public boolean resetExceptionFromCancel() {
        Throwable throwable = this.lastException.get();
        if (throwable == CANCEL_EXCEPTION) {
            return this.lastException.compareAndSet(throwable, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionPerfItem getPerfItem() {
        String isolationString;
        SessionPerfItem item = new SessionPerfItem();
        item.setDnTag(this.client.getPool().getDnTag());
        item.setTcpTag(this.client.getTcpTag());
        item.setSessionId(this.sessionId);
        item.setStatus(this.status);
        item.setPlanCount(this.perfCollection.getPlanCount().get());
        item.setQueryCount(this.perfCollection.getQueryCount().get());
        item.setUpdateCount(this.perfCollection.getUpdateCount().get());
        item.setTsoCount(this.perfCollection.getTsoCount().get());
        long nowNanos = System.nanoTime();
        item.setLiveNanos(nowNanos - this.createNanos);
        item.setIdleNanosSinceLastPacket(nowNanos - this.lastPacketNanos);
        item.setCharsetClient(this.getRequestEncodingMySQL());
        item.setCharsetResult(this.getResultMetaEncodingMySQL());
        item.setTimezone(this.getDefaultTimezone().getDisplayName());
        int isolation = this.getIsolation();
        switch (isolation) {
            case 0: {
                isolationString = "NONE";
                break;
            }
            case 1: {
                isolationString = "RU";
                break;
            }
            case 2: {
                isolationString = "RC";
                break;
            }
            case 4: {
                isolationString = "RR";
                break;
            }
            case 8: {
                isolationString = "S";
                break;
            }
            default: {
                isolationString = "UNKNOWN";
            }
        }
        item.setIsolation(isolationString);
        item.setAutoCommit(this.isAutoCommit());
        StringBuilder builder = new StringBuilder();
        XSession xSession = this;
        synchronized (xSession) {
            boolean first = true;
            for (Map.Entry<String, Object> entry : this.sessionVariablesChanged.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            item.setLastRequestDB(this.lastDB);
        }
        item.setVariablesChanged(builder.toString());
        XResult request = this.lastRequest.get();
        if (request != null) {
            item.setQueuedRequestDepth(request.getQueuedDepth());
            StringBuilder sql = new StringBuilder(null == request.getSql() ? "" : request.getSql().display());
            XResult prob = request;
            while ((prob = prob.getPrevious()) != null) {
                sql.insert(0, null == prob.getSql() ? ";" : prob.getSql() + ";");
            }
            item.setLastRequestTraceId(request.getConnection().getTraceId());
            item.setLastRequestSql(sql.toString());
            item.setLastRequestExtra(request.getExtra());
            item.setLastRequestType(request.getRequestType().toString());
            item.setLastRequestStatus(request.getStatus().toString());
            item.setLastRequestFetchCount(request.getFetchCount());
            item.setLastRequestTokenSize(request.getTokenSize());
            item.setLastRequestWorkingNanos(nowNanos - request.getStartNanos());
            item.setLastRequestDataPktResponseNanos(request.getPktResponseNanos());
            item.setLastRequestResponseNanos(request.getResponseNanos());
            item.setLastRequestFinishNanos(request.getFinishNanos());
            item.setLastRequestTokenDoneCount(request.getTokenDoneCount());
            item.setLastRequestActiveOfferTokenCount(request.getActiveOfferTokenCount());
            item.setLastRequestStartMillis(request.getStartMillis());
            item.setLastRequestResultChunk(request.isResultChunk());
            item.setLastRequestRetrans(request.isRetrans());
            item.setLastRequestGoCache(request.isGoCache());
        }
        return item;
    }

    public synchronized boolean isAutoCommit() {
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAutoCommit(XConnection connection, boolean enableAutoCommit) throws SQLException {
        block7: {
            boolean needSet;
            boolean bl = needSet = enableAutoCommit != this.autoCommit;
            if (needSet) {
                this.autoCommit = enableAutoCommit;
            }
            try {
                if (!needSet) break block7;
                boolean isStashed = this.stashTransactionSequence();
                try {
                    this.execUpdate(connection, BytesSql.getBytesSql((String)(enableAutoCommit ? "SET autocommit=1" : "SET autocommit=0")), null, null, true, null);
                }
                finally {
                    if (isStashed) {
                        this.stashPopTransactionSequence();
                    }
                }
            }
            catch (Throwable e) {
                throw GeneralUtil.nestedException((Throwable)this.setLastException(e, true));
            }
        }
    }

    private void traceCtsInfo() {
        if (this.lazyUseCtsTransaction) {
            this.historySql.add("msg_use_cts_transaction=ON");
            this.sessionSql.add("msg_use_cts_transaction=ON");
        }
        if (this.lazySnapshotSeq != -1L) {
            this.historySql.add("msg_snapshot_seq=" + this.lazySnapshotSeq);
            this.sessionSql.add("msg_snapshot_seq=" + this.lazySnapshotSeq);
        }
        if (this.lazyCommitSeq != -1L) {
            this.historySql.add("msg_commit_seq=" + this.lazyCommitSeq);
            this.sessionSql.add("msg_commit_seq=" + this.lazyCommitSeq);
        }
        if (this.lazyMarkDistributed) {
            this.historySql.add("msg_mark_distributed=ON");
            this.sessionSql.add("msg_mark_distributed=ON");
        }
    }

    public static String toJavaEncoding(String encoding) {
        if (encoding.startsWith("utf8mb")) {
            return "utf8";
        }
        if (encoding.equalsIgnoreCase("binary")) {
            return "iso_8859_1";
        }
        return encoding;
    }

    public synchronized String getRequestEncodingMySQL() {
        if (this.defaultEncodingMySQL != null) {
            return this.defaultEncodingMySQL;
        }
        if (null == this.characterSetClient) {
            Map<String, Object> variables;
            Map<String, Object> map = variables = null == this.sessionVariables ? this.client.getGlobalVariablesL() : this.sessionVariables;
            if (null == variables) {
                this.characterSetClient = "utf8";
            } else {
                this.characterSetClient = (String)variables.get("character_set_client");
                if (null == this.characterSetClient) {
                    this.characterSetClient = "utf8";
                }
            }
        }
        return this.characterSetClient;
    }

    public synchronized String getResultMetaEncodingMySQL() {
        if (null == this.characterSetResults) {
            Map<String, Object> variables;
            Map<String, Object> map = variables = null == this.sessionVariables ? this.client.getGlobalVariablesL() : this.sessionVariables;
            if (null == variables) {
                this.characterSetResults = "utf8";
            } else {
                this.characterSetResults = (String)variables.get("character_set_results");
                if (null == this.characterSetResults) {
                    this.characterSetResults = "utf8";
                }
            }
        }
        return this.characterSetResults;
    }

    public synchronized TimeZone getDefaultTimezone() {
        if (null == this.timeZone) {
            Map<String, Object> variables;
            Map<String, Object> map = variables = null == this.sessionVariables ? this.client.getGlobalVariablesL() : this.sessionVariables;
            if (null == variables) {
                this.timeZone = TimeZone.getTimeZone("GMT+08:00");
            } else {
                String nowZone = (String)variables.get("time_zone");
                if (null == nowZone) {
                    this.timeZone = TimeZone.getTimeZone("GMT+08:00");
                } else {
                    if (nowZone.equalsIgnoreCase("SYSTEM")) {
                        nowZone = (String)variables.get("system_time_zone");
                        if (null == nowZone) {
                            nowZone = "GMT+08:00";
                        } else if (nowZone.equalsIgnoreCase("CST")) {
                            nowZone = "GMT+08:00";
                        }
                    } else {
                        String trimmed = nowZone.trim();
                        if (trimmed.length() > 0 && ('+' == trimmed.charAt(0) || '-' == trimmed.charAt(0))) {
                            nowZone = "GMT" + trimmed;
                        } else if (!nowZone.equals(trimmed)) {
                            nowZone = trimmed;
                        }
                    }
                    this.timeZone = TimeZone.getTimeZone(nowZone);
                }
            }
        }
        return this.timeZone;
    }

    public synchronized String formatTime(Date date) {
        if (null == this.timeFormatter) {
            this.timeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.timeFormatter.setTimeZone(this.getDefaultTimezone());
        }
        return this.timeFormatter.format(date);
    }

    public synchronized int getIsolation() {
        if (null == this.isolation) {
            Map<String, Object> variables;
            Map<String, Object> map = variables = null == this.sessionVariables ? this.client.getGlobalVariablesL() : this.sessionVariables;
            if (null == variables) {
                this.isolation = 2;
            } else {
                String isolationString = (String)variables.get(isolationVariable);
                if (null == isolationString) {
                    this.isolation = 2;
                } else {
                    switch (isolationString.toUpperCase()) {
                        case "READ-UNCOMMITTED": {
                            this.isolation = 1;
                            break;
                        }
                        case "READ-COMMITTED": {
                            this.isolation = 2;
                            break;
                        }
                        case "REPEATABLE-READ": {
                            this.isolation = 4;
                            break;
                        }
                        case "SERIALIZABLE": {
                            this.isolation = 8;
                            break;
                        }
                        default: {
                            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " unknown isolation level: " + isolationString});
                        }
                    }
                }
            }
        }
        return this.isolation;
    }

    public synchronized void resetConnectionInfoCache() {
        this.characterSetClient = null;
        this.characterSetResults = null;
        this.timeZone = null;
        this.timeFormatter = null;
        this.isolation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setVariables(XConnection connection, Map<String, Object> newVariables, boolean isGlobal) throws SQLException {
        if (!isGlobal && this.sessionVariables == null) {
            this.sessionVariables = new HashMap<String, Object>(this.client.getSessionVariablesL());
        }
        Map<String, Object> serverVariables = null;
        HashSet serverVariablesNeedToRemove = Sets.newHashSet();
        boolean resetSqlLogBin = false;
        if (!isGlobal) {
            for (String key : this.sessionVariablesChanged.keySet()) {
                boolean isProtected = false;
                for (String var : protectedVariables) {
                    if (!var.equals(key)) continue;
                    isProtected = true;
                    break;
                }
                if (isProtected || newVariables.containsKey(key)) continue;
                if (serverVariables == null) {
                    serverVariables = new HashMap<String, Object>(newVariables);
                }
                if (this.client.getGlobalVariablesL().containsKey(key)) {
                    serverVariables.put(key, this.client.getGlobalVariablesL().get(key));
                    continue;
                }
                serverVariablesNeedToRemove.add(key);
            }
        }
        if (serverVariables == null) {
            serverVariables = newVariables;
        }
        boolean first = true;
        ArrayList<void> parmas = new ArrayList<void>();
        StringBuilder query = new StringBuilder("SET ");
        HashMap<String, void> tmpVariablesChanged = new HashMap<String, void>();
        for (Map.Entry<String, Object> entry : serverVariables.entrySet()) {
            String oldValuesStr;
            Object oldValue;
            void var14_22;
            String newValueStr;
            String key = entry.getKey();
            Object object = entry.getValue();
            if (ServerVariables.extraVariables.contains(key) || ServerVariables.XbannedVariables.contains(key) || !isGlobal && ServerVariables.isMysqlGlobal((String)key)) continue;
            if (object instanceof String) {
                newValueStr = (String)object;
                if (newValueStr.startsWith("@@")) {
                    String keyRef;
                    String newValueLC = newValueStr.toLowerCase();
                    if (newValueLC.startsWith("@@session.")) {
                        keyRef = newValueLC.substring("@@session.".length());
                        Object object2 = this.sessionVariables.get(keyRef);
                    } else if (newValueLC.startsWith("@@global.")) {
                        keyRef = newValueLC.substring("@@global.".length());
                        Object object3 = this.client.getGlobalVariablesL().get(keyRef);
                    } else {
                        keyRef = newValueLC.substring("@@".length());
                        Object object4 = this.client.getGlobalVariablesL().get(keyRef);
                    }
                } else if ("default".equalsIgnoreCase(newValueStr)) {
                    Object object5 = this.client.getGlobalVariablesL().get(key);
                }
            }
            newValueStr = String.valueOf(var14_22);
            if (!isGlobal) {
                oldValue = this.sessionVariables.get(key);
            } else {
                Object object6 = oldValue = this.globalVariables == null ? this.client.getGlobalVariablesL().get(key) : this.globalVariables.get(key);
            }
            if (oldValue != null && (TStringUtil.equalsIgnoreCase((String)newValueStr, (String)(oldValuesStr = String.valueOf(oldValue))) || StringUtils.isEmpty((String)newValueStr) && "NULL".equalsIgnoreCase(oldValuesStr) || StringUtils.isEmpty((String)oldValuesStr) && "NULL".equalsIgnoreCase(newValueStr))) continue;
            if (!first) {
                query.append(" , ");
            } else {
                first = false;
            }
            boolean isBoth = ServerVariables.isMysqlBoth((String)key);
            if (isGlobal) {
                query.append(" GLOBAL ");
            }
            StringBuilder tmpQuery = new StringBuilder(" , ");
            query.append("`").append(key).append("`=");
            tmpQuery.append("`").append(key).append("`=");
            if (TStringUtil.isParsableNumber((String)newValueStr)) {
                query.append(newValueStr);
                tmpQuery.append(newValueStr);
            } else if ("NULL".equalsIgnoreCase(newValueStr) || var14_22 == null || StringUtils.isEmpty((String)newValueStr)) {
                if (ServerVariables.canExecByBoth.contains(key) || ServerVariables.canOnlyExecByNullVariables.contains(key)) {
                    query.append("NULL");
                    tmpQuery.append("NULL");
                } else {
                    if (!ServerVariables.canOnlyExecByEmptyStrVariables.contains(key)) throw new TddlRuntimeException(ErrorCode.ERR_VARIABLE_CAN_NOT_SET_TO_NULL_FOR_NOW, new String[]{key});
                    query.append("''");
                    tmpQuery.append("''");
                }
            } else {
                query.append("?");
                parmas.add(var14_22);
                if (isBoth) {
                    tmpQuery.append("?");
                    parmas.add(var14_22);
                }
            }
            if (isBoth) {
                query.append((CharSequence)tmpQuery);
            }
            tmpVariablesChanged.put(key, var14_22);
        }
        for (String key : serverVariablesNeedToRemove) {
            if (!first) {
                query.append(", ");
            } else {
                first = false;
            }
            if (key.equalsIgnoreCase("sql_log_bin")) {
                query.append(key).append("=").append("'ON'");
                resetSqlLogBin = true;
                continue;
            }
            query.append("@").append(key).append("=").append("NULL");
        }
        if (first) return;
        List<PolarxDatatypes.Any> args = parmas.stream().map(obj -> XUtil.genAny(XUtil.genScalar(obj, this))).collect(Collectors.toList());
        boolean isStashed = this.stashTransactionSequence();
        try {
            this.execUpdate(connection, BytesSql.getBytesSql((String)query.toString()), null, args, true, null);
        }
        catch (Exception ex) {
            if (resetSqlLogBin) {
                connection.setLastException(ex, true);
            }
        }
        finally {
            if (isStashed) {
                this.stashPopTransactionSequence();
            }
        }
        this.resetConnectionInfoCache();
        if (!isGlobal) {
            for (String string : serverVariablesNeedToRemove) {
                this.sessionVariables.remove(string);
                this.sessionVariablesChanged.remove(string);
            }
            for (Map.Entry entry : tmpVariablesChanged.entrySet()) {
                this.sessionVariables.put((String)entry.getKey(), entry.getValue());
                this.sessionVariablesChanged.put((String)entry.getKey(), entry.getValue());
            }
            return;
        } else {
            if (this.globalVariables == null && !tmpVariablesChanged.isEmpty()) {
                this.globalVariables = new HashMap<String, Object>(this.client.getGlobalVariablesL());
            }
            for (Map.Entry entry : tmpVariablesChanged.entrySet()) {
                this.globalVariables.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void setSessionVariables(XConnection connection, Map<String, Object> newServerVariables) throws SQLException {
        this.setVariables(connection, newServerVariables, false);
    }

    public synchronized void setGlobalVariables(XConnection connection, Map<String, Object> newGlobalVariables) throws SQLException {
        this.setVariables(connection, newGlobalVariables, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void applyDefaultEncodingMySQL(XConnection connection) throws SQLException {
        if (this.defaultEncodingMySQL != null) {
            String copy = this.defaultEncodingMySQL;
            this.defaultEncodingMySQL = null;
            if (!copy.equalsIgnoreCase(this.getRequestEncodingMySQL())) {
                boolean isStashed = this.stashTransactionSequence();
                try {
                    this.execUpdate(connection, BytesSql.getBytesSql((String)("set names `" + copy + "`")), null, null, true, null);
                }
                finally {
                    if (isStashed) {
                        this.stashPopTransactionSequence();
                    }
                }
                this.updateEncodingMySQL(copy);
            }
        }
    }

    public synchronized void setDefalutEncodingMySQL(String defalutEncodingMySQL) {
        this.defaultEncodingMySQL = defalutEncodingMySQL;
    }

    private synchronized void updateEncodingMySQL(String encoding) {
        this.defaultEncodingMySQL = null;
        if (null == this.sessionVariables) {
            this.sessionVariables = new HashMap<String, Object>(this.client.getSessionVariablesL());
        }
        for (String var : encodingVariables) {
            this.sessionVariables.put(var, encoding);
            this.sessionVariablesChanged.put(var, encoding);
        }
        this.characterSetClient = null;
        this.characterSetResults = null;
    }

    public synchronized void updateIsolation(String value) {
        if (null == this.sessionVariables) {
            this.sessionVariables = new HashMap<String, Object>(this.client.getSessionVariablesL());
        }
        this.sessionVariables.put(isolationVariable, value);
        this.sessionVariablesChanged.put(isolationVariable, value);
        this.isolation = null;
    }

    public void flushNetwork() {
        this.client.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIgnorable(XConnection connection) throws SQLException {
        XResult req;
        XSession xSession = this;
        synchronized (xSession) {
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                try {
                    long startNanos = System.nanoTime();
                    this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                    this.lastRequest.set(new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null));
                    this.lastIgnore = false;
                }
                catch (Throwable e) {
                    XLog.XLogLogger.error(this + " failed to close expect.");
                    XLog.XLogLogger.error(this.setLastException(e, true));
                }
            }
            req = this.lastRequest.get();
        }
        if (req != null && req.isIgnorableNotFinish()) {
            this.client.flush();
            try {
                req.waitFinish(true);
            }
            catch (Throwable e) {
                XLog.XLogLogger.error(this + " failed to flush ignorable.");
                XLog.XLogLogger.error(this.setLastException(e, true));
            }
        }
    }

    public synchronized boolean reusable() {
        if (XConnectionManager.getInstance().isEnableTrxLeakCheck() && (this.transactionStatus || this.xaStatus != null)) {
            XLog.XLogLogger.error(this + " transaction leak found. " + (this.transactionStatus ? "normal trx on." : "") + (this.xaStatus != null ? this.xaStatus : ""));
            StringBuilder builder = new StringBuilder();
            builder.append("in stack:\n");
            if (this.stackTraceElements != null) {
                for (StackTraceElement e : this.stackTraceElements) {
                    builder.append(e.toString()).append('\n');
                }
            }
            StackTraceElement[] now = Thread.currentThread().getStackTrace();
            builder.append("out stack:\n");
            for (StackTraceElement e : now) {
                builder.append(e.toString()).append('\n');
            }
            XLog.XLogLogger.error(builder.toString());
            return false;
        }
        return !(Status.Ready != this.status || null != this.getLastException() || null != this.lastRequest.get() && !this.lastRequest.get().isGoodAndDone() || this.historySql.size() >= 1000 || !this.client.isActive() || !this.client.reusable() || System.nanoTime() - this.createNanos - this.randomDelay >= XConnectionManager.getInstance().getSessionAgingNanos() || XConfig.GALAXY_X_PROTOCOL && this.lastIgnore);
    }

    public synchronized boolean reset() {
        if (this.reusable() && 0 == this.packetQueue.count()) {
            this.lastUserRequest.set(null);
            this.lastRequest.set(null);
            this.lastIgnore = false;
            this.lazySnapshotSeq = -1L;
            this.lazyCommitSeq = -1L;
            this.lazyMarkDistributed = false;
            this.lazyUseCtsTransaction = false;
            this.noCache = false;
            this.forceCache = false;
            this.chunkResult = false;
            this.sessionSql.clear();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Status nowStatus = this.status;
        if (Status.Init == nowStatus || Status.Closed == nowStatus) {
            return;
        }
        try {
            if (XLog.XProtocolLogger.isDebugEnabled()) {
                this.historySql.add("cancel query");
                this.sessionSql.add("cancel query");
            }
            XPacket packet = new XPacket(this.sessionId, 111, PolarxSession.KillSession.newBuilder().setType(PolarxSession.KillSession.KillType.QUERY).setXSessionId(this.sessionId).build());
            this.client.send(packet, true);
        }
        finally {
            XSession xSession = this;
            synchronized (xSession) {
                this.setLastException(CANCEL_EXCEPTION, false);
            }
        }
    }

    private void pushEOF() {
        this.pushFatal(XPacket.EOF);
    }

    private void pushKilled() {
        this.pushFatal(XPacket.KILLED);
    }

    private void dataNotify() {
        this.dataNotify(true);
    }

    private void dataNotify(boolean with_lock) {
        XResult probe = this.lastRequest.get();
        if (probe != null) {
            boolean needPush;
            probe.recordPktResponse();
            if (XConfig.GALAXY_X_PROTOCOL && null == (probe = this.lastUserRequest.get())) {
                return;
            }
            boolean bl = needPush = probe.getDataNotify() != null;
            if (needPush) {
                Runnable cb;
                XResult real;
                XResult xResult = real = XConfig.GALAXY_X_PROTOCOL ? this.lastUserRequest.get() : this.lastRequest.get();
                if (real != null && (cb = real.getDataNotify()) != null) {
                    cb.run();
                }
            }
        }
    }

    public void pushFatal(XPacket fatal) {
        this.packetQueue.put(fatal);
        this.dataNotify(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(boolean pushKilled) {
        Status nowStatus = this.status;
        if (Status.Init == nowStatus || Status.Closed == nowStatus) {
            return;
        }
        try {
            if (XLog.XProtocolLogger.isDebugEnabled()) {
                this.historySql.add("kill query");
                this.sessionSql.add("kill query");
            }
            XPacket packet = new XPacket(this.sessionId, 111, PolarxSession.KillSession.newBuilder().setType(PolarxSession.KillSession.KillType.CONNECTION).setXSessionId(this.sessionId).build());
            this.client.send(packet, true);
        }
        finally {
            XSession xSession = this;
            synchronized (xSession) {
                this.setLastException(KILL_EXCEPTION, true);
            }
        }
        if (pushKilled) {
            this.pushKilled();
        }
    }

    public void killWithMessage(String msg) {
        this.kill(false);
        String errStr = this + " killed. " + msg;
        this.pushFatal(new XPacket(-1L, 1, Polarx.Error.newBuilder().setSeverity(Polarx.Error.Severity.FATAL).setCode(-1).setSqlState(errStr).setMsg(errStr).build()));
    }

    public void tokenOffer(int tokenKb) {
        Status nowStatus = this.status;
        if (Status.Init == nowStatus || Status.Closed == nowStatus) {
            return;
        }
        XPacket packet = new XPacket(this.sessionId, 112, PolarxSql.TokenOffer.newBuilder().setToken(tokenKb).build());
        this.client.send(packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPackets(ArrayList<XPacket> packets) {
        if (packets.isEmpty()) {
            return;
        }
        try {
            int consume = 0;
            Status nowStatus = this.status;
            if (Status.Waiting == nowStatus) {
                Object object = this.statusLock;
                synchronized (object) {
                    if (Status.Waiting == this.status) {
                        if (0 == packets.get(0).getType()) {
                            ++consume;
                            nowStatus = this.status = Status.Ready;
                            this.client.getPerfCollection().getSessionCreateSuccessCount().getAndIncrement();
                            this.client.getPool().getPerfCollection().getSessionCreateSuccessCount().getAndIncrement();
                        } else {
                            Polarx.Error error;
                            if (1 == packets.get(0).getType() && (error = (Polarx.Error)packets.get(0).getPacket()).getSeverity() == Polarx.Error.Severity.FATAL) {
                                nowStatus = this.status = Status.Ready;
                            }
                            this.client.getPerfCollection().getSessionCreateFailCount().getAndIncrement();
                            this.client.getPool().getPerfCollection().getSessionCreateFailCount().getAndIncrement();
                            if (Status.Waiting == this.status) {
                                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{"Unknown new session response. sid: " + packets.get(0).getSid() + " type: " + packets.get(0).getType() + " pkt: " + packets.get(0).getPacket()});
                            }
                        }
                    }
                }
            }
            if (Status.Ready == nowStatus || Status.AutoCommit == nowStatus) {
                this.packetQueue.put((Collection<? extends XPacket>)(0 == consume ? packets : packets.subList(consume, packets.size())));
                boolean gotData = false;
                for (XPacket packet : packets) {
                    if (13 != packet.getType() && 21 != packet.getType() && 20 != packet.getType() && 19 != packet.getType() && 14 != packet.getType() && 1 != packet.getType() && 16 != packet.getType() && 17 != packet.getType()) continue;
                    gotData = true;
                    break;
                }
                if (gotData) {
                    this.dataNotify();
                }
            }
        }
        catch (Throwable e) {
            XLog.XLogLogger.error(this + " failed to push packet.");
            XLog.XLogLogger.error(e);
            try {
                this.pushFatal(XPacket.FATAL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void setDefaultDB(String defaultDB) {
        if (defaultDB != null && !defaultDB.isEmpty()) {
            if (this.lastDB != null && this.lastDB.equals(defaultDB)) {
                return;
            }
            this.lazyUseDB = defaultDB;
            this.lastDB = defaultDB;
        }
    }

    public void setLazyCtsTransaction() {
        this.lazyUseCtsTransaction = true;
    }

    public void setLazyMarkDistributed() {
        this.lazyMarkDistributed = true;
    }

    public void setLazySnapshotSeq(long lazySnapshotSeq) {
        this.lazySnapshotSeq = lazySnapshotSeq;
    }

    public void setLazyCommitSeq(long lazyCommitSeq) {
        this.lazyCommitSeq = lazyCommitSeq;
    }

    public boolean stashTransactionSequence() {
        if (this.isStashed) {
            return false;
        }
        this.isStashed = true;
        this.stashUseCtsTransaction = this.lazyUseCtsTransaction;
        this.stashMarkDistributed = this.lazyMarkDistributed;
        this.stashSnapshotSeq = this.lazySnapshotSeq;
        this.stashCommitSeq = this.lazyCommitSeq;
        this.lazyUseCtsTransaction = false;
        this.lazyMarkDistributed = false;
        this.lazySnapshotSeq = -1L;
        this.lazyCommitSeq = -1L;
        return true;
    }

    public void stashPopTransactionSequence() {
        this.isStashed = false;
        this.lazyUseCtsTransaction = this.stashUseCtsTransaction;
        this.lazyMarkDistributed = this.stashMarkDistributed;
        this.lazySnapshotSeq = this.stashSnapshotSeq;
        this.lazyCommitSeq = this.stashCommitSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForRequest() {
        Status nowStatus = this.status;
        if (Status.Init == nowStatus) {
            Object object = this.statusLock;
            synchronized (object) {
                if (Status.Init == this.status) {
                    this.status = Status.Waiting;
                    GLOBAL_COUNTER.getAndIncrement();
                    PolarxSession.NewSession.Builder builder = PolarxSession.NewSession.newBuilder();
                    XPacket packet = new XPacket(this.sessionId, 110, builder.build());
                    this.client.send(packet, false);
                }
            }
        } else if (Status.AutoCommit == nowStatus && this.lastRequest.get() != null) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{this + " duplicated request on AutoCommit session."});
        }
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isForceCache() {
        return this.forceCache;
    }

    public void setForceCache(boolean forceCache) {
        this.forceCache = forceCache;
    }

    public boolean isChunkResult() {
        return this.chunkResult;
    }

    public void setChunkResult(boolean chunkResult) {
        this.chunkResult = chunkResult;
    }

    private XResult getResultSet(XConnection connection, long startNanos, boolean ignoreResult, BytesSql sql, XPacketBuilder retransmit, XResult.RequestType requestType, String extra) throws SQLException {
        XResult last = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, ignoreResult, requestType, sql, connection.getDefaultTokenKb(), retransmit, extra);
        this.lastRequest.set(last);
        this.lastUserRequest.set(last);
        return last;
    }

    private synchronized boolean send_internal(XConnection connection, XPacket packet, boolean ignoreResult) throws SQLException {
        if (XConfig.GALAXY_X_PROTOCOL) {
            if (ignoreResult && !this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 24, PolarxExpect.Open.newBuilder().addCond(PolarxExpect.Open.Condition.newBuilder().setConditionKey(1)).build()), false);
                long startNanos = System.nanoTime();
                this.lastRequest.set(new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect([+no_error])"), connection.getDefaultTokenKb(), null, null));
                this.lastIgnore = true;
            }
            if (!ignoreResult && this.lastIgnore) {
                this.client.send(packet, false);
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                return true;
            }
            this.client.send(packet, !ignoreResult);
        } else {
            this.client.send(packet, !ignoreResult);
        }
        return false;
    }

    public synchronized XResult execQuery(XConnection connection, PolarxExecPlan.ExecPlan.Builder execPlan, BytesSql nativeSql, byte[] traceId, boolean ignoreResult) throws SQLException {
        XResult result;
        PolarxExecPlan.AnyPlan originalPlan;
        if (XConfig.GALAXY_X_PROTOCOL) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Plan trans not supported in galaxy."});
        }
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getQueryCount().getAndIncrement();
        }
        this.perfCollection.getPlanCount().getAndIncrement();
        this.initForRequest();
        this.applyDefaultEncodingMySQL(connection);
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.traceCtsInfo();
            this.historySql.add(execPlan.toString());
            this.sessionSql.add(execPlan.toString());
        }
        if (traceId != null) {
            execPlan.setTraceId(ByteString.copyFrom((byte[])traceId));
        }
        boolean pureDigest = false;
        if (!ignoreResult && !this.noCache && this.supportPlanCache()) {
            pureDigest = true;
            if (dataSource != null) {
                dataSource.getCachePlanQuery().getAndIncrement();
            }
        }
        String extra = null;
        if (!XConfig.GALAXY_X_PROTOCOL) {
            execPlan.setResetError(!this.lastIgnore);
        }
        execPlan.setToken(connection.getDefaultTokenKb());
        if (this.lazyUseCtsTransaction) {
            execPlan.setUseCtsTransaction(true);
            extra = null == extra ? "use_cts;" : extra + "use_cts;";
            this.lazyUseCtsTransaction = false;
        }
        if (this.lazyMarkDistributed) {
            execPlan.setMarkDistributed(true);
            extra = null == extra ? "mark_distributed;" : extra + "mark_distributed;";
            this.lazyMarkDistributed = false;
        }
        if (this.lazySnapshotSeq != -1L) {
            execPlan.setSnapshotSeq(this.lazySnapshotSeq);
            extra = null == extra ? "snapshot=" + this.lazySnapshotSeq + ";" : extra + "snapshot=" + this.lazySnapshotSeq + ";";
            this.lazySnapshotSeq = -1L;
        }
        if (this.lazyCommitSeq != -1L) {
            execPlan.setCommitSeq(this.lazyCommitSeq);
            extra = null == extra ? "commit=" + this.lazyCommitSeq + ";" : extra + "commit=" + this.lazyCommitSeq + ";";
            this.lazyCommitSeq = -1L;
        }
        if (this.chunkResult && this.supportChunkResult()) {
            execPlan.setChunkResult(true);
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = ignoreResult;
        }
        PolarxExecPlan.AnyPlan anyPlan = originalPlan = pureDigest && !this.forceCache ? execPlan.getPlan() : null;
        if (pureDigest) {
            execPlan.clearPlan();
        } else {
            JsonFormat format = new JsonFormat();
            execPlan.setAuditStr(ByteString.copyFromUtf8((String)format.printToString((Message)execPlan.getPlan())));
        }
        PolarxExecPlan.ExecPlan plan = execPlan.build();
        XPacket packet = new XPacket(this.sessionId, 100, plan);
        try {
            long startNanos = System.nanoTime();
            boolean postOp = this.send_internal(connection, packet, ignoreResult);
            if (!ignoreResult) {
                this.addActive();
            }
            result = this.getResultSet(connection, startNanos, ignoreResult, nativeSql, null == originalPlan ? null : new XPacketBuilder(this.sessionId, execPlan, originalPlan), XResult.RequestType.PLAN_QUERY, extra);
            if (postOp) {
                this.lastRequest.set(new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null));
            }
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        if (!ignoreResult && !connection.isStreamMode()) {
            result.finishBlockMode();
        }
        return ignoreResult ? null : result;
    }

    private void execPreDealing(XConnection connection, BytesSql sql, boolean isUpdate) throws SQLException {
        XDataSource dataSource;
        if (XConnectionManager.getInstance().isEnableTrxLeakCheck()) {
            String tempSql = sql.toString();
            if (StringUtils.containsIgnoreCase((String)tempSql, (String)"XA START ") || StringUtils.containsIgnoreCase((String)tempSql, (String)"XA PREPARE ")) {
                this.xaStatus = tempSql;
            } else if (StringUtils.containsIgnoreCase((String)tempSql, (String)"XA ROLLBACK ") || StringUtils.containsIgnoreCase((String)tempSql, (String)"XA COMMIT ")) {
                this.xaStatus = null;
            } else if (tempSql.equalsIgnoreCase("begin") || StringUtils.containsIgnoreCase((String)tempSql, (String)"*/begin") || StringUtils.containsIgnoreCase((String)tempSql, (String)"START TRANSACTION")) {
                this.transactionStatus = true;
            } else if (tempSql.equalsIgnoreCase("rollback") || tempSql.equalsIgnoreCase("commit") || StringUtils.containsIgnoreCase((String)tempSql, (String)"*/rollback") || StringUtils.containsIgnoreCase((String)tempSql, (String)"*/commit")) {
                this.transactionStatus = false;
            }
        }
        if ((dataSource = connection.getDataSource()) != null) {
            if (isUpdate) {
                dataSource.getUpdateCount().getAndIncrement();
            } else {
                dataSource.getQueryCount().getAndIncrement();
            }
        }
        if (isUpdate) {
            this.perfCollection.getUpdateCount().getAndIncrement();
        } else {
            this.perfCollection.getQueryCount().getAndIncrement();
        }
        this.initForRequest();
        this.applyDefaultEncodingMySQL(connection);
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.traceCtsInfo();
            this.historySql.add(sql.toString());
            this.sessionSql.add(sql.toString());
        }
    }

    public XResult execQuery(XConnection connection, BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest) throws SQLException {
        return this.execQuery(connection, sql, hint, args, ignoreResult, digest, null);
    }

    public synchronized XResult execQuery(XConnection connection, BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest, String returning) throws SQLException {
        XResult result;
        if (returning != null && XConfig.GALAXY_X_PROTOCOL) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Returning not supported in galaxy."});
        }
        this.execPreDealing(connection, sql, false);
        boolean explain = this.isExplain(hint);
        if (explain) {
            hint = Arrays.copyOfRange(hint, 8, hint.length);
        }
        PolarxSql.StmtExecute.Builder builder = PolarxSql.StmtExecute.newBuilder();
        String returningHint = null != returning ? "/* +returning fields(" + returning + ") */ " : "";
        boolean setStmt = true;
        if (!ignoreResult && !this.noCache && digest != null && this.supportPlanCache()) {
            XDataSource dataSource;
            setStmt = false;
            builder.setStmtDigest(digest);
            if (hint != null) {
                builder.setHint(ByteString.copyFrom((byte[])hint));
            }
            if ((dataSource = connection.getDataSource()) != null) {
                dataSource.getCacheSqlQuery().getAndIncrement();
            }
        } else if (!XConfig.GALAXY_X_PROTOCOL) {
            builder.setHint(ByteString.copyFromUtf8((String)returningHint));
        }
        String extra = null;
        if (setStmt) {
            try {
                if (explain && !this.isExplain(sql.getBytes())) {
                    builder.setStmt(EXPLAIN_PRE.concat(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL()))));
                } else if ((builder.getStmtDigest() == null || builder.getStmtDigest().isEmpty()) && hint != null) {
                    builder.setStmt(ByteString.copyFrom((byte[])hint).concat(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL()))));
                } else {
                    builder.setStmt(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL())));
                }
            }
            catch (UnsupportedCharsetException e) {
                XLog.XLogLogger.error((Throwable)e);
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{e.getMessage()});
            }
        }
        if (args != null) {
            builder.addAllArgs(args);
        }
        if (connection.isCompactMetadata()) {
            builder.setCompactMetadata(true);
        }
        if (this.lazyUseDB != null) {
            builder.setSchemaName(this.lazyUseDB);
            this.lazyUseDB = null;
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            builder.setResetError(!this.lastIgnore);
        }
        builder.setToken(connection.getDefaultTokenKb());
        extra = this.setLazyTrxVariables(builder, extra);
        if (this.chunkResult && this.supportChunkResult()) {
            builder.setChunkResult(true);
        }
        if (connection.isWithFeedback() && this.supportFeedback()) {
            builder.setFeedBack(true);
        }
        if (connection.getCapabilities() != 0L) {
            builder.setCapabilities(connection.getCapabilities());
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = ignoreResult;
        }
        XPacket packet = new XPacket(this.sessionId, 101, builder.build());
        try {
            long startNanos = System.nanoTime();
            boolean postOp = this.send_internal(connection, packet, ignoreResult);
            if (!ignoreResult) {
                this.addActive();
            }
            XPacketBuilder retransmit = !setStmt && !this.forceCache ? new XPacketBuilder(this.sessionId, builder, sql, XSession.toJavaEncoding(this.getRequestEncodingMySQL())) : null;
            result = this.getResultSet(connection, startNanos, ignoreResult, sql, retransmit, XResult.RequestType.SQL_QUERY, extra);
            if (postOp) {
                this.lastRequest.set(new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null));
            }
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        if (!ignoreResult && !connection.isStreamMode()) {
            result.finishBlockMode();
        }
        return ignoreResult ? null : result;
    }

    private boolean isExplain(byte[] hint) {
        if (hint == null || hint.length < 8) {
            return false;
        }
        return hint[0] == 101 && hint[1] == 120 && hint[2] == 112 && hint[3] == 108 && hint[4] == 97 && hint[5] == 105 && hint[6] == 110 && hint[7] == 32;
    }

    public synchronized XResult execGalaxyPrepare(XConnection connection, BytesSql sql, byte[] hint, ByteString digest, List<GPTable> tables, ByteString params, int paramNum, boolean ignoreResult, boolean isUpdate) throws SQLException {
        XResult result;
        boolean setStmt;
        ByteString extraPrefix;
        this.execPreDealing(connection, sql, isUpdate);
        assert (!this.isExplain(hint));
        PolarxSql.GalaxyPrepareExecute.Builder builder = PolarxSql.GalaxyPrepareExecute.newBuilder();
        ByteString byteString = extraPrefix = 0 == tables.size() ? ByteString.copyFromUtf8((String)("/*" + this.lastDB + "*/")) : null;
        if (!this.noCache && digest != null && this.supportPlanCache()) {
            setStmt = false;
            builder.setStmtDigest(digest);
        } else {
            setStmt = true;
            try {
                String encoding = XSession.toJavaEncoding(this.getRequestEncodingMySQL());
                builder.setStmt(null == extraPrefix ? sql.byteString(encoding) : extraPrefix.concat(sql.byteString(encoding)));
            }
            catch (UnsupportedCharsetException e) {
                XLog.XLogLogger.error((Throwable)e);
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{e.getMessage()});
            }
        }
        if (hint != null) {
            builder.setHint(ByteString.copyFrom((byte[])hint));
        }
        if (tables != null && !tables.isEmpty()) {
            PolarxSql.GalaxyPrepareTableData.Builder tableBuilder = PolarxSql.GalaxyPrepareTableData.newBuilder();
            for (GPTable tableData : tables) {
                tableBuilder.setTableIndex(tableData.getTableParamIndex());
                tableBuilder.setTableName(ByteString.copyFromUtf8((String)tableData.getTableName()));
                builder.addTables(tableBuilder);
            }
        }
        if (params != null && !params.isEmpty()) {
            builder.setParam(params);
            builder.setParamNum(paramNum);
        }
        if (connection.isCompactMetadata()) {
            builder.setCompactMetadata(true);
        }
        if (this.lazyUseDB != null) {
            builder.setDbName(this.lazyUseDB);
            this.lazyUseDB = null;
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            builder.setResetError(!this.lastIgnore);
        }
        builder.setToken(connection.getDefaultTokenKb());
        String extra = null;
        if (this.lazyUseCtsTransaction) {
            builder.setUseCtsTransaction(true);
            extra = null == extra ? "use_cts;" : extra + "use_cts;";
            this.lazyUseCtsTransaction = false;
        }
        if (this.lazyMarkDistributed) {
            builder.setMarkDistributed(true);
            extra = null == extra ? "mark_distributed;" : extra + "mark_distributed;";
            this.lazyMarkDistributed = false;
        }
        if (this.lazySnapshotSeq != -1L) {
            builder.setSnapshotSeq(this.lazySnapshotSeq);
            extra = null == extra ? "snapshot=" + this.lazySnapshotSeq + ";" : extra + "snapshot=" + this.lazySnapshotSeq + ";";
            this.lazySnapshotSeq = -1L;
        }
        if (this.lazyCommitSeq != -1L) {
            builder.setCommitSeq(this.lazyCommitSeq);
            extra = null == extra ? "commit=" + this.lazyCommitSeq + ";" : extra + "commit=" + this.lazyCommitSeq + ";";
            this.lazyCommitSeq = -1L;
        }
        if (this.chunkResult && this.supportChunkResult()) {
            builder.setResultSetType(PolarxSql.GalaxyPrepareExecute.ResultSetType.CHUNK_V1);
        }
        if (connection.isWithFeedback() && this.supportFeedback()) {
            builder.setFeedBack(true);
        }
        if (connection.getCapabilities() != 0L) {
            builder.setCapabilities(connection.getCapabilities());
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = ignoreResult;
        }
        XPacket packet = new XPacket(this.sessionId, 102, builder.build());
        try {
            long startNanos = System.nanoTime();
            boolean postOp = this.send_internal(connection, packet, ignoreResult);
            if (!ignoreResult) {
                this.addActive();
            }
            XPacketBuilder retransmit = !setStmt && !this.forceCache ? new XPacketBuilder(this.sessionId, builder, sql, XSession.toJavaEncoding(this.getRequestEncodingMySQL()), extraPrefix) : null;
            result = this.getResultSet(connection, startNanos, ignoreResult, sql, retransmit, XResult.RequestType.SQL_PREPARE_EXECUTE, extra);
            if (postOp) {
                this.lastRequest.set(new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null));
            }
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        if (!(ignoreResult || !isUpdate && connection.isStreamMode())) {
            result.finishBlockMode();
        }
        return ignoreResult ? null : result;
    }

    public synchronized XResult execUpdate(XConnection connection, BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest) throws SQLException {
        XResult result;
        if (digest != null && XConfig.GALAXY_X_PROTOCOL) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Digest not supported in galaxy."});
        }
        this.execPreDealing(connection, sql, true);
        boolean explain = this.isExplain(hint);
        if (explain) {
            hint = Arrays.copyOfRange(hint, 8, hint.length);
        }
        PolarxSql.StmtExecute.Builder builder = PolarxSql.StmtExecute.newBuilder();
        boolean setStmt = true;
        if (!ignoreResult && !this.noCache && digest != null && this.supportPlanCache()) {
            setStmt = false;
            builder.setStmtDigest(digest);
            builder.setHint(ByteString.copyFrom((byte[])hint));
            XDataSource dataSource = connection.getDataSource();
            if (dataSource != null) {
                dataSource.getCacheSqlQuery().getAndIncrement();
            }
        }
        String extra = null;
        if (setStmt) {
            try {
                if (explain && !this.isExplain(sql.getBytes())) {
                    builder.setStmt(EXPLAIN_PRE.concat(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL()))));
                } else if ((builder.getStmtDigest() == null || builder.getStmtDigest().isEmpty()) && hint != null) {
                    builder.setStmt(ByteString.copyFrom((byte[])hint).concat(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL()))));
                } else {
                    builder.setStmt(sql.byteString(XSession.toJavaEncoding(this.getRequestEncodingMySQL())));
                }
            }
            catch (UnsupportedCharsetException e) {
                XLog.XLogLogger.error((Throwable)e);
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{e.getMessage()});
            }
        }
        if (args != null) {
            builder.addAllArgs(args);
        }
        if (connection.isCompactMetadata()) {
            builder.setCompactMetadata(true);
        }
        if (this.lazyUseDB != null) {
            builder.setSchemaName(this.lazyUseDB);
            this.lazyUseDB = null;
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            builder.setResetError(!this.lastIgnore);
        }
        extra = this.setLazyTrxVariables(builder, extra);
        if (connection.isWithFeedback() && this.supportFeedback()) {
            builder.setFeedBack(true);
        }
        if (connection.getCapabilities() != 0L) {
            builder.setCapabilities(connection.getCapabilities());
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = ignoreResult;
        }
        XPacket packet = new XPacket(this.sessionId, 101, builder.build());
        try {
            long startNanos = System.nanoTime();
            boolean postOp = this.send_internal(connection, packet, ignoreResult);
            if (!ignoreResult) {
                this.addActive();
            }
            XPacketBuilder retransmit = !setStmt && !this.forceCache ? new XPacketBuilder(this.sessionId, builder, sql, XSession.toJavaEncoding(this.getRequestEncodingMySQL())) : null;
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, ignoreResult, XResult.RequestType.SQL_UPDATE, sql, connection.getDefaultTokenKb(), retransmit, extra);
            this.lastRequest.set(result);
            this.lastUserRequest.set(result);
            if (postOp) {
                this.lastRequest.set(new XResult(connection, this.packetQueue, result, startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null));
            }
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        if (!ignoreResult) {
            result.finishBlockMode();
        }
        return result;
    }

    private String setLazyTrxVariables(PolarxSql.StmtExecute.Builder builder, String extra) {
        if (this.lazyUseCtsTransaction) {
            builder.setUseCtsTransaction(true);
            extra = null == extra ? "use_cts;" : extra + "use_cts;";
            this.lazyUseCtsTransaction = false;
        }
        if (this.lazyMarkDistributed) {
            builder.setMarkDistributed(true);
            extra = null == extra ? "mark_distributed;" : extra + "mark_distributed;";
            this.lazyMarkDistributed = false;
        }
        if (this.lazySnapshotSeq != -1L) {
            builder.setSnapshotSeq(this.lazySnapshotSeq);
            extra = null == extra ? "snapshot=" + this.lazySnapshotSeq + ";" : extra + "snapshot=" + this.lazySnapshotSeq + ";";
            this.lazySnapshotSeq = -1L;
        }
        if (this.lazyCommitSeq != -1L) {
            builder.setCommitSeq(this.lazyCommitSeq);
            extra = null == extra ? "commit=" + this.lazyCommitSeq + ";" : extra + "commit=" + this.lazyCommitSeq + ";";
            this.lazyCommitSeq = -1L;
        }
        return extra;
    }

    public synchronized long getTSO(XConnection connection, int count) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String GET_TSO_SQL = "get_tso()";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("get_tso()");
            this.sessionSql.add("get_tso()");
        }
        PolarxExecPlan.GetTSO.Builder builder = PolarxExecPlan.GetTSO.newBuilder();
        builder.setLeaderName(ByteString.EMPTY);
        if (count < 1) {
            count = 1;
        }
        builder.setBatchCount(count);
        boolean pendingRequests = this.lastIgnore;
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 113, builder.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && pendingRequests) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult last = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(last);
                last.finishBlockMode();
            } else if (pendingRequests) {
                this.flushNetwork();
                XResult last = this.lastRequest.get();
                if (last != null) {
                    last.finishBlockMode();
                }
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), false, XResult.RequestType.FETCH_TSO, BytesSql.getBytesSql((String)"get_tso()"), connection.getDefaultTokenKb(), null, null);
            this.lastRequest.set(result);
            this.lastUserRequest.set(result);
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        result.finishBlockMode();
        if (result.getTsoErrorNo() != 0) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{this + " failed to get TSO. errno " + result.getTsoErrorNo()});
        }
        return result.getTsoValue();
    }

    public synchronized void handleAutoSavepoint(XConnection connection, String name, PolarxExecPlan.AutoSp.Operation op, boolean ignoreResult) throws SQLException {
        XResult result;
        String sql;
        if (XConfig.GALAXY_X_PROTOCOL || !this.isXRPC()) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Auto savepoint opt only support xrpc."});
        }
        this.initForRequest();
        switch (op) {
            case SET: {
                sql = "SAVEPOINT `" + name + "`";
                break;
            }
            case RELEASE: {
                sql = "RELEASE SAVEPOINT `" + name + "`";
                break;
            }
            case ROLLBACK: {
                sql = "ROLLBACK SAVEPOINT `" + name + "`";
                break;
            }
            default: {
                sql = null;
            }
        }
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add(sql);
            this.sessionSql.add(sql);
        }
        PolarxExecPlan.AutoSp.Builder builder = PolarxExecPlan.AutoSp.newBuilder();
        builder.setSpName(ByteString.copyFromUtf8((String)name));
        builder.setOp(op);
        builder.setResetError(!this.lastIgnore);
        this.lastIgnore = ignoreResult;
        XPacket packet = new XPacket(this.sessionId, 115, builder.build());
        try {
            long startNanos = System.nanoTime();
            this.client.send(packet, !ignoreResult);
            if (!ignoreResult) {
                this.addActive();
            }
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, ignoreResult, XResult.RequestType.AUTO_SP, BytesSql.getBytesSql((String)sql), connection.getDefaultTokenKb(), null, null);
            this.lastRequest.set(result);
            this.lastUserRequest.set(result);
        }
        catch (Throwable t) {
            throw GeneralUtil.nestedException((Throwable)this.setLastException(t, true));
        }
        if (!ignoreResult) {
            result.finishBlockMode();
        }
    }

    public long getConnectionId() {
        return this.connectionId != -1L ? this.connectionId : 0L;
    }

    public void refereshConnetionId(XConnection connection) throws SQLException {
        if (this.connectionId != -1L || this.status == Status.AutoCommit) {
            return;
        }
        Long connId = null;
        XResult result = this.execQuery(connection, BytesSql.getBytesSql((String)"select connection_id()"), null, null, false, null);
        while (result.next() != null) {
            try {
                Number res = (Number)XResultUtil.resultToObject(result.getMetaData().get(0), result.current().getRow().get(0), true, TimeZone.getDefault()).getKey();
                if (null != connId) continue;
                connId = res.longValue();
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        if (null == connId) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{this + " failed to get connection id."});
        }
        this.connectionId = connId;
    }

    public boolean supportMessageTimestamp() {
        if (!XConnectionManager.getInstance().isEnableMessageTimestamp()) {
            return false;
        }
        if (this.flagMessageTimestamp != null) {
            return this.flagMessageTimestamp;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagMessageTimestamp = true;
                return this.flagMessageTimestamp;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver >= 20210204L) {
                    this.flagMessageTimestamp = true;
                    return this.flagMessageTimestamp;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else {
            if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
                this.flagMessageTimestamp = true;
                return this.flagMessageTimestamp;
            }
            if (this.isXRPC()) {
                this.flagMessageTimestamp = true;
                return this.flagMessageTimestamp;
            }
        }
        this.flagMessageTimestamp = false;
        return this.flagMessageTimestamp;
    }

    public boolean supportPlanCache() {
        if (!XConnectionManager.getInstance().isEnablePlanCache()) {
            return false;
        }
        if (this.flagQueryCache != null) {
            return this.flagQueryCache;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagQueryCache = true;
                return this.flagQueryCache;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver >= 20210204L) {
                    this.flagQueryCache = true;
                    return this.flagQueryCache;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else {
            if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
                this.flagQueryCache = true;
                return this.flagQueryCache;
            }
            if (this.isXRPC()) {
                this.flagQueryCache = true;
                return this.flagQueryCache;
            }
        }
        this.flagQueryCache = false;
        return this.flagQueryCache;
    }

    public boolean supportChunkResult() {
        if (!XConnectionManager.getInstance().isEnableChunkResult()) {
            return false;
        }
        if (this.flagQueryChunk != null) {
            return this.flagQueryChunk;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagQueryChunk = true;
                return this.flagQueryChunk;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver > 20210315L) {
                    this.flagQueryChunk = true;
                    return this.flagQueryChunk;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else {
            if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
                this.flagQueryChunk = true;
                return this.flagQueryChunk;
            }
            if (this.isXRPC()) {
                this.flagQueryChunk = true;
                return this.flagQueryChunk;
            }
        }
        this.flagQueryChunk = false;
        return this.flagQueryChunk;
    }

    public boolean supportSingleShardOptimization() {
        if (!XConnectionManager.getInstance().isEnableMessageTimestamp()) {
            return false;
        }
        if (this.flagSingleShardOptimization != null) {
            return this.flagSingleShardOptimization;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagSingleShardOptimization = true;
                return this.flagSingleShardOptimization;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver >= 20210701L) {
                    this.flagSingleShardOptimization = true;
                    return this.flagSingleShardOptimization;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else {
            if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
                this.flagSingleShardOptimization = true;
                return this.flagSingleShardOptimization;
            }
            if (this.isXRPC()) {
                this.flagSingleShardOptimization = true;
                return this.flagSingleShardOptimization;
            }
        }
        this.flagSingleShardOptimization = false;
        return this.flagSingleShardOptimization;
    }

    public boolean supportFeedback() {
        if (!XConnectionManager.getInstance().isEnableFeedback()) {
            return false;
        }
        if (this.flagFeedback != null) {
            return this.flagFeedback;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagFeedback = true;
                return this.flagFeedback;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver >= 20210624L) {
                    this.flagFeedback = true;
                    return this.flagFeedback;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
            this.flagFeedback = false;
            return this.flagFeedback;
        }
        this.flagFeedback = false;
        return this.flagFeedback;
    }

    public boolean supportRawString() {
        if (XConfig.GALAXY_X_PROTOCOL) {
            return false;
        }
        if (this.flagRawString != null) {
            return this.flagRawString;
        }
        if (!this.client.isActive()) {
            return false;
        }
        if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_X_CLUSTER) {
            String minor = this.client.getMinorVersion();
            if (minor.equals("local") || minor.equals("log")) {
                this.flagRawString = true;
                return this.flagRawString;
            }
            try {
                long ver = Long.parseLong(minor);
                if (ver >= 20211104L) {
                    this.flagRawString = true;
                    return this.flagRawString;
                }
            }
            catch (Exception e) {
                XLog.XLogLogger.error(this + " unknown xdb minor version: " + minor);
            }
        } else {
            if (this.client.getBaseVersion() == XClient.DnBaseVersion.DN_RDS_80_X_CLUSTER) {
                this.flagRawString = true;
                return this.flagRawString;
            }
            if (this.isXRPC()) {
                this.flagRawString = true;
                return this.flagRawString;
            }
        }
        this.flagRawString = false;
        return this.flagRawString;
    }

    public boolean isXRPC() {
        if (this.flagXRPC != null) {
            return this.flagXRPC;
        }
        if (!this.client.isActive()) {
            return false;
        }
        Object newRpc = this.client.getGlobalVariablesL().get("new_rpc");
        if (newRpc instanceof String && ((String)newRpc).equalsIgnoreCase("ON")) {
            this.flagXRPC = true;
            return this.flagXRPC;
        }
        this.flagXRPC = false;
        return this.flagXRPC;
    }

    public PolarxPhysicalBackfill.GetFileInfoOperator execCheckFileExistence(XConnection connection, PolarxPhysicalBackfill.GetFileInfoOperator.Builder builder) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String SQL_MARK = "checkFileExistence";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("checkFileExistence");
            this.sessionSql.add("checkFileExistence");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 116, builder.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult last = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(last);
                last.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.GET_FILE_INFO, BytesSql.getBytesSql((String)"checkFileExistence"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getIbdFileInfo();
    }

    public PolarxPhysicalBackfill.TransferFileDataOperator execReadBufferFromFile(XConnection connection, PolarxPhysicalBackfill.TransferFileDataOperator.Builder transferFile) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String SQL_MARK = "getBufferFromFile";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("getBufferFromFile");
            this.sessionSql.add("getBufferFromFile");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 117, transferFile.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult lastResult = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(lastResult);
                lastResult.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.TRANSFER_FILE, BytesSql.getBytesSql((String)"getBufferFromFile"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getBufferFromIbdFile();
    }

    public long execTransferFile(XConnection connection, PolarxPhysicalBackfill.TransferFileDataOperator.Builder transferFile) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        this.initForRequest();
        String SQL_MARK = "transferFile";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("transferFile");
            this.sessionSql.add("transferFile");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 117, transferFile.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult lastResult = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(lastResult);
                lastResult.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.TRANSFER_FILE, BytesSql.getBytesSql((String)"transferFile"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getTransferBufferSize();
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse execCloneFile(XConnection connection, PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String SQL_MARK = "cloneFile";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("cloneFile");
            this.sessionSql.add("cloneFile");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 118, builder.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult lastResult = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(lastResult);
                lastResult.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.CLONE_FILE, BytesSql.getBytesSql((String)"cloneFile"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getFileManageOperatorResponse();
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse execDeleteTempIbdFile(XConnection connection, PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String SQL_MARK = "deleteTempFile";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("deleteTempFile");
            this.sessionSql.add("deleteTempFile");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 118, builder.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult lastResult = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(lastResult);
                lastResult.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.DELETE_FILE, BytesSql.getBytesSql((String)"deleteTempFile"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getFileManageOperatorResponse();
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse execFallocateIbdFile(XConnection connection, PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        XResult result;
        XDataSource dataSource = connection.getDataSource();
        if (dataSource != null) {
            dataSource.getTsoCount().getAndIncrement();
        }
        this.perfCollection.getTsoCount().getAndIncrement();
        this.initForRequest();
        String SQL_MARK = "fallocateIdbFile";
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            this.historySql.add("fallocateIdbFile");
            this.sessionSql.add("fallocateIdbFile");
        }
        if (!XConfig.GALAXY_X_PROTOCOL) {
            this.lastIgnore = false;
        }
        XPacket packet = new XPacket(this.sessionId, 118, builder.build());
        try {
            long startNanos = System.nanoTime();
            if (XConfig.GALAXY_X_PROTOCOL && this.lastIgnore) {
                this.client.send(new XPacket(this.sessionId, 25, PolarxExpect.Close.newBuilder().build()), true);
                this.lastIgnore = false;
                XResult lastResult = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + connection.actualTimeoutNanos(), true, XResult.RequestType.EXPECTATIONS, BytesSql.getBytesSql((String)"expect_close"), connection.getDefaultTokenKb(), null, null);
                this.lastRequest.set(lastResult);
                lastResult.finishBlockMode();
            }
            this.client.send(packet, true);
            this.addActive();
            result = new XResult(connection, this.packetQueue, this.lastRequest.get(), startNanos, startNanos + connection.actualTimeoutNanos(), startNanos + 3600000000000L, false, XResult.RequestType.FALLOCATE_FILE, BytesSql.getBytesSql((String)"fallocateIdbFile"), connection.getDefaultTokenKb(), null, null);
            this.lastUserRequest.set(result);
            this.lastRequest.set(result);
        }
        catch (Throwable t) {
            this.lastException.set(t);
            throw t;
        }
        result.finishBlockMode();
        return result.getFileManageOperatorResponse();
    }

    public boolean supportMarkDistributed() {
        if (this.flagMarkDistributed != null) {
            return this.flagMarkDistributed;
        }
        if (!this.client.isActive()) {
            return false;
        }
        Object markDistributed = this.client.getSessionVariablesL().get("innodb_mark_distributed");
        if (null != markDistributed) {
            this.flagMarkDistributed = true;
            return this.flagMarkDistributed;
        }
        this.flagMarkDistributed = false;
        return this.flagMarkDistributed;
    }

    public int hashCode() {
        return Long.hashCode(this.sessionId);
    }

    public boolean equals(Object obj) {
        return obj instanceof XSession && ((XSession)obj).sessionId == this.sessionId;
    }

    @Override
    public int compareTo(XSession o) {
        if (this.sessionId == o.sessionId) {
            return 0;
        }
        return this.sessionId < o.sessionId ? -1 : 1;
    }

    public String toString() {
        return "XSession sid=" + this.sessionId + " status=" + (Object)((Object)this.status) + " from " + this.client;
    }

    public static enum Status {
        Init,
        Waiting,
        Ready,
        Closed,
        AutoCommit;

    }
}

