/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.compatible;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.rpc.pool.XClientPool;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class XDataSource
implements DataSource {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String defaultDatabase;
    private final String name;
    private long getConnTimeoutNanos = 5000000000L;
    private String defaultEncodingMySQL = null;
    private long defaultQueryTimeoutNanos = -1L;
    private final AtomicLong queryCount = new AtomicLong(0L);
    private final AtomicLong updateCount = new AtomicLong(0L);
    private final AtomicLong tsoCount = new AtomicLong(0L);
    private final AtomicLong totalRespondTime = new AtomicLong(0L);
    private final AtomicLong totalPhysicalTime = new AtomicLong(0L);
    private final AtomicLong cachePlanQuery = new AtomicLong(0L);
    private final AtomicLong cacheSqlQuery = new AtomicLong(0L);
    private final AtomicLong cachePlanMiss = new AtomicLong(0L);
    private final AtomicLong cacheSqlMiss = new AtomicLong(0L);

    public XDataSource(String host, int port, String username, String password, String defaultDatabase, String name) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.defaultDatabase = defaultDatabase;
        this.name = name;
        String[] split = name.split("#");
        String instInfo = split.length >= 2 ? split[1] : name;
        XConnectionManager.getInstance().initializeDataSource(host, port, username, password, instInfo);
    }

    public void close() {
        XConnectionManager.getInstance().deinitializeDataSource(this.host, this.port, this.username, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.name;
    }

    public long getGetConnTimeoutNanos() {
        return this.getConnTimeoutNanos;
    }

    public long getGetConnTimeoutMillis() {
        return this.getConnTimeoutNanos / 1000000L;
    }

    public void setGetConnTimeoutNanos(long nanos) {
        this.getConnTimeoutNanos = nanos;
    }

    public void setGetConnTimeoutMillis(long millis) {
        this.getConnTimeoutNanos = millis * 1000000L;
    }

    public void setDefaultEncodingMySQL(String defaultEncoding) {
        if (defaultEncoding.equalsIgnoreCase("utf8")) {
            defaultEncoding = "utf8mb4";
        }
        this.defaultEncodingMySQL = defaultEncoding;
    }

    public void setDefaultQueryTimeoutNanos(long nanos) {
        this.defaultQueryTimeoutNanos = nanos;
    }

    public void setDefaultQueryTimeoutMillis(long millis) {
        this.defaultQueryTimeoutNanos = millis * 1000000L;
    }

    public AtomicLong getQueryCount() {
        return this.queryCount;
    }

    public AtomicLong getUpdateCount() {
        return this.updateCount;
    }

    public AtomicLong getTsoCount() {
        return this.tsoCount;
    }

    public AtomicLong getTotalRespondTime() {
        return this.totalRespondTime;
    }

    public AtomicLong getTotalPhysicalTime() {
        return this.totalPhysicalTime;
    }

    public AtomicLong getCachePlanQuery() {
        return this.cachePlanQuery;
    }

    public AtomicLong getCacheSqlQuery() {
        return this.cacheSqlQuery;
    }

    public AtomicLong getCachePlanMiss() {
        return this.cachePlanMiss;
    }

    public AtomicLong getCacheSqlMiss() {
        return this.cacheSqlMiss;
    }

    public String getUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append("X://").append(this.username).append('@').append(this.host).append(':').append(this.port).append('/');
        if (this.defaultDatabase != null) {
            builder.append(this.defaultDatabase);
        }
        builder.append("?connectTimeout=").append(this.getConnTimeoutNanos / 1000000L);
        if (this.defaultEncodingMySQL != null) {
            builder.append("&characterEncoding=").append(this.defaultEncodingMySQL);
        }
        if (this.defaultQueryTimeoutNanos > 0L) {
            builder.append("&socketTimeout=").append(this.defaultQueryTimeoutNanos / 1000000L);
        }
        return builder.toString();
    }

    public XClientPool.XStatus getStatus() {
        return XConnectionManager.getInstance().getClientPool(this.host, this.port, this.username, this.password).getStatus();
    }

    public String getDigest() {
        return XConnectionManager.digest(this.host, this.port, this.username, this.password);
    }

    public XClientPool getClientPool() {
        return XConnectionManager.getInstance().getClientPool(this.host, this.port, this.username, this.password);
    }

    @Override
    public Connection getConnection() throws SQLException {
        XConnection connection = null;
        try {
            connection = XConnectionManager.getInstance().getConnection(this.host, this.port, this.username, this.password, this.defaultDatabase, this.getConnTimeoutNanos);
            connection.setDataSource(this);
            if (this.defaultEncodingMySQL != null && !this.defaultEncodingMySQL.isEmpty() && !this.defaultEncodingMySQL.equalsIgnoreCase(connection.getSession().getRequestEncodingMySQL())) {
                connection.getSession().setDefalutEncodingMySQL(this.defaultEncodingMySQL);
            } else {
                connection.getSession().setDefalutEncodingMySQL(null);
            }
            if (this.defaultQueryTimeoutNanos > 0L) {
                connection.setNetworkTimeoutNanos(this.defaultQueryTimeoutNanos);
            }
            return connection;
        }
        catch (Exception e) {
            if (connection != null) {
                connection.setLastException(e, true);
                connection.close();
            }
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, (Throwable)e, new String[]{this + " " + e.getMessage()});
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return XDataSource.class.isAssignableFrom(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new NotSupportException();
    }

    public String toString() {
        return "XDataSource to " + this.getDigest();
    }
}

