/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.compatible;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.common.jdbc.RawString;
import com.alibaba.polardbx.common.properties.DynamicConfig;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.common.utils.Pair;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GP57Util;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPParam;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPTable;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPUtil;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.XUtil;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.compatible.XResultSet;
import com.alibaba.polardbx.rpc.compatible.XStatement;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.result.XResult;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import com.mysql.cj.x.protobuf.PolarxDatatypes;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XPreparedStatement
extends XStatement
implements PreparedStatement {
    private String sql;
    private BytesSql bytesSql;
    private byte[] hint;
    private final Map<Integer, Integer> placeHolderPos = new HashMap<Integer, Integer>();
    private boolean useGalaxyPrepare;
    private ByteString galaxyDigest = null;
    private final PolarxDatatypes.Any[] params;
    private final Object[] gp80Params;
    private final GP57Util gp57Params;
    private final List<PolarxDatatypes.Any[]> batch = new ArrayList<PolarxDatatypes.Any[]>();
    private final List<GPParam> gpBatch = new ArrayList<GPParam>();

    public XPreparedStatement(XConnection connection, BytesSql bytesSql, byte[] hint) {
        super(connection);
        this.bytesSql = bytesSql;
        this.hint = hint;
        for (int i = 0; i < bytesSql.dynamicSize(); ++i) {
            this.placeHolderPos.put(this.placeHolderPos.size(), i);
        }
        this.params = new PolarxDatatypes.Any[bytesSql.dynamicSize()];
        if (XConfig.GALAXY_X_PROTOCOL) {
            this.gp80Params = new Object[bytesSql.dynamicSize()];
            this.gp57Params = null;
        } else {
            this.gp80Params = null;
            this.gp57Params = new GP57Util(bytesSql.dynamicSize());
        }
        this.useGalaxyPrepare = DynamicConfig.getInstance().getXprotoGalaxyPrepare();
    }

    public XPreparedStatement(XConnection connection, String sql) {
        super(connection);
        this.bytesSql = BytesSql.getBytesSql((String)sql);
        int startPos = XPreparedStatement.findStartOfStatement(sql);
        int statementLength = sql.length();
        int quotedIdentifierChar = 96;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        boolean inQuotedId = false;
        for (int i = startPos; i < statementLength; ++i) {
            char c = sql.charAt(i);
            if (c == '\\' && i < statementLength - 1) {
                ++i;
                continue;
            }
            if (!inQuotes && c == '`') {
                inQuotedId = !inQuotedId;
            } else if (!inQuotedId) {
                if (inQuotes) {
                    if ((c == '\'' || c == '\"') && c == quoteChar) {
                        if (i < statementLength - 1 && sql.charAt(i + 1) == quoteChar) {
                            ++i;
                            continue;
                        }
                        inQuotes = false;
                        quoteChar = '\u0000';
                    }
                } else {
                    if (c == '#' || c == '-' && i + 1 < statementLength && sql.charAt(i + 1) == '-') {
                        int endOfStmt = statementLength - 1;
                        while (i < endOfStmt && (c = sql.charAt(i)) != '\r' && c != '\n') {
                            ++i;
                        }
                        continue;
                    }
                    if (c == '/' && i + 1 < statementLength) {
                        char cNext = sql.charAt(i + 1);
                        if (cNext == '*') {
                            for (int j = i += 2; j < statementLength; ++j) {
                                ++i;
                                cNext = sql.charAt(j);
                                if (cNext != '*' || j + 1 >= statementLength || sql.charAt(j + 1) != '/') continue;
                                if (++i < statementLength) {
                                    c = sql.charAt(i);
                                }
                                break;
                            }
                        }
                    } else if (c == '\'' || c == '\"') {
                        inQuotes = true;
                        quoteChar = c;
                    }
                }
            }
            if (c != '?' || inQuotes || inQuotedId) continue;
            this.placeHolderPos.put(this.placeHolderPos.size(), i);
        }
        this.params = new PolarxDatatypes.Any[this.placeHolderPos.size()];
        if (XConfig.GALAXY_X_PROTOCOL) {
            this.gp80Params = new Object[this.placeHolderPos.size()];
            this.gp57Params = null;
        } else {
            this.gp80Params = null;
            this.gp57Params = new GP57Util(this.placeHolderPos.size());
        }
        this.useGalaxyPrepare = DynamicConfig.getInstance().getXprotoGalaxyPrepare();
    }

    public boolean isUseGalaxyPrepare() {
        return this.useGalaxyPrepare;
    }

    public void setUseGalaxyPrepare(boolean useGalaxyPrepare) {
        this.useGalaxyPrepare = useGalaxyPrepare;
    }

    public void setGalaxyDigest(ByteString galaxyDigest) {
        this.galaxyDigest = galaxyDigest;
    }

    private static String surroundWithBacktick(String identifier) {
        if (identifier.contains("`")) {
            return "`" + identifier.replaceAll("`", "``") + "`";
        }
        return "`" + identifier + "`";
    }

    public Pair<BytesSql, List<PolarxDatatypes.Any>> reorganizeParam() {
        return this.reorganizeParam(this.params);
    }

    private Pair<BytesSql, List<PolarxDatatypes.Any>> reorganizeParam(PolarxDatatypes.Any[] params) {
        if (this.bytesSql == null) {
            this.bytesSql = BytesSql.getBytesSql((String)this.sql);
        }
        return new Pair((Object)this.bytesSql, (Object)ImmutableList.copyOf((Object[])params));
    }

    private GPParam galaxyPrepare() {
        if (this.gp57Params != null) {
            return this.gp57Params.genParam();
        }
        return this.galaxyPrepare(this.gp80Params);
    }

    private GPParam galaxyPrepare(Object[] params) {
        ArrayList<GPTable> tables = new ArrayList<GPTable>();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            for (int idx = 0; idx < params.length; ++idx) {
                if (params[idx] instanceof byte[]) {
                    stream.write((byte[])params[idx]);
                    continue;
                }
                assert (params[idx] instanceof String);
                tables.add(new GPTable(idx + 1, (String)params[idx]));
            }
        }
        catch (Exception e) {
            throw GeneralUtil.nestedException((Throwable)e);
        }
        return new GPParam(tables, ByteString.copyFrom((byte[])stream.toByteArray()), params.length - tables.size());
    }

    public XResult executeQueryX() throws SQLException {
        return this.executeQueryX((ByteString)null);
    }

    public XResult executeQueryX(ByteString digest) throws SQLException {
        if (this.useGalaxyPrepare) {
            GPParam newParam = this.galaxyPrepare();
            if (null == this.bytesSql) {
                this.bytesSql = BytesSql.getBytesSql((String)this.sql);
            }
            return this.connection.execGalaxyPrepare(this.bytesSql, this.hint, null == digest ? this.galaxyDigest : digest, newParam.getTables(), newParam.getParams(), newParam.getParamNum(), false, false);
        }
        Pair<BytesSql, List<PolarxDatatypes.Any>> newParam = this.reorganizeParam();
        return this.connection.execQuery((BytesSql)newParam.getKey(), this.hint, (List)newParam.getValue(), false, digest);
    }

    public long executeUpdateX() throws SQLException {
        return this.executeUpdateX((ByteString)null);
    }

    public long executeUpdateX(ByteString digest) throws SQLException {
        if (this.useGalaxyPrepare) {
            GPParam newParam = this.galaxyPrepare();
            if (null == this.bytesSql) {
                this.bytesSql = BytesSql.getBytesSql((String)this.sql);
            }
            XResult result = this.connection.execGalaxyPrepare(this.bytesSql, this.hint, null == digest ? this.galaxyDigest : digest, newParam.getTables(), newParam.getParams(), newParam.getParamNum(), false, true);
            result.finishBlockMode();
            return result.getRowsAffected();
        }
        Pair<BytesSql, List<PolarxDatatypes.Any>> newParam = this.reorganizeParam();
        return this.connection.execUpdate((BytesSql)newParam.getKey(), this.hint, (List<PolarxDatatypes.Any>)((List)newParam.getValue()), false, digest).getRowsAffected();
    }

    public XResult executeUpdateReturningX(String returning) throws SQLException {
        if (this.useGalaxyPrepare) {
            throw new NotSupportException();
        }
        Pair<BytesSql, List<PolarxDatatypes.Any>> newParam = this.reorganizeParam();
        return this.connection.execUpdateReturning((BytesSql)newParam.getKey(), this.hint, (List<PolarxDatatypes.Any>)((List)newParam.getValue()), returning);
    }

    private void setParam(int idx, PolarxDatatypes.Any param) {
        int my_idx = idx - 1;
        this.params[my_idx] = param;
    }

    private void setGp80Param(int idx, Object obj) {
        int my_idx = idx - 1;
        this.gp80Params[my_idx] = obj;
    }

    @Override
    public void close() throws SQLException {
        Arrays.fill(this.params, null);
        if (this.gp57Params != null) {
            this.gp57Params.reset();
        }
        if (this.gp80Params != null) {
            Arrays.fill(this.gp80Params, null);
        }
        this.batch.clear();
        this.gpBatch.clear();
        super.close();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        XResult result = this.executeQueryX();
        return new XResultSet(result);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeUpdateX();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setNull(parameterIndex - 1);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genNull());
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setBoolean(parameterIndex - 1, x);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genBoolean(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genBooleanScalar(x)));
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setTiny(parameterIndex - 1, x, false);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genSInt(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genSIntScalar(x)));
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setShort(parameterIndex - 1, x, false);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genSInt(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genSIntScalar(x)));
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setInt32(parameterIndex - 1, x, false);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genSInt(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genSIntScalar(x)));
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setInt64(parameterIndex - 1, x, false);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genSInt(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genSIntScalar(x)));
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setFloat(parameterIndex - 1, x);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genFloat(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genFloatScalar(x)));
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setDouble(parameterIndex - 1, x);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genDouble(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genDoubleScalar(x)));
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setDecimal(parameterIndex - 1, x);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(x.toPlainString()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8RawStringScalar(x.toPlainString(), null)));
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setString(parameterIndex - 1, x, XSession.toJavaEncoding(this.connection.getSession().getRequestEncodingMySQL()));
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(x));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8StringScalar(x)));
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setBytes(parameterIndex - 1, x, 0, x.length);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genBytes(x, 0, x.length));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genOctetsScalar(ByteBuffer.wrap(x))));
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setString(parameterIndex - 1, x.toString(), StandardCharsets.UTF_8);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(x.toString()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8StringScalar(x.toString())));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setString(parameterIndex - 1, x.toString(), StandardCharsets.UTF_8);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(x.toString()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8StringScalar(x.toString())));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setString(parameterIndex - 1, x.toString(), StandardCharsets.UTF_8);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(x.toString()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8StringScalar(x.toString())));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.set(parameterIndex - 1, x, this.connection.getSession());
            } else {
                this.setGp80Param(parameterIndex, GPUtil.gen(x, this.connection.getSession()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genScalar(x, this.connection.getSession())));
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof RawString) {
            if (this.useGalaxyPrepare) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Use galaxy prepare with raw string."});
            }
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8RawStringScalar(((RawString)x).buildRawString(), this.connection.getSession())));
        } else if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.set(parameterIndex - 1, x, this.connection.getSession());
            } else {
                this.setGp80Param(parameterIndex, GPUtil.gen(x, this.connection.getSession()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genScalar(x, this.connection.getSession())));
        }
    }

    @Override
    public boolean execute() throws SQLException {
        XResult result = this.executeQueryX();
        List<PolarxResultset.ColumnMetaData> metaData = result.getMetaData();
        return metaData != null && metaData.size() != 0;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.useGalaxyPrepare) {
            this.gpBatch.add(this.galaxyPrepare());
            if (this.gp57Params != null) {
                this.gp57Params.reset();
            } else {
                Arrays.fill(this.gp80Params, (Object)0);
            }
        } else {
            this.batch.add((PolarxDatatypes.Any[])this.params.clone());
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
        this.gpBatch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.useGalaxyPrepare) {
            int i;
            XResult[] results = new XResult[this.gpBatch.size()];
            int[] affected = new int[this.gpBatch.size()];
            if (null == this.bytesSql) {
                this.bytesSql = BytesSql.getBytesSql((String)this.sql);
            }
            for (i = 0; i < this.gpBatch.size(); ++i) {
                GPParam newParam = this.gpBatch.get(i);
                results[i] = this.connection.execGalaxyPrepare(this.bytesSql, this.hint, this.galaxyDigest, newParam.getTables(), newParam.getParams(), newParam.getParamNum(), false, true);
            }
            for (i = 0; i < this.gpBatch.size(); ++i) {
                affected[i] = (int)results[i].getRowsAffected();
            }
            return affected;
        }
        XResult[] results = new XResult[this.batch.size()];
        int[] affected = new int[this.batch.size()];
        boolean finishExecute = false;
        try {
            int prev_done = 0;
            for (int i = 0; i < this.batch.size(); ++i) {
                PolarxDatatypes.Any[] paramPair = this.batch.get(i);
                Pair<BytesSql, List<PolarxDatatypes.Any>> newParam = this.reorganizeParam(paramPair);
                if (XConfig.GALAXY_X_PROTOCOL) {
                    results[i] = this.connection.execUpdate((BytesSql)newParam.getKey(), this.hint, (List)newParam.getValue(), false);
                    continue;
                }
                if (i == this.batch.size() - 1) {
                    finishExecute = true;
                }
                results[i] = this.connection.execUpdate((BytesSql)newParam.getKey(), this.hint, (List)newParam.getValue(), !finishExecute);
                results[i].setFatalOnIgnorable(false);
                if (finishExecute || (long)(i - prev_done) <= 64L) continue;
                prev_done = i;
                this.connection.flushNetwork();
                try {
                    while (results[i].next() != null) {
                    }
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.connection.execUpdate("select 'executeBatch abort'");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    finishExecute = true;
                    throw t;
                }
            }
        }
        catch (SQLException e) {
            if (!finishExecute) {
                this.connection.setLastException(e, true);
            }
            throw e;
        }
        catch (Throwable t) {
            if (finishExecute) {
                throw t;
            }
            throw GeneralUtil.nestedException((Throwable)this.connection.setLastException(t, true));
        }
        for (int i = 0; i < this.batch.size(); ++i) {
            affected[i] = (int)results[i].getRowsAffected();
        }
        return affected;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            InputStream inputStream = x.getBinaryStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = inputStream.read(buffer))) {
                outputStream.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            throw new SQLException("XPreparedStatement setBlob error.", e);
        }
        if (this.useGalaxyPrepare) {
            byte[] bytes = outputStream.toByteArray();
            if (this.gp57Params != null) {
                this.gp57Params.setBytes(parameterIndex - 1, bytes, 0, bytes.length);
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genBytes(bytes, 0, bytes.length));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genOctetsScalar(ByteBuffer.wrap(outputStream.toByteArray()))));
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (null == x) {
            if (this.useGalaxyPrepare) {
                if (this.gp57Params != null) {
                    this.gp57Params.setNull(parameterIndex - 1);
                } else {
                    this.setGp80Param(parameterIndex, GPUtil.genNull());
                }
            } else {
                this.setParam(parameterIndex, XUtil.genAny(XUtil.genNullScalar()));
            }
            return;
        }
        StringBuilder builder = new StringBuilder();
        try {
            Reader inputStream = x.getCharacterStream();
            char[] buffer = new char[2048];
            int n = 0;
            while (-1 != (n = inputStream.read(buffer))) {
                builder.append(buffer, 0, n);
            }
        }
        catch (Exception e) {
            throw new SQLException("XPreparedStatement setClob error.", e);
        }
        if (this.useGalaxyPrepare) {
            if (this.gp57Params != null) {
                this.gp57Params.setString(parameterIndex - 1, builder.toString(), XSession.toJavaEncoding(this.connection.getSession().getRequestEncodingMySQL()));
            } else {
                this.setGp80Param(parameterIndex, GPUtil.genUtf8String(builder.toString()));
            }
        } else {
            this.setParam(parameterIndex, XUtil.genAny(XUtil.genUtf8StringScalar(builder.toString())));
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void setHint(byte[] hint) {
        this.hint = hint;
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor, int beginPos) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int inLength = searchIn.length();
        while (beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos))) {
            ++beginPos;
        }
        return XPreparedStatement.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static int findStartOfStatement(String sql) {
        int statementStartPos = 0;
        if (XPreparedStatement.startsWithIgnoreCaseAndWs(sql, "/*", 0)) {
            statementStartPos = sql.indexOf("*/");
            statementStartPos = statementStartPos == -1 ? 0 : (statementStartPos += 2);
        } else if ((XPreparedStatement.startsWithIgnoreCaseAndWs(sql, "--", 0) || XPreparedStatement.startsWithIgnoreCaseAndWs(sql, "#", 0)) && (statementStartPos = sql.indexOf(10)) == -1 && (statementStartPos = sql.indexOf(13)) == -1) {
            statementStartPos = 0;
        }
        return statementStartPos;
    }
}

