/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.compatible;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.common.jdbc.BufferResultSet;
import com.alibaba.polardbx.common.utils.CaseInsensitive;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.compatible.XResultSetMetaData;
import com.alibaba.polardbx.rpc.result.XResult;
import com.alibaba.polardbx.rpc.result.XResultUtil;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxNotice;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class XResultSet
implements BufferResultSet {
    private final XResult result;
    private final XResultSetMetaData metaData;
    private boolean lastWasNull = false;
    private volatile Map<String, Integer> labelCache = null;

    public XResultSet(XResult result) {
        this.result = result;
        this.metaData = new XResultSetMetaData(result);
    }

    public XResult getXResult() {
        return this.result;
    }

    public boolean next() throws SQLException {
        return this.result.next() != null;
    }

    public void close() throws SQLException {
        while (this.result.next() != null) {
        }
        this.result.close();
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        return null == obj ? null : obj.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        return obj != null && ((Number)obj).longValue() != 0L;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? (byte)0 : number.byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? (short)0 : number.shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? 0 : number.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? 0L : number.longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? 0.0f : number.floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number number = (Number)this.getObject(columnIndex);
        return null == number ? 0.0 : number.doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new NotSupportException();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        return obj instanceof String ? ((String)obj).getBytes() : (byte[])obj;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new NotSupportException();
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public SQLWarning getWarnings() throws SQLException {
        PolarxNotice.Warning warning = this.result.getWarning();
        if (warning != null) {
            return new SQLWarning(warning.getMsg(), "", warning.getCode());
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        throw new NotSupportException();
    }

    public String getCursorName() throws SQLException {
        throw new NotSupportException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public Object getObject(int columnIndex) throws SQLException {
        List<PolarxResultset.ColumnMetaData> meta = this.result.getMetaData();
        List<ByteString> data = this.result.current().getRow();
        if (data == null || null == meta) {
            throw new SQLException("Bad result, data or meta is null.");
        }
        if (data.size() != meta.size()) {
            throw new SQLException(String.format("Bad result, data size(%d) is not equal meta size(%d).", data.size(), meta.size()));
        }
        if (columnIndex > meta.size()) {
            throw new SQLException("Bad columnIndex.");
        }
        try {
            Object obj = XResultUtil.resultToObject(meta.get(columnIndex - 1), data.get(columnIndex - 1), true, this.result.getSession().getDefaultTimezone()).getKey();
            this.lastWasNull = null == obj;
            return obj;
        }
        catch (Exception e) {
            throw new SQLException("Failed to read object from XResult.", e);
        }
    }

    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnLabel) throws SQLException {
        try {
            Integer idx;
            List<PolarxResultset.ColumnMetaData> meta = this.result.getMetaData();
            if (null == meta) {
                throw new SQLException("Bad result.");
            }
            if (null == this.labelCache) {
                XResultSet xResultSet = this;
                synchronized (xResultSet) {
                    if (null == this.labelCache) {
                        TreeMap<String, Integer> tmpLabelCache = new TreeMap<String, Integer>(CaseInsensitive.CASE_INSENSITIVE_ORDER);
                        for (int i = 0; i < meta.size(); ++i) {
                            PolarxResultset.ColumnMetaData item = meta.get(i);
                            String table = item.getTable().toString(XSession.toJavaEncoding(this.result.getSession().getResultMetaEncodingMySQL()));
                            String label = item.getName().toString(XSession.toJavaEncoding(this.result.getSession().getResultMetaEncodingMySQL()));
                            tmpLabelCache.put(label, i + 1);
                            tmpLabelCache.put(table + "." + label, i + 1);
                        }
                        this.labelCache = tmpLabelCache;
                    }
                }
            }
            if ((idx = this.labelCache.get(columnLabel)) != null) {
                return idx;
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to find column in XResult.", e);
        }
        throw new SQLException("ResultSet column label '" + columnLabel + "' not found.", "S0022", 0);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(obj.toString());
    }

    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new NotSupportException();
    }

    public boolean isAfterLast() throws SQLException {
        throw new NotSupportException();
    }

    public boolean isFirst() throws SQLException {
        throw new NotSupportException();
    }

    public boolean isLast() throws SQLException {
        throw new NotSupportException();
    }

    public void beforeFirst() throws SQLException {
        throw new NotSupportException();
    }

    public void afterLast() throws SQLException {
        throw new NotSupportException();
    }

    public boolean first() throws SQLException {
        throw new NotSupportException();
    }

    public boolean last() throws SQLException {
        throw new NotSupportException();
    }

    public int getRow() throws SQLException {
        throw new NotSupportException();
    }

    public boolean absolute(int row) throws SQLException {
        throw new NotSupportException();
    }

    public boolean relative(int rows) throws SQLException {
        throw new NotSupportException();
    }

    public boolean previous() throws SQLException {
        throw new NotSupportException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new NotSupportException();
    }

    public int getFetchDirection() throws SQLException {
        throw new NotSupportException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new NotSupportException();
    }

    public int getFetchSize() throws SQLException {
        throw new NotSupportException();
    }

    public int getType() throws SQLException {
        throw new NotSupportException();
    }

    public int getConcurrency() throws SQLException {
        throw new NotSupportException();
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotSupportException();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotSupportException();
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotSupportException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new NotSupportException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNull(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateString(String columnLabel, String x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new NotSupportException();
    }

    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new NotSupportException();
    }

    public void insertRow() throws SQLException {
        throw new NotSupportException();
    }

    public void updateRow() throws SQLException {
        throw new NotSupportException();
    }

    public void deleteRow() throws SQLException {
        throw new NotSupportException();
    }

    public void refreshRow() throws SQLException {
        throw new NotSupportException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new NotSupportException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new NotSupportException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new NotSupportException();
    }

    public Statement getStatement() throws SQLException {
        throw new NotSupportException();
    }

    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new NotSupportException();
    }

    public Ref getRef(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Clob getClob(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Array getArray(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new NotSupportException();
    }

    public Ref getRef(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public Blob getBlob(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public Clob getClob(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public Array getArray(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new NotSupportException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public URL getURL(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new NotSupportException();
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new NotSupportException();
    }

    public int getHoldability() throws SQLException {
        throw new NotSupportException();
    }

    public boolean isClosed() throws SQLException {
        throw new NotSupportException();
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new NotSupportException();
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new NotSupportException();
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new NotSupportException();
    }

    public String getNString(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public String getNString(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new NotSupportException();
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotSupportException();
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new NotSupportException();
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotSupportException();
    }

    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new NotSupportException();
    }

    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new NotSupportException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("not a wrapper for " + iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return XResultSet.class.isAssignableFrom(iface);
    }

    public long estimateCurrentSetSize() {
        if (this.result != null) {
            return this.result.currentPipeSize();
        }
        return 0L;
    }
}

