/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.compatible;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.compatible.ArrayResultSet;
import com.alibaba.polardbx.rpc.compatible.XPreparedStatement;
import com.alibaba.polardbx.rpc.compatible.XResultSet;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.result.XResult;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class XStatement
implements Statement {
    protected final XConnection connection;
    private int fetchSize = 0;
    private List<String> batchSql = new ArrayList<String>();
    private boolean closed = false;

    public XStatement(XConnection connection) {
        this.connection = connection;
    }

    public XResult executeQueryX(String sql) throws SQLException {
        return this.connection.execQuery(sql);
    }

    public XResult executeQueryX(BytesSql sql, byte[] hint, ByteString digest) throws SQLException {
        return this.connection.execQuery(sql, hint, null, false, digest);
    }

    public long executeUpdateX(String sql) throws SQLException {
        return this.connection.execUpdate(sql);
    }

    public long executeUpdateX(BytesSql sql, byte[] hint) throws SQLException {
        return this.connection.execUpdate(sql, hint, null);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        XResult result = this.executeQueryX(sql);
        return new XResultSet(result);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        List<String> multi = this.splitMultiStatement(sql);
        if (multi.size() > 1) {
            long sum = 0L;
            for (String single : multi) {
                sum += this.executeUpdateX(single);
            }
            return (int)sum;
        }
        return (int)this.executeUpdateX(sql);
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.connection.setNetworkTimeout(null, seconds * 1000);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        List<String> multi = this.splitMultiStatement(sql);
        XResult firstResult = null;
        ArrayList<XResult> results = new ArrayList<XResult>();
        for (int i = 0; i < multi.size(); ++i) {
            XResult result = this.connection.execQuery(multi.get(i), null, false);
            if (null == firstResult) {
                firstResult = result;
            }
            results.add(result);
        }
        if (null == firstResult) {
            return false;
        }
        for (XResult result : results) {
            while (result.next() != null) {
            }
        }
        List<PolarxResultset.ColumnMetaData> metaData = firstResult.getMetaData();
        return metaData != null && metaData.size() != 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        this.connection.setStreamMode(rows == Integer.MIN_VALUE);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batchSql.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchSql.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        XResult[] results = new XResult[this.batchSql.size()];
        int[] affecteds = new int[this.batchSql.size()];
        boolean finishExecute = false;
        try {
            int prev_done = 0;
            for (int i = 0; i < this.batchSql.size(); ++i) {
                if (XConfig.GALAXY_X_PROTOCOL) {
                    results[i] = this.connection.execUpdate(this.batchSql.get(i), null, false);
                    continue;
                }
                if (i == this.batchSql.size() - 1) {
                    finishExecute = true;
                }
                results[i] = this.connection.execUpdate(this.batchSql.get(i), null, !finishExecute);
                results[i].setFatalOnIgnorable(false);
                if (finishExecute || (long)(i - prev_done) <= 64L) continue;
                prev_done = i;
                this.connection.flushNetwork();
                try {
                    while (results[i].next() != null) {
                    }
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.connection.execUpdate("select 'executeBatch abort'");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    finishExecute = true;
                    throw t;
                }
            }
        }
        catch (SQLException e) {
            if (!finishExecute) {
                this.connection.setLastException(e, true);
            }
            throw e;
        }
        catch (Throwable t) {
            if (finishExecute) {
                throw t;
            }
            throw GeneralUtil.nestedException((Throwable)this.connection.setLastException(t, true));
        }
        for (int i = 0; i < this.batchSql.size(); ++i) {
            affecteds[i] = (int)results[i].getRowsAffected();
        }
        return affecteds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ArrayResultSet resultSet = new ArrayResultSet();
        resultSet.getColumnName().add("GENERATED_KEY");
        XResult last = this.connection.getLastUserRequest();
        if (last != null && last.isHaveGeneratedInsertId()) {
            resultSet.getRows().add(new Object[]{last.getGeneratedInsertId()});
        }
        return resultSet;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return XStatement.class.isAssignableFrom(iface);
    }

    private List<String> splitMultiStatement(String sql) {
        int startPos = XPreparedStatement.findStartOfStatement(sql);
        int statementLength = sql.length();
        int quotedIdentifierChar = 96;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        boolean inQuotedId = false;
        int start_pos = 0;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = startPos; i < statementLength; ++i) {
            char c = sql.charAt(i);
            if (c == '\\' && i < statementLength - 1) {
                ++i;
                continue;
            }
            if (!inQuotes && c == '`') {
                inQuotedId = !inQuotedId;
            } else if (!inQuotedId) {
                if (inQuotes) {
                    if ((c == '\'' || c == '\"') && c == quoteChar) {
                        if (i < statementLength - 1 && sql.charAt(i + 1) == quoteChar) {
                            ++i;
                            continue;
                        }
                        inQuotes = false;
                        quoteChar = '\u0000';
                    }
                } else {
                    if (c == '#' || c == '-' && i + 1 < statementLength && sql.charAt(i + 1) == '-') {
                        int endOfStmt = statementLength - 1;
                        while (i < endOfStmt && (c = sql.charAt(i)) != '\r' && c != '\n') {
                            ++i;
                        }
                        continue;
                    }
                    if (c == '/' && i + 1 < statementLength) {
                        char cNext = sql.charAt(i + 1);
                        if (cNext == '*') {
                            for (int j = i += 2; j < statementLength; ++j) {
                                ++i;
                                cNext = sql.charAt(j);
                                if (cNext != '*' || j + 1 >= statementLength || sql.charAt(j + 1) != '/') continue;
                                if (++i < statementLength) {
                                    c = sql.charAt(i);
                                }
                                break;
                            }
                        }
                    } else if (c == '\'' || c == '\"') {
                        inQuotes = true;
                        quoteChar = c;
                    }
                }
            }
            if (c != ';' || inQuotes || inQuotedId) continue;
            result.add(sql.substring(start_pos, i));
            start_pos = i + 1;
        }
        if (start_pos < statementLength) {
            result.add(sql.substring(start_pos, statementLength));
        }
        return result;
    }
}

