/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.net;

import com.alibaba.polardbx.rpc.net.NIOConnection;
import com.alibaba.polardbx.rpc.net.NIOReactor;
import com.alibaba.polardbx.rpc.perf.ReactorPerfItem;
import com.alibaba.polardbx.rpc.utils.BufferPool;
import java.io.IOException;

public class NIOProcessor {
    public static final int DEFAULT_BUFFER_SIZE = 0x1000000;
    public static final int DEFAULT_BUFFER_CHUNK_SIZE = 65536;
    private final String name;
    private final NIOReactor reactor;
    private final BufferPool bufferPool;

    public NIOProcessor(String name) throws IOException {
        this(name, 0x1000000, 65536);
    }

    public NIOProcessor(String name, int buffer, int chunk) throws IOException {
        this.name = name;
        this.reactor = new NIOReactor(name);
        this.bufferPool = new BufferPool(buffer, chunk);
    }

    public String getName() {
        return this.name;
    }

    public NIOReactor getReactor() {
        return this.reactor;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void startup() {
        this.reactor.startup();
    }

    public void postRegister(NIOConnection c) {
        this.reactor.postRegister(c);
    }

    public void postWrite(NIOConnection c) {
        this.reactor.postWrite(c);
    }

    public ReactorPerfItem getPerfItem() {
        ReactorPerfItem item = new ReactorPerfItem();
        item.setName(this.name);
        item.setSocketCount(this.reactor.getPerfCollection().getSocketCount().get());
        item.setEventLoopCount(this.reactor.getPerfCollection().getEventLoopCount().get());
        item.setRegisterCount(this.reactor.getPerfCollection().getRegisterCount().get());
        item.setReadCount(this.reactor.getPerfCollection().getReadCount().get());
        item.setWriteCount(this.reactor.getPerfCollection().getWriteCount().get());
        item.setBufferSize((long)this.bufferPool.getChunkSize() * (long)this.bufferPool.capacity());
        item.setBufferChunkSize(this.bufferPool.getChunkSize());
        item.setPooledBufferCount(this.bufferPool.size());
        return item;
    }
}

