/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.net;

import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.net.ErrorCode;
import com.alibaba.polardbx.rpc.net.NIOConnection;
import com.alibaba.polardbx.rpc.perf.ReactorPerfCollection;
import com.alibaba.polardbx.rpc.utils.NotifyQueue;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class NIOReactor {
    private final String name;
    private final R reactorR;
    private final W reactorW;
    private final ReactorPerfCollection perfCollection = new ReactorPerfCollection();

    public NIOReactor(String name) throws IOException {
        this.name = name;
        this.reactorR = new R();
        this.reactorW = new W();
    }

    public ReactorPerfCollection getPerfCollection() {
        return this.perfCollection;
    }

    final void startup() {
        new Thread((Runnable)this.reactorR, this.name + "-R").start();
        new Thread((Runnable)this.reactorW, this.name + "-W").start();
    }

    final void postRegister(NIOConnection c) {
        this.reactorR.registerQueue.offer(c);
        this.reactorR.selector.wakeup();
    }

    final void postWrite(NIOConnection c) {
        this.reactorW.writeQueue.put(c);
    }

    private final class W
    implements Runnable {
        private final NotifyQueue<NIOConnection> writeQueue = new NotifyQueue();

        private W() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        NIOConnection c;
                        if ((c = this.writeQueue.poll(1000000000L, TimeUnit.NANOSECONDS)) == null) {
                            continue;
                        }
                        this.write(c);
                    }
                }
                catch (Throwable e) {
                    XLog.XLogLogger.warn(NIOReactor.this.name, e);
                    continue;
                }
                break;
            }
        }

        private void write(NIOConnection c) {
            try {
                c.writeByQueue();
            }
            catch (Throwable e) {
                c.handleError(ErrorCode.ERR_WRITE_BY_QUEUE, e);
            }
        }
    }

    private final class R
    implements Runnable {
        private final Selector selector = Selector.open();
        private final ConcurrentLinkedQueue<NIOConnection> registerQueue = new ConcurrentLinkedQueue();

        private R() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = this.selector;
            while (true) {
                try {
                    block6: while (true) {
                        selector.select(1000L);
                        this.register(selector);
                        Set<SelectionKey> keys = selector.selectedKeys();
                        try {
                            NIOReactor.this.perfCollection.getEventLoopCount().getAndIncrement();
                            Iterator<SelectionKey> iterator = keys.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block6;
                                SelectionKey key = iterator.next();
                                Object att = key.attachment();
                                if (att != null && key.isValid()) {
                                    int readyOps = key.readyOps();
                                    if ((readyOps & 1) != 0) {
                                        this.read((NIOConnection)att);
                                        continue;
                                    }
                                    if ((readyOps & 4) != 0) {
                                        this.write((NIOConnection)att);
                                        continue;
                                    }
                                    key.cancel();
                                    continue;
                                }
                                key.cancel();
                            }
                        }
                        finally {
                            keys.clear();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    XLog.XLogLogger.warn(NIOReactor.this.name, e);
                    continue;
                }
                break;
            }
        }

        private void register(Selector selector) {
            NIOConnection c;
            while ((c = this.registerQueue.poll()) != null) {
                try {
                    NIOReactor.this.perfCollection.getRegisterCount().getAndIncrement();
                    c.register(selector);
                }
                catch (Throwable e) {
                    c.handleError(ErrorCode.ERR_REGISTER, e);
                }
            }
        }

        private void read(NIOConnection c) {
            try {
                NIOReactor.this.perfCollection.getReadCount().getAndIncrement();
                c.read();
            }
            catch (Throwable e) {
                c.handleError(ErrorCode.ERR_READ, e);
            }
        }

        private void write(NIOConnection c) {
            try {
                NIOReactor.this.perfCollection.getWriteCount().getAndIncrement();
                c.writeByEvent();
            }
            catch (Throwable e) {
                c.handleError(ErrorCode.ERR_WRITE_BY_EVENT, e);
            }
        }
    }
}

