/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.net;

import com.alibaba.polardbx.common.utils.logger.Logger;
import com.alibaba.polardbx.common.utils.logger.LoggerFactory;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.net.NIOProcessor;

public class NIOWorker {
    private static final Logger logger = LoggerFactory.getLogger(NIOWorker.class);
    private final NIOProcessor[] processors;
    private int index = 0;
    private static int MAX_THREADS = 32;
    private static long MAX_BUF_SIZE = 0x10000000L;

    public NIOWorker(int threadNumber) {
        long bufPerThread;
        if (threadNumber > MAX_THREADS) {
            threadNumber = MAX_THREADS;
        }
        if ((bufPerThread = MAX_BUF_SIZE / (long)threadNumber) > 0x1000000L) {
            bufPerThread = 0x1000000L;
        }
        XLog.XLogLogger.info("XProtocol NIOWorker start with " + threadNumber + " threads and " + bufPerThread + " bytes buf per thread.");
        this.processors = new NIOProcessor[threadNumber];
        try {
            for (int i = 0; i < threadNumber; ++i) {
                this.processors[i] = new NIOProcessor("X-NIO-Worker-" + i, (int)bufPerThread, 65536);
                this.processors[i].startup();
            }
        }
        catch (Throwable e) {
            XLog.XLogLogger.error(e);
            logger.error(e);
            System.exit(-1);
        }
    }

    public NIOProcessor[] getProcessors() {
        return this.processors;
    }

    public NIOProcessor getProcessor() {
        return this.processors[++this.index % this.processors.length];
    }

    static {
        if (System.getenv("cpu_cores") != null) {
            try {
                MAX_THREADS = Integer.parseInt(System.getenv("cpu_cores")) * 2;
            }
            catch (Throwable e) {
                XLog.XLogLogger.warn(e);
            }
        }
        try {
            long max = Runtime.getRuntime().maxMemory();
            long sz = 0x100000L;
            while (sz * 20L < max) {
                sz <<= 1;
            }
            MAX_BUF_SIZE = sz;
        }
        catch (Throwable e) {
            XLog.XLogLogger.warn(e);
        }
    }
}

