/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.packet;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.mysql.cj.polarx.protobuf.PolarxSql;
import com.mysql.cj.x.protobuf.PolarxExecPlan;

public class XPacketBuilder {
    final long sessionId;
    final PolarxExecPlan.ExecPlan.Builder planBuilder;
    final PolarxExecPlan.AnyPlan plan;
    final PolarxSql.StmtExecute.Builder sqlBuilder;
    final BytesSql sql;
    final String encoding;
    final PolarxSql.GalaxyPrepareExecute.Builder galaxyPrepareBuilder;
    final ByteString extraPrefix;

    public XPacketBuilder(long sessionId, PolarxExecPlan.ExecPlan.Builder planBuilder, PolarxExecPlan.AnyPlan plan) {
        this.sessionId = sessionId;
        this.planBuilder = planBuilder;
        this.plan = plan;
        this.sqlBuilder = null;
        this.sql = null;
        this.encoding = null;
        this.galaxyPrepareBuilder = null;
        this.extraPrefix = null;
    }

    public XPacketBuilder(long sessionId, PolarxSql.StmtExecute.Builder sqlBuilder, BytesSql sql, String encoding) {
        this.sessionId = sessionId;
        this.planBuilder = null;
        this.plan = null;
        this.sqlBuilder = sqlBuilder;
        this.sql = sql;
        this.encoding = encoding;
        this.galaxyPrepareBuilder = null;
        this.extraPrefix = null;
    }

    public XPacketBuilder(long sessionId, PolarxSql.GalaxyPrepareExecute.Builder galaxyPrepareBuilder, BytesSql sql, String encoding, ByteString extraPrefix) {
        this.sessionId = sessionId;
        this.planBuilder = null;
        this.plan = null;
        this.sqlBuilder = null;
        this.sql = sql;
        this.encoding = encoding;
        this.galaxyPrepareBuilder = galaxyPrepareBuilder;
        this.extraPrefix = extraPrefix;
    }

    public boolean isPlan() {
        return this.planBuilder != null;
    }

    public boolean isSql() {
        return this.sqlBuilder != null;
    }

    public boolean isGalaxyPrepare() {
        return this.galaxyPrepareBuilder != null;
    }

    public XPacket build() {
        if (this.planBuilder != null) {
            assert (this.plan != null);
            this.planBuilder.setPlan(this.plan);
            JsonFormat format = new JsonFormat();
            this.planBuilder.setAuditStr(ByteString.copyFromUtf8((String)format.printToString((Message)this.planBuilder.getPlan())));
            return new XPacket(this.sessionId, 100, this.planBuilder.build());
        }
        if (this.sqlBuilder != null) {
            assert (this.sql != null);
            assert (this.encoding != null);
            try {
                this.sqlBuilder.setStmt(this.sql.byteString(this.encoding));
            }
            catch (Exception e) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{e.getMessage()});
            }
            return new XPacket(this.sessionId, 101, this.sqlBuilder.build());
        }
        assert (this.galaxyPrepareBuilder != null);
        assert (this.sql != null);
        assert (this.encoding != null);
        try {
            this.galaxyPrepareBuilder.setStmt(null == this.extraPrefix ? this.sql.byteString(this.encoding) : this.extraPrefix.concat(this.sql.byteString(this.encoding)));
        }
        catch (Exception e) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{e.getMessage()});
        }
        return new XPacket(this.sessionId, 102, this.galaxyPrepareBuilder.build());
    }
}

