/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.packet;

import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.utils.NotifyQueue;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class XPacketQueue
extends NotifyQueue<XPacket> {
    private final AtomicLong bufferSize = new AtomicLong(0L);

    @Override
    public void put(XPacket xPacket) {
        this.bufferSize.getAndAdd(xPacket.getPacketSize());
        super.put(xPacket);
    }

    @Override
    public void put(Collection<? extends XPacket> c) {
        for (XPacket xPacket : c) {
            this.bufferSize.getAndAdd(xPacket.getPacketSize());
        }
        super.put(c);
    }

    @Override
    public XPacket poll(long timeout, TimeUnit unit) throws InterruptedException {
        XPacket xPacket = (XPacket)super.poll(timeout, unit);
        if (xPacket != null) {
            this.bufferSize.getAndAdd(-xPacket.getPacketSize());
        }
        return xPacket;
    }

    public long getBufferSize() {
        return this.bufferSize.get();
    }
}

