/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.pool;

import com.alibaba.polardbx.common.eventlogger.EventLogger;
import com.alibaba.polardbx.common.eventlogger.EventType;
import com.alibaba.polardbx.common.exception.TddlNestableRuntimeException;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.properties.DynamicConfig;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.client.XClient;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.perf.DnPerfCollection;
import com.alibaba.polardbx.rpc.perf.DnPerfItem;
import com.alibaba.polardbx.rpc.perf.SessionPerfItem;
import com.alibaba.polardbx.rpc.perf.TcpPerfItem;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import com.alibaba.polardbx.rpc.result.XResult;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public class XClientPool {
    private final XConnectionManager manager;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Set<String> instInfo = new CopyOnWriteArraySet<String>();
    private final List<XClient> clients = new CopyOnWriteArrayList<XClient>();
    private final AtomicInteger clientRR = new AtomicInteger(0);
    private final List<XClient> agingClients = new CopyOnWriteArrayList<XClient>();
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final Queue<XSession> idleSessions = new ConcurrentLinkedQueue<XSession>();
    private final AtomicInteger idleCount = new AtomicInteger(0);
    private final DnPerfCollection perfCollection = new DnPerfCollection();
    private DnPerfItem lastItem = null;
    private long lastNanos = 0L;

    public XClientPool(XConnectionManager manager, String host, int port, String username, String password) {
        this.manager = manager;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getInstInfo() {
        return this.instInfo;
    }

    public int getNowPoolSize() {
        return this.clients.size();
    }

    private int getAliveSessionCount() {
        int count = 0;
        for (int retry = 0; retry < 10; ++retry) {
            try {
                int clientSize = this.clients.size();
                for (int i = 0; i < clientSize; ++i) {
                    count += this.clients.get(i).getWorkingSessionCount();
                }
                return count;
            }
            catch (IndexOutOfBoundsException ignore) {
                count = 0;
                continue;
            }
        }
        return 0;
    }

    public XStatus getStatus() {
        XStatus status = new XStatus();
        status.client = this.clients.size();
        status.idleSession = this.idleCount.get();
        status.workingSession = this.getAliveSessionCount();
        status.workingSession = status.workingSession >= status.idleSession ? (status.workingSession -= status.idleSession) : 0;
        return status;
    }

    public AtomicInteger getRefCount() {
        return this.refCount;
    }

    public boolean isInUse() {
        return this.refCount.get() > 0;
    }

    public DnPerfCollection getPerfCollection() {
        return this.perfCollection;
    }

    public String getDnTag() {
        return XConnectionManager.digest(this.host, this.port, this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnPerfItem getPerfItem() {
        DnPerfItem item = new DnPerfItem();
        item.setDnTag(this.getDnTag());
        item.setSendMsgCount(this.perfCollection.getSendMsgCount().get());
        item.setSendFlushCount(this.perfCollection.getSendFlushCount().get());
        item.setSendSize(this.perfCollection.getSendSize().get());
        item.setRecvNetCount(this.perfCollection.getRecvNetCount().get());
        item.setRecvMsgCount(this.perfCollection.getRecvMsgCount().get());
        item.setRecvSize(this.perfCollection.getRecvSize().get());
        item.setSessionCreateCount(this.perfCollection.getSessionCreateCount().get());
        item.setSessionDropCount(this.perfCollection.getSessionDropCount().get());
        item.setSessionCreateSuccessCount(this.perfCollection.getSessionCreateSuccessCount().get());
        item.setSessionCreateFailCount(this.perfCollection.getSessionCreateFailCount().get());
        item.setSessionActiveCount(this.perfCollection.getSessionActiveCount().get());
        item.setGetConnectionCount(this.perfCollection.getGetConnectionCount().get());
        XClientPool xClientPool = this;
        synchronized (xClientPool) {
            if (null == this.lastItem) {
                this.lastItem = item;
                this.lastNanos = System.nanoTime();
            } else {
                long nanos = System.nanoTime();
                long delta = nanos - this.lastNanos;
                if (delta > 0L) {
                    item.setSendMsgRate((double)(item.getSendMsgCount() - this.lastItem.getSendMsgCount()) * 1.0E9 / (double)delta);
                    item.setSendFlushRate((double)(item.getSendFlushCount() - this.lastItem.getSendFlushCount()) * 1.0E9 / (double)delta);
                    item.setSendRate((double)(item.getSendSize() - this.lastItem.getSendSize()) * 1.0E9 / (double)delta);
                    item.setRecvMsgRate((double)(item.getRecvMsgCount() - this.lastItem.getRecvMsgCount()) * 1.0E9 / (double)delta);
                    item.setRecvNetRate((double)(item.getRecvNetCount() - this.lastItem.getRecvNetCount()) * 1.0E9 / (double)delta);
                    item.setRecvRate((double)(item.getRecvSize() - this.lastItem.getRecvSize()) * 1.0E9 / (double)delta);
                    item.setSessionCreateRate((double)(item.getSessionCreateCount() - this.lastItem.getSessionCreateCount()) * 1.0E9 / (double)delta);
                    item.setSessionDropRate((double)(item.getSessionDropCount() - this.lastItem.getSessionDropCount()) * 1.0E9 / (double)delta);
                    item.setSessionCreateSuccessRate((double)(item.getSessionCreateSuccessCount() - this.lastItem.getSessionCreateSuccessCount()) * 1.0E9 / (double)delta);
                    item.setSessionCreateFailRate((double)(item.getSessionCreateFailCount() - this.lastItem.getSessionCreateFailCount()) * 1.0E9 / (double)delta);
                    item.setGatherTimeDelta((double)delta / 1.0E9);
                }
                if ((double)delta >= 1.0E9) {
                    this.lastItem = item;
                    this.lastNanos = nanos;
                }
            }
        }
        int aliveSize = this.clients.size();
        int agingSize = this.agingClients.size();
        item.setTcpTotalCount(aliveSize + agingSize);
        item.setTcpAgingCount(agingSize);
        ArrayList<XClient> copy = new ArrayList<XClient>();
        copy.addAll(this.clients);
        copy.addAll(this.agingClients);
        item.setSessionCount(copy.stream().mapToLong(XClient::getWorkingSessionCount).sum());
        item.setSessionIdleCount(this.idleCount.get());
        item.setRefCount(this.refCount.get());
        return item;
    }

    public void gatherTcpPerf(List<TcpPerfItem> list) {
        XClient[] aging;
        XClient[] working;
        for (XClient client : working = this.clients.toArray(new XClient[0])) {
            TcpPerfItem tcp = client.getPerfItem();
            tcp.setTcpState(TcpPerfItem.TcpState.Working);
            list.add(tcp);
        }
        for (XClient client : aging = this.agingClients.toArray(new XClient[0])) {
            TcpPerfItem tcp = client.getPerfItem();
            tcp.setTcpState(TcpPerfItem.TcpState.Aging);
            list.add(tcp);
        }
    }

    public void gatherSessionPerf(List<SessionPerfItem> list) {
        XClient[] aging;
        XClient[] working;
        for (XClient client : working = this.clients.toArray(new XClient[0])) {
            client.gatherSessionPerf(list);
        }
        for (XClient client : aging = this.agingClients.toArray(new XClient[0])) {
            client.gatherSessionPerf(list);
        }
    }

    public boolean reuseSession(XSession session) {
        if (this.idleCount.get() < this.manager.getMaxPooledSessionPerInstance() && session.reusable()) {
            this.idleCount.getAndIncrement();
            this.idleSessions.offer(session);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection getConnection(BiFunction<XClient, XPacket, Boolean> consumer, long timeoutNanos) throws Exception {
        long concurrent = this.perfCollection.getSessionActiveCount().get();
        long wait = this.perfCollection.getGetConnectionCount().get();
        long waitThresh = DynamicConfig.getInstance().getXprotoMaxDnWaitConnection();
        if (concurrent > DynamicConfig.getInstance().getXprotoMaxDnConcurrent() || wait > waitThresh) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{"Max concurrent or wait exceed. now concurrent: " + concurrent + " wait: " + wait + '.'});
        }
        try {
            this.perfCollection.getGetConnectionCount().getAndIncrement();
            XConnection xConnection = this.getConnection(consumer, timeoutNanos, false);
            return xConnection;
        }
        finally {
            this.perfCollection.getGetConnectionCount().getAndDecrement();
        }
    }

    public String diagnose() {
        ArrayList<XClient> copy = new ArrayList<XClient>();
        copy.addAll(this.clients);
        copy.addAll(this.agingClients);
        return this + " now " + this.clients.size() + " TCP(" + this.agingClients.size() + " aging), " + copy.stream().mapToLong(XClient::getWorkingSessionCount).sum() + " sessions(" + this.perfCollection.getSessionActiveCount().get() + " running, " + this.idleCount.get() + " idle), " + this.perfCollection.getGetConnectionCount().get() + " waiting connection.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection getConnection(BiFunction<XClient, XPacket, Boolean> consumer, long timeoutNanos, boolean forceAlloc) throws Exception {
        XConnection newConnection;
        XClient newClient;
        long nowNanos;
        long startNanos = System.nanoTime();
        block35: while (true) {
            Object connection;
            XClient client;
            int i;
            if (!this.isInUse()) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " not in use."});
            }
            if (!forceAlloc) {
                XSession pooled;
                while ((pooled = this.idleSessions.poll()) != null) {
                    this.idleCount.getAndDecrement();
                    try {
                        if (pooled.reset()) {
                            if (XLog.XProtocolLogger.isInfoEnabled()) {
                                pooled.recordThreadContext();
                            }
                            try {
                                XConnection connection2 = new XConnection(pooled);
                                connection2.init(0L);
                                connection2.setConnectNano(0L);
                                connection2.setWaitNano(System.nanoTime() - startNanos);
                                return connection2;
                            }
                            catch (Throwable e) {
                                XLog.XLogLogger.error(e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    pooled.getClient().dropSession(pooled);
                }
            }
            int clientSize = this.clients.size();
            for (i = 0; i < clientSize; ++i) {
                try {
                    client = this.clients.get(i);
                }
                catch (IndexOutOfBoundsException ignore) {
                    continue block35;
                }
                if (!client.isActive() || 0 != client.getWorkingSessionCount()) continue;
                connection = client.newXConnection(this.manager.getIdGenerator());
                if (client.reusable()) {
                    try {
                        long initTimeoutNanos = startNanos + timeoutNanos - System.nanoTime();
                        if (initTimeoutNanos < 1000000000L) {
                            initTimeoutNanos = 1000000000L;
                        }
                        ((XConnection)connection).init(initTimeoutNanos);
                        ((XConnection)connection).setConnectNano(0L);
                        ((XConnection)connection).setWaitNano(System.nanoTime() - startNanos);
                        return connection;
                    }
                    catch (Throwable e) {
                        XLog.XLogLogger.error(e);
                        try {
                            ((XConnection)connection).close();
                        }
                        catch (Throwable t) {
                            XLog.XLogLogger.error(t);
                        }
                        throw new TddlNestableRuntimeException("Failed to init new session on an empty TCP.", e);
                    }
                }
                try {
                    ((XConnection)connection).close();
                    continue;
                }
                catch (Throwable t) {
                    XLog.XLogLogger.error(t);
                }
            }
            if (clientSize >= this.manager.getMaxClientPerInstance()) {
                for (i = 0; i < clientSize; ++i) {
                    try {
                        client = this.clients.get(this.clientRR.getAndIncrement() % clientSize);
                    }
                    catch (IndexOutOfBoundsException ignore) {
                        continue block35;
                    }
                    if (!client.isActive() || client.getWorkingSessionCount() >= this.manager.getMaxSessionPerClient()) continue;
                    connection = client.newXConnection(this.manager.getIdGenerator());
                    if (client.reusable()) {
                        try {
                            long initTimeoutNanos = startNanos + timeoutNanos - System.nanoTime();
                            if (initTimeoutNanos < 1000000000L) {
                                initTimeoutNanos = 1000000000L;
                            }
                            ((XConnection)connection).init(initTimeoutNanos);
                            ((XConnection)connection).setConnectNano(0L);
                            ((XConnection)connection).setWaitNano(System.nanoTime() - startNanos);
                            return connection;
                        }
                        catch (Throwable e) {
                            XLog.XLogLogger.error(e);
                            try {
                                ((XConnection)connection).close();
                            }
                            catch (Throwable t) {
                                XLog.XLogLogger.error(t);
                            }
                            throw new TddlNestableRuntimeException("Failed to init new session on a non-empty TCP.", e);
                        }
                    }
                    try {
                        ((XConnection)connection).close();
                        continue;
                    }
                    catch (Throwable t) {
                        XLog.XLogLogger.error(t);
                    }
                }
            }
            connection = this.clients;
            synchronized (connection) {
                int nowPoolSize = this.clients.size();
                nowNanos = System.nanoTime();
                if (nowNanos - startNanos >= timeoutNanos) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CONNECTION, new String[]{this + " get XConnection timeout. " + timeoutNanos + "ns"});
                }
                if (nowPoolSize < this.manager.getMaxClientPerInstance()) {
                    newClient = new XClient(this.manager.getEventWorker(), this, consumer, timeoutNanos);
                    try {
                        newConnection = newClient.newXConnection(this.manager.getIdGenerator());
                    }
                    catch (Throwable e) {
                        XLog.XLogLogger.error(e);
                        newClient.close();
                        throw new TddlNestableRuntimeException("Failed to allocate session on a new TCP.", e);
                    }
                    this.clients.add(newClient);
                } else {
                    newClient = null;
                    newConnection = null;
                }
            }
            if (null != newClient) break;
            Thread.sleep(10L);
        }
        long connectStartNanos = System.nanoTime();
        try {
            if (!newClient.waitChannel()) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " connect fail."});
            }
            nowNanos = System.nanoTime();
            long initTimeoutNanos = startNanos + timeoutNanos - nowNanos;
            if (initTimeoutNanos <= 1000000000L) {
                initTimeoutNanos = 1000000000L;
            }
            newClient.initClient(this.manager.getIdGenerator(), initTimeoutNanos);
        }
        catch (Exception e) {
            try {
                newConnection.close();
            }
            catch (Throwable t) {
                XLog.XLogLogger.error(t);
            }
            this.removeClient(newClient, e.getMessage());
            throw new TddlNestableRuntimeException("Failed to init new TCP.", (Throwable)e);
        }
        if (!this.isInUse()) {
            try {
                newConnection.close();
            }
            catch (Throwable t) {
                XLog.XLogLogger.error(t);
            }
            TddlRuntimeException e = new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{this + " not in use."});
            this.removeClient(newClient, e.getMessage());
            throw e;
        }
        try {
            long initTimeoutNanos = startNanos + timeoutNanos - System.nanoTime();
            if (initTimeoutNanos < 1000000000L) {
                initTimeoutNanos = 1000000000L;
            }
            newConnection.init(initTimeoutNanos);
            newConnection.setWaitNano(connectStartNanos - startNanos);
            newConnection.setConnectNano(System.nanoTime() - connectStartNanos);
            return newConnection;
        }
        catch (Throwable e) {
            XLog.XLogLogger.error(e);
            try {
                newConnection.close();
            }
            catch (Throwable t) {
                XLog.XLogLogger.error(t);
            }
            throw new TddlNestableRuntimeException("Failed to init new session on a new TCP.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(XClient client, String msg) {
        List<XClient> list = this.clients;
        synchronized (list) {
            this.clients.remove(client);
        }
        list = this.agingClients;
        synchronized (list) {
            this.agingClients.remove(client);
        }
        client.setFatalError((Throwable)new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{msg}));
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupClient(ThreadPoolExecutor executor) {
        Object client;
        XSession pooled;
        long nowNanos = System.nanoTime();
        int cnt = this.idleCount.get();
        int idx = 0;
        while ((pooled = this.idleSessions.poll()) != null) {
            this.idleCount.getAndDecrement();
            boolean exit = ++idx >= cnt || nowNanos - pooled.getLastPacketNanos() < 10000000000L;
            try {
                if (pooled.reset() && this.reuseSession(pooled)) {
                    pooled = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (pooled != null) {
                XLog.XLogLogger.debug("Drop session not reusable. " + pooled);
                try {
                    pooled.getClient().dropSession(pooled);
                }
                catch (Throwable t) {
                    XLog.XLogLogger.error(t);
                }
            }
            if (!exit) continue;
            break;
        }
        Object copy = ImmutableList.copyOf(this.clients);
        Iterator exit = copy.iterator();
        while (exit.hasNext()) {
            boolean removed;
            client = (XClient)exit.next();
            if (!((XClient)client).isOld() || this.agingClients.size() > 3 * this.manager.getMaxClientPerInstance()) continue;
            List<XClient> list = this.clients;
            synchronized (list) {
                removed = this.clients.remove(client);
            }
            if (!removed) continue;
            XLog.XLogLogger.info(client + " move to aging queue.");
            this.agingClients.add((XClient)client);
            ((XClient)client).markNotReusable();
        }
        ArrayList<XClient> aliveAging = new ArrayList<XClient>();
        copy = ImmutableList.copyOf(this.agingClients);
        client = copy.iterator();
        while (client.hasNext()) {
            XClient client2 = (XClient)client.next();
            if (0 == client2.getWorkingSessionCount()) {
                XLog.XLogLogger.info(client2 + " aging close.");
                executor.execute(() -> this.removeClient(client2, "Client removedClient removed safe."));
                continue;
            }
            aliveAging.add(client2);
        }
        int probeTimeout = DynamicConfig.getInstance().getXprotoProbeTimeout();
        copy = new ArrayList();
        copy.addAll(this.clients);
        copy.addAll(aliveAging);
        Iterator client2 = copy.iterator();
        while (client2.hasNext()) {
            XClient client3 = (XClient)client2.next();
            executor.execute(() -> {
                if (client3.isBad() || probeTimeout > 0 && client3.needProb() && !client3.probe(this.manager.getIdGenerator(), 1000000L * (long)probeTimeout)) {
                    EventLogger.log((EventType)EventType.XRPC_KILL_CLIENT, (String)("TCP kill " + client3));
                    XLog.XLogLogger.warn("Found bad " + client3 + " and remove it.");
                    this.removeClient(client3, "Client removed.");
                } else if (client3.isActive()) {
                    try {
                        client3.shrinkBuffer();
                        client3.refreshVariables(this.manager.getIdGenerator(), 5000000000L);
                    }
                    catch (Exception e) {
                        XLog.XLogLogger.error("Error when refresh variables on " + client3 + ".");
                        XLog.XLogLogger.error((Throwable)e);
                    }
                }
            });
        }
        int aliveCnt = this.getAliveSessionCount();
        if (aliveCnt < XConnectionManager.getInstance().getMinPooledSessionPerInstance()) {
            int allocCnt = (XConnectionManager.getInstance().getMinPooledSessionPerInstance() - aliveCnt + 1) * 2 / 3;
            XLog.XLogLogger.debug("Pre-alloc connection cnt " + allocCnt + " on " + this);
            for (int i = 0; i < allocCnt; ++i) {
                executor.execute(() -> {
                    try (XConnection connection = this.getConnection(XConnectionManager.getInstance().getPacketConsumer(), 2000000000L, true);){
                        int originalNetworkTimeout = connection.getNetworkTimeout();
                        try {
                            connection.setNetworkTimeoutNanos(2000000000L);
                            try (XResult result = connection.execQuery("/*X pre alloc*/ select 1");){
                                while (result.next() != null) {
                                }
                            }
                        }
                        finally {
                            connection.setNetworkTimeout(null, originalNetworkTimeout);
                        }
                    }
                    catch (Exception e) {
                        XLog.XLogLogger.error((Throwable)e);
                    }
                });
            }
        }
        if (XLog.XProtocolLogger.isDebugEnabled()) {
            copy = new ArrayList();
            copy.addAll(this.clients);
            copy.addAll(this.agingClients);
            XLog.XLogLogger.info("Now cleanup on " + this + " ref:" + this.refCount.get() + " conc: " + this.perfCollection.getSessionActiveCount().get());
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                XClient client4 = (XClient)iterator.next();
                client4.getWorkingSessionMap().values().stream().filter(s -> !this.idleSessions.contains(s)).forEach(s -> XLog.XLogLogger.info("Running: " + (null == s.getLastRequest() ? "null" : s.getLastRequest().getSql())));
            }
            XLog.XLogLogger.info("Total sess cnt: " + XSession.GLOBAL_COUNTER.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        ImmutableList copy = ImmutableList.copyOf(this.clients);
        for (XClient client : copy) {
            boolean removed;
            List<XClient> list = this.clients;
            synchronized (list) {
                removed = this.clients.remove(client);
            }
            if (!removed) continue;
            XLog.XLogLogger.info(client + " force reload and move to aging queue.");
            this.agingClients.add(client);
            client.markNotReusable();
        }
        XLog.XLogLogger.info(this + " reload done.");
    }

    public void shutdown() {
        XLog.XLogLogger.info(this + " shutdown.");
        ArrayList<XClient> copy = new ArrayList<XClient>();
        copy.addAll(this.clients);
        copy.addAll(this.agingClients);
        for (XClient client : copy) {
            this.removeClient(client, "Datasource shutdown.");
        }
    }

    public String toString() {
        return "XClientPool to " + this.getDnTag();
    }

    public static class XStatus {
        public int client;
        public int idleSession;
        public int workingSession;
    }
}

