/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.pool;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.common.properties.DynamicConfig;
import com.alibaba.polardbx.rpc.GalaxyPrepare.GPTable;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.client.XClient;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.compatible.XDataSource;
import com.alibaba.polardbx.rpc.compatible.XPreparedStatement;
import com.alibaba.polardbx.rpc.compatible.XStatement;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import com.alibaba.polardbx.rpc.result.XResult;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxNotice;
import com.mysql.cj.polarx.protobuf.PolarxPhysicalBackfill;
import com.mysql.cj.x.protobuf.PolarxDatatypes;
import com.mysql.cj.x.protobuf.PolarxExecPlan;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class XConnection
implements AutoCloseable,
Connection {
    private ReentrantReadWriteLock sessionLock = new ReentrantReadWriteLock();
    private XSession session;
    private boolean initialized = false;
    private boolean streamMode = false;
    private boolean compactMetadata = false;
    private boolean withFeedback = false;
    private long capabilities = 0L;
    private int defaultTokenKb = DynamicConfig.getInstance().getXprotoFlowControlSizeKb();
    private String traceId = null;
    private long connectNano = 0L;
    private long waitNano = 0L;
    private XDataSource dataSource = null;
    private Executor networkTimeoutExecutor = null;
    private long networkTimeoutNanos = 0L;
    private boolean autoCommit = true;

    public XConnection(XSession session) {
        this.session = session;
        if (XConnectionManager.getInstance().isEnableTrxLeakCheck()) {
            this.session.recordStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long timeoutNanos) throws SQLException {
        if (!this.initialized) {
            this.sessionLock.readLock().lock();
            long orgTimeout = this.networkTimeoutNanos;
            try {
                if (timeoutNanos > 0L) {
                    this.networkTimeoutNanos = timeoutNanos;
                }
                this.session.setAutoCommit(this, true);
                this.session.refereshConnetionId(this);
            }
            finally {
                this.networkTimeoutNanos = orgTimeout;
                this.sessionLock.readLock().unlock();
            }
            this.initialized = true;
        }
    }

    private void check() throws SQLException {
        if (null == this.session) {
            throw new SQLException(this + " closed.", "Closed.");
        }
        if (!this.initialized) {
            throw new SQLException(this + " not initialized.", "Not initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        this.sessionLock.writeLock().lock();
        try {
            if (this.session == null) return;
            try {
                if (!this.session.isAutoCommit()) {
                    this.session.execUpdate(this, BytesSql.getBytesSql((String)"rollback"), null, null, true, null);
                }
                this.session.flushIgnorable(this);
                XResult lastRequest = this.session.getLastRequest();
                if (lastRequest == null) return;
                if (lastRequest.isGoodAndDone()) return;
                for (XResult probe = lastRequest; probe != null; probe = probe.getPrevious()) {
                    XLog.XLogLogger.error(this + " last req: " + probe.getSql().toString() + " status:" + probe.getStatus().toString());
                }
                XLog.XLogLogger.error(this + " last req unclosed. " + lastRequest.getSql());
                this.session.kill(true);
                return;
            }
            catch (Throwable e) {
                this.session.setLastException(e, true);
                XLog.XLogLogger.error(e);
                return;
            }
            finally {
                XClient parent = this.session.getClient();
                try {
                    if (!parent.reuseSession(this.session)) {
                        parent.dropSession(this.session);
                    }
                }
                catch (Throwable e) {
                    XLog.XLogLogger.error(this + " failed to check session.");
                    XLog.XLogLogger.error(e);
                    try {
                        parent.dropSession(this.session);
                    }
                    catch (Exception e1) {
                        XLog.XLogLogger.error(this + " failed to drop session.");
                        XLog.XLogLogger.error(e);
                    }
                }
                finally {
                    this.session = null;
                }
            }
        }
        finally {
            this.sessionLock.writeLock().unlock();
        }
    }

    public XSession getSessionUncheck() {
        return this.session;
    }

    public XSession getSession() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XSession xSession = this.session;
            return xSession;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    public void setStreamMode(boolean streamMode) {
        this.streamMode = streamMode;
    }

    public boolean isCompactMetadata() {
        return this.compactMetadata;
    }

    public void setCompactMetadata(boolean compactMetadata) {
        this.compactMetadata = compactMetadata;
    }

    public boolean isWithFeedback() {
        return this.withFeedback;
    }

    public void setWithFeedback(boolean withFeedback) {
        this.withFeedback = withFeedback;
    }

    public long getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(long capabilities) {
        this.capabilities = capabilities;
    }

    public int getDefaultTokenKb() {
        return this.defaultTokenKb;
    }

    public void setDefaultTokenKb(int defaultTokenKb) {
        this.defaultTokenKb = defaultTokenKb;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public long getConnectNano() {
        return this.connectNano;
    }

    public void setConnectNano(long connectNano) {
        this.connectNano = connectNano;
    }

    public long getWaitNano() {
        return this.waitNano;
    }

    public void setWaitNano(long waitNano) {
        this.waitNano = waitNano;
    }

    public XDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(XDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void kill() throws SQLException {
        this.kill(true, true);
    }

    public void kill(boolean pushKilled, boolean withClose) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.kill(pushKilled);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
        if (withClose) {
            this.close();
        }
    }

    public void setLazyCtsTransaction() throws SQLException {
        this.check();
        this.session.setLazyCtsTransaction();
    }

    public void setLazyMarkDistributed() throws SQLException {
        this.check();
        this.session.setLazyMarkDistributed();
    }

    public void setLazySnapshotSeq(long lazySnapshotSeq) throws SQLException {
        this.check();
        this.session.setLazySnapshotSeq(lazySnapshotSeq);
    }

    public void setLazyCommitSeq(long lazyCommitSeq) throws SQLException {
        this.check();
        this.session.setLazyCommitSeq(lazyCommitSeq);
    }

    public XResult execQuery(PolarxExecPlan.ExecPlan.Builder execPlan, BytesSql nativeSql) throws SQLException {
        return this.execQuery(execPlan, nativeSql, null, false);
    }

    public XResult execQuery(PolarxExecPlan.ExecPlan.Builder execPlan, BytesSql nativeSql, byte[] traceId) throws SQLException {
        return this.execQuery(execPlan, nativeSql, traceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execQuery(PolarxExecPlan.ExecPlan.Builder execPlan, BytesSql nativeSql, byte[] traceId, boolean ignoreResult) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, execPlan, nativeSql, traceId, ignoreResult);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public XResult execQuery(String sql) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, BytesSql.getBytesSql((String)sql), null, null, false, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execQuery(String sql, List<PolarxDatatypes.Any> args) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, BytesSql.getBytesSql((String)sql), null, args, false, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execQuery(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, sql, hint, args, false, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execQuery(String sql, List<PolarxDatatypes.Any> args, boolean ignoreResult) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, BytesSql.getBytesSql((String)sql), null, args, ignoreResult, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execQuery(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, sql, hint, args, ignoreResult, digest);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execGalaxyPrepare(BytesSql sql, byte[] hint, ByteString digest, List<GPTable> tables, ByteString params, int paramNum, boolean ignoreResult, boolean isUpdate) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execGalaxyPrepare(this, sql, hint, digest, tables, params, paramNum, ignoreResult, isUpdate);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execUpdate(String sql) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            long l = this.session.execUpdate(this, BytesSql.getBytesSql((String)sql), null, null, false, null).getRowsAffected();
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execUpdate(String sql, List<PolarxDatatypes.Any> args) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            long l = this.session.execUpdate(this, BytesSql.getBytesSql((String)sql), null, args, false, null).getRowsAffected();
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execUpdate(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            long l = this.session.execUpdate(this, sql, hint, args, false, null).getRowsAffected();
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdate(String sql, List<PolarxDatatypes.Any> args, boolean ignoreResult) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execUpdate(this, BytesSql.getBytesSql((String)sql), null, args, ignoreResult, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdate(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execUpdate(this, sql, hint, args, ignoreResult, null);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdate(String sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execUpdate(this, BytesSql.getBytesSql((String)sql), hint, args, ignoreResult, digest);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdate(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, boolean ignoreResult, ByteString digest) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execUpdate(this, sql, hint, args, ignoreResult, digest);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdateReturning(String sql, byte[] hint, List<PolarxDatatypes.Any> args, String returning) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, BytesSql.getBytesSql((String)sql), hint, args, false, null, returning);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XResult execUpdateReturning(BytesSql sql, byte[] hint, List<PolarxDatatypes.Any> args, String returning) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.execQuery(this, sql, hint, args, false, null, returning);
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTSO(int count) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            long l = this.session.getTSO(this, count);
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void flushNetwork() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.flushNetwork();
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean supportMessageTimestamp() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.supportMessageTimestamp();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean supportSingleShardOptimization() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.supportSingleShardOptimization();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean supportRawString() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.supportRawString();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean isXRPC() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.isXRPC();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean supportMarkDistributed() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.supportMarkDistributed();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public long getConnectionId() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            long l = this.session.getConnectionId();
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public XResult getLastUserRequest() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            XResult xResult = this.session.getLastUserRequest();
            return xResult;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void cancel() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.cancel();
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public Throwable getLastException() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            Throwable throwable = this.session.getLastException();
            return throwable;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable setLastException(Throwable lastException, boolean forceReplace) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            Throwable throwable = this.session.setLastException(lastException, forceReplace);
            return throwable;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public boolean resetExceptionFromCancel() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            boolean bl = this.session.resetExceptionFromCancel();
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void tokenOffer() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.tokenOffer(this.defaultTokenKb);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void setDefaultDB(String defaultDB) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.setDefaultDB(defaultDB);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void setSessionVariables(Map<String, Object> newServerVariables) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.setSessionVariables(this, newServerVariables);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public void setGlobalVariables(Map<String, Object> newGlobalVariables) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.setGlobalVariables(this, newGlobalVariables);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAutoSavepoint(String name, PolarxExecPlan.AutoSp.Operation op, boolean ignoreResult) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.handleAutoSavepoint(this, name, op, ignoreResult);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public long actualTimeoutNanos() {
        long t = this.networkTimeoutNanos;
        return 0L == t ? 900000000000L : t;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new XStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new XPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(BytesSql sql, byte[] hint) throws SQLException {
        return new XPreparedStatement(this, sql, hint);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            this.session.setAutoCommit(this, autoCommit);
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.execUpdate("commit");
    }

    @Override
    public void rollback() throws SQLException {
        this.execUpdate("rollback");
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            boolean bl = null == this.session;
            return bl;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new NotSupportException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            String levelString;
            String sql;
            this.check();
            if (level == this.session.getIsolation()) {
                return;
            }
            switch (level) {
                case 1: {
                    sql = "set session transaction isolation level read uncommitted";
                    levelString = "READ-UNCOMMITTED";
                    break;
                }
                case 2: {
                    sql = "set session transaction isolation level read committed";
                    levelString = "READ-COMMITTED";
                    break;
                }
                case 4: {
                    sql = "set session transaction isolation level repeatable read";
                    levelString = "REPEATABLE-READ";
                    break;
                }
                case 8: {
                    sql = "set session transaction isolation level serializable";
                    levelString = "SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unknown transaction isolation level: " + level);
                }
            }
            boolean isStashed = this.session.stashTransactionSequence();
            try {
                this.session.execUpdate(this, BytesSql.getBytesSql((String)sql), null, null, true, null);
                this.session.updateIsolation(levelString);
            }
            finally {
                if (isStashed) {
                    this.session.stashPopTransactionSequence();
                }
            }
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            int n = this.session.getIsolation();
            return n;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        XResult last;
        this.sessionLock.readLock().lock();
        try {
            this.check();
            last = this.session.getLastUserRequest();
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
        PolarxNotice.Warning warning = null == last ? null : last.getWarning();
        return null == warning ? null : new SQLWarning(warning.getMsg(), "", warning.getCode());
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (1003 == resultSetType && 1007 == resultSetConcurrency) {
            return new XPreparedStatement(this, sql);
        }
        throw new NotSupportException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            return new XPreparedStatement(this, sql);
        }
        throw new NotSupportException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new NotSupportException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new NotSupportException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new NotSupportException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new NotSupportException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execTransferFile(PolarxPhysicalBackfill.TransferFileDataOperator.Builder transferFile) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (transferFile.getOperatorType() == PolarxPhysicalBackfill.TransferFileDataOperator.Type.PUT_DATA_TO_TAR_IBD);
            long l = this.session.execTransferFile(this, transferFile);
            return l;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public PolarxPhysicalBackfill.TransferFileDataOperator execReadBufferFromFile(PolarxPhysicalBackfill.TransferFileDataOperator.Builder transferFile) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (transferFile.getOperatorType() == PolarxPhysicalBackfill.TransferFileDataOperator.Type.GET_DATA_FROM_SRC_IBD);
            PolarxPhysicalBackfill.TransferFileDataOperator transferFileDataOperator = this.session.execReadBufferFromFile(this, transferFile);
            return transferFileDataOperator;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public PolarxPhysicalBackfill.GetFileInfoOperator execCheckFileExistence(PolarxPhysicalBackfill.GetFileInfoOperator.Builder builder) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (builder.getOperatorType() == PolarxPhysicalBackfill.GetFileInfoOperator.Type.CHECK_SRC_FILE_EXISTENCE || builder.getOperatorType() == PolarxPhysicalBackfill.GetFileInfoOperator.Type.CHECK_TAR_FILE_EXISTENCE);
            PolarxPhysicalBackfill.GetFileInfoOperator getFileInfoOperator = this.session.execCheckFileExistence(this, builder);
            return getFileInfoOperator;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse exeCloneFile(PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (builder.getOperatorType() == PolarxPhysicalBackfill.FileManageOperator.Type.COPY_IBD_TO_TEMP_DIR_IN_SRC);
            PolarxPhysicalBackfill.FileManageOperatorResponse fileManageOperatorResponse = this.session.execCloneFile(this, builder);
            return fileManageOperatorResponse;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse execDeleteTempIbdFile(PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (builder.getOperatorType() == PolarxPhysicalBackfill.FileManageOperator.Type.DELETE_IBD_FROM_TEMP_DIR_IN_SRC);
            PolarxPhysicalBackfill.FileManageOperatorResponse fileManageOperatorResponse = this.session.execDeleteTempIbdFile(this, builder);
            return fileManageOperatorResponse;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse execFallocateIbdFile(PolarxPhysicalBackfill.FileManageOperator.Builder builder) throws SQLException {
        this.sessionLock.readLock().lock();
        try {
            this.check();
            assert (builder.getOperatorType() == PolarxPhysicalBackfill.FileManageOperator.Type.FALLOCATE_IBD);
            PolarxPhysicalBackfill.FileManageOperatorResponse fileManageOperatorResponse = this.session.execDeleteTempIbdFile(this, builder);
            return fileManageOperatorResponse;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeoutExecutor = executor;
        this.networkTimeoutNanos = (long)milliseconds * 1000000L;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return (int)(this.networkTimeoutNanos / 1000000L);
    }

    public void setNetworkTimeoutNanos(long nanos) {
        this.networkTimeoutNanos = nanos;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return XConnection.class.isAssignableFrom(iface);
    }

    public String toString() {
        XSession s = this.session;
        if (null == s) {
            return "XConnection for closed session.";
        }
        return "XConnection for " + s;
    }
}

