/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.pool;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.polardbx.common.exception.TddlNestableRuntimeException;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.utils.thread.ExecutorUtil;
import com.alibaba.polardbx.common.utils.thread.NamedThreadFactory;
import com.alibaba.polardbx.common.utils.thread.ThreadCpuStatUtil;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.client.XClient;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.net.NIOProcessor;
import com.alibaba.polardbx.rpc.net.NIOWorker;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.perf.DnPerfItem;
import com.alibaba.polardbx.rpc.perf.ReactorPerfItem;
import com.alibaba.polardbx.rpc.perf.SessionPerfItem;
import com.alibaba.polardbx.rpc.perf.TcpPerfItem;
import com.alibaba.polardbx.rpc.pool.XClientPool;
import com.alibaba.polardbx.rpc.pool.XConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public class XConnectionManager {
    private final NIOWorker eventWorker = new NIOWorker(ThreadCpuStatUtil.NUM_CORES * 2);
    private final Map<String, XClientPool> instancePool = new ConcurrentHashMap<String, XClientPool>();
    private int metaDbPort = -1;
    private int storageDbPort = -1;
    private volatile int maxClientPerInstance;
    private volatile int maxSessionPerClient;
    private volatile int maxPooledSessionPerInstance;
    private volatile long sessionAgingNanos = 600000000000L;
    private volatile long slowThresholdNanos = 500000000L;
    private volatile int minPooledSessionPerInstance = 128;
    private volatile boolean enableAuth = true;
    private volatile boolean enableAutoCommitOptimize = true;
    private volatile boolean enableXplan = true;
    private volatile boolean enableXplanExpendStar = true;
    private volatile boolean enableXplanTableScan = false;
    private volatile boolean enableTrxLeakCheck = false;
    private volatile boolean enableMessageTimestamp = true;
    private volatile boolean enablePlanCache = true;
    private volatile boolean enableChunkResult = true;
    private volatile boolean enablePureAsyncMpp = true;
    private volatile boolean enableDirectWrite = false;
    private volatile boolean enableFeedback = true;
    private volatile boolean enableChecker = true;
    private volatile long maxPacketSize = 0x4000000L;
    private final ScheduledExecutorService service = ExecutorUtil.createScheduler((int)1, (ThreadFactory)new NamedThreadFactory("XConnection-Check-Scheduler"), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    private final AtomicLong idGenerator = new AtomicLong(2L);
    private ThreadPoolExecutor checkerThreads = null;
    private final AtomicLong lastCheckTime = new AtomicLong(0L);
    private final AtomicReference<String> instId = new AtomicReference<Object>(null);
    private static final XConnectionManager INSTANCE = new XConnectionManager(32, 1024, 512);

    private XConnectionManager(int maxClientPerInstance, int maxSessionPerClient, int maxPooledSessionPerInstance) {
        this.maxClientPerInstance = maxClientPerInstance;
        this.maxSessionPerClient = maxSessionPerClient;
        this.maxPooledSessionPerInstance = maxPooledSessionPerInstance;
        long intervalNanos = 10000000000L;
        this.service.scheduleAtFixedRate(() -> {
            block20: {
                if (!this.enableChecker) {
                    return;
                }
                long checkNanos = System.nanoTime();
                long lastCheck = this.lastCheckTime.get();
                if (lastCheck != 0L && checkNanos - lastCheck > 0L && checkNanos - lastCheck < 5000000000L) {
                    return;
                }
                this.lastCheckTime.set(checkNanos);
                try {
                    if (XLog.XPerfLogger.isInfoEnabled()) {
                        ArrayList<DnPerfItem> dnPerfItems = new ArrayList<DnPerfItem>();
                        XConnectionManager.getInstance().gatherDnPerf(dnPerfItems);
                        XLog.XPerfLogger.info(JSONObject.toJSONString(dnPerfItems));
                    }
                }
                catch (Throwable t) {
                    XLog.XLogLogger.error(t);
                }
                try {
                    long nowNanos;
                    if (null == this.checkerThreads) {
                        this.checkerThreads = new ThreadPoolExecutor(32, 32, 10000000000L, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("XConnection-Check-Workers", true));
                    }
                    try {
                        for (XClientPool pool : this.instancePool.values()) {
                            if (pool.getRefCount().get() > 0) {
                                pool.cleanupClient(this.checkerThreads);
                                continue;
                            }
                            XLog.XLogLogger.warn("Found 0 reference pool " + pool + " may leak or initializing.");
                        }
                    }
                    catch (Exception e) {
                        XLog.XLogLogger.error((Throwable)e);
                    }
                    long startTimeNanos = System.nanoTime();
                    while ((nowNanos = System.nanoTime()) - startTimeNanos < 300000000000L && this.checkerThreads.getCompletedTaskCount() < this.checkerThreads.getTaskCount()) {
                        Thread.sleep(100L);
                    }
                    XLog.XLogLogger.info("XConnection check time: " + (nowNanos - startTimeNanos) + "ns");
                    if (this.checkerThreads.getCompletedTaskCount() >= this.checkerThreads.getTaskCount()) break block20;
                    try {
                        this.checkerThreads.shutdown();
                        this.checkerThreads.awaitTermination(300000000000L, TimeUnit.NANOSECONDS);
                    }
                    catch (Throwable t) {
                        XLog.XLogLogger.error(t);
                    }
                    finally {
                        this.checkerThreads.shutdownNow();
                    }
                    this.checkerThreads = null;
                }
                catch (Throwable t) {
                    XLog.XLogLogger.error(t);
                    if (this.checkerThreads == null) break block20;
                    try {
                        this.checkerThreads.shutdownNow();
                    }
                    catch (Throwable t1) {
                        XLog.XLogLogger.error(t1);
                    }
                    this.checkerThreads = null;
                }
            }
        }, 10000000000L, 10000000000L, TimeUnit.NANOSECONDS);
    }

    public static XConnectionManager getInstance() {
        return INSTANCE;
    }

    public NIOWorker getEventWorker() {
        return this.eventWorker;
    }

    public int getMetaDbPort() {
        return this.metaDbPort;
    }

    public void setMetaDbPort(int metaDbPort) {
        this.metaDbPort = metaDbPort;
    }

    public int getStorageDbPort() {
        return this.storageDbPort;
    }

    public void setStorageDbPort(int storageDbPort) {
        this.storageDbPort = storageDbPort;
    }

    public int getMaxClientPerInstance() {
        return this.maxClientPerInstance;
    }

    public void setMaxClientPerInstance(int maxClientPerInstance) {
        this.maxClientPerInstance = maxClientPerInstance;
    }

    public int getMaxSessionPerClient() {
        return this.maxSessionPerClient;
    }

    public void setMaxSessionPerClient(int maxSessionPerClient) {
        this.maxSessionPerClient = maxSessionPerClient;
    }

    public int getMaxPooledSessionPerInstance() {
        return this.maxPooledSessionPerInstance;
    }

    public void setMaxPooledSessionPerInstance(int maxPooledSessionPerInstance) {
        this.maxPooledSessionPerInstance = maxPooledSessionPerInstance;
    }

    public long getSessionAgingNanos() {
        return this.sessionAgingNanos;
    }

    public void setSessionAgingNanos(long sessionAgingNanos) {
        this.sessionAgingNanos = sessionAgingNanos;
    }

    public void setSessionAgingTimeMillis(long millis) {
        this.sessionAgingNanos = millis * 1000000L;
    }

    public long getSlowThresholdNanos() {
        return this.slowThresholdNanos;
    }

    public void setSlowThresholdNanos(long slowThresholdNanos) {
        this.slowThresholdNanos = slowThresholdNanos;
    }

    public void setSlowThresholdMillis(long millis) {
        this.slowThresholdNanos = millis * 1000000L;
    }

    public int getMinPooledSessionPerInstance() {
        return this.minPooledSessionPerInstance;
    }

    public void setMinPooledSessionPerInstance(int minPooledSessionPerInstance) {
        this.minPooledSessionPerInstance = minPooledSessionPerInstance;
    }

    public boolean isEnableAuth() {
        return this.enableAuth;
    }

    public void setEnableAuth(boolean enableAuth) {
        this.enableAuth = enableAuth;
    }

    public boolean isEnableAutoCommitOptimize() {
        return this.enableAutoCommitOptimize;
    }

    public void setEnableAutoCommitOptimize(boolean enableAutoCommitOptimize) {
        this.enableAutoCommitOptimize = enableAutoCommitOptimize;
    }

    public boolean isEnableXplan() {
        if (XConfig.GALAXY_X_PROTOCOL) {
            return false;
        }
        return this.enableXplan;
    }

    public void setEnableXplan(boolean enableXplan) {
        this.enableXplan = enableXplan;
    }

    public boolean isEnableXplanExpendStar() {
        return this.enableXplanExpendStar;
    }

    public void setEnableXplanExpendStar(boolean enableXplanExpendStar) {
        this.enableXplanExpendStar = enableXplanExpendStar;
    }

    public boolean isEnableXplanTableScan() {
        return this.enableXplanTableScan;
    }

    public void setEnableXplanTableScan(boolean enableXplanTableScan) {
        this.enableXplanTableScan = enableXplanTableScan;
    }

    public boolean isEnableTrxLeakCheck() {
        return this.enableTrxLeakCheck;
    }

    public void setEnableTrxLeakCheck(boolean enableTrxLeakCheck) {
        this.enableTrxLeakCheck = enableTrxLeakCheck;
    }

    public boolean isEnableMessageTimestamp() {
        if (XConfig.GALAXY_X_PROTOCOL) {
            return false;
        }
        return this.enableMessageTimestamp;
    }

    public void setEnableMessageTimestamp(boolean enableMessageTimestamp) {
        this.enableMessageTimestamp = enableMessageTimestamp;
    }

    public boolean isEnablePlanCache() {
        if (XConfig.GALAXY_X_PROTOCOL) {
            return false;
        }
        return this.enablePlanCache;
    }

    public void setEnablePlanCache(boolean enablePlanCache) {
        this.enablePlanCache = enablePlanCache;
    }

    public boolean isEnableChunkResult() {
        if (XConfig.GALAXY_X_PROTOCOL) {
            return false;
        }
        return this.enableChunkResult;
    }

    public void setEnableChunkResult(boolean enableChunkResult) {
        this.enableChunkResult = enableChunkResult;
    }

    public boolean isEnablePureAsyncMpp() {
        return this.enablePureAsyncMpp;
    }

    public void setEnablePureAsyncMpp(boolean enablePureAsyncMpp) {
        this.enablePureAsyncMpp = enablePureAsyncMpp;
    }

    public boolean isEnableDirectWrite() {
        return this.enableDirectWrite;
    }

    public void setEnableDirectWrite(boolean enableDirectWrite) {
        this.enableDirectWrite = enableDirectWrite;
    }

    public boolean isEnableFeedback() {
        if (XConfig.GALAXY_X_PROTOCOL || XConfig.OPEN_XRPC_PROTOCOL) {
            return false;
        }
        return this.enableFeedback;
    }

    public void setEnableFeedback(boolean enableFeedback) {
        this.enableFeedback = enableFeedback;
    }

    public boolean isEnableChecker() {
        return this.enableChecker;
    }

    public void setEnableChecker(boolean enableChecker) {
        this.enableChecker = enableChecker;
    }

    public long getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(long maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public AtomicLong getIdGenerator() {
        return this.idGenerator;
    }

    public AtomicReference<String> getInstId() {
        return this.instId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDataSource(String host, int port, String username, String password, String instInfo) {
        Map<String, XClientPool> map = this.instancePool;
        synchronized (map) {
            XClientPool clientPool = this.instancePool.computeIfAbsent(XConnectionManager.digest(host, port, username, password), key -> new XClientPool(this, host, port, username, password));
            int cnt = clientPool.getRefCount().getAndIncrement();
            XLog.XLogLogger.info("XConnectionManager new datasource to " + username + "@" + host + ":" + port + " id is " + cnt + " NOW_GLOBAL_SESSION: " + XSession.GLOBAL_COUNTER.get());
            clientPool.getInstInfo().add(instInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinitializeDataSource(String host, int port, String username, String password) {
        XClientPool clientPool;
        String digest = XConnectionManager.digest(host, port, username, password);
        Map<String, XClientPool> map = this.instancePool;
        synchronized (map) {
            clientPool = this.instancePool.get(digest);
            if (clientPool != null) {
                int cnt = clientPool.getRefCount().decrementAndGet();
                if (0 == cnt) {
                    this.instancePool.remove(digest);
                } else {
                    clientPool = null;
                }
                XLog.XLogLogger.info("XConnectionManager datasource deinit " + username + "@" + host + ":" + port + " rest count is " + cnt + " NOW_GLOBAL_SESSION: " + XSession.GLOBAL_COUNTER.get());
            }
        }
        if (clientPool != null) {
            clientPool.shutdown();
        }
    }

    public BiFunction<XClient, XPacket, Boolean> getPacketConsumer() {
        return (cli, pkt) -> true;
    }

    public XClientPool getClientPool(String host, int port, String username, String password) {
        return this.instancePool.get(XConnectionManager.digest(host, port, username, password));
    }

    public void reload() {
        for (XClientPool clientPool : this.instancePool.values()) {
            clientPool.reload();
        }
    }

    public XConnection getConnection(String host, int port, String username, String password, String defaultDB, long timeoutNanos) throws Exception {
        XClientPool clientPool = this.instancePool.get(XConnectionManager.digest(host, port, username, password));
        if (null == clientPool) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_CLIENT, new String[]{"Client pool not initialized."});
        }
        XConnection connection = null;
        try {
            connection = clientPool.getConnection(this.getPacketConsumer(), timeoutNanos);
            connection.setDefaultDB(defaultDB);
            return connection;
        }
        catch (Exception e) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    XLog.XLogLogger.error(t);
                }
            }
            TddlNestableRuntimeException nested = new TddlNestableRuntimeException(e.getMessage() + ' ' + clientPool.diagnose(), (Throwable)e);
            XLog.XLogLogger.error((Throwable)nested);
            throw nested;
        }
    }

    public static String digest(String host, int port, String username, String password) {
        return username + '#' + Integer.toHexString(password.hashCode()) + '@' + host + ':' + port;
    }

    public void gatherReactorPerf(List<ReactorPerfItem> list) {
        for (NIOProcessor processor : this.eventWorker.getProcessors()) {
            list.add(processor.getPerfItem());
        }
    }

    public void gatherDnPerf(List<DnPerfItem> list) {
        XClientPool[] instances;
        for (XClientPool pool : instances = this.instancePool.values().toArray(new XClientPool[0])) {
            list.add(pool.getPerfItem());
        }
    }

    public void gatherTcpPerf(List<TcpPerfItem> list) {
        XClientPool[] instances;
        for (XClientPool pool : instances = this.instancePool.values().toArray(new XClientPool[0])) {
            pool.gatherTcpPerf(list);
        }
    }

    public void gatherSessionPerf(List<SessionPerfItem> list) {
        XClientPool[] instances;
        for (XClientPool pool : instances = this.instancePool.values().toArray(new XClientPool[0])) {
            pool.gatherSessionPerf(list);
        }
    }
}

