/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.mysql.cj.polarx.protobuf.PolarxResultset;

public class XMetaUtil {
    private int jdbcType;
    private String jdbcTypeString;
    private long fieldLength;

    public XMetaUtil(PolarxResultset.ColumnMetaData meta) {
        switch (meta.getOriginalType()) {
            case MYSQL_TYPE_BIT: {
                this.jdbcType = -7;
                this.jdbcTypeString = "BIT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_TINY: {
                this.jdbcType = 1 == meta.getLength() ? -7 : -6;
                this.jdbcTypeString = PolarxResultset.ColumnMetaData.FieldType.UINT == meta.getType() ? "TINYINT UNSIGNED" : "TINYINT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_SHORT: {
                this.jdbcType = 5;
                this.jdbcTypeString = PolarxResultset.ColumnMetaData.FieldType.UINT == meta.getType() ? "SMALLINT UNSIGNED" : "SMALLINT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_INT24: {
                this.jdbcType = 4;
                this.jdbcTypeString = PolarxResultset.ColumnMetaData.FieldType.UINT == meta.getType() ? "MEDIUMINT UNSIGNED" : "MEDIUMINT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_LONG: {
                this.jdbcType = 4;
                this.jdbcTypeString = PolarxResultset.ColumnMetaData.FieldType.UINT == meta.getType() ? "INT UNSIGNED" : "INT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_LONGLONG: {
                this.jdbcType = -5;
                this.jdbcTypeString = PolarxResultset.ColumnMetaData.FieldType.UINT == meta.getType() ? "BIGINT UNSIGNED" : "BIGINT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_DECIMAL: 
            case MYSQL_TYPE_NEWDECIMAL: {
                this.jdbcType = 3;
                this.jdbcTypeString = "DECIMAL";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_FLOAT: {
                this.jdbcType = 7;
                this.jdbcTypeString = (meta.getFlags() & 1) != 0 ? "FLOAT UNSIGNED" : "FLOAT";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_DOUBLE: {
                this.jdbcType = 8;
                this.jdbcTypeString = (meta.getFlags() & 1) != 0 ? "DOUBLE UNSIGNED" : "DOUBLE";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_DATE: 
            case MYSQL_TYPE_NEWDATE: {
                this.jdbcType = 91;
                this.jdbcTypeString = "DATE";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_DATETIME: 
            case MYSQL_TYPE_DATETIME2: {
                this.jdbcType = 93;
                this.jdbcTypeString = "DATETIME";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_TIMESTAMP: 
            case MYSQL_TYPE_TIMESTAMP2: {
                this.jdbcType = 93;
                this.jdbcTypeString = "TIMESTAMP";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_TIME: 
            case MYSQL_TYPE_TIME2: {
                this.jdbcType = 92;
                this.jdbcTypeString = "TIME";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_YEAR: {
                this.jdbcType = 91;
                this.jdbcTypeString = "YEAR";
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_STRING: 
            case MYSQL_TYPE_VAR_STRING: {
                if (63L == meta.getCollation()) {
                    this.jdbcType = -2;
                    this.jdbcTypeString = "BINARY";
                } else {
                    this.jdbcType = 1;
                    this.jdbcTypeString = "CHAR";
                }
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_VARCHAR: {
                if (63L == meta.getCollation()) {
                    this.jdbcType = -3;
                    this.jdbcTypeString = "VARBINARY";
                } else {
                    this.jdbcType = 12;
                    this.jdbcTypeString = "VARCHAR";
                }
                this.fieldLength = meta.getLength();
                break;
            }
            case MYSQL_TYPE_BLOB: 
            case MYSQL_TYPE_TINY_BLOB: 
            case MYSQL_TYPE_MEDIUM_BLOB: 
            case MYSQL_TYPE_LONG_BLOB: {
                switch (meta.getLength()) {
                    case 255: {
                        if (63L == meta.getCollation()) {
                            this.jdbcType = -3;
                            this.jdbcTypeString = "TINYBLOB";
                            break;
                        }
                        this.jdbcType = -1;
                        this.jdbcTypeString = "VARCHAR";
                        break;
                    }
                    case 65535: {
                        if (63L == meta.getCollation()) {
                            this.jdbcType = -4;
                            this.jdbcTypeString = "BLOB";
                            break;
                        }
                        this.jdbcType = -1;
                        this.jdbcTypeString = "VARCHAR";
                        break;
                    }
                    case 0xFFFFFF: {
                        if (63L == meta.getCollation()) {
                            this.jdbcType = -4;
                            this.jdbcTypeString = "MEDIUMBLOB";
                            break;
                        }
                        this.jdbcType = -1;
                        this.jdbcTypeString = "VARCHAR";
                        break;
                    }
                    default: {
                        if (63L == meta.getCollation()) {
                            this.jdbcType = -4;
                            this.jdbcTypeString = "LONGBLOB";
                            break;
                        }
                        this.jdbcType = -1;
                        this.jdbcTypeString = "VARCHAR";
                    }
                }
                this.fieldLength = meta.getLength();
                if (this.fieldLength >= 0L) break;
                this.fieldLength = 0xFFFFFFFFL;
                break;
            }
            case MYSQL_TYPE_ENUM: {
                this.jdbcType = 1;
                this.jdbcTypeString = "CHAR";
                this.fieldLength = 4L;
                break;
            }
            case MYSQL_TYPE_SET: {
                this.jdbcType = 1;
                this.jdbcTypeString = "CHAR";
                this.fieldLength = 20L;
                break;
            }
            case MYSQL_TYPE_JSON: {
                this.jdbcType = 1;
                this.jdbcTypeString = "JSON";
                this.fieldLength = 0xFFFFFFFFL;
                break;
            }
            case MYSQL_TYPE_GEOMETRY: {
                this.jdbcType = -2;
                this.jdbcTypeString = "GEOMETRY";
                this.fieldLength = 0xFFFFFFFFL;
                break;
            }
            case MYSQL_TYPE_NULL: {
                this.jdbcType = 0;
                this.jdbcTypeString = "NULL";
                this.fieldLength = 0L;
                break;
            }
            default: {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unknown meta type: " + meta.getOriginalType().name()});
            }
        }
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getJdbcTypeString() {
        return this.jdbcTypeString;
    }

    public long getFieldLength() {
        return this.fieldLength;
    }
}

