/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.jdbc.BytesSql;
import com.alibaba.polardbx.common.utils.GeneralUtil;
import com.alibaba.polardbx.common.utils.logger.Logger;
import com.alibaba.polardbx.common.utils.logger.LoggerFactory;
import com.alibaba.polardbx.rpc.XConfig;
import com.alibaba.polardbx.rpc.XLog;
import com.alibaba.polardbx.rpc.client.XSession;
import com.alibaba.polardbx.rpc.packet.XPacket;
import com.alibaba.polardbx.rpc.packet.XPacketBuilder;
import com.alibaba.polardbx.rpc.packet.XPacketQueue;
import com.alibaba.polardbx.rpc.pool.XConnection;
import com.alibaba.polardbx.rpc.pool.XConnectionManager;
import com.alibaba.polardbx.rpc.result.XResultObject;
import com.alibaba.polardbx.rpc.result.XResultUtil;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxNotice;
import com.mysql.cj.polarx.protobuf.PolarxPhysicalBackfill;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import com.mysql.cj.x.protobuf.Polarx;
import com.mysql.cj.x.protobuf.PolarxDatatypes;
import com.mysql.cj.x.protobuf.PolarxExecPlan;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class XResult
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(XResult.class);
    private final XConnection connection;
    private final XSession session;
    private final XPacketQueue pipe;
    private XResult previous;
    private final long startNanos;
    private long queryTimeoutNanos;
    private long totalTimeoutNanos;
    private boolean timeoutOccurs = false;
    private final boolean ignoreResult;
    private boolean isFatalOnIgnorable = true;
    private final RequestType requestType;
    private final String extra;
    private final BytesSql sql;
    private XPacketBuilder retransmitPacketBuilder;
    private final List<PolarxResultset.ColumnMetaData> metaData = new ArrayList<PolarxResultset.ColumnMetaData>(16);
    private XResultObject pipeCache = null;
    private long fetchCount = 0L;
    private long tokenSize = 0L;
    private long rowsAffected = 0L;
    private long generatedInsertId = 0L;
    private boolean haveGeneratedInsertId = false;
    private final List<PolarxNotice.Warning> warnings = new ArrayList<PolarxNotice.Warning>();
    private int tsoErrorNo = 1;
    private long tsoValue = 0L;
    private volatile long pktResponseNanos = -1L;
    private long responseNanos = -1L;
    private long finishNanos = -1L;
    private long transferBufferSize = -1L;
    private PolarxPhysicalBackfill.TransferFileDataOperator bufferFromIbdFile;
    private PolarxPhysicalBackfill.GetFileInfoOperator ibdFileInfo;
    private PolarxPhysicalBackfill.FileManageOperatorResponse fileManageOperatorResponse;
    private AtomicBoolean logged = new AtomicBoolean(false);
    private int idx = 0;
    private List<List<ByteString>> rows;
    private volatile Runnable dataNotify = null;
    private boolean allowPrefetchToken = true;
    private long tokenDoneCount = 0L;
    private long activeOfferTokenCount = 0L;
    private final long startMillis = System.currentTimeMillis();
    private boolean resultChunk = false;
    private boolean retrans = false;
    private final boolean goCache;
    private long examinedRowCount = -1L;
    private List<String[]> chosenIndexes = null;
    private ResultStatus status = ResultStatus.XResultStart;

    public XResult(XConnection connection, XPacketQueue pipe, XResult previous, long startNanos, long queryTimeoutNanos, long totalTimeoutNanos, boolean ignoreResult, RequestType requestType, BytesSql sql, long tokenKb, XPacketBuilder retransmitPacketBuilder, String extra) throws SQLException {
        this.connection = connection;
        this.session = connection.getSessionUncheck();
        this.pipe = pipe;
        this.previous = previous;
        this.startNanos = startNanos;
        this.queryTimeoutNanos = queryTimeoutNanos;
        this.totalTimeoutNanos = totalTimeoutNanos - startNanos > queryTimeoutNanos - startNanos ? totalTimeoutNanos : queryTimeoutNanos;
        this.ignoreResult = ignoreResult;
        this.requestType = requestType;
        this.extra = extra;
        this.sql = sql;
        this.retransmitPacketBuilder = retransmitPacketBuilder;
        this.goCache = retransmitPacketBuilder != null;
        this.tokenSize = tokenKb * 1024L;
        this.rows = null;
    }

    public void finishBlockMode() throws SQLException {
        if (this.rows != null) {
            return;
        }
        try {
            XResultObject res;
            ArrayList<List<ByteString>> tmpRows = new ArrayList<List<ByteString>>();
            while ((res = this.internalFetchOneObject()) != null) {
                if (null == res.getRow()) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Chunk can only with stream mode."});
                }
                tmpRows.add(res.getRow());
            }
            this.rows = tmpRows;
        }
        finally {
            if (this.finishNanos < 0L) {
                this.finishNanos = System.nanoTime() - this.startNanos;
            }
            this.doLog();
        }
    }

    public XConnection getConnection() {
        return this.connection;
    }

    public XSession getSession() {
        return this.session;
    }

    public void setFatalOnIgnorable(boolean fatalOnIgnorable) {
        this.isFatalOnIgnorable = fatalOnIgnorable;
    }

    public BytesSql getSql() {
        return this.sql;
    }

    public String getExtra() {
        return this.extra;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public long getTokenSize() {
        return this.tokenSize;
    }

    public void recordPktResponse() {
        if (-1L == this.pktResponseNanos) {
            this.pktResponseNanos = System.nanoTime() - this.startNanos;
        }
    }

    public long getPktResponseNanos() {
        return this.pktResponseNanos;
    }

    public long getResponseNanos() {
        return this.responseNanos;
    }

    public long getFinishNanos() {
        return this.finishNanos;
    }

    public long getActiveOfferTokenCount() {
        return this.activeOfferTokenCount;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public boolean isResultChunk() {
        return this.resultChunk;
    }

    public boolean isRetrans() {
        return this.retrans;
    }

    public boolean isGoCache() {
        return this.goCache;
    }

    public long getStartNanos() {
        return this.startNanos;
    }

    public long getQueryTimeoutNanos() {
        return this.queryTimeoutNanos;
    }

    public Runnable getDataNotify() {
        return this.dataNotify;
    }

    public void setDataNotify(Runnable dataNotify) {
        this.dataNotify = dataNotify;
    }

    public boolean isAllowPrefetchToken() {
        return this.allowPrefetchToken;
    }

    public void setAllowPrefetchToken(boolean allowPrefetchToken) {
        this.allowPrefetchToken = allowPrefetchToken;
    }

    public long getTokenDoneCount() {
        return this.tokenDoneCount;
    }

    public boolean isDataReady() throws SQLException {
        if (this.status != ResultStatus.XResultStart && this.status != ResultStatus.XResultMeta) {
            return true;
        }
        try {
            XResultObject res = this.internalFetchOneObject(false);
            if (null == res) {
                this.pipeCache = null;
                this.doLog();
            } else {
                if (res.isPending()) {
                    return false;
                }
                this.pipeCache = res;
            }
        }
        catch (Exception e) {
            if (this.finishNanos < 0L) {
                this.finishNanos = System.nanoTime() - this.startNanos;
            }
            this.doLog();
            throw e;
        }
        return true;
    }

    public List<PolarxResultset.ColumnMetaData> getMetaData() throws SQLException {
        this.initMeta();
        return this.metaData;
    }

    public long getFetchCount() {
        return this.fetchCount;
    }

    public long getRowsAffected() {
        return this.rowsAffected;
    }

    public long getGeneratedInsertId() {
        return this.generatedInsertId;
    }

    public boolean isHaveGeneratedInsertId() {
        return this.haveGeneratedInsertId;
    }

    public PolarxNotice.Warning getWarning() {
        return this.warnings.isEmpty() ? null : this.warnings.get(0);
    }

    public List<PolarxNotice.Warning> getWarnings() {
        return this.warnings;
    }

    public int getTsoErrorNo() {
        return this.tsoErrorNo;
    }

    public long getTsoValue() {
        return this.tsoValue;
    }

    public long getExaminedRowCount() {
        return this.examinedRowCount;
    }

    public List<String[]> getChosenIndexes() {
        return this.chosenIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block16: {
            try {
                if (this.previous != null) {
                    try {
                        if (this.previous.waitFinish(true)) {
                            this.previous = null;
                        }
                    }
                    catch (Throwable e) {
                        logger.warn(e);
                        logger.warn("Query canceled with previous unexpected error. " + this.sql);
                    }
                }
                if (!this.isCancelable()) break block16;
                logger.debug("Query canceling: " + this.sql);
                try {
                    this.connection.cancel();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    if (this.connection.getLastUserRequest() == this && !this.ignoreResult) {
                        while (this.next() != null) {
                        }
                        this.connection.resetExceptionFromCancel();
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("Query execution was interrupted")) {
                        boolean reuse = false;
                        try {
                            reuse = this.connection.resetExceptionFromCancel();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        logger.info("Query was canceled on DN and session " + (reuse ? "reuse" : "drop") + " sql: " + this.sql);
                        break block16;
                    }
                    logger.warn((Throwable)e);
                    logger.warn("Query canceled with unexpected error. " + this.sql);
                }
            }
            finally {
                this.doLog();
            }
        }
    }

    void doLog() {
        boolean prev = this.logged.getAndSet(true);
        if (prev) {
            return;
        }
        if (!this.ignoreResult) {
            this.session.subActive();
        }
        if (this.connection == null || this.connection.getDataSource() == null) {
            return;
        }
        try {
            if (this.responseNanos >= 0L) {
                this.connection.getDataSource().getTotalRespondTime().getAndAdd(this.responseNanos / 1000L);
            } else if (this.finishNanos >= 0L) {
                this.connection.getDataSource().getTotalRespondTime().getAndAdd(this.finishNanos / 1000L);
            }
            if (this.finishNanos >= 0L) {
                this.connection.getDataSource().getTotalPhysicalTime().getAndAdd(this.finishNanos / 1000L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (XLog.XRequestLogger.isInfoEnabled() && this.finishNanos >= XConnectionManager.getInstance().getSlowThresholdNanos()) {
            try {
                XSession session = this.connection.getSession();
                Object[] objectArray = new Object[15];
                objectArray[0] = this.sql;
                objectArray[1] = this.connection.getDataSource().getName().replace('#', '$');
                Object object = objectArray[2] = this.goCache ? "cache" : "normal";
                objectArray[3] = this.goCache ? (this.retrans ? "miss" : "hit") : "N/A";
                objectArray[4] = this.resultChunk ? "chunk" : "row";
                objectArray[5] = Long.toString(this.startMillis);
                objectArray[6] = Long.toString(this.responseNanos / 1000L);
                objectArray[7] = Long.toString(this.finishNanos / 1000L);
                objectArray[8] = this.fetchCount;
                objectArray[9] = this.tokenDoneCount;
                objectArray[10] = this.activeOfferTokenCount;
                objectArray[11] = this.connection.getTraceId();
                objectArray[12] = this.requestType.getName();
                objectArray[13] = null == session ? "" : Long.toString(session.getSessionId());
                objectArray[14] = null == this.extra ? "" : this.extra;
                XLog.XRequestLogger.info(XLog.XRequestFormat.format(objectArray).replace('\n', ' '));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isDone() {
        return this.status == ResultStatus.XResultFinish || this.status == ResultStatus.XResultError || this.status == ResultStatus.XResultFatal;
    }

    public boolean isGoodAndDone() {
        return this.status == ResultStatus.XResultFinish || this.status == ResultStatus.XResultError;
    }

    public boolean isCancelable() {
        return null == this.previous && !this.isDone();
    }

    public boolean isIgnorable() {
        return this.ignoreResult;
    }

    public XResult getPrevious() {
        return this.previous;
    }

    public boolean isGoodIgnorable() {
        return this.ignoreResult && this.status != ResultStatus.XResultFatal;
    }

    public boolean isIgnorableNotFinish() {
        return this.ignoreResult && this.status != ResultStatus.XResultFatal && this.status != ResultStatus.XResultFinish && this.status != ResultStatus.XResultError;
    }

    public boolean waitFinish(boolean wait) throws InterruptedException, SQLException {
        if (this.ignoreResult) {
            try {
                XResultObject resultObject;
                while ((resultObject = this.internalFetchOneObject(wait)) != null) {
                    if (!resultObject.isPending()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                if (this.finishNanos < 0L) {
                    this.finishNanos = System.nanoTime() - this.startNanos;
                }
                this.doLog();
                throw e;
            }
            this.doLog();
            return true;
        }
        if (this.status != ResultStatus.XResultFinish && this.status != ResultStatus.XResultError) {
            if (ResultStatus.XResultFatal == this.status) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"XResult fatal error caused by previous fatal."});
            }
            logger.error("Previous unfinished query: " + this.sql);
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Fetch next with previous unfinished." + (this.timeoutOccurs ? " Previous query timeout." : "")});
        }
        return true;
    }

    public int getQueuedDepth() {
        int depth = 0;
        XResult prob = this;
        while (prob != null && !prob.isDone()) {
            ++depth;
            prob = prob.previous;
        }
        return depth;
    }

    private XResultObject internalFetchOneObject() throws SQLException {
        return this.internalFetchOneObject(true);
    }

    private XResultObject internalFetchOneObject(boolean wait) throws SQLException {
        if (ResultStatus.XResultError == this.status || ResultStatus.XResultFatal == this.status) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Fetch next on a XResult with error or fatal state."});
        }
        if (ResultStatus.XResultFinish == this.status) {
            return null;
        }
        if (this.requestType == RequestType.FETCH_TSO) {
            XResult probe = this.previous;
            while (probe != null) {
                probe.queryTimeoutNanos = this.queryTimeoutNanos;
                probe.totalTimeoutNanos = this.totalTimeoutNanos;
                probe = probe.previous;
            }
        }
        if (this.previous != null) {
            boolean previousFinish = false;
            try {
                previousFinish = this.previous.waitFinish(wait);
            }
            catch (Exception e) {
                ResultStatus previousState = this.previous.status;
                if (ResultStatus.XResultFatal == previousState) {
                    this.status = ResultStatus.XResultFatal;
                    throw GeneralUtil.nestedException((Throwable)this.session.setLastException(e, true));
                }
                if (previousState != ResultStatus.XResultFinish && previousState != ResultStatus.XResultError) {
                    logger.error("Prev unfinished: " + this.previous.sql + " status: " + previousState.name() + " now: " + this.sql + " status: " + this.status.name());
                    if (this.previous.timeoutOccurs) {
                        this.timeoutOccurs = true;
                    }
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Fetch next with previous unfinished." + (this.timeoutOccurs ? " Previous query timeout." : "")});
                }
                previousFinish = true;
            }
            if (!previousFinish) {
                if (wait) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Fetch next with previous pending and block mode."});
                }
                return new XResultObject();
            }
            this.previous = null;
        }
        XResult xResult = this;
        synchronized (xResult) {
            long gotPktNanos;
            XPacket packet;
            if (ResultStatus.XResultError == this.status || ResultStatus.XResultFatal == this.status) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_SESSION, new String[]{"Fetch next on a XResult with error or fatal state."});
            }
            if (ResultStatus.XResultFinish == this.status) {
                return null;
            }
            block56: while (true) {
                PolarxNotice.SessionStateChanged sessionStateChanged;
                PolarxNotice.Frame frame2;
                block103: {
                    long nowNanos = System.nanoTime();
                    boolean queryStart = this.status == ResultStatus.XResultStart || this.status == ResultStatus.XResultMeta;
                    long timeoutNanos = queryStart ? this.queryTimeoutNanos : this.totalTimeoutNanos;
                    long waitNanos = nowNanos - timeoutNanos >= 0L ? 0L : timeoutNanos - nowNanos;
                    try {
                        packet = this.pipe.poll(wait ? waitNanos : 0L, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        throw GeneralUtil.nestedException((Throwable)this.session.setLastException(e, true));
                    }
                    if (null == packet) {
                        if (!wait) {
                            return new XResultObject();
                        }
                        this.timeoutOccurs = true;
                        throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"XResult stream fetch result timeout. " + (queryStart ? "Query timeout." : "Total timeout.") + " " + (double)(timeoutNanos - this.startNanos) / 1.0E9 + "s"});
                    }
                    this.timeoutOccurs = false;
                    gotPktNanos = System.nanoTime();
                    int headerSize = XConfig.GALAXY_X_PROTOCOL ? 14 : 13;
                    this.tokenSize -= (long)(headerSize + packet.getPacketSize());
                    block8 : switch (this.status) {
                        case XResultStart: {
                            switch (packet.getType()) {
                                case 12: {
                                    if (XConfig.GALAXY_X_PROTOCOL) {
                                        this.metaData.add(XResultUtil.compatibleMetaConvert((PolarxResultset.ColumnMetaDataCompatible)packet.getPacket()));
                                    } else {
                                        this.metaData.add((PolarxResultset.ColumnMetaData)packet.getPacket());
                                    }
                                    this.status = ResultStatus.XResultMeta;
                                    this.responseNanos = gotPktNanos - this.startNanos;
                                    this.retransmitPacketBuilder = null;
                                    continue block56;
                                }
                                case 11: {
                                    try {
                                        frame2 = (PolarxNotice.Frame)packet.getPacket();
                                        if (3 != frame2.getType() || PolarxNotice.Frame.Scope.LOCAL != frame2.getScope() || (sessionStateChanged = PolarxNotice.SessionStateChanged.parseFrom(frame2.getPayload())).getParam() != PolarxNotice.SessionStateChanged.Parameter.ROWS_AFFECTED || !sessionStateChanged.hasValue() || PolarxDatatypes.Scalar.Type.V_UINT != sessionStateChanged.getValue().getType()) break block8;
                                        this.rowsAffected = sessionStateChanged.getValue().getVUnsignedInt();
                                        this.status = ResultStatus.XResultAffected;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.retransmitPacketBuilder = null;
                                        continue block56;
                                    }
                                    catch (Throwable frame2) {
                                        break;
                                    }
                                }
                                case 20: {
                                    if (this.requestType == RequestType.FETCH_TSO) {
                                        PolarxExecPlan.ResultTSO tso = (PolarxExecPlan.ResultTSO)packet.getPacket();
                                        this.tsoErrorNo = tso.getErrorNo();
                                        this.tsoValue = tso.getTs();
                                        this.status = ResultStatus.XResultFinish;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.finishNanos = gotPktNanos - this.startNanos;
                                        return null;
                                    }
                                    break block103;
                                }
                                case 0: {
                                    if (this.requestType == RequestType.EXPECTATIONS || this.requestType == RequestType.AUTO_SP) {
                                        this.status = ResultStatus.XResultFinish;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.finishNanos = gotPktNanos - this.startNanos;
                                        return null;
                                    }
                                    break block103;
                                }
                                case 23: {
                                    if (this.requestType == RequestType.TRANSFER_FILE) {
                                        PolarxPhysicalBackfill.TransferFileDataOperator transferFileData = (PolarxPhysicalBackfill.TransferFileDataOperator)packet.getPacket();
                                        if (transferFileData.getOperatorType() == PolarxPhysicalBackfill.TransferFileDataOperator.Type.PUT_DATA_TO_TAR_IBD) {
                                            this.transferBufferSize = transferFileData.getBufferLen();
                                            this.status = ResultStatus.XResultFinish;
                                            this.responseNanos = gotPktNanos - this.startNanos;
                                            this.finishNanos = gotPktNanos - this.startNanos;
                                            return null;
                                        }
                                        this.bufferFromIbdFile = transferFileData;
                                        this.status = ResultStatus.XResultFinish;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.finishNanos = gotPktNanos - this.startNanos;
                                        return null;
                                    }
                                    break block103;
                                }
                                case 22: {
                                    if (this.requestType == RequestType.GET_FILE_INFO) {
                                        PolarxPhysicalBackfill.GetFileInfoOperator getFileInfo;
                                        this.ibdFileInfo = getFileInfo = (PolarxPhysicalBackfill.GetFileInfoOperator)packet.getPacket();
                                        this.status = ResultStatus.XResultFinish;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.finishNanos = gotPktNanos - this.startNanos;
                                        return null;
                                    }
                                    break block103;
                                }
                                case 24: {
                                    if (this.requestType == RequestType.CLONE_FILE || this.requestType == RequestType.DELETE_FILE || this.requestType == RequestType.FALLOCATE_FILE) {
                                        PolarxPhysicalBackfill.FileManageOperatorResponse fileManageRes;
                                        this.fileManageOperatorResponse = fileManageRes = (PolarxPhysicalBackfill.FileManageOperatorResponse)packet.getPacket();
                                        this.status = ResultStatus.XResultFinish;
                                        this.responseNanos = gotPktNanos - this.startNanos;
                                        this.finishNanos = gotPktNanos - this.startNanos;
                                        return null;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        case XResultMeta: {
                            String[] indexArray;
                            PolarxResultset.FetchDone fetchDone;
                            PolarxResultset.Chunk chunk;
                            switch (packet.getType()) {
                                case 12: {
                                    if (XConfig.GALAXY_X_PROTOCOL) {
                                        this.metaData.add(XResultUtil.compatibleMetaConvert((PolarxResultset.ColumnMetaDataCompatible)packet.getPacket()));
                                        continue block56;
                                    }
                                    this.metaData.add((PolarxResultset.ColumnMetaData)packet.getPacket());
                                    continue block56;
                                }
                                case 13: {
                                    this.status = ResultStatus.XResultRows;
                                    ++this.fetchCount;
                                    return new XResultObject(((PolarxResultset.Row)packet.getPacket()).getFieldList());
                                }
                                case 21: {
                                    chunk = (PolarxResultset.Chunk)packet.getPacket();
                                    this.status = ResultStatus.XResultRows;
                                    this.fetchCount += (long)chunk.getRowCount();
                                    this.resultChunk = true;
                                    return new XResultObject((PolarxResultset.Chunk)packet.getPacket());
                                }
                                case 14: {
                                    String indexes;
                                    fetchDone = (PolarxResultset.FetchDone)packet.getPacket();
                                    if (fetchDone.hasExaminedRowCount()) {
                                        this.examinedRowCount = fetchDone.getExaminedRowCount();
                                    }
                                    if (fetchDone.hasChosenIndex() && (indexArray = (indexes = fetchDone.getChosenIndex().toStringUtf8()).split(";")).length > 0) {
                                        if (null == this.chosenIndexes) {
                                            this.chosenIndexes = new ArrayList<String[]>(indexArray.length);
                                        }
                                        for (String index : indexArray) {
                                            this.chosenIndexes.add(index.split("\\."));
                                        }
                                    }
                                    this.status = ResultStatus.XResultFetchDone;
                                    continue block56;
                                }
                            }
                            break;
                        }
                        case XResultRows: {
                            String[] indexArray;
                            PolarxResultset.FetchDone fetchDone;
                            PolarxResultset.Chunk chunk;
                            switch (packet.getType()) {
                                case 13: {
                                    ++this.fetchCount;
                                    long tokenSizeLow = (long)this.connection.getDefaultTokenKb() * 1024L / 5L;
                                    if (this.allowPrefetchToken && this.tokenSize < tokenSizeLow && this.pipe.getBufferSize() < tokenSizeLow) {
                                        this.connection.tokenOffer();
                                        this.tokenSize = (long)this.connection.getDefaultTokenKb() * 1024L;
                                        ++this.activeOfferTokenCount;
                                    }
                                    return new XResultObject(((PolarxResultset.Row)packet.getPacket()).getFieldList());
                                }
                                case 21: {
                                    chunk = (PolarxResultset.Chunk)packet.getPacket();
                                    this.fetchCount += (long)chunk.getRowCount();
                                    long tokenSizeLow = (long)this.connection.getDefaultTokenKb() * 1024L / 5L;
                                    if (this.allowPrefetchToken && this.tokenSize < tokenSizeLow && this.pipe.getBufferSize() < tokenSizeLow) {
                                        this.connection.tokenOffer();
                                        this.tokenSize = (long)this.connection.getDefaultTokenKb() * 1024L;
                                        ++this.activeOfferTokenCount;
                                    }
                                    this.resultChunk = true;
                                    return new XResultObject((PolarxResultset.Chunk)packet.getPacket());
                                }
                                case 14: {
                                    String indexes;
                                    fetchDone = (PolarxResultset.FetchDone)packet.getPacket();
                                    if (fetchDone.hasExaminedRowCount()) {
                                        this.examinedRowCount = fetchDone.getExaminedRowCount();
                                    }
                                    if (fetchDone.hasChosenIndex() && (indexArray = (indexes = fetchDone.getChosenIndex().toStringUtf8()).split(";")).length > 0) {
                                        if (null == this.chosenIndexes) {
                                            this.chosenIndexes = new ArrayList<String[]>(indexArray.length);
                                        }
                                        for (String index : indexArray) {
                                            this.chosenIndexes.add(index.split("\\."));
                                        }
                                    }
                                    this.status = ResultStatus.XResultFetchDone;
                                    continue block56;
                                }
                                case 16: {
                                    this.status = ResultStatus.XResultFatal;
                                    this.finishNanos = gotPktNanos - this.startNanos;
                                    throw GeneralUtil.nestedException((Throwable)this.session.setLastException((Throwable)new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Fatal error more result set not supported."}), true));
                                }
                            }
                            break;
                        }
                        case XResultFetchDone: {
                            switch (packet.getType()) {
                                case 17: {
                                    this.status = ResultStatus.XResultFinish;
                                    this.finishNanos = gotPktNanos - this.startNanos;
                                    return null;
                                }
                                case 11: {
                                    try {
                                        PolarxNotice.SessionStateChanged sessionStateChanged2;
                                        frame2 = (PolarxNotice.Frame)packet.getPacket();
                                        if (3 != frame2.getType() || (sessionStateChanged2 = PolarxNotice.SessionStateChanged.parseFrom(frame2.getPayload())).getParam() != PolarxNotice.SessionStateChanged.Parameter.ROWS_AFFECTED || !sessionStateChanged2.hasValue() || PolarxDatatypes.Scalar.Type.V_UINT != sessionStateChanged2.getValue().getType()) break block8;
                                        this.rowsAffected = sessionStateChanged2.getValue().getVUnsignedInt();
                                        this.status = ResultStatus.XResultAffected;
                                        continue block56;
                                    }
                                    catch (Throwable frame3) {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        case XResultAffected: {
                            if (17 != packet.getType()) break;
                            this.status = ResultStatus.XResultFinish;
                            this.finishNanos = gotPktNanos - this.startNanos;
                            return null;
                        }
                    }
                }
                if (1 == packet.getType()) {
                    Polarx.Error error = (Polarx.Error)packet.getPacket();
                    if (XConfig.GALAXY_X_PROTOCOL && this.requestType == RequestType.EXPECTATIONS && 5159 == error.getCode() && this.sql.equals((Object)"expect_close")) {
                        this.status = ResultStatus.XResultFinish;
                        this.finishNanos = gotPktNanos - this.startNanos;
                        return null;
                    }
                    if (!(error.getSeverity() != Polarx.Error.Severity.ERROR || this.ignoreResult && this.isFatalOnIgnorable)) {
                        if (!(ResultStatus.XResultStart != this.status || 6000 != error.getCode() && 8000 != error.getCode() || this.retransmitPacketBuilder == null || this.ignoreResult)) {
                            try {
                                boolean badUsage = false;
                                XResult last = this.connection.getSession().getLastRequest();
                                if (last != this) {
                                    while (last != null) {
                                        if (last == this) {
                                            badUsage = true;
                                            break;
                                        }
                                        last = last.previous;
                                    }
                                }
                                if (!badUsage) {
                                    logger.debug("Sql/plan cache miss.");
                                    if (this.connection.getDataSource() != null) {
                                        if (this.retransmitPacketBuilder.isPlan()) {
                                            this.connection.getDataSource().getCachePlanMiss().getAndIncrement();
                                        } else if (this.retransmitPacketBuilder.isSql()) {
                                            this.connection.getDataSource().getCacheSqlMiss().getAndIncrement();
                                        }
                                    }
                                    this.connection.getSession().getClient().send(this.retransmitPacketBuilder.build(), true);
                                    this.retransmitPacketBuilder = null;
                                    this.retrans = true;
                                    continue;
                                }
                            }
                            catch (Throwable t) {
                                throw GeneralUtil.nestedException((Throwable)this.session.setLastException(t, true));
                            }
                            this.status = ResultStatus.XResultError;
                            this.finishNanos = gotPktNanos - this.startNanos;
                            throw new SQLException("Sql cache mismatch while pipeline is not empty.", error.getSqlState(), error.getCode());
                        }
                        this.status = ResultStatus.XResultError;
                        this.finishNanos = gotPktNanos - this.startNanos;
                        if (error.getCode() == 1062) {
                            throw new MySQLIntegrityConstraintViolationException(error.getMsg(), error.getSqlState(), error.getCode());
                        }
                        throw new SQLException(error.getMsg(), error.getSqlState(), error.getCode());
                    }
                    this.status = ResultStatus.XResultFatal;
                    this.finishNanos = gotPktNanos - this.startNanos;
                    throw (SQLException)this.session.setLastException(new SQLException("Fatal error when fetch data: " + error.getMsg(), error.getSqlState(), error.getCode()), true);
                }
                if (11 == packet.getType()) {
                    try {
                        frame2 = (PolarxNotice.Frame)packet.getPacket();
                        block40 : switch (frame2.getType()) {
                            case 1: {
                                if (PolarxNotice.Frame.Scope.LOCAL != frame2.getScope()) break;
                                this.warnings.add(PolarxNotice.Warning.parseFrom(frame2.getPayload()));
                                break;
                            }
                            case 3: {
                                if (PolarxNotice.Frame.Scope.LOCAL != frame2.getScope()) break;
                                sessionStateChanged = PolarxNotice.SessionStateChanged.parseFrom(frame2.getPayload());
                                if (sessionStateChanged.getParam() != PolarxNotice.SessionStateChanged.Parameter.GENERATED_INSERT_ID || !sessionStateChanged.hasValue()) continue block56;
                                switch (sessionStateChanged.getValue().getType()) {
                                    case V_SINT: {
                                        this.generatedInsertId = sessionStateChanged.getValue().getVSignedInt();
                                        this.haveGeneratedInsertId = true;
                                        break block40;
                                    }
                                    case V_UINT: {
                                        this.generatedInsertId = sessionStateChanged.getValue().getVUnsignedInt();
                                        this.haveGeneratedInsertId = true;
                                        break block40;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (19 != packet.getType()) break;
                this.connection.tokenOffer();
                this.tokenSize = (long)this.connection.getDefaultTokenKb() * 1024L;
                ++this.tokenDoneCount;
            }
            this.finishNanos = gotPktNanos - this.startNanos;
            throw GeneralUtil.nestedException((Throwable)this.connection.setLastException((Throwable)new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"XResult unexpected packet type " + packet.getType() + " at status " + this.status.name() + "."}), true));
        }
    }

    private void initMeta() throws SQLException {
        if (this.status != ResultStatus.XResultStart && this.status != ResultStatus.XResultMeta) {
            return;
        }
        try {
            this.pipeCache = this.internalFetchOneObject();
            if (null == this.pipeCache) {
                this.doLog();
            }
        }
        catch (Exception e) {
            if (this.finishNanos < 0L) {
                this.finishNanos = System.nanoTime() - this.startNanos;
            }
            this.doLog();
            throw e;
        }
    }

    public XResultObject current() {
        return 0 == this.idx ? null : this.pipeCache;
    }

    public XResultObject next() throws SQLException {
        if (this.rows != null) {
            if (this.idx < this.rows.size()) {
                this.pipeCache = new XResultObject(this.rows.get(this.idx));
                ++this.idx;
            } else {
                this.pipeCache = null;
            }
            return this.current();
        }
        if (ResultStatus.XResultFinish == this.status) {
            return null;
        }
        if (this.pipeCache != null && 0 == this.idx) {
            ++this.idx;
            return this.current();
        }
        try {
            this.pipeCache = this.internalFetchOneObject();
            if (null == this.pipeCache) {
                this.doLog();
            }
        }
        catch (Exception e) {
            if (this.finishNanos < 0L) {
                this.finishNanos = System.nanoTime() - this.startNanos;
            }
            this.doLog();
            throw e;
        }
        ++this.idx;
        return this.current();
    }

    public XResultObject mergeNext(XResultObject current) throws SQLException {
        assert (current != null);
        XResultObject next = this.next();
        if (null == next.getChunk()) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Error merge on non-chunk result."});
        }
        current.addSecondChunk(next.getChunk());
        this.pipeCache = current;
        return this.current();
    }

    public long currentPipeSize() {
        if (this.pipeCache != null) {
            if (this.pipeCache.getRow() != null) {
                return this.pipeCache.getRow().stream().mapToLong(ByteString::size).sum();
            }
            return this.pipeCache.getChunk().getColumnsList().stream().mapToLong(c -> (c.hasNullBitmap() ? c.getNullBitmap().size() : 0) + (c.hasFixedSizeColumn() ? c.getFixedSizeColumn().getValue().size() : 0) + (c.hasVariableSizeColumn() ? c.getVariableSizeColumn().getValue().size() : 0)).sum();
        }
        return 0L;
    }

    public long getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public PolarxPhysicalBackfill.TransferFileDataOperator getBufferFromIbdFile() {
        return this.bufferFromIbdFile;
    }

    public PolarxPhysicalBackfill.GetFileInfoOperator getIbdFileInfo() {
        return this.ibdFileInfo;
    }

    public PolarxPhysicalBackfill.FileManageOperatorResponse getFileManageOperatorResponse() {
        return this.fileManageOperatorResponse;
    }

    public static enum ResultStatus {
        XResultStart,
        XResultMeta,
        XResultRows,
        XResultFetchDone,
        XResultAffected,
        XResultFinish,
        XResultError,
        XResultFatal;

    }

    public static enum RequestType {
        SQL_QUERY("sql_query"),
        SQL_UPDATE("sql_update"),
        PLAN_QUERY("plan_query"),
        PLAN_UPDATE("plan_update"),
        FETCH_TSO("fetch_tso"),
        EXPECTATIONS("expectations"),
        SQL_PREPARE_EXECUTE("sql_prepare_execute"),
        AUTO_SP("auto_sp"),
        GET_FILE_INFO("get_file_info"),
        TRANSFER_FILE("transfer_file"),
        CLONE_FILE("clone_file"),
        DELETE_FILE("delete_file"),
        FALLOCATE_FILE("fallocate_file");

        private final String name;

        private RequestType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

