/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.rpc.result.chunk.BlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.BitBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.DateBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.DatetimeBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.DecimalBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.DoubleBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.FloatBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.LongBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.SetBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.SignedLongBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.StringBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.block.TimeBlockDecoder;
import com.google.protobuf.ByteString;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.util.ArrayList;
import java.util.List;

public class XResultObject {
    private final PolarxResultset.Chunk chunk;
    private List<PolarxResultset.Chunk> secondChunks = null;
    private final List<ByteString> row;
    private List<PolarxResultset.ColumnMetaData> metas = null;
    private List<BlockDecoder> decoders = null;

    public XResultObject() {
        this.chunk = null;
        this.row = null;
    }

    public XResultObject(PolarxResultset.Chunk chunk) {
        this.chunk = chunk;
        this.row = null;
    }

    public XResultObject(List<ByteString> row) {
        this.chunk = null;
        this.row = row;
    }

    public void addSecondChunk(PolarxResultset.Chunk secondChunk) {
        if (null == this.secondChunks) {
            this.secondChunks = new ArrayList<PolarxResultset.Chunk>();
        }
        this.secondChunks.add(secondChunk);
    }

    public boolean isPending() {
        return null == this.chunk && null == this.row;
    }

    public PolarxResultset.Chunk getChunk() {
        return this.chunk;
    }

    public List<PolarxResultset.Chunk> getSecondChunks() {
        return this.secondChunks;
    }

    public List<ByteString> getRow() {
        return this.row;
    }

    public int getChunkColumnCount() {
        return (null == this.chunk ? 0 : this.chunk.getColumnsCount()) + (null == this.secondChunks ? 0 : this.secondChunks.stream().mapToInt(PolarxResultset.Chunk::getColumnsCount).sum());
    }

    private BlockDecoder choseDecoder(PolarxResultset.Chunk nowChunk, int index, PolarxResultset.ColumnMetaData meta) {
        switch (meta.getType()) {
            case SINT: {
                return new SignedLongBlockDecoder(nowChunk, index, meta);
            }
            case UINT: {
                return new LongBlockDecoder(nowChunk, index, meta);
            }
            case DOUBLE: {
                return new DoubleBlockDecoder(nowChunk, index, meta);
            }
            case FLOAT: {
                return new FloatBlockDecoder(nowChunk, index, meta);
            }
            case BYTES: 
            case ENUM: {
                return new StringBlockDecoder(nowChunk, index, meta);
            }
            case TIME: {
                return new TimeBlockDecoder(nowChunk, index, meta);
            }
            case DATETIME: {
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_DATE: 
                    case MYSQL_TYPE_NEWDATE: {
                        return new DateBlockDecoder(nowChunk, index, meta);
                    }
                    case MYSQL_TYPE_DATETIME: 
                    case MYSQL_TYPE_DATETIME2: 
                    case MYSQL_TYPE_TIMESTAMP: 
                    case MYSQL_TYPE_TIMESTAMP2: {
                        return new DatetimeBlockDecoder(nowChunk, index, meta);
                    }
                }
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unknown DATETIME sub-type " + meta.getOriginalType().toString()});
            }
            case SET: {
                return new SetBlockDecoder(nowChunk, index, meta);
            }
            case BIT: {
                return new BitBlockDecoder(nowChunk, index, meta);
            }
            case DECIMAL: {
                return new DecimalBlockDecoder(nowChunk, index, meta);
            }
        }
        throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unknown meta type " + meta.getType().toString()});
    }

    public boolean intiForChunkDecode(List<PolarxResultset.ColumnMetaData> metas) {
        if (null == this.chunk) {
            return false;
        }
        this.metas = metas;
        this.decoders = new ArrayList<BlockDecoder>(metas.size());
        int totalColumn = this.getChunkColumnCount();
        if (totalColumn != metas.size()) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Chunk column number mismatch."});
        }
        int metaIdx = 0;
        for (int i = 0; i < this.chunk.getColumnsCount(); ++i) {
            this.decoders.add(this.choseDecoder(this.chunk, i, metas.get(metaIdx++)));
        }
        if (this.secondChunks != null) {
            for (PolarxResultset.Chunk c : this.secondChunks) {
                for (int i = 0; i < c.getColumnsCount(); ++i) {
                    this.decoders.add(this.choseDecoder(c, i, metas.get(metaIdx++)));
                }
            }
        }
        return true;
    }

    public boolean next() {
        try {
            for (BlockDecoder decoder : this.decoders) {
                if (decoder.next()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, (Throwable)e, new String[0]);
        }
    }

    public List<BlockDecoder> getDecoders() {
        return this.decoders;
    }
}

