/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result;

import com.alibaba.polardbx.common.CrcAccumulator;
import com.alibaba.polardbx.common.charset.MySQLUnicodeUtils;
import com.alibaba.polardbx.common.datatype.Decimal;
import com.alibaba.polardbx.common.datatype.DecimalConverter;
import com.alibaba.polardbx.common.datatype.DecimalStructure;
import com.alibaba.polardbx.common.datatype.FastDecimalUtils;
import com.alibaba.polardbx.common.datatype.RawBytesDecimalUtils;
import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.utils.BigDecimalUtil;
import com.alibaba.polardbx.common.utils.LongUtil;
import com.alibaba.polardbx.common.utils.Pair;
import com.alibaba.polardbx.common.utils.time.MySQLTimeConverter;
import com.alibaba.polardbx.common.utils.time.core.MySQLTimeVal;
import com.alibaba.polardbx.common.utils.time.core.MysqlDateTime;
import com.alibaba.polardbx.common.utils.time.core.OriginalDate;
import com.alibaba.polardbx.common.utils.time.core.OriginalTime;
import com.alibaba.polardbx.common.utils.time.core.OriginalTimestamp;
import com.alibaba.polardbx.common.utils.time.core.TimeStorage;
import com.alibaba.polardbx.common.utils.time.parser.TimeParseStatus;
import com.alibaba.polardbx.rpc.jdbc.CharsetMapping;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import io.airlift.slice.Slice;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.BiFunction;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;

public class XResultUtil {
    private static final Charset LATIN1 = Charset.forName("LATIN1");
    private static final byte[] EMPTY_BYTES = new byte[0];
    public static final int COLUMN_FLAGS_UINT_ZEROFILL = 1;
    public static final int COLUMN_FLAGS_DOUBLE_UNSIGNED = 1;
    public static final int COLUMN_FLAGS_FLOAT_UNSIGNED = 1;
    public static final int COLUMN_FLAGS_DECIMAL_UNSIGNED = 1;
    public static final int COLUMN_FLAGS_BYTES_RIGHTPAD = 1;
    public static final int COLUMN_FLAGS_DATETIME_TIMESTAMP = 1;
    public static final int COLUMN_FLAGS_NOT_NULL = 16;
    public static final int COLUMN_FLAGS_PRIMARY_KEY = 32;
    public static final int COLUMN_FLAGS_UNIQUE_KEY = 64;
    public static final int COLUMN_FLAGS_MULTIPLE_KEY = 128;
    public static final int COLUMN_FLAGS_AUTO_INCREMENT = 256;
    public static final int CONTENT_TYPE_BYTES_GEOMETRY = 1;
    public static final int CONTENT_TYPE_BYTES_JSON = 2;
    public static final int CONTENT_TYPE_BYTES_XML = 3;
    public static final int GTS_PROTOCOL_SUCCESS = 0;
    public static final int GTS_PROTOCOL_NOT_INITED = 1;
    public static final int GTS_PROTOCOL_LEASE_EXPIRE = 2;
    public static long ZERO_TIMESTAMP_LONG_VAL = 0L;

    public static Pair<Object, byte[]> resultToObject(PolarxResultset.ColumnMetaData meta, ByteString data, boolean legacy, TimeZone tz) throws Exception {
        byte[] bytes;
        Object obj;
        String encoding;
        boolean isBinary;
        byte[] rawBytes = data.toByteArray();
        if (0 == rawBytes.length) {
            return new Pair(null, null);
        }
        CodedInputStream stream = CodedInputStream.newInstance((byte[])rawBytes);
        if (meta.hasCollation()) {
            isBinary = 63L == meta.getCollation();
            encoding = CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation());
        } else {
            isBinary = false;
            encoding = null;
        }
        block0 : switch (meta.getType()) {
            case SINT: {
                obj = stream.readSInt64();
                bytes = obj.toString().getBytes();
                break;
            }
            case UINT: {
                byte[] orgBytes;
                boolean zerofill = (meta.getFlags() & 1) != 0;
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_LONGLONG: {
                        obj = new BigInteger(ByteBuffer.allocate(9).put((byte)0).putLong(stream.readUInt64()).array());
                        orgBytes = obj.toString().getBytes();
                        break;
                    }
                    case MYSQL_TYPE_YEAR: {
                        long l = stream.readUInt64();
                        MysqlDateTime mysqlDateTime = new MysqlDateTime();
                        mysqlDateTime.setSqlType(91);
                        mysqlDateTime.setNeg(false);
                        mysqlDateTime.setYear(l);
                        mysqlDateTime.setMonth(1L);
                        mysqlDateTime.setDay(1L);
                        obj = new OriginalDate(mysqlDateTime);
                        StringBuilder builder = new StringBuilder();
                        if (l >= 1000L) {
                            builder.append(l);
                        } else if (l >= 100L) {
                            builder.append('0').append(l);
                        } else if (l >= 10L) {
                            builder.append("00").append(l);
                        } else if (l >= 0L) {
                            builder.append("000").append(l);
                        } else {
                            builder.append(l);
                        }
                        orgBytes = builder.toString().getBytes();
                        break;
                    }
                    default: {
                        obj = stream.readUInt64();
                        orgBytes = obj.toString().getBytes();
                    }
                }
                int len = meta.getLength();
                if (zerofill && len > orgBytes.length) {
                    bytes = new byte[len];
                    int pad = len - orgBytes.length;
                    System.arraycopy(orgBytes, 0, bytes, pad, orgBytes.length);
                    for (int i = 0; i < pad; ++i) {
                        bytes[i] = 48;
                    }
                    break;
                }
                bytes = orgBytes;
                break;
            }
            case DOUBLE: {
                obj = stream.readDouble();
                bytes = obj.toString().getBytes();
                break;
            }
            case FLOAT: {
                obj = Float.valueOf(stream.readFloat());
                bytes = obj.toString().getBytes();
                break;
            }
            case BYTES: {
                bytes = Arrays.copyOf(rawBytes, rawBytes.length - 1);
                switch (meta.getContentType()) {
                    case 1: {
                        obj = bytes;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        if (null == encoding || isBinary) {
                            obj = new String(rawBytes, 0, rawBytes.length - 1);
                            break block0;
                        }
                        obj = new String(rawBytes, 0, rawBytes.length - 1, encoding);
                        break block0;
                    }
                }
                if (isBinary) {
                    obj = bytes;
                    break;
                }
                if (null == encoding) {
                    obj = new String(rawBytes, 0, rawBytes.length - 1);
                    break;
                }
                obj = new String(rawBytes, 0, rawBytes.length - 1, encoding);
                break;
            }
            case TIME: {
                boolean negative = stream.readRawByte() > 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int nanos = 0;
                if (!stream.isAtEnd()) {
                    hours = (int)stream.readInt64();
                    if (!stream.isAtEnd()) {
                        minutes = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            seconds = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                nanos = 1000 * (int)stream.readInt64();
                            }
                        }
                    }
                }
                MysqlDateTime mysqlDateTime = new MysqlDateTime();
                mysqlDateTime.setSqlType(92);
                mysqlDateTime.setNeg(negative);
                mysqlDateTime.setHour((long)hours);
                mysqlDateTime.setMinute((long)minutes);
                mysqlDateTime.setSecond((long)seconds);
                mysqlDateTime.setSecondPart((long)nanos);
                if (!legacy) {
                    throw new UnsupportedOperationException("Unsupported type: " + meta.getType().name());
                }
                obj = new OriginalTime(mysqlDateTime);
                String timeStr = mysqlDateTime.toTimeString(Math.min(6, meta.getFractionalDigits()));
                bytes = timeStr.getBytes();
                break;
            }
            case DATETIME: {
                MysqlDateTime mysqlDateTime = new MysqlDateTime();
                int year = (int)stream.readUInt64();
                int month = (int)stream.readUInt64();
                int day = (int)stream.readUInt64();
                if (stream.getBytesUntilLimit() > 0) {
                    int hours = 0;
                    int minutes = 0;
                    int seconds = 0;
                    int nanos = 0;
                    if (!stream.isAtEnd()) {
                        hours = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            minutes = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                seconds = (int)stream.readInt64();
                                if (!stream.isAtEnd()) {
                                    nanos = 1000 * (int)stream.readInt64();
                                }
                            }
                        }
                    }
                    mysqlDateTime.setSqlType(93);
                    mysqlDateTime.setNeg(false);
                    mysqlDateTime.setYear((long)year);
                    mysqlDateTime.setMonth((long)month);
                    mysqlDateTime.setDay((long)day);
                    mysqlDateTime.setHour((long)hours);
                    mysqlDateTime.setMinute((long)minutes);
                    mysqlDateTime.setSecond((long)seconds);
                    mysqlDateTime.setSecondPart((long)nanos);
                    if (!legacy) {
                        throw new UnsupportedOperationException("Unsupported type: " + meta.getType().name());
                    }
                    obj = new OriginalTimestamp(mysqlDateTime);
                    String timeStr = mysqlDateTime.toDatetimeString(Math.min(6, meta.getFractionalDigits()));
                    bytes = timeStr.getBytes();
                    break;
                }
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_DATE: 
                    case MYSQL_TYPE_NEWDATE: {
                        mysqlDateTime.setSqlType(91);
                        mysqlDateTime.setNeg(false);
                        mysqlDateTime.setYear((long)year);
                        mysqlDateTime.setMonth((long)month);
                        mysqlDateTime.setDay((long)day);
                        if (!legacy) {
                            throw new UnsupportedOperationException("Unsupported type: " + meta.getType().name());
                        }
                        obj = new OriginalDate(mysqlDateTime);
                        String timeStr = mysqlDateTime.toDateString();
                        bytes = timeStr.getBytes();
                        break block0;
                    }
                    case MYSQL_TYPE_DATETIME: 
                    case MYSQL_TYPE_DATETIME2: 
                    case MYSQL_TYPE_TIMESTAMP: 
                    case MYSQL_TYPE_TIMESTAMP2: {
                        mysqlDateTime.setSqlType(93);
                        mysqlDateTime.setNeg(false);
                        mysqlDateTime.setYear((long)year);
                        mysqlDateTime.setMonth((long)month);
                        mysqlDateTime.setDay((long)day);
                        if (!legacy) {
                            throw new UnsupportedOperationException("Unsupported type: " + meta.getType().name());
                        }
                        obj = new OriginalTimestamp(mysqlDateTime);
                        String timeStr = mysqlDateTime.toDatetimeString(Math.min(6, meta.getFractionalDigits()));
                        bytes = timeStr.getBytes();
                        break block0;
                    }
                }
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name() + " org_type: " + meta.getOriginalType().name()});
            }
            case SET: {
                StringBuilder vals = new StringBuilder();
                while (stream.getBytesUntilLimit() > 0) {
                    if (vals.length() > 0) {
                        vals.append(",");
                    }
                    long valLen = stream.readUInt64();
                    vals.append(new String(stream.readRawBytes((int)valLen), encoding));
                }
                String str = vals.toString();
                obj = str;
                bytes = str.getBytes();
                break;
            }
            case ENUM: {
                String str = new String(rawBytes, 0, rawBytes.length - 1, encoding);
                obj = str;
                bytes = str.getBytes();
                break;
            }
            case BIT: {
                ByteBuffer buf = ByteBuffer.allocate(8).putLong(stream.readUInt64());
                int bytesLen = meta.getLength() / 8 + (meta.getLength() % 8 != 0 ? 1 : 0);
                bytes = new byte[bytesLen];
                obj = bytes;
                buf.flip();
                buf.position(8 - bytesLen);
                buf.get(bytes);
                break;
            }
            case DECIMAL: {
                byte scale = stream.readRawByte();
                CharBuffer unscaledString = CharBuffer.allocate(2 * stream.getBytesUntilLimit());
                unscaledString.position(1);
                byte sign = 0;
                while (true) {
                    int b;
                    if ((b = 0xFF & stream.readRawByte()) >> 4 > 9) {
                        sign = (byte)(b >> 4);
                        break;
                    }
                    unscaledString.append((char)((b >> 4) + 48));
                    if ((b & 0xF) > 9) {
                        sign = (byte)(b & 0xF);
                        break;
                    }
                    unscaledString.append((char)((b & 0xF) + 48));
                }
                if (stream.getBytesUntilLimit() > 0) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Did not read all bytes while decoding decimal. Bytes left: " + stream.getBytesUntilLimit()});
                }
                switch (sign) {
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        unscaledString.put(0, '+');
                        break;
                    }
                    case 11: 
                    case 13: {
                        unscaledString.put(0, '-');
                    }
                }
                int characters = unscaledString.position();
                unscaledString.clear();
                BigInteger unscaled = new BigInteger(unscaledString.subSequence(0, characters).toString());
                obj = new BigDecimal(unscaled, scale);
                bytes = obj.toString().getBytes();
                break;
            }
            default: {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name()});
            }
        }
        return new Pair(obj, (Object)bytes);
    }

    private static boolean isUtf8(String charset) {
        return !(charset.length() < 4 || 'U' != charset.charAt(0) && 'u' != charset.charAt(0) || 'T' != charset.charAt(1) && 't' != charset.charAt(1) || 'F' != charset.charAt(2) && 'f' != charset.charAt(2) || '8' != charset.charAt(3));
    }

    public static byte[] resultToBytes(PolarxResultset.ColumnMetaData meta, ByteString data, String targetCharset) throws Exception {
        if (0 == data.size()) {
            return null;
        }
        CodedInputStream stream = data.newCodedInput();
        switch (meta.getType()) {
            case SINT: {
                return LongUtil.toBytes((long)stream.readSInt64());
            }
            case UINT: {
                byte[] orgBytes;
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_YEAR: {
                        byte[] year = LongUtil.toUnsignedBytes((long)stream.readUInt64());
                        orgBytes = new byte[]{48, 48, 48, 48};
                        assert (year.length <= orgBytes.length);
                        System.arraycopy(year, 0, orgBytes, orgBytes.length - year.length, year.length);
                        break;
                    }
                    default: {
                        orgBytes = LongUtil.toUnsignedBytes((long)stream.readUInt64());
                    }
                }
                int len = meta.getLength();
                if ((meta.getFlags() & 1) != 0 && len > orgBytes.length) {
                    byte[] bytes = new byte[len];
                    int pad = len - orgBytes.length;
                    System.arraycopy(orgBytes, 0, bytes, pad, orgBytes.length);
                    for (int i = 0; i < pad; ++i) {
                        bytes[i] = 48;
                    }
                    return bytes;
                }
                return orgBytes;
            }
            case DOUBLE: {
                return Double.toString(stream.readDouble()).getBytes();
            }
            case FLOAT: {
                return Float.toString(stream.readFloat()).getBytes();
            }
            case BYTES: {
                boolean isUtf8;
                String mysqlCharset;
                String encoding;
                switch (meta.getContentType()) {
                    case 1: {
                        return stream.readRawBytes(data.size() - 1);
                    }
                }
                if (meta.hasCollation()) {
                    if (meta.getCollation() != 63L) {
                        encoding = CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation());
                        mysqlCharset = CharsetMapping.getCollationForCollationIndex((int)meta.getCollation());
                        isUtf8 = CharsetMapping.isUtf8((int)meta.getCollation());
                    } else {
                        encoding = null;
                        mysqlCharset = null;
                        isUtf8 = false;
                    }
                } else {
                    encoding = null;
                    mysqlCharset = null;
                    isUtf8 = false;
                }
                if (null == mysqlCharset || isUtf8 && XResultUtil.isUtf8(targetCharset) || mysqlCharset.equalsIgnoreCase(targetCharset)) {
                    return stream.readRawBytes(data.size() - 1);
                }
                return new String(stream.readRawBytes(data.size() - 1), encoding).getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
            }
            case TIME: {
                boolean negative = stream.readRawByte() > 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int nanos = 0;
                if (!stream.isAtEnd()) {
                    hours = (int)stream.readInt64();
                    if (!stream.isAtEnd()) {
                        minutes = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            seconds = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                nanos = 1000 * (int)stream.readInt64();
                            }
                        }
                    }
                }
                MysqlDateTime mysqlDateTime = new MysqlDateTime();
                mysqlDateTime.setSqlType(92);
                mysqlDateTime.setNeg(negative);
                mysqlDateTime.setHour((long)hours);
                mysqlDateTime.setMinute((long)minutes);
                mysqlDateTime.setSecond((long)seconds);
                mysqlDateTime.setSecondPart((long)nanos);
                return mysqlDateTime.toTimeString(Math.min(6, meta.getFractionalDigits())).getBytes();
            }
            case DATETIME: {
                MysqlDateTime mysqlDateTime = new MysqlDateTime();
                int year = (int)stream.readUInt64();
                int month = (int)stream.readUInt64();
                int day = (int)stream.readUInt64();
                if (stream.getBytesUntilLimit() > 0) {
                    int hours = 0;
                    int minutes = 0;
                    int seconds = 0;
                    int nanos = 0;
                    if (!stream.isAtEnd()) {
                        hours = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            minutes = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                seconds = (int)stream.readInt64();
                                if (!stream.isAtEnd()) {
                                    nanos = 1000 * (int)stream.readInt64();
                                }
                            }
                        }
                    }
                    mysqlDateTime.setSqlType(93);
                    mysqlDateTime.setNeg(false);
                    mysqlDateTime.setYear((long)year);
                    mysqlDateTime.setMonth((long)month);
                    mysqlDateTime.setDay((long)day);
                    mysqlDateTime.setHour((long)hours);
                    mysqlDateTime.setMinute((long)minutes);
                    mysqlDateTime.setSecond((long)seconds);
                    mysqlDateTime.setSecondPart((long)nanos);
                    return mysqlDateTime.fastToDatetimeBytes(Math.min(6, meta.getFractionalDigits()));
                }
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_DATE: 
                    case MYSQL_TYPE_NEWDATE: {
                        mysqlDateTime.setSqlType(91);
                        mysqlDateTime.setNeg(false);
                        mysqlDateTime.setYear((long)year);
                        mysqlDateTime.setMonth((long)month);
                        mysqlDateTime.setDay((long)day);
                        return mysqlDateTime.fastToDateBytes();
                    }
                    case MYSQL_TYPE_DATETIME: 
                    case MYSQL_TYPE_DATETIME2: 
                    case MYSQL_TYPE_TIMESTAMP: 
                    case MYSQL_TYPE_TIMESTAMP2: {
                        mysqlDateTime.setSqlType(93);
                        mysqlDateTime.setNeg(false);
                        mysqlDateTime.setYear((long)year);
                        mysqlDateTime.setMonth((long)month);
                        mysqlDateTime.setDay((long)day);
                        return mysqlDateTime.fastToDatetimeBytes(Math.min(6, meta.getFractionalDigits()));
                    }
                }
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name() + " org_type: " + meta.getOriginalType().name()});
            }
            case SET: {
                String encoding = meta.hasCollation() ? CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation()) : null;
                StringBuilder vals = new StringBuilder();
                while (stream.getBytesUntilLimit() > 0) {
                    if (vals.length() > 0) {
                        vals.append(",");
                    }
                    long valLen = stream.readUInt64();
                    if (encoding != null) {
                        vals.append(new String(stream.readRawBytes((int)valLen), encoding));
                        continue;
                    }
                    vals.append(new String(stream.readRawBytes((int)valLen)));
                }
                return vals.toString().getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
            }
            case ENUM: {
                boolean isUtf8;
                String mysqlCharset;
                String encoding;
                if (meta.hasCollation()) {
                    if (meta.getCollation() != 63L) {
                        encoding = CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation());
                        mysqlCharset = CharsetMapping.getCollationForCollationIndex((int)meta.getCollation());
                        isUtf8 = CharsetMapping.isUtf8((int)meta.getCollation());
                    } else {
                        encoding = null;
                        mysqlCharset = null;
                        isUtf8 = false;
                    }
                } else {
                    encoding = null;
                    mysqlCharset = null;
                    isUtf8 = false;
                }
                if (null == mysqlCharset || mysqlCharset.equalsIgnoreCase(targetCharset) || isUtf8 && XResultUtil.isUtf8(targetCharset)) {
                    return stream.readRawBytes(data.size() - 1);
                }
                return new String(stream.readRawBytes(data.size() - 1), encoding).getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
            }
            case BIT: {
                ByteBuffer buf = ByteBuffer.allocate(8).putLong(stream.readUInt64());
                int bytesLen = meta.getLength() / 8 + (meta.getLength() % 8 != 0 ? 1 : 0);
                byte[] bytes = new byte[bytesLen];
                buf.flip();
                buf.position(8 - bytesLen);
                buf.get(bytes);
                return bytes;
            }
            case DECIMAL: {
                byte sign;
                byte scale = stream.readRawByte();
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2 * stream.getBytesUntilLimit());
                byteStream.write(43);
                while (true) {
                    int b;
                    if ((b = 0xFF & stream.readRawByte()) >> 4 > 9) {
                        sign = (byte)(b >> 4);
                        break;
                    }
                    byteStream.write((char)((b >> 4) + 48));
                    if ((b & 0xF) > 9) {
                        sign = (byte)(b & 0xF);
                        break;
                    }
                    byteStream.write((char)((b & 0xF) + 48));
                }
                if (stream.getBytesUntilLimit() > 0) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Did not read all bytes while decoding decimal. Bytes left: " + stream.getBytesUntilLimit()});
                }
                byte[] byteStrNum = byteStream.toByteArray();
                switch (sign) {
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        byteStrNum[0] = 43;
                        break;
                    }
                    case 11: 
                    case 13: {
                        byteStrNum[0] = 45;
                    }
                }
                return BigDecimalUtil.fastGetBigDecimalStringBytes((byte[])byteStrNum, (int)scale);
            }
        }
        throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name()});
    }

    public static void resultToColumnVector(PolarxResultset.ColumnMetaData meta, ByteString data, String targetCharset, ColumnVector columnVector, int rowNumber, boolean flipUnsigned, int precision, int scale, int length, ZoneId timezone, ColumnVector redundantColumnVector, BiFunction<byte[], Integer, byte[]> collationHandler, Optional<CrcAccumulator> accumulator) throws Exception {
        if (data.isEmpty()) {
            if (columnVector instanceof LongColumnVector) {
                columnVector.isNull[rowNumber] = true;
                columnVector.noNulls = false;
                ((LongColumnVector)columnVector).vector[rowNumber] = 0L;
                accumulator.ifPresent(CrcAccumulator::appendNull);
                return;
            }
            if (columnVector instanceof BytesColumnVector) {
                columnVector.isNull[rowNumber] = true;
                columnVector.noNulls = false;
                ((BytesColumnVector)columnVector).setRef(rowNumber, EMPTY_BYTES, 0, 0);
                if (redundantColumnVector instanceof BytesColumnVector) {
                    redundantColumnVector.isNull[rowNumber] = true;
                    redundantColumnVector.noNulls = false;
                    ((BytesColumnVector)redundantColumnVector).setRef(rowNumber, EMPTY_BYTES, 0, 0);
                }
                accumulator.ifPresent(CrcAccumulator::appendNull);
                return;
            }
            if (columnVector instanceof DoubleColumnVector) {
                columnVector.isNull[rowNumber] = true;
                columnVector.noNulls = false;
                ((DoubleColumnVector)columnVector).vector[rowNumber] = 0.0;
                accumulator.ifPresent(CrcAccumulator::appendNull);
                return;
            }
            throw new UnsupportedOperationException("Unsupported column vector: " + columnVector);
        }
        CodedInputStream stream = data.newCodedInput();
        switch (meta.getType()) {
            case SINT: {
                long sInt64;
                ((LongColumnVector)columnVector).vector[rowNumber] = sInt64 = stream.readSInt64();
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_LONGLONG: {
                        accumulator.ifPresent(a -> a.appendHash(Long.hashCode(sInt64)));
                        break;
                    }
                    case MYSQL_TYPE_LONG: 
                    case MYSQL_TYPE_INT24: {
                        accumulator.ifPresent(a -> a.appendHash((int)sInt64));
                        break;
                    }
                    case MYSQL_TYPE_SHORT: {
                        accumulator.ifPresent(a -> a.appendHash(Short.hashCode((short)sInt64)));
                        break;
                    }
                    case MYSQL_TYPE_TINY: {
                        accumulator.ifPresent(a -> a.appendHash(Byte.hashCode((byte)sInt64)));
                        break;
                    }
                }
                return;
            }
            case UINT: {
                block19 : switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_YEAR: {
                        long uInt64;
                        ((LongColumnVector)columnVector).vector[rowNumber] = uInt64 = stream.readUInt64();
                        accumulator.ifPresent(a -> a.appendHash(Long.hashCode(uInt64)));
                        break;
                    }
                    default: {
                        long uInt64 = stream.readUInt64();
                        ((LongColumnVector)columnVector).vector[rowNumber] = flipUnsigned ? uInt64 ^ Long.MIN_VALUE : uInt64;
                        switch (meta.getOriginalType()) {
                            case MYSQL_TYPE_LONGLONG: 
                            case MYSQL_TYPE_LONG: {
                                accumulator.ifPresent(a -> a.appendHash(Long.hashCode(uInt64)));
                                break block19;
                            }
                            case MYSQL_TYPE_INT24: 
                            case MYSQL_TYPE_SHORT: {
                                accumulator.ifPresent(a -> a.appendHash((int)uInt64));
                                break block19;
                            }
                            case MYSQL_TYPE_TINY: {
                                accumulator.ifPresent(a -> a.appendHash(Short.hashCode((short)uInt64)));
                            }
                        }
                    }
                }
                return;
            }
            case DOUBLE: {
                double doubleVal;
                ((DoubleColumnVector)columnVector).vector[rowNumber] = doubleVal = stream.readDouble();
                accumulator.ifPresent(a -> a.appendHash(Double.hashCode(doubleVal)));
                return;
            }
            case FLOAT: {
                float floatVal = stream.readFloat();
                ((DoubleColumnVector)columnVector).vector[rowNumber] = floatVal;
                accumulator.ifPresent(a -> a.appendHash(Float.hashCode(floatVal)));
                return;
            }
            case BYTES: {
                boolean isUtf8;
                String mysqlCharset;
                String encoding;
                byte[] rawBytes = stream.readRawBytes(data.size() - 1);
                switch (meta.getContentType()) {
                    case 1: {
                        ((BytesColumnVector)columnVector).setVal(rowNumber, rawBytes);
                        accumulator.ifPresent(a -> a.appendBytes(rawBytes, 0, rawBytes.length));
                        return;
                    }
                }
                if (meta.hasCollation()) {
                    if (meta.getCollation() != 63L) {
                        encoding = CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation());
                        mysqlCharset = CharsetMapping.getCollationForCollationIndex((int)meta.getCollation());
                        isUtf8 = CharsetMapping.isUtf8((int)meta.getCollation());
                    } else {
                        encoding = null;
                        mysqlCharset = null;
                        isUtf8 = false;
                    }
                } else {
                    encoding = null;
                    mysqlCharset = null;
                    isUtf8 = false;
                }
                if (redundantColumnVector != null && collationHandler != null && length != -1) {
                    ((BytesColumnVector)redundantColumnVector).setVal(rowNumber, collationHandler.apply(rawBytes, length));
                }
                if (null == mysqlCharset || mysqlCharset.equalsIgnoreCase(targetCharset) || isUtf8 && XResultUtil.isUtf8(targetCharset)) {
                    ((BytesColumnVector)columnVector).setVal(rowNumber, rawBytes);
                    accumulator.ifPresent(a -> a.appendBytes(rawBytes, 0, rawBytes.length));
                    return;
                }
                byte[] bytesVal = new String(rawBytes, encoding).getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
                ((BytesColumnVector)columnVector).setVal(rowNumber, bytesVal);
                accumulator.ifPresent(a -> a.appendBytes(bytesVal, 0, bytesVal.length));
                return;
            }
            case TIME: {
                long packed;
                boolean negative = stream.readRawByte() > 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int nanos = 0;
                if (!stream.isAtEnd()) {
                    hours = (int)stream.readInt64();
                    if (!stream.isAtEnd()) {
                        minutes = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            seconds = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                nanos = 1000 * (int)stream.readInt64();
                            }
                        }
                    }
                }
                ((LongColumnVector)columnVector).vector[rowNumber] = packed = TimeStorage.writeTime((long)hours, (long)minutes, (long)seconds, (long)nanos, (boolean)negative);
                accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                return;
            }
            case DATETIME: {
                int year = (int)stream.readUInt64();
                int month = (int)stream.readUInt64();
                int day = (int)stream.readUInt64();
                if (stream.getBytesUntilLimit() > 0) {
                    int hours = 0;
                    int minutes = 0;
                    int seconds = 0;
                    int nanos = 0;
                    if (!stream.isAtEnd()) {
                        hours = (int)stream.readInt64();
                        if (!stream.isAtEnd()) {
                            minutes = (int)stream.readInt64();
                            if (!stream.isAtEnd()) {
                                seconds = (int)stream.readInt64();
                                if (!stream.isAtEnd()) {
                                    nanos = 1000 * (int)stream.readInt64();
                                }
                            }
                        }
                    }
                    switch (meta.getOriginalType()) {
                        case MYSQL_TYPE_DATETIME: 
                        case MYSQL_TYPE_DATETIME2: {
                            long packed;
                            ((LongColumnVector)columnVector).vector[rowNumber] = packed = TimeStorage.writeTimestamp((long)year, (long)month, (long)day, (long)hours, (long)minutes, (long)seconds, (long)nanos, (boolean)false);
                            accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                            return;
                        }
                        case MYSQL_TYPE_TIMESTAMP: 
                        case MYSQL_TYPE_TIMESTAMP2: {
                            MysqlDateTime mysqlDateTime = new MysqlDateTime((long)year, (long)month, (long)day, (long)hours, (long)minutes, (long)seconds, (long)nanos);
                            TimeParseStatus timeParseStatus = new TimeParseStatus();
                            MySQLTimeVal timeVal = MySQLTimeConverter.convertDatetimeToTimestampWithoutCheck((MysqlDateTime)mysqlDateTime, (TimeParseStatus)timeParseStatus, (ZoneId)timezone);
                            if (timeVal == null) {
                                timeVal = new MySQLTimeVal();
                            }
                            ((LongColumnVector)columnVector).vector[rowNumber] = year == 0 && month == 0 && day == 0 && hours == 0 && minutes == 0 && seconds == 0 && nanos == 0 ? ZERO_TIMESTAMP_LONG_VAL : XResultUtil.timeValToLong(timeVal);
                            long packed = TimeStorage.writeTimestamp((MysqlDateTime)mysqlDateTime);
                            accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                            return;
                        }
                    }
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name() + " org_type: " + meta.getOriginalType().name()});
                }
                switch (meta.getOriginalType()) {
                    case MYSQL_TYPE_DATE: 
                    case MYSQL_TYPE_NEWDATE: {
                        long packed;
                        ((LongColumnVector)columnVector).vector[rowNumber] = packed = TimeStorage.writeDate((long)year, (long)month, (long)day);
                        accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                        return;
                    }
                    case MYSQL_TYPE_DATETIME: 
                    case MYSQL_TYPE_DATETIME2: {
                        long packed;
                        ((LongColumnVector)columnVector).vector[rowNumber] = packed = TimeStorage.writeTimestamp((long)year, (long)month, (long)day, (long)0L, (long)0L, (long)0L, (long)0L, (boolean)false);
                        accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                        return;
                    }
                    case MYSQL_TYPE_TIMESTAMP: 
                    case MYSQL_TYPE_TIMESTAMP2: {
                        MysqlDateTime mysqlDateTime = new MysqlDateTime((long)year, (long)month, (long)day, 0L, 0L, 0L, 0L);
                        TimeParseStatus timeParseStatus = new TimeParseStatus();
                        MySQLTimeVal timeVal = MySQLTimeConverter.convertDatetimeToTimestampWithoutCheck((MysqlDateTime)mysqlDateTime, (TimeParseStatus)timeParseStatus, (ZoneId)timezone);
                        if (timeVal == null) {
                            timeVal = new MySQLTimeVal();
                        }
                        ((LongColumnVector)columnVector).vector[rowNumber] = year == 0 && month == 0 && day == 0 ? ZERO_TIMESTAMP_LONG_VAL : XResultUtil.timeValToLong(timeVal);
                        long packed = TimeStorage.writeTimestamp((MysqlDateTime)mysqlDateTime);
                        accumulator.ifPresent(a -> a.appendHash(Long.hashCode(packed)));
                        return;
                    }
                }
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name() + " org_type: " + meta.getOriginalType().name()});
            }
            case SET: {
                String encoding = meta.hasCollation() ? CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation()) : null;
                StringBuilder vals = new StringBuilder();
                while (stream.getBytesUntilLimit() > 0) {
                    if (vals.length() > 0) {
                        vals.append(",");
                    }
                    long valLen = stream.readUInt64();
                    if (encoding != null) {
                        vals.append(new String(stream.readRawBytes((int)valLen), encoding));
                        continue;
                    }
                    vals.append(new String(stream.readRawBytes((int)valLen)));
                }
                byte[] bytesVal = vals.toString().getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
                ((BytesColumnVector)columnVector).setVal(rowNumber, bytesVal);
                accumulator.ifPresent(a -> a.appendBytes(bytesVal, 0, bytesVal.length));
                return;
            }
            case ENUM: {
                boolean isUtf8;
                String mysqlCharset;
                String encoding;
                if (meta.hasCollation()) {
                    if (meta.getCollation() != 63L) {
                        encoding = CharsetMapping.getJavaEncodingForCollationIndex((int)meta.getCollation());
                        mysqlCharset = CharsetMapping.getCollationForCollationIndex((int)meta.getCollation());
                        isUtf8 = CharsetMapping.isUtf8((int)meta.getCollation());
                    } else {
                        encoding = null;
                        mysqlCharset = null;
                        isUtf8 = false;
                    }
                } else {
                    encoding = null;
                    mysqlCharset = null;
                    isUtf8 = false;
                }
                byte[] rawBytes = stream.readRawBytes(data.size() - 1);
                if (null == mysqlCharset || mysqlCharset.equalsIgnoreCase(targetCharset) || isUtf8 && XResultUtil.isUtf8(targetCharset)) {
                    ((BytesColumnVector)columnVector).setVal(rowNumber, rawBytes);
                    accumulator.ifPresent(a -> a.appendBytes(rawBytes, 0, rawBytes.length));
                    return;
                }
                byte[] bytesVal = new String(rawBytes, encoding).getBytes(CharsetMapping.getJavaEncodingForMysqlCharset(targetCharset));
                ((BytesColumnVector)columnVector).setVal(rowNumber, bytesVal);
                accumulator.ifPresent(a -> a.appendBytes(bytesVal, 0, bytesVal.length));
                return;
            }
            case BIT: {
                long longVal;
                ByteBuffer buf = ByteBuffer.allocate(8).putLong(stream.readUInt64());
                int bytesLen = meta.getLength() / 8 + (meta.getLength() % 8 != 0 ? 1 : 0);
                byte[] bytes = new byte[bytesLen];
                buf.flip();
                buf.position(8 - bytesLen);
                buf.get(bytes);
                ((LongColumnVector)columnVector).vector[rowNumber] = longVal = XResultUtil.bytesToLong(bytes);
                accumulator.ifPresent(a -> a.appendHash(Long.hashCode(longVal)));
                return;
            }
            case DECIMAL: {
                byte readScale = stream.readRawByte();
                ByteBuffer unscaledString = ByteBuffer.allocate(2 * stream.getBytesUntilLimit());
                unscaledString.position(1);
                byte sign = 0;
                while (true) {
                    int b;
                    if ((b = 0xFF & stream.readRawByte()) >> 4 > 9) {
                        sign = (byte)(b >> 4);
                        break;
                    }
                    unscaledString.put((byte)((b >> 4) + 48));
                    if ((b & 0xF) > 9) {
                        sign = (byte)(b & 0xF);
                        break;
                    }
                    unscaledString.put((byte)((b & 0xF) + 48));
                }
                if (stream.getBytesUntilLimit() > 0) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Did not read all bytes while decoding decimal. Bytes left: " + stream.getBytesUntilLimit()});
                }
                switch (sign) {
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        unscaledString.put(0, (byte)43);
                        break;
                    }
                    case 11: 
                    case 13: {
                        unscaledString.put(0, (byte)45);
                    }
                }
                int characters = unscaledString.position();
                unscaledString.clear();
                byte[] bs = unscaledString.array();
                XResultUtil.putDecimalToVector(columnVector, accumulator, rowNumber, bs, characters, precision, scale);
                return;
            }
        }
        throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Unsupported type: " + meta.getType().name()});
    }

    private static void putDecimalToVector(ColumnVector columnVector, Optional<CrcAccumulator> accumulator, int rowNumber, byte[] bs, int characters, int precision, int scale) {
        if (columnVector instanceof LongColumnVector) {
            XResultUtil.putDecimal64ToVector((LongColumnVector)columnVector, accumulator, rowNumber, bs, characters, precision, scale);
        } else {
            XResultUtil.putNormalDecimalToVector((BytesColumnVector)columnVector, accumulator, rowNumber, bs, characters, precision, scale);
        }
    }

    private static void putDecimal64ToVector(LongColumnVector columnVector, Optional<CrcAccumulator> accumulator, int rowNumber, byte[] bs, int characters, int precision, int scale) {
        long decimal64;
        columnVector.vector[rowNumber] = decimal64 = Long.parseLong(new String(bs, 0, characters));
        Decimal decimal = new Decimal(decimal64, scale);
        accumulator.ifPresent(a -> a.appendHash(RawBytesDecimalUtils.hashCode((Slice)decimal.getMemorySegment())));
    }

    private static void putNormalDecimalToVector(BytesColumnVector columnVector, Optional<CrcAccumulator> accumulator, int rowNumber, byte[] bs, int characters, int precision, int scale) {
        DecimalStructure dec = new DecimalStructure();
        DecimalConverter.parseString((byte[])bs, (int)0, (int)characters, (DecimalStructure)dec, (boolean)false);
        FastDecimalUtils.shift((DecimalStructure)dec, (DecimalStructure)dec, (int)(-scale));
        byte[] result = new byte[DecimalConverter.binarySize((int)precision, (int)scale)];
        DecimalConverter.decimalToBin((DecimalStructure)dec, (byte[])result, (int)precision, (int)scale);
        byte[] utf8Bytes = MySQLUnicodeUtils.latin1ToUtf8((byte[])result).getBytes();
        columnVector.setVal(rowNumber, utf8Bytes);
        accumulator.ifPresent(a -> a.appendHash(RawBytesDecimalUtils.hashCode((Slice)dec.getDecimalMemorySegment())));
    }

    public static PolarxResultset.ColumnMetaData compatibleMetaConvert(PolarxResultset.ColumnMetaDataCompatible compatible) {
        PolarxResultset.ColumnMetaData.Builder builder = PolarxResultset.ColumnMetaData.newBuilder();
        builder.setType(compatible.getType());
        builder.setOriginalType(compatible.getOriginalType());
        if (compatible.hasName()) {
            builder.setName(compatible.getName());
        }
        if (compatible.hasOriginalName()) {
            builder.setOriginalName(compatible.getOriginalName());
        }
        if (compatible.hasTable()) {
            builder.setTable(compatible.getTable());
        }
        if (compatible.hasOriginalTable()) {
            builder.setOriginalTable(compatible.getOriginalTable());
        }
        if (compatible.hasSchema()) {
            builder.setSchema(compatible.getSchema());
        }
        if (compatible.hasCatalog()) {
            builder.setCatalog(compatible.getCatalog());
        }
        if (compatible.hasCollation()) {
            builder.setCollation(compatible.getCollation());
        }
        if (compatible.hasFractionalDigits()) {
            builder.setFractionalDigits(compatible.getFractionalDigits());
        }
        if (compatible.hasLength()) {
            builder.setLength(compatible.getLength());
        }
        if (compatible.hasFlags()) {
            builder.setFlags(compatible.getFlags());
        }
        if (compatible.hasContentType()) {
            builder.setContentType(compatible.getContentType());
        }
        return builder.build();
    }

    private static long bytesToLong(byte[] bytes) {
        assert (bytes.length <= 8);
        long val = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            val |= (long)(bytes[i] & 0xFF) << (bytes.length - i - 1) * 8;
        }
        return val;
    }

    public static long timeValToLong(MySQLTimeVal timeVal) {
        byte[] bytes = new byte[7];
        long sec = timeVal.getSeconds();
        long nano = timeVal.getNano();
        int i0 = (int)sec;
        bytes[3] = (byte)(i0 & 0xFF);
        bytes[2] = (byte)(i0 >> 8 & 0xFF);
        bytes[1] = (byte)(i0 >> 16 & 0xFF);
        bytes[0] = (byte)(i0 >> 24 & 0xFF);
        int i2 = (int)(nano / 1000L);
        bytes[6] = (byte)(i2 & 0xFF);
        bytes[5] = (byte)(i2 >> 8 & 0xFF);
        bytes[4] = (byte)(i2 >> 16 & 0xFF);
        return XResultUtil.bytesToLong(bytes);
    }

    public static MySQLTimeVal longToTimeValue(long lval) {
        byte[] bytes = new byte[]{(byte)(lval >> 48 & 0xFFL), (byte)(lval >> 40 & 0xFFL), (byte)(lval >> 32 & 0xFFL), (byte)(lval >> 24 & 0xFFL), (byte)(lval >> 16 & 0xFFL), (byte)(lval >> 8 & 0xFFL), (byte)(lval & 0xFFL)};
        return XResultUtil.bytesToTimeValue(bytes);
    }

    public static MySQLTimeVal bytesToTimeValue(byte[] bytes) {
        assert (bytes.length == 7);
        MySQLTimeVal timeVal = new MySQLTimeVal();
        long seconds = Byte.toUnsignedInt(bytes[3]) + (Byte.toUnsignedInt(bytes[2]) << 8) + (Byte.toUnsignedInt(bytes[1]) << 16) + (Byte.toUnsignedInt(bytes[0]) << 24);
        timeVal.setSeconds(seconds);
        long nano = (Byte.toUnsignedInt(bytes[4]) & 0x80) != 0 ? (long)((int)(Integer.toUnsignedLong(255) << 24 | Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[4])) << 16 | Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[5])) << 8 | Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[6])))) : (long)((int)(Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[4])) << 16 | Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[5])) << 8 | Integer.toUnsignedLong(Byte.toUnsignedInt(bytes[6]))));
        timeVal.setNano(nano *= 1000L);
        return timeVal;
    }
}

